"""
Add RepositorySearchScore table.

Revision ID: f30984525c86
Revises: be8d1c402ce0
Create Date: 2017-04-04 14:30:13.270728
"""

# revision identifiers, used by Alembic.
revision = "f30984525c86"
down_revision = "be8d1c402ce0"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "repositorysearchscore",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("repository_id", sa.Integer(), nullable=False),
        sa.Column("score", sa.BigInteger(), nullable=False),
        sa.Column("last_updated", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["repository_id"],
            ["repository.id"],
            name=op.f("fk_repositorysearchscore_repository_id_repository"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_repositorysearchscore")),
    )
    op.create_index(
        "repositorysearchscore_repository_id",
        "repositorysearchscore",
        ["repository_id"],
        unique=True,
    )
    op.create_index("repositorysearchscore_score", "repositorysearchscore", ["score"], unique=False)
    ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_table(
        "repositorysearchscore",
        [
            ("repository_id", tester.TestDataType.Foreign("repository")),
            ("score", tester.TestDataType.BigInteger),
            ("last_updated", tester.TestDataType.DateTime),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("repositorysearchscore")
    ### end Alembic commands ###
