"""
Add user metadata fields.

Revision ID: faf752bd2e0a
Revises: 6c7014e84a5e
Create Date: 2016-11-14 17:29:03.984665
"""

# revision identifiers, used by Alembic.
revision = "faf752bd2e0a"
down_revision = "6c7014e84a5e"

import sqlalchemy as sa

from util.migrate import UTF8CharField


def upgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user", sa.Column("company", UTF8CharField(length=255), nullable=True))
    op.add_column("user", sa.Column("family_name", UTF8CharField(length=255), nullable=True))
    op.add_column("user", sa.Column("given_name", UTF8CharField(length=255), nullable=True))
    ### end Alembic commands ###

    op.bulk_insert(
        tables.userpromptkind,
        [
            {"name": "enter_name"},
            {"name": "enter_company"},
        ],
    )

    # ### population of test data ### #
    tester.populate_column("user", "company", tester.TestDataType.UTF8Char)
    tester.populate_column("user", "family_name", tester.TestDataType.UTF8Char)
    tester.populate_column("user", "given_name", tester.TestDataType.UTF8Char)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("user", "given_name")
    op.drop_column("user", "family_name")
    op.drop_column("user", "company")
    ### end Alembic commands ###

    op.execute(
        (
            tables.userpromptkind.delete().where(
                tables.userpromptkind.c.name == op.inline_literal("enter_name")
            )
        )
    )

    op.execute(
        (
            tables.userpromptkind.delete().where(
                tables.userpromptkind.c.name == op.inline_literal("enter_company")
            )
        )
    )
