import * as ts from 'typescript';
export interface VariableInfo {
    domain: DeclarationDomain;
    declarations: ts.PropertyName[];
    exported: boolean;
    uses: VariableUse[];
    inGlobalScope: boolean;
}
export interface VariableUse {
    domain: UsageDomain;
    location: ts.Identifier;
}
export declare const enum DeclarationDomain {
    Namespace = 1,
    Type = 2,
    Value = 4,
    Any = 7,
}
export declare const enum UsageDomain {
    Namespace = 1,
    Type = 2,
    Value = 4,
    ValueOrNamespace = 5,
    Any = 7,
    TypeQuery = 8,
}
export declare function getUsageDomain(node: ts.Identifier): UsageDomain | undefined;
export declare function collectVariableUsage(sourceFile: ts.SourceFile): Map<ts.Identifier, VariableInfo>;
