"""
Add new Appr-specific tables.

Revision ID: 610320e9dacf
Revises: 5cbbfc95bac7
Create Date: 2018-05-24 16:46:13.514562
"""

# revision identifiers, used by Alembic.
revision = "610320e9dacf"
down_revision = "5cbbfc95bac7"

import sqlalchemy as sa

from util.migrate.table_ops import copy_table_contents


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "apprblobplacementlocation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprblobplacementlocation")),
    )
    op.create_index(
        "apprblobplacementlocation_name", "apprblobplacementlocation", ["name"], unique=True
    )
    op.create_table(
        "apprtagkind",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprtagkind")),
    )
    op.create_index("apprtagkind_name", "apprtagkind", ["name"], unique=True)
    op.create_table(
        "apprblob",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("digest", sa.String(length=255), nullable=False),
        sa.Column("media_type_id", sa.Integer(), nullable=False),
        sa.Column("size", sa.BigInteger(), nullable=False),
        sa.Column("uncompressed_size", sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(
            ["media_type_id"], ["mediatype.id"], name=op.f("fk_apprblob_media_type_id_mediatype")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprblob")),
    )
    op.create_index("apprblob_digest", "apprblob", ["digest"], unique=True)
    op.create_index("apprblob_media_type_id", "apprblob", ["media_type_id"], unique=False)
    op.create_table(
        "apprmanifest",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("digest", sa.String(length=255), nullable=False),
        sa.Column("media_type_id", sa.Integer(), nullable=False),
        sa.Column("manifest_json", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["media_type_id"],
            ["mediatype.id"],
            name=op.f("fk_apprmanifest_media_type_id_mediatype"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprmanifest")),
    )
    op.create_index("apprmanifest_digest", "apprmanifest", ["digest"], unique=True)
    op.create_index("apprmanifest_media_type_id", "apprmanifest", ["media_type_id"], unique=False)
    op.create_table(
        "apprmanifestlist",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("digest", sa.String(length=255), nullable=False),
        sa.Column("manifest_list_json", sa.Text(), nullable=False),
        sa.Column("schema_version", sa.String(length=255), nullable=False),
        sa.Column("media_type_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["media_type_id"],
            ["mediatype.id"],
            name=op.f("fk_apprmanifestlist_media_type_id_mediatype"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprmanifestlist")),
    )
    op.create_index("apprmanifestlist_digest", "apprmanifestlist", ["digest"], unique=True)
    op.create_index(
        "apprmanifestlist_media_type_id", "apprmanifestlist", ["media_type_id"], unique=False
    )
    op.create_table(
        "apprblobplacement",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("blob_id", sa.Integer(), nullable=False),
        sa.Column("location_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["blob_id"], ["apprblob.id"], name=op.f("fk_apprblobplacement_blob_id_apprblob")
        ),
        sa.ForeignKeyConstraint(
            ["location_id"],
            ["apprblobplacementlocation.id"],
            name=op.f("fk_apprblobplacement_location_id_apprblobplacementlocation"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprblobplacement")),
    )
    op.create_index("apprblobplacement_blob_id", "apprblobplacement", ["blob_id"], unique=False)
    op.create_index(
        "apprblobplacement_blob_id_location_id",
        "apprblobplacement",
        ["blob_id", "location_id"],
        unique=True,
    )
    op.create_index(
        "apprblobplacement_location_id", "apprblobplacement", ["location_id"], unique=False
    )
    op.create_table(
        "apprmanifestblob",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=False),
        sa.Column("blob_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["blob_id"], ["apprblob.id"], name=op.f("fk_apprmanifestblob_blob_id_apprblob")
        ),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["apprmanifest.id"],
            name=op.f("fk_apprmanifestblob_manifest_id_apprmanifest"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprmanifestblob")),
    )
    op.create_index("apprmanifestblob_blob_id", "apprmanifestblob", ["blob_id"], unique=False)
    op.create_index(
        "apprmanifestblob_manifest_id", "apprmanifestblob", ["manifest_id"], unique=False
    )
    op.create_index(
        "apprmanifestblob_manifest_id_blob_id",
        "apprmanifestblob",
        ["manifest_id", "blob_id"],
        unique=True,
    )
    op.create_table(
        "apprmanifestlistmanifest",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manifest_list_id", sa.Integer(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=False),
        sa.Column("operating_system", sa.String(length=255), nullable=True),
        sa.Column("architecture", sa.String(length=255), nullable=True),
        sa.Column("platform_json", sa.Text(), nullable=True),
        sa.Column("media_type_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["apprmanifest.id"],
            name=op.f("fk_apprmanifestlistmanifest_manifest_id_apprmanifest"),
        ),
        sa.ForeignKeyConstraint(
            ["manifest_list_id"],
            ["apprmanifestlist.id"],
            name=op.f("fk_apprmanifestlistmanifest_manifest_list_id_apprmanifestlist"),
        ),
        sa.ForeignKeyConstraint(
            ["media_type_id"],
            ["mediatype.id"],
            name=op.f("fk_apprmanifestlistmanifest_media_type_id_mediatype"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprmanifestlistmanifest")),
    )
    op.create_index(
        "apprmanifestlistmanifest_manifest_id",
        "apprmanifestlistmanifest",
        ["manifest_id"],
        unique=False,
    )
    op.create_index(
        "apprmanifestlistmanifest_manifest_list_id",
        "apprmanifestlistmanifest",
        ["manifest_list_id"],
        unique=False,
    )
    op.create_index(
        "apprmanifestlistmanifest_manifest_list_id_media_type_id",
        "apprmanifestlistmanifest",
        ["manifest_list_id", "media_type_id"],
        unique=False,
    )
    op.create_index(
        "apprmanifestlistmanifest_manifest_list_id_operating_system_arch",
        "apprmanifestlistmanifest",
        ["manifest_list_id", "operating_system", "architecture", "media_type_id"],
        unique=False,
    )
    op.create_index(
        "apprmanifestlistmanifest_media_type_id",
        "apprmanifestlistmanifest",
        ["media_type_id"],
        unique=False,
    )
    op.create_table(
        "apprtag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("repository_id", sa.Integer(), nullable=False),
        sa.Column("manifest_list_id", sa.Integer(), nullable=True),
        sa.Column("lifetime_start", sa.BigInteger(), nullable=False),
        sa.Column("lifetime_end", sa.BigInteger(), nullable=True),
        sa.Column("hidden", sa.Boolean(), nullable=False),
        sa.Column("reverted", sa.Boolean(), nullable=False),
        sa.Column("protected", sa.Boolean(), nullable=False),
        sa.Column("tag_kind_id", sa.Integer(), nullable=False),
        sa.Column("linked_tag_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["linked_tag_id"], ["apprtag.id"], name=op.f("fk_apprtag_linked_tag_id_apprtag")
        ),
        sa.ForeignKeyConstraint(
            ["manifest_list_id"],
            ["apprmanifestlist.id"],
            name=op.f("fk_apprtag_manifest_list_id_apprmanifestlist"),
        ),
        sa.ForeignKeyConstraint(
            ["repository_id"], ["repository.id"], name=op.f("fk_apprtag_repository_id_repository")
        ),
        sa.ForeignKeyConstraint(
            ["tag_kind_id"], ["apprtagkind.id"], name=op.f("fk_apprtag_tag_kind_id_apprtagkind")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_apprtag")),
    )
    op.create_index("apprtag_lifetime_end", "apprtag", ["lifetime_end"], unique=False)
    op.create_index("apprtag_linked_tag_id", "apprtag", ["linked_tag_id"], unique=False)
    op.create_index("apprtag_manifest_list_id", "apprtag", ["manifest_list_id"], unique=False)
    op.create_index("apprtag_repository_id", "apprtag", ["repository_id"], unique=False)
    op.create_index(
        "apprtag_repository_id_name", "apprtag", ["repository_id", "name"], unique=False
    )
    op.create_index(
        "apprtag_repository_id_name_hidden",
        "apprtag",
        ["repository_id", "name", "hidden"],
        unique=False,
    )
    op.create_index(
        "apprtag_repository_id_name_lifetime_end",
        "apprtag",
        ["repository_id", "name", "lifetime_end"],
        unique=True,
    )
    op.create_index("apprtag_tag_kind_id", "apprtag", ["tag_kind_id"], unique=False)
    # ### end Alembic commands ###

    conn = op.get_bind()
    copy_table_contents("blobplacementlocation", "apprblobplacementlocation", conn)
    copy_table_contents("tagkind", "apprtagkind", conn)

    # ### population of test data ### #

    tester.populate_table(
        "apprmanifest",
        [
            ("digest", tester.TestDataType.String),
            ("media_type_id", tester.TestDataType.Foreign("mediatype")),
            ("manifest_json", tester.TestDataType.JSON),
        ],
    )

    tester.populate_table(
        "apprmanifestlist",
        [
            ("digest", tester.TestDataType.String),
            ("manifest_list_json", tester.TestDataType.JSON),
            ("schema_version", tester.TestDataType.String),
            ("media_type_id", tester.TestDataType.Foreign("mediatype")),
        ],
    )

    tester.populate_table(
        "apprmanifestlistmanifest",
        [
            ("manifest_list_id", tester.TestDataType.Foreign("apprmanifestlist")),
            ("manifest_id", tester.TestDataType.Foreign("apprmanifest")),
            ("operating_system", tester.TestDataType.String),
            ("architecture", tester.TestDataType.String),
            ("platform_json", tester.TestDataType.JSON),
            ("media_type_id", tester.TestDataType.Foreign("mediatype")),
        ],
    )

    tester.populate_table(
        "apprblob",
        [
            ("digest", tester.TestDataType.String),
            ("media_type_id", tester.TestDataType.Foreign("mediatype")),
            ("size", tester.TestDataType.BigInteger),
            ("uncompressed_size", tester.TestDataType.BigInteger),
        ],
    )

    tester.populate_table(
        "apprmanifestblob",
        [
            ("manifest_id", tester.TestDataType.Foreign("apprmanifest")),
            ("blob_id", tester.TestDataType.Foreign("apprblob")),
        ],
    )

    tester.populate_table(
        "apprtag",
        [
            ("name", tester.TestDataType.String),
            ("repository_id", tester.TestDataType.Foreign("repository")),
            ("manifest_list_id", tester.TestDataType.Foreign("apprmanifestlist")),
            ("lifetime_start", tester.TestDataType.Integer),
            ("hidden", tester.TestDataType.Boolean),
            ("reverted", tester.TestDataType.Boolean),
            ("protected", tester.TestDataType.Boolean),
            ("tag_kind_id", tester.TestDataType.Foreign("apprtagkind")),
        ],
    )

    tester.populate_table(
        "apprblobplacement",
        [
            ("blob_id", tester.TestDataType.Foreign("apprmanifestblob")),
            ("location_id", tester.TestDataType.Foreign("apprblobplacementlocation")),
        ],
    )

    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("apprtag")
    op.drop_table("apprmanifestlistmanifest")
    op.drop_table("apprmanifestblob")
    op.drop_table("apprblobplacement")
    op.drop_table("apprmanifestlist")
    op.drop_table("apprmanifest")
    op.drop_table("apprblob")
    op.drop_table("apprtagkind")
    op.drop_table("apprblobplacementlocation")
    # ### end Alembic commands ###
