"""add manifestsecuritystatus table

Revision ID: 8e6a363784bb
Revises: 4fd6b8463eb2
Create Date: 2020-03-17 12:40:54.161894

"""

# revision identifiers, used by Alembic.
revision = "8e6a363784bb"
down_revision = "4fd6b8463eb2"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "manifestsecuritystatus",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("manifest_id", sa.Integer(), nullable=False),
        sa.Column("repository_id", sa.Integer(), nullable=False),
        sa.Column("index_status", sa.Integer(), nullable=False),
        sa.Column("error_json", sa.Text(), nullable=False),
        sa.Column("last_indexed", sa.DateTime(), nullable=False),
        sa.Column("indexer_hash", sa.String(length=128), nullable=False),
        sa.Column("indexer_version", sa.Integer(), nullable=False),
        sa.Column("metadata_json", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manifest_id"],
            ["manifest.id"],
            name=op.f("fk_manifestsecuritystatus_manifest_id_manifest"),
        ),
        sa.ForeignKeyConstraint(
            ["repository_id"],
            ["repository.id"],
            name=op.f("fk_manifestsecuritystatus_repository_id_repository"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_manifestsecuritystatus")),
    )
    op.create_index(
        "manifestsecuritystatus_index_status",
        "manifestsecuritystatus",
        ["index_status"],
        unique=False,
    )
    op.create_index(
        "manifestsecuritystatus_indexer_hash",
        "manifestsecuritystatus",
        ["indexer_hash"],
        unique=False,
    )
    op.create_index(
        "manifestsecuritystatus_indexer_version",
        "manifestsecuritystatus",
        ["indexer_version"],
        unique=False,
    )
    op.create_index(
        "manifestsecuritystatus_last_indexed",
        "manifestsecuritystatus",
        ["last_indexed"],
        unique=False,
    )
    op.create_index(
        "manifestsecuritystatus_manifest_id", "manifestsecuritystatus", ["manifest_id"], unique=True
    )
    op.create_index(
        "manifestsecuritystatus_repository_id",
        "manifestsecuritystatus",
        ["repository_id"],
        unique=False,
    )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_table(
        "manifestsecuritystatus",
        [
            ("manifest_id", tester.TestDataType.Foreign("manifest")),
            ("repository_id", tester.TestDataType.Foreign("repository")),
            ("index_status", tester.TestDataType.Integer),
            ("error_json", tester.TestDataType.String),
            ("last_indexed", tester.TestDataType.DateTime),
            ("indexer_hash", tester.TestDataType.String),
            ("indexer_version", tester.TestDataType.Integer),
            ("metadata_json", tester.TestDataType.String),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("manifestsecuritystatus")
    # ### end Alembic commands ###
