"""
Add disabled datetime to trigger.

Revision ID: 87fbbc224f10
Revises: 17aff2e1354e
Create Date: 2017-10-24 14:06:37.658705
"""

# revision identifiers, used by Alembic.
revision = "87fbbc224f10"
down_revision = "17aff2e1354e"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "repositorybuildtrigger", sa.Column("disabled_datetime", sa.DateTime(), nullable=True)
    )
    op.create_index(
        "repositorybuildtrigger_disabled_datetime",
        "repositorybuildtrigger",
        ["disabled_datetime"],
        unique=False,
    )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_column(
        "repositorybuildtrigger", "disabled_datetime", tester.TestDataType.DateTime
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("repositorybuildtrigger_disabled_datetime", table_name="repositorybuildtrigger")
    op.drop_column("repositorybuildtrigger", "disabled_datetime")
    # ### end Alembic commands ###
