# How to Contribute

Quay is [Apache 2.0 licensed](LICENSE) and accepts contributions via GitHub pull requests.
This document outlines some of the conventions on development workflow, commit message formatting, contact points and other resources to make it easier to get your contribution accepted.

# Certificate of Origin

By contributing to this project you agree to the Developer Certificate of Origin [DCO](../DCO).
This document was created by the Linux Kernel community and is a simple statement that you, as a contributor, have the legal right to make the contribution.
See the [DCO](../DCO) file for details.

# Email and Chat

The project currently uses a mailing list and IRC channel:

- Issues: [PROJQUAY Jira](https://issues.redhat.com/projects/PROJQUAY/issues)
- Email: [quay-sig@googlegroups.com](https://groups.google.com/g/quay-sig)
- IRC: #[quay](irc://irc.libera.chat:6667/#quay) IRC channel on libera.chat

Please avoid emailing maintainers directly.
They are very busy and read the mailing lists.

## Getting Started

- Fork the repository on GitHub
- Read the [README](../README.md) for build and test instructions
- Play with the project, submit bugs, submit patches!

## Contribution Flow

This is a rough outline of what a contributor's workflow looks like:

- All changes require a referenced [PROJQUAY Jira](https://issues.redhat.com/projects/PROJQUAY/issues)
- Create a topic branch from where you want to base your work (usually main).
- Make commits of logical units.
- Make sure your commit messages are in the proper format (see below).
- Push your changes to a topic branch in your fork of the repository.
- Make sure the tests pass, and add any new tests as appropriate.
- Submit a pull request to the original repository.

Thanks for your contributions!

## Backporting

Sometimes a change needs to be delivered in the next Quay z-stream. This is
indicated by the "fixVersion" field in a JIRA ticket.

If something you're working on has the "fixVersion" set to either `z-stream` or
a specific version, such as `3.6.3`, it is the developer's responsibility to
backport it.

If you're not a project maintainer, make sure to notify one about the need for
backporting.

Commits that are not backported to a release branch (such as `redhat-3.6`) will
not be part of the next release from that branch.

To backport a change (after a PR is merged), simply invoke the cherry-pick bot
by commenting the following in the PR:

```
/cherrypick redhat-3.6
```

After a few seconds, the cherry-pick bot will create a PR against the specified
branch and write a comment with a link to the new PR in the original PR.

The new PR needs to be reviewed and merged as usual.

### Format of the Commit Message

We follow a rough convention for commit messages that is designed to answer two questions: what changed and why.
The subject line should feature the what and the body of the commit should describe the why.

```
scripts: add the test-cluster command (PROJQUAY-1234)

this uses tmux to setup a test cluster that you can easily kill and
start for debugging.
```

The format can be described more formally as follows:

```
<subsystem>: <what changed> (PROJQUAY-####)
<BLANK LINE>
<why this change was made>
```

The first line is the subject and should be no longer than 70 characters, the second line is always blank, and other lines should be wrapped at 80 characters.
This allows the message to be easier to read on GitHub as well as in various git tools.
