"""Add new metadata columns to Manifest table

Revision ID: 88e64904d000
Revises: 3383aad1e992
Create Date: 2020-04-21 14:00:50.376517

"""

# revision identifiers, used by Alembic.
revision = "88e64904d000"
down_revision = "3383aad1e992"

import sqlalchemy as sa
from sqlalchemy.engine.reflection import Inspector


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    inspector = Inspector.from_engine(op.get_bind())
    manifest_columns = inspector.get_columns("manifest")
    manifest_indexes = inspector.get_indexes("manifest")

    if not "config_media_type" in [c["name"] for c in manifest_columns]:
        op.add_column(
            "manifest", sa.Column("config_media_type", sa.String(length=255), nullable=True)
        )

    if not "layers_compressed_size" in [c["name"] for c in manifest_columns]:
        op.add_column(
            "manifest", sa.Column("layers_compressed_size", sa.BigInteger(), nullable=True)
        )

    if not "manifest_repository_id_config_media_type" in [i["name"] for i in manifest_indexes]:
        op.create_index(
            "manifest_repository_id_config_media_type",
            "manifest",
            ["repository_id", "config_media_type"],
            unique=False,
        )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_column("manifest", "config_media_type", tester.TestDataType.String)
    tester.populate_column("manifest", "layers_compressed_size", tester.TestDataType.Integer)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("manifest_repository_id_config_media_type", table_name="manifest")
    op.drop_column("manifest", "layers_compressed_size")
    op.drop_column("manifest", "config_media_type")
    # ### end Alembic commands ###
