from typing import List, Optional, Dict, Tuple, Any, Type
from mock import patch

import pytest
from flask_principal import AnonymousIdentity

import features
from endpoints.api import api
from endpoints.api.test.shared import conduct_api_call
from endpoints.test.shared import client_with_identity, toggle_feature

from endpoints.api.appspecifictokens import *
from endpoints.api.billing import *
from endpoints.api.build import *
from endpoints.api.discovery import *
from endpoints.api.globalmessages import *
from endpoints.api.logs import *
from endpoints.api.manifest import *
from endpoints.api.organization import *
from endpoints.api.permission import *
from endpoints.api.prototype import *
from endpoints.api.repoemail import *
from endpoints.api.repository import *
from endpoints.api.repositorynotification import *
from endpoints.api.repotoken import *
from endpoints.api.robot import *
from endpoints.api.search import *
from endpoints.api.secscan import *
from endpoints.api.signing import *
from endpoints.api.subscribe import *
from endpoints.api.suconfig import *
from endpoints.api.superuser import *
from endpoints.api.tag import *
from endpoints.api.team import *
from endpoints.api.trigger import *
from endpoints.api.user import *
from endpoints.api.mirror import *
from endpoints.api.namespacequota import *

from endpoints.api.repository import Repository

from test.fixtures import *

ORG_PARAMS = {"orgname": "buynlarge"}
TEAM_PARAMS = {"orgname": "buynlarge", "teamname": "owners"}
BUILD_PARAMS = {"build_uuid": "test-1234"}
REPO_PARAMS = {"repository": "devtable/someapp"}
SEARCH_PARAMS = {"query": ""}
NOTIFICATION_PARAMS = {
    "namespace": "devtable",
    "repository": "devtable/simple",
    "uuid": "some uuid",
}
TOKEN_PARAMS = {"token_uuid": "someuuid"}
TRIGGER_PARAMS = {"repository": "devtable/simple", "trigger_uuid": "someuuid"}
MANIFEST_PARAMS = {"repository": "devtable/simple", "manifestref": "sha256:deadbeef"}
EXPORTLOGS_PARAMS = {"callback_url": "http://foo"}


SECURITY_TESTS: List[
    Tuple[
        Type[ApiResource],
        str,
        Optional[Dict[str, Any]],
        Optional[Dict[str, Any]],
        Optional[str],
        int,
    ]
] = [
    (AppTokens, "GET", {}, {}, None, 401),
    (AppTokens, "GET", {}, {}, "freshuser", 200),
    (AppTokens, "GET", {}, {}, "reader", 200),
    (AppTokens, "GET", {}, {}, "devtable", 200),
    (AppTokens, "POST", {}, {}, None, 401),
    (AppTokens, "POST", {}, {}, "freshuser", 400),
    (AppTokens, "POST", {}, {}, "reader", 400),
    (AppTokens, "POST", {}, {}, "devtable", 400),
    (AppToken, "GET", TOKEN_PARAMS, {}, None, 401),
    (AppToken, "GET", TOKEN_PARAMS, {}, "freshuser", 404),
    (AppToken, "GET", TOKEN_PARAMS, {}, "reader", 404),
    (AppToken, "GET", TOKEN_PARAMS, {}, "devtable", 404),
    (AppToken, "DELETE", TOKEN_PARAMS, {}, None, 401),
    (AppToken, "DELETE", TOKEN_PARAMS, {}, "freshuser", 404),
    (AppToken, "DELETE", TOKEN_PARAMS, {}, "reader", 404),
    (AppToken, "DELETE", TOKEN_PARAMS, {}, "devtable", 404),
    (RepositoryManifest, "GET", MANIFEST_PARAMS, {}, None, 401),
    (RepositoryManifest, "GET", MANIFEST_PARAMS, {}, "freshuser", 403),
    (RepositoryManifest, "GET", MANIFEST_PARAMS, {}, "reader", 403),
    (RepositoryManifest, "GET", MANIFEST_PARAMS, {}, "devtable", 404),
    (OrganizationCollaboratorList, "GET", ORG_PARAMS, None, None, 401),
    (OrganizationCollaboratorList, "GET", ORG_PARAMS, None, "freshuser", 403),
    (OrganizationCollaboratorList, "GET", ORG_PARAMS, None, "reader", 403),
    (OrganizationCollaboratorList, "GET", ORG_PARAMS, None, "devtable", 200),
    (OrganizationTeamSyncing, "POST", TEAM_PARAMS, {}, None, 401),
    (OrganizationTeamSyncing, "POST", TEAM_PARAMS, {}, "freshuser", 403),
    (OrganizationTeamSyncing, "POST", TEAM_PARAMS, {}, "reader", 403),
    (OrganizationTeamSyncing, "POST", TEAM_PARAMS, {}, "devtable", 400),
    (OrganizationTeamSyncing, "DELETE", TEAM_PARAMS, {}, None, 401),
    (OrganizationTeamSyncing, "DELETE", TEAM_PARAMS, {}, "freshuser", 403),
    (OrganizationTeamSyncing, "DELETE", TEAM_PARAMS, {}, "reader", 403),
    (OrganizationTeamSyncing, "DELETE", TEAM_PARAMS, {}, "devtable", 200),
    (ConductRepositorySearch, "GET", SEARCH_PARAMS, None, None, 200),
    (ConductRepositorySearch, "GET", SEARCH_PARAMS, None, "freshuser", 200),
    (ConductRepositorySearch, "GET", SEARCH_PARAMS, None, "reader", 200),
    (ConductRepositorySearch, "GET", SEARCH_PARAMS, None, "devtable", 200),
    (SuperUserRepositoryBuildLogs, "GET", BUILD_PARAMS, None, None, 401),
    (SuperUserRepositoryBuildLogs, "GET", BUILD_PARAMS, None, "freshuser", 403),
    (SuperUserRepositoryBuildLogs, "GET", BUILD_PARAMS, None, "reader", 403),
    (SuperUserRepositoryBuildLogs, "GET", BUILD_PARAMS, None, "devtable", 400),
    (SuperUserRepositoryBuildStatus, "GET", BUILD_PARAMS, None, None, 401),
    (SuperUserRepositoryBuildStatus, "GET", BUILD_PARAMS, None, "freshuser", 403),
    (SuperUserRepositoryBuildStatus, "GET", BUILD_PARAMS, None, "reader", 403),
    (SuperUserRepositoryBuildStatus, "GET", BUILD_PARAMS, None, "devtable", 400),
    (SuperUserRepositoryBuildResource, "GET", BUILD_PARAMS, None, None, 401),
    (SuperUserRepositoryBuildResource, "GET", BUILD_PARAMS, None, "freshuser", 403),
    (SuperUserRepositoryBuildResource, "GET", BUILD_PARAMS, None, "reader", 403),
    (SuperUserRepositoryBuildResource, "GET", BUILD_PARAMS, None, "devtable", 404),
    (RepositorySignatures, "GET", REPO_PARAMS, {}, "freshuser", 403),
    (RepositorySignatures, "GET", REPO_PARAMS, {}, "reader", 403),
    (RepositorySignatures, "GET", REPO_PARAMS, {}, "devtable", 404),
    (RepositoryNotification, "POST", NOTIFICATION_PARAMS, {}, None, 401),
    (RepositoryNotification, "POST", NOTIFICATION_PARAMS, {}, "freshuser", 403),
    (RepositoryNotification, "POST", NOTIFICATION_PARAMS, {}, "reader", 403),
    (RepositoryNotification, "POST", NOTIFICATION_PARAMS, {}, "devtable", 400),
    (RepositoryTrust, "POST", REPO_PARAMS, {"trust_enabled": True}, None, 401),
    (RepositoryTrust, "POST", REPO_PARAMS, {"trust_enabled": True}, "freshuser", 403),
    (RepositoryTrust, "POST", REPO_PARAMS, {"trust_enabled": True}, "reader", 403),
    (RepositoryTrust, "POST", REPO_PARAMS, {"trust_enabled": True}, "devtable", 404),
    (BuildTrigger, "GET", TRIGGER_PARAMS, {}, None, 401),
    (BuildTrigger, "GET", TRIGGER_PARAMS, {}, "freshuser", 403),
    (BuildTrigger, "GET", TRIGGER_PARAMS, {}, "reader", 403),
    (BuildTrigger, "GET", TRIGGER_PARAMS, {}, "devtable", 404),
    (BuildTrigger, "DELETE", TRIGGER_PARAMS, {}, None, 401),
    (BuildTrigger, "DELETE", TRIGGER_PARAMS, {}, "freshuser", 403),
    (BuildTrigger, "DELETE", TRIGGER_PARAMS, {}, "reader", 403),
    (BuildTrigger, "DELETE", TRIGGER_PARAMS, {}, "devtable", 404),
    (BuildTrigger, "PUT", TRIGGER_PARAMS, {}, None, 401),
    (BuildTrigger, "PUT", TRIGGER_PARAMS, {}, "freshuser", 403),
    (BuildTrigger, "PUT", TRIGGER_PARAMS, {}, "reader", 403),
    (BuildTrigger, "PUT", TRIGGER_PARAMS, {}, "devtable", 400),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "devtable", "repository": "devtable/shared"},
        None,
        "devtable",
        200,
    ),
    (
        RepositoryUserTransitivePermission,
        "GET",
        {"username": "devtable", "repository": "devtable/nope"},
        None,
        "devtable",
        404,
    ),
    (StarredRepositoryList, "GET", None, None, None, 401),
    (StarredRepositoryList, "GET", None, None, "devtable", 200),
    (StarredRepositoryList, "GET", None, None, "freshuser", 200),
    (StarredRepositoryList, "GET", None, None, "reader", 200),
    (
        StarredRepositoryList,
        "POST",
        None,
        {"namespace": "public", "repository": "publicrepo"},
        None,
        401,
    ),
    (
        StarredRepositoryList,
        "POST",
        None,
        {"namespace": "public", "repository": "publicrepo"},
        "devtable",
        201,
    ),
    (
        StarredRepositoryList,
        "POST",
        None,
        {"namespace": "public", "repository": "publicrepo"},
        "freshuser",
        201,
    ),
    (
        StarredRepositoryList,
        "POST",
        None,
        {"namespace": "public", "repository": "publicrepo"},
        "reader",
        201,
    ),
    (StarredRepository, "DELETE", {"repository": "public/publicrepo"}, None, None, 401),
    (StarredRepository, "DELETE", {"repository": "public/publicrepo"}, None, "devtable", 204),
    (StarredRepository, "DELETE", {"repository": "public/publicrepo"}, None, "freshuser", 204),
    (StarredRepository, "DELETE", {"repository": "public/publicrepo"}, None, "reader", 204),
    (UserNotification, "GET", {"uuid": "someuuid"}, None, None, 401),
    (UserNotification, "GET", {"uuid": "someuuid"}, None, "devtable", 404),
    (UserNotification, "GET", {"uuid": "someuuid"}, None, "freshuser", 404),
    (UserNotification, "GET", {"uuid": "someuuid"}, None, "reader", 404),
    (UserNotification, "PUT", {"uuid": "someuuid"}, {}, None, 401),
    (UserNotification, "PUT", {"uuid": "someuuid"}, {}, "devtable", 404),
    (UserNotification, "PUT", {"uuid": "someuuid"}, {}, "freshuser", 404),
    (UserNotification, "PUT", {"uuid": "someuuid"}, {}, "reader", 404),
    (UserInvoiceList, "GET", None, None, None, 401),
    (UserInvoiceList, "GET", None, None, "devtable", 200),
    (UserInvoiceList, "GET", None, None, "freshuser", 404),
    (UserInvoiceList, "GET", None, None, "reader", 404),
    (PrivateRepositories, "GET", None, None, None, 401),
    (PrivateRepositories, "GET", None, None, "devtable", 200),
    (PrivateRepositories, "GET", None, None, "freshuser", 200),
    (PrivateRepositories, "GET", None, None, "reader", 200),
    (
        ConvertToOrganization,
        "POST",
        None,
        {"adminPassword": "IQTM", "plan": "1RB4", "adminUser": "44E8"},
        None,
        401,
    ),
    (
        ConvertToOrganization,
        "POST",
        None,
        {"adminPassword": "IQTM", "plan": "1RB4", "adminUser": "44E8"},
        "devtable",
        400,
    ),
    (
        ConvertToOrganization,
        "POST",
        None,
        {"adminPassword": "IQTM", "plan": "1RB4", "adminUser": "44E8"},
        "freshuser",
        400,
    ),
    (
        ConvertToOrganization,
        "POST",
        None,
        {"adminPassword": "IQTM", "plan": "1RB4", "adminUser": "44E8"},
        "reader",
        400,
    ),
    (UserRobotList, "GET", None, None, None, 401),
    (UserRobotList, "GET", None, None, "devtable", 200),
    (UserRobotList, "GET", None, None, "freshuser", 200),
    (UserRobotList, "GET", None, None, "reader", 200),
    (UserCard, "GET", None, None, None, 401),
    (UserCard, "GET", None, None, "devtable", 200),
    (UserCard, "GET", None, None, "freshuser", 200),
    (UserCard, "GET", None, None, "reader", 200),
    (UserCard, "POST", None, {"token": "ORH4"}, None, 401),
    (UserPlan, "GET", None, None, None, 401),
    (UserPlan, "GET", None, None, "devtable", 200),
    (UserPlan, "GET", None, None, "freshuser", 200),
    (UserPlan, "GET", None, None, "reader", 200),
    (UserPlan, "PUT", None, {"plan": "1QIK"}, None, 401),
    (UserLogs, "GET", None, None, None, 401),
    (UserLogs, "GET", None, None, "devtable", 200),
    (UserLogs, "GET", None, None, "freshuser", 200),
    (UserLogs, "GET", None, None, "reader", 200),
    (OrganizationList, "POST", None, {"name": "KSIS", "email": "DHVZ"}, None, 401),
    (OrganizationList, "POST", None, {"name": "KSIS", "email": "DHVZ"}, "devtable", 400),
    (OrganizationList, "POST", None, {"name": "KSIS", "email": "DHVZ"}, "freshuser", 400),
    (OrganizationList, "POST", None, {"name": "KSIS", "email": "DHVZ"}, "reader", 400),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, None, 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "devtable", 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "reader", 200),
    (RepositoryList, "GET", None, None, None, 400),
    (RepositoryList, "GET", None, None, "devtable", 400),
    (RepositoryList, "GET", None, None, "freshuser", 400),
    (RepositoryList, "GET", None, None, "reader", 400),
    (
        RepositoryList,
        "POST",
        None,
        {"repository": "xzgb", "visibility": "public", "description": "0O8U"},
        None,
        400,
    ),
    (
        RepositoryList,
        "POST",
        None,
        {"repository": "xzgb", "visibility": "public", "description": "0O8U"},
        "devtable",
        201,
    ),
    (
        RepositoryList,
        "POST",
        None,
        {"repository": "xzgb", "visibility": "public", "description": "0O8U"},
        "freshuser",
        201,
    ),
    (
        RepositoryList,
        "POST",
        None,
        {"repository": "xzgb", "visibility": "public", "description": "0O8U"},
        "reader",
        201,
    ),
    (DiscoveryResource, "GET", None, None, None, 200),
    (DiscoveryResource, "GET", None, None, "devtable", 200),
    (DiscoveryResource, "GET", None, None, "freshuser", 200),
    (DiscoveryResource, "GET", None, None, "reader", 200),
    (FileDropResource, "POST", None, {"mimeType": "TKBX"}, None, 200),
    (FileDropResource, "POST", None, {"mimeType": "TKBX"}, "devtable", 200),
    (FileDropResource, "POST", None, {"mimeType": "TKBX"}, "freshuser", 200),
    (FileDropResource, "POST", None, {"mimeType": "TKBX"}, "reader", 200),
    (Recovery, "POST", None, {"email": "826S"}, None, 200),
    (Recovery, "POST", None, {"email": "826S"}, "devtable", 200),
    (Recovery, "POST", None, {"email": "826S"}, "freshuser", 200),
    (Recovery, "POST", None, {"email": "826S"}, "reader", 200),
    (Signout, "POST", None, None, None, 200),
    (Signout, "POST", None, None, "devtable", 200),
    (Signout, "POST", None, None, "freshuser", 200),
    (Signout, "POST", None, None, "reader", 200),
    (Signin, "POST", None, {"username": "E9RY", "password": "LQ0N"}, None, 403),
    (Signin, "POST", None, {"username": "E9RY", "password": "LQ0N"}, "devtable", 403),
    (Signin, "POST", None, {"username": "E9RY", "password": "LQ0N"}, "freshuser", 403),
    (Signin, "POST", None, {"username": "E9RY", "password": "LQ0N"}, "reader", 403),
    (ExternalLoginInformation, "POST", {"service_id": "someservice"}, {}, None, 400),
    (ExternalLoginInformation, "POST", {"service_id": "someservice"}, {}, "devtable", 400),
    (ExternalLoginInformation, "POST", {"service_id": "someservice"}, {}, "freshuser", 400),
    (ExternalLoginInformation, "POST", {"service_id": "someservice"}, {}, "reader", 400),
    (DetachExternal, "POST", {"service_id": "someservice"}, {}, None, 401),
    (DetachExternal, "POST", {"service_id": "someservice"}, {}, "devtable", 200),
    (DetachExternal, "POST", {"service_id": "someservice"}, {}, "freshuser", 200),
    (DetachExternal, "POST", {"service_id": "someservice"}, {}, "reader", 200),
    (VerifyUser, "POST", None, {"password": "LQ0N"}, None, 401),
    (VerifyUser, "POST", None, {"password": "password"}, "devtable", 200),
    (VerifyUser, "POST", None, {"password": "LQ0N"}, "freshuser", 403),
    (VerifyUser, "POST", None, {"password": "LQ0N"}, "reader", 403),
    (ClientKey, "POST", None, {"password": "LQ0N"}, None, 401),
    (ClientKey, "POST", None, {"password": "password"}, "devtable", 200),
    (ClientKey, "POST", None, {"password": "LQ0N"}, "freshuser", 400),
    (ClientKey, "POST", None, {"password": "password"}, "reader", 200),
    (ListPlans, "GET", None, None, None, 200),
    (ListPlans, "GET", None, None, "devtable", 200),
    (ListPlans, "GET", None, None, "freshuser", 200),
    (ListPlans, "GET", None, None, "reader", 200),
    (User, "GET", None, None, None, 401),
    (User, "GET", None, None, "devtable", 200),
    (User, "GET", None, None, "freshuser", 200),
    (User, "GET", None, None, "reader", 200),
    (User, "POST", None, {"username": "T946", "password": "0SG4", "email": "MENT"}, None, 400),
    (
        User,
        "POST",
        None,
        {"username": "T946", "password": "0SG4", "email": "MENT"},
        "devtable",
        400,
    ),
    (
        User,
        "POST",
        None,
        {"username": "T946", "password": "0SG4", "email": "MENT"},
        "freshuser",
        400,
    ),
    (
        User,
        "POST",
        None,
        {"username": "T946", "password": "0SG4", "email": "MENT"},
        "reader",
        400,
    ),
    (User, "PUT", None, {}, None, 401),
    (User, "PUT", None, {}, "devtable", 200),
    (User, "PUT", None, {}, "freshuser", 200),
    (User, "PUT", None, {}, "reader", 200),
    (User, "DELETE", None, {}, None, 401),
    (User, "DELETE", None, {}, "devtable", 400),
    (User, "DELETE", None, {}, "freshuser", 204),
    (User, "DELETE", None, {}, "reader", 204),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "devtable",
        400,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "devtable",
        200,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        TeamMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        TeamMember,
        "PUT",
        {"orgname": "buynlarge", "membername": "devtable", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (TeamPermissions, "GET", {"orgname": "buynlarge", "teamname": "readers"}, None, None, 401),
    (
        TeamPermissions,
        "GET",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "devtable",
        200,
    ),
    (
        TeamPermissions,
        "GET",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (TeamPermissions, "GET", {"orgname": "buynlarge", "teamname": "readers"}, None, "reader", 403),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "readers"}, None, None, 401),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "readers"}, None, "devtable", 200),
    (
        TeamMemberList,
        "GET",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "readers"}, None, "reader", 200),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "owners"}, None, None, 401),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "owners"}, None, "devtable", 200),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "owners"}, None, "freshuser", 403),
    (TeamMemberList, "GET", {"orgname": "buynlarge", "teamname": "owners"}, None, "reader", 403),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "public/publicrepo"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "public/publicrepo"},
        {"role": "read"},
        "devtable",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "public/publicrepo"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "public/publicrepo"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "devtable/shared"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "devtable/shared"},
        {"role": "read"},
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "devtable/shared"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "devtable/shared"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "DELETE",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "GET",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "devtable",
        400,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryUserPermission,
        "PUT",
        {"username": "A2O9", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "readers"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "readers"},
        {"role": "read"},
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "readers"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "readers"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "readers"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "readers"},
        {"role": "read"},
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "readers"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "readers"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "devtable",
        204,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "devtable",
        200,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        {"role": "read"},
        "devtable",
        200,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "readers"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "public/publicrepo", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "owners"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "owners"},
        {"role": "read"},
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "owners"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "public/publicrepo", "teamname": "owners"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "devtable/shared", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "owners"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "owners"},
        {"role": "read"},
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "owners"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "devtable/shared", "teamname": "owners"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "GET",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        {"role": "read"},
        "devtable",
        200,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryTeamPermission,
        "PUT",
        {"repository": "buynlarge/orgrepo", "teamname": "owners"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "devtable",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerActivate,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "devtable",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "public/publicrepo", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "devtable/shared", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerFieldValues,
        "POST",
        {"field_name": "test_field", "repository": "buynlarge/orgrepo", "trigger_uuid": "SWO1"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "831C"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "831C"},
        {"namespace": "foo"},
        "devtable",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "831C"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "831C"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "831C"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "831C"},
        {"namespace": "foo"},
        "devtable",
        404,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "831C"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "831C"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "831C"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "831C"},
        {"namespace": "foo"},
        "devtable",
        404,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "831C"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerSources,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "831C"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "4I2Y"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "4I2Y"},
        {},
        "devtable",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "4I2Y"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "4I2Y"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "4I2Y"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "4I2Y"},
        {},
        "devtable",
        404,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "4I2Y"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "4I2Y"},
        {},
        "reader",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "4I2Y"},
        {},
        None,
        401,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "4I2Y"},
        {},
        "devtable",
        404,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "4I2Y"},
        {},
        "freshuser",
        403,
    ),
    (
        BuildTriggerSubdirs,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "4I2Y"},
        {},
        "reader",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "ZM1W"},
        None,
        None,
        401,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "ZM1W"},
        None,
        "devtable",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "ZM1W"},
        None,
        "freshuser",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "ZM1W"},
        None,
        "reader",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "ZM1W"},
        None,
        None,
        401,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "ZM1W"},
        None,
        "devtable",
        200,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "ZM1W"},
        None,
        "freshuser",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "ZM1W"},
        None,
        "reader",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "ZM1W"},
        None,
        None,
        401,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "ZM1W"},
        None,
        "devtable",
        200,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "ZM1W"},
        None,
        "freshuser",
        403,
    ),
    (
        TriggerBuildList,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "ZM1W"},
        None,
        "reader",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        "devtable",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        {},
        "devtable",
        404,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        {},
        "devtable",
        404,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        ActivateBuildTrigger,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        {"config": {}},
        "devtable",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "public/publicrepo", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "devtable/shared", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        {"config": {}},
        "devtable",
        404,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerAnalyze,
        "POST",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "0BYE"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        None,
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "freshuser",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "reader",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "reader",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildStatus,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        400,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        None,
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "freshuser",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "reader",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "reader",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildResource,
        "GET",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        404,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildResource,
        "DELETE",
        {"build_uuid": "FG86", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryBuildLogs,
        "GET",
        {"build_uuid": "S5J8", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "public/publicrepo"},
        None,
        None,
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "public/publicrepo"},
        None,
        "devtable",
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "public/publicrepo"},
        None,
        "freshuser",
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "public/publicrepo"},
        None,
        "reader",
        200,
    ),
    (ListRepositoryTags, "GET", {"tag": "TN96", "repository": "devtable/shared"}, None, None, 401),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "devtable/shared"},
        None,
        "devtable",
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "devtable/shared"},
        None,
        "reader",
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        200,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        ListRepositoryTags,
        "GET",
        {"tag": "TN96", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        200,
    ),
    (
        PermissionPrototype,
        "DELETE",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        None,
        None,
        401,
    ),
    (
        PermissionPrototype,
        "DELETE",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        None,
        "devtable",
        404,
    ),
    (
        PermissionPrototype,
        "DELETE",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        None,
        "freshuser",
        403,
    ),
    (
        PermissionPrototype,
        "DELETE",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        None,
        "reader",
        403,
    ),
    (
        PermissionPrototype,
        "PUT",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        {"role": "read"},
        None,
        401,
    ),
    (
        PermissionPrototype,
        "PUT",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        {"role": "read"},
        "devtable",
        404,
    ),
    (
        PermissionPrototype,
        "PUT",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        PermissionPrototype,
        "PUT",
        {"orgname": "buynlarge", "prototypeid": "L24B"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        OrganizationMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        None,
        401,
    ),
    (
        OrganizationMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "devtable",
        404,
    ),
    (
        OrganizationMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationMember,
        "DELETE",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "reader",
        403,
    ),
    (
        OrganizationMember,
        "GET",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        None,
        401,
    ),
    (
        OrganizationMember,
        "GET",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "devtable",
        404,
    ),
    (
        OrganizationMember,
        "GET",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationMember,
        "GET",
        {"orgname": "buynlarge", "membername": "someuser"},
        None,
        "reader",
        403,
    ),
    (OrgRobot, "DELETE", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, None, 401),
    (
        OrgRobot,
        "DELETE",
        {"orgname": "buynlarge", "robot_shortname": "Z7PD"},
        None,
        "devtable",
        400,
    ),
    (
        OrgRobot,
        "DELETE",
        {"orgname": "buynlarge", "robot_shortname": "Z7PD"},
        None,
        "freshuser",
        403,
    ),
    (OrgRobot, "DELETE", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, "reader", 403),
    (OrgRobot, "GET", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, None, 401),
    (OrgRobot, "GET", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, "devtable", 400),
    (OrgRobot, "GET", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, "freshuser", 403),
    (OrgRobot, "GET", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, None, "reader", 403),
    (OrgRobot, "PUT", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, {}, None, 401),
    (OrgRobot, "PUT", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, {}, "devtable", 400),
    (OrgRobot, "PUT", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, {}, "freshuser", 403),
    (OrgRobot, "PUT", {"orgname": "buynlarge", "robot_shortname": "Z7PD"}, {}, "reader", 403),
    (OrganizationTeam, "DELETE", {"orgname": "buynlarge", "teamname": "readers"}, None, None, 401),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "devtable",
        204,
    ),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "readers"},
        None,
        "reader",
        403,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "readers"},
        {"role": "member"},
        None,
        401,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "readers"},
        {"role": "member"},
        "devtable",
        200,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "readers"},
        {"role": "member"},
        "freshuser",
        403,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "readers"},
        {"role": "member"},
        "reader",
        403,
    ),
    (OrganizationTeam, "DELETE", {"orgname": "buynlarge", "teamname": "owners"}, None, None, 401),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners"},
        None,
        "devtable",
        400,
    ),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationTeam,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners"},
        None,
        "reader",
        403,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners"},
        {"role": "member"},
        None,
        401,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners"},
        {"role": "member"},
        "devtable",
        400,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners"},
        {"role": "member"},
        "freshuser",
        403,
    ),
    (
        OrganizationTeam,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners"},
        {"role": "member"},
        "reader",
        403,
    ),
    (RepositoryTeamPermissionList, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (
        RepositoryTeamPermissionList,
        "GET",
        {"repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTeamPermissionList,
        "GET",
        {"repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryTeamPermissionList, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (RepositoryTeamPermissionList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryTeamPermissionList, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (
        RepositoryTeamPermissionList,
        "GET",
        {"repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryTeamPermissionList, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (RepositoryTeamPermissionList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (
        RepositoryTeamPermissionList,
        "GET",
        {"repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        200,
    ),
    (
        RepositoryTeamPermissionList,
        "GET",
        {"repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryTeamPermissionList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (RepositoryUserPermissionList, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (
        RepositoryUserPermissionList,
        "GET",
        {"repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryUserPermissionList,
        "GET",
        {"repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryUserPermissionList, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (RepositoryUserPermissionList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryUserPermissionList, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (
        RepositoryUserPermissionList,
        "GET",
        {"repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryUserPermissionList, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (RepositoryUserPermissionList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (
        RepositoryUserPermissionList,
        "GET",
        {"repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        200,
    ),
    (
        RepositoryUserPermissionList,
        "GET",
        {"repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryUserPermissionList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "public/publicrepo", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        404,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        404,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "devtable/shared", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        404,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "DELETE",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        None,
        401,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "devtable",
        404,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTrigger,
        "GET",
        {"repository": "buynlarge/orgrepo", "trigger_uuid": "D6TI"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "DELETE",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryNotification,
        "GET",
        {"uuid": "QFAT", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (RepositoryToken, "GET", {"code": "UJQB", "repository": "public/publicrepo"}, None, None, 401),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "public/publicrepo"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "public/publicrepo"},
        {"role": "read"},
        "devtable",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "public/publicrepo"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "public/publicrepo"},
        {"role": "read"},
        "reader",
        403,
    ),
    (RepositoryToken, "DELETE", {"code": "UJQB", "repository": "devtable/shared"}, None, None, 401),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (RepositoryToken, "GET", {"code": "UJQB", "repository": "devtable/shared"}, None, None, 401),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "devtable/shared"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "devtable/shared"},
        {"role": "read"},
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "devtable/shared"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "devtable/shared"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "DELETE",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (RepositoryToken, "GET", {"code": "UJQB", "repository": "buynlarge/orgrepo"}, None, None, 401),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "GET",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        None,
        401,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "devtable",
        410,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "freshuser",
        403,
    ),
    (
        RepositoryToken,
        "PUT",
        {"code": "UJQB", "repository": "buynlarge/orgrepo"},
        {"role": "read"},
        "reader",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "devtable",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "devtable",
        404,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "devtable",
        404,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RestoreTag,
        "POST",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (RepositoryTag, "DELETE", {"tag": "HP8R", "repository": "public/publicrepo"}, None, None, 401),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "devtable",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "public/publicrepo"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (RepositoryTag, "DELETE", {"tag": "HP8R", "repository": "devtable/shared"}, None, None, 401),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "devtable/shared"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "devtable",
        404,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "devtable/shared"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (RepositoryTag, "DELETE", {"tag": "HP8R", "repository": "buynlarge/orgrepo"}, None, None, 401),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        400,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "DELETE",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        None,
        401,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "devtable",
        404,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "freshuser",
        403,
    ),
    (
        RepositoryTag,
        "PUT",
        {"tag": "HP8R", "repository": "buynlarge/orgrepo"},
        {"manifest_digest": "WXNG"},
        "reader",
        403,
    ),
    (PermissionPrototypeList, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (PermissionPrototypeList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (PermissionPrototypeList, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (PermissionPrototypeList, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (
        PermissionPrototypeList,
        "POST",
        {"orgname": "buynlarge"},
        {"role": "read", "delegate": {"kind": "user", "name": "7DGP"}},
        None,
        401,
    ),
    (
        PermissionPrototypeList,
        "POST",
        {"orgname": "buynlarge"},
        {"role": "read", "delegate": {"kind": "user", "name": "7DGP"}},
        "devtable",
        400,
    ),
    (
        PermissionPrototypeList,
        "POST",
        {"orgname": "buynlarge"},
        {"role": "read", "delegate": {"kind": "user", "name": "7DGP"}},
        "freshuser",
        403,
    ),
    (
        PermissionPrototypeList,
        "POST",
        {"orgname": "buynlarge"},
        {"role": "read", "delegate": {"kind": "user", "name": "7DGP"}},
        "reader",
        403,
    ),
    (OrganizationInvoiceList, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationInvoiceList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationInvoiceList, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationInvoiceList, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrgPrivateRepositories, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrgPrivateRepositories, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrgPrivateRepositories, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrgPrivateRepositories, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrganizationMemberList, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationMemberList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationMemberList, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationMemberList, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrgRobotList, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrgRobotList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrgRobotList, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrgRobotList, "GET", {"orgname": "buynlarge"}, None, "reader", 200),
    (OrganizationCard, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationCard, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationCard, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationCard, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrganizationCard, "POST", {"orgname": "buynlarge"}, {"token": "4VFR"}, None, 401),
    (OrganizationCard, "POST", {"orgname": "buynlarge"}, {"token": "4VFR"}, "freshuser", 403),
    (OrganizationCard, "POST", {"orgname": "buynlarge"}, {"token": "4VFR"}, "reader", 403),
    (OrganizationPlan, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationPlan, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationPlan, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationPlan, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrganizationPlan, "PUT", {"orgname": "buynlarge"}, {"plan": "WWEI"}, None, 401),
    (OrganizationPlan, "PUT", {"orgname": "buynlarge"}, {"plan": "WWEI"}, "freshuser", 403),
    (OrganizationPlan, "PUT", {"orgname": "buynlarge"}, {"plan": "WWEI"}, "reader", 403),
    (OrgLogs, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrgLogs, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrgLogs, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrgLogs, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "public/publicrepo"},
        {"visibility": "public"},
        None,
        401,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "public/publicrepo"},
        {"visibility": "public"},
        "devtable",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "public/publicrepo"},
        {"visibility": "public"},
        "freshuser",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "public/publicrepo"},
        {"visibility": "public"},
        "reader",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "devtable/shared"},
        {"visibility": "public"},
        None,
        401,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "devtable/shared"},
        {"visibility": "public"},
        "devtable",
        200,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "devtable/shared"},
        {"visibility": "public"},
        "freshuser",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "devtable/shared"},
        {"visibility": "public"},
        "reader",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"visibility": "public"},
        None,
        401,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"visibility": "public"},
        "devtable",
        200,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"visibility": "public"},
        "freshuser",
        403,
    ),
    (
        RepositoryVisibility,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"visibility": "public"},
        "reader",
        403,
    ),
    (BuildTriggerList, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (BuildTriggerList, "GET", {"repository": "public/publicrepo"}, None, "devtable", 403),
    (BuildTriggerList, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 403),
    (BuildTriggerList, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (BuildTriggerList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (BuildTriggerList, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (BuildTriggerList, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (BuildTriggerList, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (BuildTriggerList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (BuildTriggerList, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 200),
    (BuildTriggerList, "GET", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (BuildTriggerList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (RepositoryNotificationList, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (RepositoryNotificationList, "GET", {"repository": "public/publicrepo"}, None, "devtable", 403),
    (
        RepositoryNotificationList,
        "GET",
        {"repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryNotificationList, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (RepositoryNotificationList, "POST", {"repository": "public/publicrepo"}, {}, None, 401),
    (RepositoryNotificationList, "POST", {"repository": "public/publicrepo"}, {}, "devtable", 403),
    (RepositoryNotificationList, "POST", {"repository": "public/publicrepo"}, {}, "freshuser", 403),
    (RepositoryNotificationList, "POST", {"repository": "public/publicrepo"}, {}, "reader", 403),
    (RepositoryNotificationList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryNotificationList, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (RepositoryNotificationList, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (RepositoryNotificationList, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (RepositoryNotificationList, "POST", {"repository": "devtable/shared"}, {}, None, 401),
    (
        RepositoryNotificationList,
        "POST",
        {"repository": "devtable/shared"},
        {"config": {"email": "a@b.com"}, "event": "repo_push", "method": "email"},
        "devtable",
        400,
    ),
    (RepositoryNotificationList, "POST", {"repository": "devtable/shared"}, {}, "freshuser", 403),
    (RepositoryNotificationList, "POST", {"repository": "devtable/shared"}, {}, "reader", 403),
    (RepositoryNotificationList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (RepositoryNotificationList, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 200),
    (
        RepositoryNotificationList,
        "GET",
        {"repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (RepositoryNotificationList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (RepositoryNotificationList, "POST", {"repository": "buynlarge/orgrepo"}, {}, None, 401),
    (
        RepositoryNotificationList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"config": {"email": "a@b.com"}, "event": "repo_push", "method": "email"},
        "devtable",
        400,
    ),
    (RepositoryNotificationList, "POST", {"repository": "buynlarge/orgrepo"}, {}, "freshuser", 403),
    (RepositoryNotificationList, "POST", {"repository": "buynlarge/orgrepo"}, {}, "reader", 403),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        None,
        "devtable",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        {},
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        {},
        "devtable",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        {},
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "public/publicrepo"},
        {},
        "reader",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        None,
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        {},
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        {},
        "devtable",
        200,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        {},
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "devtable/shared"},
        {},
        "reader",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        None,
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "GET",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        {},
        None,
        401,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        {},
        "devtable",
        200,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        {},
        "freshuser",
        403,
    ),
    (
        RepositoryAuthorizedEmail,
        "POST",
        {"email": "jschorr@devtable.com", "repository": "buynlarge/orgrepo"},
        {},
        "reader",
        403,
    ),
    (RepositoryTokenList, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (RepositoryTokenList, "GET", {"repository": "public/publicrepo"}, None, "devtable", 403),
    (RepositoryTokenList, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 403),
    (RepositoryTokenList, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "public/publicrepo"},
        {"friendlyName": "R1CN"},
        None,
        401,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "public/publicrepo"},
        {"friendlyName": "R1CN"},
        "devtable",
        403,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "public/publicrepo"},
        {"friendlyName": "R1CN"},
        "freshuser",
        403,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "public/publicrepo"},
        {"friendlyName": "R1CN"},
        "reader",
        403,
    ),
    (RepositoryTokenList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryTokenList, "GET", {"repository": "devtable/shared"}, None, "devtable", 410),
    (RepositoryTokenList, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (RepositoryTokenList, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "devtable/shared"},
        {"friendlyName": "R1CN"},
        None,
        401,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "devtable/shared"},
        {"friendlyName": "R1CN"},
        "devtable",
        410,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "devtable/shared"},
        {"friendlyName": "R1CN"},
        "freshuser",
        403,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "devtable/shared"},
        {"friendlyName": "R1CN"},
        "reader",
        403,
    ),
    (RepositoryTokenList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (RepositoryTokenList, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 410),
    (RepositoryTokenList, "GET", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (RepositoryTokenList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"friendlyName": "R1CN"},
        None,
        401,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"friendlyName": "R1CN"},
        "devtable",
        410,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"friendlyName": "R1CN"},
        "freshuser",
        403,
    ),
    (
        RepositoryTokenList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"friendlyName": "R1CN"},
        "reader",
        403,
    ),
    (RepositoryBuildList, "GET", {"repository": "public/publicrepo"}, None, None, 200),
    (RepositoryBuildList, "GET", {"repository": "public/publicrepo"}, None, "devtable", 200),
    (RepositoryBuildList, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 200),
    (RepositoryBuildList, "GET", {"repository": "public/publicrepo"}, None, "reader", 200),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "public/publicrepo"},
        {"file_id": "UX7K"},
        None,
        401,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "public/publicrepo"},
        {"file_id": "UX7K"},
        "devtable",
        403,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "public/publicrepo"},
        {"file_id": "UX7K"},
        "freshuser",
        403,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "public/publicrepo"},
        {"file_id": "UX7K"},
        "reader",
        403,
    ),
    (RepositoryBuildList, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryBuildList, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (RepositoryBuildList, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (RepositoryBuildList, "GET", {"repository": "devtable/shared"}, None, "reader", 200),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "devtable/shared"},
        {"file_id": "UX7K"},
        None,
        401,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "devtable/shared"},
        {"file_id": "UX7K"},
        "devtable",
        201,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "devtable/shared"},
        {"file_id": "UX7K"},
        "freshuser",
        403,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "devtable/shared"},
        {"file_id": "UX7K"},
        "reader",
        403,
    ),
    (RepositoryBuildList, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (RepositoryBuildList, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 200),
    (RepositoryBuildList, "GET", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (RepositoryBuildList, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 200),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"file_id": "UX7K"},
        None,
        401,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"file_id": "UX7K"},
        "devtable",
        201,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"file_id": "UX7K"},
        "freshuser",
        403,
    ),
    (
        RepositoryBuildList,
        "POST",
        {"repository": "buynlarge/orgrepo"},
        {"file_id": "UX7K"},
        "reader",
        403,
    ),
    (RepositoryLogs, "GET", {"repository": "public/publicrepo"}, None, None, 401),
    (RepositoryLogs, "GET", {"repository": "public/publicrepo"}, None, "devtable", 403),
    (RepositoryLogs, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 403),
    (RepositoryLogs, "GET", {"repository": "public/publicrepo"}, None, "reader", 403),
    (RepositoryLogs, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (RepositoryLogs, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (RepositoryLogs, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (RepositoryLogs, "GET", {"repository": "devtable/shared"}, None, "reader", 403),
    (RepositoryLogs, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (RepositoryLogs, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 200),
    (RepositoryLogs, "GET", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (RepositoryLogs, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (UserRobot, "DELETE", {"robot_shortname": "robotname"}, None, None, 401),
    (UserRobot, "DELETE", {"robot_shortname": "robotname"}, None, "devtable", 400),
    (UserRobot, "DELETE", {"robot_shortname": "robotname"}, None, "freshuser", 400),
    (UserRobot, "DELETE", {"robot_shortname": "robotname"}, None, "reader", 400),
    (UserRobot, "GET", {"robot_shortname": "robotname"}, None, None, 401),
    (UserRobot, "GET", {"robot_shortname": "robotname"}, None, "devtable", 400),
    (UserRobot, "GET", {"robot_shortname": "robotname"}, None, "freshuser", 400),
    (UserRobot, "GET", {"robot_shortname": "robotname"}, None, "reader", 400),
    (UserRobot, "PUT", {"robot_shortname": "robotname"}, {}, None, 401),
    (UserRobot, "PUT", {"robot_shortname": "robotname"}, {}, "devtable", 201),
    (UserRobot, "PUT", {"robot_shortname": "robotname"}, {}, "freshuser", 201),
    (UserRobot, "PUT", {"robot_shortname": "robotname"}, {}, "reader", 201),
    (RegenerateUserRobot, "POST", {"robot_shortname": "robotname"}, None, None, 401),
    (RegenerateUserRobot, "POST", {"robot_shortname": "robotname"}, None, "devtable", 400),
    (RegenerateUserRobot, "POST", {"robot_shortname": "robotname"}, None, "freshuser", 400),
    (RegenerateUserRobot, "POST", {"robot_shortname": "robotname"}, None, "reader", 400),
    (
        RegenerateOrgRobot,
        "POST",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        None,
        401,
    ),
    (
        RegenerateOrgRobot,
        "POST",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "devtable",
        400,
    ),
    (
        RegenerateOrgRobot,
        "POST",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "freshuser",
        403,
    ),
    (
        RegenerateOrgRobot,
        "POST",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "reader",
        403,
    ),
    (UserRobotPermissions, "GET", {"robot_shortname": "robotname"}, None, None, 401),
    (UserRobotPermissions, "GET", {"robot_shortname": "robotname"}, None, "devtable", 400),
    (UserRobotPermissions, "GET", {"robot_shortname": "robotname"}, None, "freshuser", 400),
    (UserRobotPermissions, "GET", {"robot_shortname": "robotname"}, None, "reader", 400),
    (
        OrgRobotPermissions,
        "GET",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        None,
        401,
    ),
    (
        OrgRobotPermissions,
        "GET",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "devtable",
        400,
    ),
    (
        OrgRobotPermissions,
        "GET",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "freshuser",
        403,
    ),
    (
        OrgRobotPermissions,
        "GET",
        {"orgname": "buynlarge", "robot_shortname": "robotname"},
        None,
        "reader",
        403,
    ),
    (Organization, "DELETE", {"orgname": "buynlarge"}, {}, None, 401),
    (Organization, "DELETE", {"orgname": "buynlarge"}, {}, "devtable", 204),
    (Organization, "DELETE", {"orgname": "buynlarge"}, {}, "freshuser", 403),
    (Organization, "DELETE", {"orgname": "buynlarge"}, {}, "reader", 403),
    (Organization, "GET", {"orgname": "buynlarge"}, None, None, 200),
    (Organization, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (Organization, "GET", {"orgname": "buynlarge"}, None, "freshuser", 200),
    (Organization, "GET", {"orgname": "buynlarge"}, None, "reader", 200),
    (Organization, "PUT", {"orgname": "buynlarge"}, {}, None, 401),
    (Organization, "PUT", {"orgname": "buynlarge"}, {}, "devtable", 200),
    (Organization, "PUT", {"orgname": "buynlarge"}, {}, "freshuser", 403),
    (Organization, "PUT", {"orgname": "buynlarge"}, {}, "reader", 403),
    (Repository, "DELETE", {"repository": "public/publicrepo"}, None, None, 401),
    (Repository, "DELETE", {"repository": "public/publicrepo"}, None, "devtable", 403),
    (Repository, "DELETE", {"repository": "public/publicrepo"}, None, "freshuser", 403),
    (Repository, "DELETE", {"repository": "public/publicrepo"}, None, "reader", 403),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, None, 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "devtable", 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "freshuser", 200),
    (Repository, "GET", {"repository": "public/publicrepo"}, None, "reader", 200),
    (Repository, "PUT", {"repository": "public/publicrepo"}, {"description": "WXNG"}, None, 401),
    (
        Repository,
        "PUT",
        {"repository": "public/publicrepo"},
        {"description": "WXNG"},
        "devtable",
        403,
    ),
    (
        Repository,
        "PUT",
        {"repository": "public/publicrepo"},
        {"description": "WXNG"},
        "freshuser",
        403,
    ),
    (
        Repository,
        "PUT",
        {"repository": "public/publicrepo"},
        {"description": "WXNG"},
        "reader",
        403,
    ),
    (Repository, "DELETE", {"repository": "devtable/shared"}, None, None, 401),
    (Repository, "DELETE", {"repository": "devtable/shared"}, None, "devtable", 204),
    (Repository, "DELETE", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (Repository, "DELETE", {"repository": "devtable/shared"}, None, "reader", 403),
    (Repository, "GET", {"repository": "devtable/shared"}, None, None, 401),
    (Repository, "GET", {"repository": "devtable/shared"}, None, "devtable", 200),
    (Repository, "GET", {"repository": "devtable/shared"}, None, "freshuser", 403),
    (Repository, "GET", {"repository": "devtable/shared"}, None, "reader", 200),
    (Repository, "PUT", {"repository": "devtable/shared"}, {"description": "WXNG"}, None, 401),
    (
        Repository,
        "PUT",
        {"repository": "devtable/shared"},
        {"description": "WXNG"},
        "devtable",
        200,
    ),
    (
        Repository,
        "PUT",
        {"repository": "devtable/shared"},
        {"description": "WXNG"},
        "freshuser",
        403,
    ),
    (Repository, "PUT", {"repository": "devtable/shared"}, {"description": "WXNG"}, "reader", 403),
    (Repository, "DELETE", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (Repository, "DELETE", {"repository": "buynlarge/orgrepo"}, None, "devtable", 204),
    (Repository, "DELETE", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (Repository, "DELETE", {"repository": "buynlarge/orgrepo"}, None, "reader", 403),
    (Repository, "GET", {"repository": "buynlarge/orgrepo"}, None, None, 401),
    (Repository, "GET", {"repository": "buynlarge/orgrepo"}, None, "devtable", 200),
    (Repository, "GET", {"repository": "buynlarge/orgrepo"}, None, "freshuser", 403),
    (Repository, "GET", {"repository": "buynlarge/orgrepo"}, None, "reader", 200),
    (Repository, "PUT", {"repository": "buynlarge/orgrepo"}, {"description": "WXNG"}, None, 401),
    (
        Repository,
        "PUT",
        {"repository": "buynlarge/orgrepo"},
        {"description": "WXNG"},
        "devtable",
        200,
    ),
    (
        Repository,
        "PUT",
        {"repository": "buynlarge/orgrepo"},
        {"description": "WXNG"},
        "freshuser",
        403,
    ),
    (
        Repository,
        "PUT",
        {"repository": "buynlarge/orgrepo"},
        {"description": "WXNG"},
        "reader",
        403,
    ),
    (EntitySearch, "GET", {"prefix": "R9NZ"}, None, None, 200),
    (EntitySearch, "GET", {"prefix": "R9NZ"}, None, "devtable", 200),
    (EntitySearch, "GET", {"prefix": "R9NZ"}, None, "freshuser", 200),
    (EntitySearch, "GET", {"prefix": "R9NZ"}, None, "reader", 200),
    (ApplicationInformation, "GET", {"client_id": "3LGI"}, None, None, 404),
    (ApplicationInformation, "GET", {"client_id": "3LGI"}, None, "devtable", 404),
    (ApplicationInformation, "GET", {"client_id": "3LGI"}, None, "freshuser", 404),
    (ApplicationInformation, "GET", {"client_id": "3LGI"}, None, "reader", 404),
    (OrganizationApplications, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationApplications, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationApplications, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationApplications, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (OrganizationApplications, "POST", {"orgname": "buynlarge"}, {"name": "foo"}, None, 401),
    (OrganizationApplications, "POST", {"orgname": "buynlarge"}, {"name": "foo"}, "devtable", 200),
    (
        OrganizationApplications,
        "POST",
        {"orgname": "buynlarge"},
        {"name": "foo"},
        "freshuser",
        403,
    ),
    (OrganizationApplications, "POST", {"orgname": "buynlarge"}, {"name": "foo"}, "reader", 403),
    (
        OrganizationApplicationResource,
        "DELETE",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        None,
        401,
    ),
    (
        OrganizationApplicationResource,
        "DELETE",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "devtable",
        204,
    ),
    (
        OrganizationApplicationResource,
        "DELETE",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationApplicationResource,
        "DELETE",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "reader",
        403,
    ),
    (
        OrganizationApplicationResource,
        "GET",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        None,
        401,
    ),
    (
        OrganizationApplicationResource,
        "GET",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "devtable",
        200,
    ),
    (
        OrganizationApplicationResource,
        "GET",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationApplicationResource,
        "GET",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "reader",
        403,
    ),
    (
        OrganizationApplicationResource,
        "PUT",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        {"redirect_uri": "foo", "name": "foo", "application_uri": "foo"},
        None,
        401,
    ),
    (
        OrganizationApplicationResource,
        "PUT",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        {"redirect_uri": "foo", "name": "foo", "application_uri": "foo"},
        "devtable",
        200,
    ),
    (
        OrganizationApplicationResource,
        "PUT",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        {"redirect_uri": "foo", "name": "foo", "application_uri": "foo"},
        "freshuser",
        403,
    ),
    (
        OrganizationApplicationResource,
        "PUT",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        {"redirect_uri": "foo", "name": "foo", "application_uri": "foo"},
        "reader",
        403,
    ),
    (
        OrganizationApplicationResetClientSecret,
        "POST",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        None,
        401,
    ),
    (
        OrganizationApplicationResetClientSecret,
        "POST",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "devtable",
        200,
    ),
    (
        OrganizationApplicationResetClientSecret,
        "POST",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationApplicationResetClientSecret,
        "POST",
        {"orgname": "buynlarge", "client_id": "deadbeef"},
        None,
        "reader",
        403,
    ),
    (Users, "GET", {"username": "devtable"}, None, None, 200),
    (UserNotificationList, "GET", None, None, None, 401),
    (UserNotificationList, "GET", None, None, "devtable", 200),
    (UserNotificationList, "GET", None, None, "freshuser", 200),
    (UserNotificationList, "GET", None, None, "reader", 200),
    (UserAuthorizationList, "GET", None, None, None, 401),
    (UserAuthorizationList, "GET", None, None, "devtable", 200),
    (UserAuthorizationList, "GET", None, None, "freshuser", 200),
    (UserAuthorizationList, "GET", None, None, "reader", 200),
    (UserAuthorization, "DELETE", {"access_token_uuid": "fake"}, None, None, 401),
    (UserAuthorization, "DELETE", {"access_token_uuid": "fake"}, None, "devtable", 404),
    (UserAuthorization, "DELETE", {"access_token_uuid": "fake"}, None, "freshuser", 404),
    (UserAuthorization, "DELETE", {"access_token_uuid": "fake"}, None, "reader", 404),
    (UserAuthorization, "GET", {"access_token_uuid": "fake"}, None, None, 401),
    (UserAuthorization, "GET", {"access_token_uuid": "fake"}, None, "devtable", 404),
    (UserAuthorization, "GET", {"access_token_uuid": "fake"}, None, "freshuser", 404),
    (UserAuthorization, "GET", {"access_token_uuid": "fake"}, None, "reader", 404),
    (UserAggregateLogs, "GET", None, None, None, 401),
    (UserAggregateLogs, "GET", None, None, "devtable", 200),
    (UserAggregateLogs, "GET", None, None, "freshuser", 200),
    (UserAggregateLogs, "GET", None, None, "reader", 200),
    (OrgAggregateLogs, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrgAggregateLogs, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrgAggregateLogs, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrgAggregateLogs, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (RepositoryAggregateLogs, "GET", {"repository": "devtable/simple"}, None, None, 401),
    (RepositoryAggregateLogs, "GET", {"repository": "devtable/simple"}, None, "devtable", 200),
    (RepositoryAggregateLogs, "GET", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepositoryAggregateLogs, "GET", {"repository": "devtable/simple"}, None, "reader", 403),
    (ExportUserLogs, "POST", None, EXPORTLOGS_PARAMS, None, 401),
    (ExportUserLogs, "POST", None, EXPORTLOGS_PARAMS, "devtable", 200),
    (ExportUserLogs, "POST", None, EXPORTLOGS_PARAMS, "freshuser", 200),
    (ExportUserLogs, "POST", None, EXPORTLOGS_PARAMS, "reader", 200),
    (ExportOrgLogs, "POST", {"orgname": "buynlarge"}, EXPORTLOGS_PARAMS, None, 401),
    (ExportOrgLogs, "POST", {"orgname": "buynlarge"}, EXPORTLOGS_PARAMS, "devtable", 200),
    (ExportOrgLogs, "POST", {"orgname": "buynlarge"}, EXPORTLOGS_PARAMS, "freshuser", 403),
    (ExportOrgLogs, "POST", {"orgname": "buynlarge"}, EXPORTLOGS_PARAMS, "reader", 403),
    (ExportRepositoryLogs, "POST", {"repository": "devtable/simple"}, EXPORTLOGS_PARAMS, None, 401),
    (
        ExportRepositoryLogs,
        "POST",
        {"repository": "devtable/simple"},
        EXPORTLOGS_PARAMS,
        "devtable",
        200,
    ),
    (
        ExportRepositoryLogs,
        "POST",
        {"repository": "devtable/simple"},
        EXPORTLOGS_PARAMS,
        "freshuser",
        403,
    ),
    (
        ExportRepositoryLogs,
        "POST",
        {"repository": "devtable/simple"},
        EXPORTLOGS_PARAMS,
        "reader",
        403,
    ),
    (SuperUserAggregateLogs, "GET", None, None, None, 401),
    (SuperUserAggregateLogs, "GET", None, None, "devtable", 200),
    (SuperUserAggregateLogs, "GET", None, None, "freshuser", 403),
    (SuperUserAggregateLogs, "GET", None, None, "reader", 403),
    (SuperUserLogs, "GET", None, None, None, 401),
    (SuperUserLogs, "GET", None, None, "devtable", 200),
    (SuperUserLogs, "GET", None, None, "freshuser", 403),
    (SuperUserLogs, "GET", None, None, "reader", 403),
    (SuperUserSendRecoveryEmail, "POST", {"username": "someuser"}, None, None, 401),
    (SuperUserSendRecoveryEmail, "POST", {"username": "someuser"}, None, "devtable", 404),
    (SuperUserSendRecoveryEmail, "POST", {"username": "someuser"}, None, "freshuser", 403),
    (SuperUserSendRecoveryEmail, "POST", {"username": "someuser"}, None, "reader", 403),
    (SuperUserTakeOwnership, "POST", {"namespace": "invalidnamespace"}, {}, None, 401),
    (SuperUserTakeOwnership, "POST", {"namespace": "invalidnamespace"}, {}, "devtable", 404),
    (SuperUserTakeOwnership, "POST", {"namespace": "invalidnamespace"}, {}, "freshuser", 403),
    (SuperUserTakeOwnership, "POST", {"namespace": "invalidnamespace"}, {}, "reader", 403),
    (SuperUserServiceKeyApproval, "POST", {"kid": 1234}, {}, None, 401),
    (SuperUserServiceKeyApproval, "POST", {"kid": 1234}, {}, "devtable", 404),
    (SuperUserServiceKeyApproval, "POST", {"kid": 1234}, {}, "freshuser", 403),
    (SuperUserServiceKeyApproval, "POST", {"kid": 1234}, {}, "reader", 403),
    (SuperUserServiceKeyManagement, "GET", None, None, None, 401),
    (SuperUserServiceKeyManagement, "GET", None, None, "devtable", 200),
    (SuperUserServiceKeyManagement, "GET", None, None, "freshuser", 403),
    (SuperUserServiceKeyManagement, "GET", None, None, "reader", 403),
    (
        SuperUserServiceKeyManagement,
        "POST",
        None,
        {"expiration": None, "service": "someservice"},
        None,
        401,
    ),
    (
        SuperUserServiceKeyManagement,
        "POST",
        None,
        {"expiration": None, "service": "someservice"},
        "devtable",
        200,
    ),
    (
        SuperUserServiceKeyManagement,
        "POST",
        None,
        {"expiration": None, "service": "someservice"},
        "freshuser",
        403,
    ),
    (
        SuperUserServiceKeyManagement,
        "POST",
        None,
        {"expiration": None, "service": "someservice"},
        "reader",
        403,
    ),
    (SuperUserServiceKey, "DELETE", {"kid": 1234}, None, None, 401),
    (SuperUserServiceKey, "DELETE", {"kid": 1234}, None, "devtable", 404),
    (SuperUserServiceKey, "DELETE", {"kid": 1234}, None, "freshuser", 403),
    (SuperUserServiceKey, "DELETE", {"kid": 1234}, None, "reader", 403),
    (SuperUserServiceKey, "GET", {"kid": 1234}, None, None, 401),
    (SuperUserServiceKey, "GET", {"kid": 1234}, None, "devtable", 404),
    (SuperUserServiceKey, "GET", {"kid": 1234}, None, "freshuser", 403),
    (SuperUserServiceKey, "GET", {"kid": 1234}, None, "reader", 403),
    (SuperUserServiceKey, "PUT", {"kid": 1234}, {}, None, 401),
    (SuperUserServiceKey, "PUT", {"kid": 1234}, {}, "devtable", 404),
    (SuperUserServiceKey, "PUT", {"kid": 1234}, {}, "freshuser", 403),
    (SuperUserServiceKey, "PUT", {"kid": 1234}, {}, "reader", 403),
    (TeamMemberInvite, "DELETE", {"code": "foobarbaz"}, None, None, 401),
    (TeamMemberInvite, "DELETE", {"code": "foobarbaz"}, None, "devtable", 400),
    (TeamMemberInvite, "DELETE", {"code": "foobarbaz"}, None, "freshuser", 400),
    (TeamMemberInvite, "DELETE", {"code": "foobarbaz"}, None, "reader", 400),
    (TeamMemberInvite, "PUT", {"code": "foobarbaz"}, None, None, 401),
    (TeamMemberInvite, "PUT", {"code": "foobarbaz"}, None, "devtable", 400),
    (TeamMemberInvite, "PUT", {"code": "foobarbaz"}, None, "freshuser", 400),
    (TeamMemberInvite, "PUT", {"code": "foobarbaz"}, None, "reader", 400),
    (ConductSearch, "GET", None, None, None, 200),
    (ConductSearch, "GET", None, None, "devtable", 200),
    (ChangeLog, "GET", None, None, None, 401),
    (ChangeLog, "GET", None, None, "devtable", 200),
    (ChangeLog, "GET", None, None, "freshuser", 403),
    (ChangeLog, "GET", None, None, "reader", 403),
    (SuperUserOrganizationList, "GET", None, None, None, 401),
    (SuperUserOrganizationList, "GET", None, None, "devtable", 200),
    (SuperUserOrganizationList, "GET", None, None, "freshuser", 403),
    (SuperUserOrganizationList, "GET", None, None, "reader", 403),
    (SuperUserOrganizationManagement, "DELETE", {"name": "buynlarge"}, None, None, 401),
    (SuperUserOrganizationManagement, "DELETE", {"name": "buynlarge"}, None, "devtable", 204),
    (SuperUserOrganizationManagement, "DELETE", {"name": "buynlarge"}, None, "freshuser", 403),
    (SuperUserOrganizationManagement, "DELETE", {"name": "buynlarge"}, None, "reader", 403),
    (SuperUserOrganizationManagement, "PUT", {"name": "buynlarge"}, {}, None, 401),
    (SuperUserOrganizationManagement, "PUT", {"name": "buynlarge"}, {}, "devtable", 200),
    (SuperUserOrganizationManagement, "PUT", {"name": "buynlarge"}, {}, "freshuser", 403),
    (SuperUserOrganizationManagement, "PUT", {"name": "buynlarge"}, {}, "reader", 403),
    (SuperUserList, "GET", None, None, None, 401),
    (SuperUserList, "GET", None, None, "devtable", 200),
    (SuperUserList, "GET", None, None, "freshuser", 403),
    (SuperUserList, "GET", None, None, "reader", 403),
    (SuperUserList, "POST", None, {"username": "foo"}, None, 401),
    (SuperUserList, "POST", None, {"username": "foo"}, "devtable", 400),
    (SuperUserList, "POST", None, {"username": "foo"}, "freshuser", 403),
    (SuperUserList, "POST", None, {"username": "foo"}, "reader", 403),
    (SuperUserManagement, "DELETE", {"username": "freshuser"}, None, None, 401),
    (SuperUserManagement, "DELETE", {"username": "freshuser"}, None, "devtable", 204),
    (SuperUserManagement, "DELETE", {"username": "freshuser"}, None, "freshuser", 403),
    (SuperUserManagement, "DELETE", {"username": "freshuser"}, None, "reader", 403),
    (SuperUserManagement, "GET", {"username": "freshuser"}, None, None, 401),
    (SuperUserManagement, "GET", {"username": "freshuser"}, None, "devtable", 200),
    (SuperUserManagement, "GET", {"username": "freshuser"}, None, "freshuser", 403),
    (SuperUserManagement, "GET", {"username": "freshuser"}, None, "reader", 403),
    (SuperUserManagement, "PUT", {"username": "freshuser"}, {}, None, 401),
    (SuperUserManagement, "PUT", {"username": "freshuser"}, {}, "devtable", 200),
    (SuperUserManagement, "PUT", {"username": "freshuser"}, {}, "freshuser", 403),
    (SuperUserManagement, "PUT", {"username": "freshuser"}, {}, "reader", 403),
    (GlobalUserMessages, "GET", None, None, None, 200),
    (GlobalUserMessages, "POST", None, None, None, 401),
    (
        GlobalUserMessages,
        "POST",
        None,
        {"message": {"content": "msg", "media_type": "text/plain", "severity": "info"}},
        "devtable",
        201,
    ),
    (
        GlobalUserMessages,
        "POST",
        None,
        {"message": {"content": "msg", "media_type": "text/plain", "severity": "info"}},
        "freshuser",
        403,
    ),
    (
        GlobalUserMessages,
        "POST",
        None,
        {"message": {"content": "msg", "media_type": "text/plain", "severity": "info"}},
        "reader",
        403,
    ),
    (GlobalUserMessage, "DELETE", {"uuid": "1234"}, None, None, 401),
    (GlobalUserMessage, "DELETE", {"uuid": "1234"}, None, "devtable", 204),
    (GlobalUserMessage, "DELETE", {"uuid": "1234"}, None, "freshuser", 403),
    (GlobalUserMessage, "DELETE", {"uuid": "1234"}, None, "reader", 403),
    (UserInvoiceFieldList, "GET", None, None, None, 401),
    (UserInvoiceFieldList, "GET", None, None, "devtable", 200),
    (UserInvoiceFieldList, "GET", None, None, "freshuser", 404),
    (UserInvoiceFieldList, "GET", None, None, "reader", 404),
    (UserInvoiceFieldList, "POST", None, None, None, 401),
    (UserInvoiceFieldList, "POST", None, {"value": "bar", "title": "foo"}, "devtable", 200),
    (UserInvoiceFieldList, "POST", None, {"value": "bar", "title": "foo"}, "freshuser", 404),
    (UserInvoiceFieldList, "POST", None, {"value": "bar", "title": "foo"}, "reader", 404),
    (UserInvoiceField, "DELETE", {"field_uuid": "1234"}, None, None, 401),
    (UserInvoiceField, "DELETE", {"field_uuid": "1234"}, None, "devtable", 201),
    (UserInvoiceField, "DELETE", {"field_uuid": "1234"}, None, "freshuser", 404),
    (UserInvoiceField, "DELETE", {"field_uuid": "1234"}, None, "reader", 404),
    (OrganizationInvoiceFieldList, "GET", {"orgname": "buynlarge"}, None, None, 403),
    (OrganizationInvoiceFieldList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationInvoiceFieldList, "GET", {"orgname": "buynlarge"}, None, "freshuser", 403),
    (OrganizationInvoiceFieldList, "GET", {"orgname": "buynlarge"}, None, "reader", 403),
    (
        OrganizationInvoiceFieldList,
        "POST",
        {"orgname": "buynlarge"},
        {"value": "bar", "title": "foo"},
        None,
        403,
    ),
    (
        OrganizationInvoiceFieldList,
        "POST",
        {"orgname": "buynlarge"},
        {"value": "bar", "title": "foo"},
        "devtable",
        200,
    ),
    (
        OrganizationInvoiceFieldList,
        "POST",
        {"orgname": "buynlarge"},
        {"value": "bar", "title": "foo"},
        "freshuser",
        403,
    ),
    (
        OrganizationInvoiceFieldList,
        "POST",
        {"orgname": "buynlarge"},
        {"value": "bar", "title": "foo"},
        "reader",
        403,
    ),
    (
        OrganizationInvoiceField,
        "DELETE",
        {"orgname": "buynlarge", "field_uuid": "1234"},
        None,
        None,
        403,
    ),
    (
        OrganizationInvoiceField,
        "DELETE",
        {"orgname": "buynlarge", "field_uuid": "1234"},
        None,
        "devtable",
        201,
    ),
    (
        OrganizationInvoiceField,
        "DELETE",
        {"orgname": "buynlarge", "field_uuid": "1234"},
        None,
        "freshuser",
        403,
    ),
    (
        OrganizationInvoiceField,
        "DELETE",
        {"orgname": "buynlarge", "field_uuid": "1234"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryManifestSecurity,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        None,
        401,
    ),
    (
        RepositoryManifestSecurity,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryManifestSecurity,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryManifestSecurity,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryManifestLabels,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        None,
        401,
    ),
    (
        RepositoryManifestLabels,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "devtable",
        404,
    ),
    (
        RepositoryManifestLabels,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "freshuser",
        403,
    ),
    (
        RepositoryManifestLabels,
        "GET",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "reader",
        403,
    ),
    (
        RepositoryManifestLabels,
        "POST",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        {"media_type": "text/plain", "value": "bar", "key": "foo"},
        None,
        401,
    ),
    (
        RepositoryManifestLabels,
        "POST",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        {"media_type": "text/plain", "value": "bar", "key": "foo"},
        "devtable",
        404,
    ),
    (
        RepositoryManifestLabels,
        "POST",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        {"media_type": "text/plain", "value": "bar", "key": "foo"},
        "freshuser",
        403,
    ),
    (
        RepositoryManifestLabels,
        "POST",
        {"manifestref": "sha256:abcd", "repository": "devtable/simple"},
        {"media_type": "text/plain", "value": "bar", "key": "foo"},
        "reader",
        403,
    ),
    (
        ManageRepositoryManifestLabel,
        "GET",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        None,
        401,
    ),
    (
        ManageRepositoryManifestLabel,
        "GET",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "devtable",
        404,
    ),
    (
        ManageRepositoryManifestLabel,
        "GET",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "freshuser",
        403,
    ),
    (
        ManageRepositoryManifestLabel,
        "GET",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "reader",
        403,
    ),
    (
        ManageRepositoryManifestLabel,
        "DELETE",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        None,
        401,
    ),
    (
        ManageRepositoryManifestLabel,
        "DELETE",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "devtable",
        404,
    ),
    (
        ManageRepositoryManifestLabel,
        "DELETE",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "freshuser",
        403,
    ),
    (
        ManageRepositoryManifestLabel,
        "DELETE",
        {"labelid": "someid", "manifestref": "sha256:abcd", "repository": "devtable/simple"},
        None,
        "reader",
        403,
    ),
    (
        InviteTeamMember,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        None,
        401,
    ),
    (
        InviteTeamMember,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "devtable",
        200,
    ),
    (
        InviteTeamMember,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "freshuser",
        403,
    ),
    (
        InviteTeamMember,
        "PUT",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "reader",
        403,
    ),
    (
        InviteTeamMember,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        None,
        401,
    ),
    (
        InviteTeamMember,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "devtable",
        404,
    ),
    (
        InviteTeamMember,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "freshuser",
        403,
    ),
    (
        InviteTeamMember,
        "DELETE",
        {"orgname": "buynlarge", "teamname": "owners", "email": "a@example.com"},
        None,
        "reader",
        403,
    ),
    (
        TestRepositoryNotification,
        "POST",
        {"repository": "buynlarge/orgrepo", "uuid": "foo"},
        None,
        None,
        401,
    ),
    (
        TestRepositoryNotification,
        "POST",
        {"repository": "buynlarge/orgrepo", "uuid": "foo"},
        None,
        "devtable",
        400,
    ),
    (
        TestRepositoryNotification,
        "POST",
        {"repository": "buynlarge/orgrepo", "uuid": "foo"},
        None,
        "freshuser",
        403,
    ),
    (
        TestRepositoryNotification,
        "POST",
        {"repository": "buynlarge/orgrepo", "uuid": "foo"},
        None,
        "reader",
        403,
    ),
    (LinkExternalEntity, "POST", {"username": "foo"}, None, None, 404),
    (
        BuildTriggerSourceNamespaces,
        "GET",
        {"repository": "devtable/simple", "trigger_uuid": "foo"},
        None,
        None,
        401,
    ),
    (
        BuildTriggerSourceNamespaces,
        "GET",
        {"repository": "devtable/simple", "trigger_uuid": "foo"},
        None,
        "devtable",
        404,
    ),
    (
        BuildTriggerSourceNamespaces,
        "GET",
        {"repository": "devtable/simple", "trigger_uuid": "foo"},
        None,
        "freshuser",
        403,
    ),
    (
        BuildTriggerSourceNamespaces,
        "GET",
        {"repository": "devtable/simple", "trigger_uuid": "foo"},
        None,
        "reader",
        403,
    ),
    (RepoMirrorResource, "GET", {"repository": "devtable/simple"}, None, None, 401),
    (RepoMirrorResource, "GET", {"repository": "devtable/simple"}, None, "devtable", 404),
    (RepoMirrorResource, "GET", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepoMirrorResource, "GET", {"repository": "devtable/simple"}, None, "reader", 403),
    (RepoMirrorResource, "POST", {"repository": "devtable/simple"}, None, None, 401),
    (RepoMirrorResource, "POST", {"repository": "devtable/simple"}, None, "devtable", 400),
    (RepoMirrorResource, "POST", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepoMirrorResource, "POST", {"repository": "devtable/simple"}, None, "reader", 403),
    (RepoMirrorResource, "PUT", {"repository": "devtable/simple"}, None, None, 401),
    (RepoMirrorResource, "PUT", {"repository": "devtable/simple"}, None, "devtable", 400),
    (RepoMirrorResource, "PUT", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepoMirrorResource, "PUT", {"repository": "devtable/simple"}, None, "reader", 403),
    (RepoMirrorSyncNowResource, "POST", {"repository": "devtable/simple"}, None, None, 401),
    (RepoMirrorSyncNowResource, "POST", {"repository": "devtable/simple"}, None, "devtable", 404),
    (RepoMirrorSyncNowResource, "POST", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepoMirrorSyncNowResource, "POST", {"repository": "devtable/simple"}, None, "reader", 403),
    (RepoMirrorSyncCancelResource, "POST", {"repository": "devtable/simple"}, None, None, 401),
    (
        RepoMirrorSyncCancelResource,
        "POST",
        {"repository": "devtable/simple"},
        None,
        "devtable",
        404,
    ),
    (
        RepoMirrorSyncCancelResource,
        "POST",
        {"repository": "devtable/simple"},
        None,
        "freshuser",
        403,
    ),
    (RepoMirrorSyncCancelResource, "POST", {"repository": "devtable/simple"}, None, "reader", 403),
    (RepositoryStateResource, "PUT", {"repository": "devtable/simple"}, None, None, 401),
    (RepositoryStateResource, "PUT", {"repository": "devtable/simple"}, None, "devtable", 400),
    (RepositoryStateResource, "PUT", {"repository": "devtable/simple"}, None, "freshuser", 403),
    (RepositoryStateResource, "PUT", {"repository": "devtable/simple"}, None, "reader", 403),
    (
        OrganizationProxyCacheConfig,
        "GET",
        {"orgname": "buynlarge"},
        None,
        "randomuser",
        403,
    ),
    (
        OrganizationProxyCacheConfig,
        "GET",
        {"orgname": "sellnsmall"},
        None,
        "devtable",
        200,
    ),
    (
        OrganizationProxyCacheConfig,
        "POST",
        {"orgname": "buynlarge"},
        {"org_name": "buynlarge", "upstream_registry": "some-upstream-registry"},
        None,
        401,
    ),
    (
        OrganizationProxyCacheConfig,
        "POST",
        {"orgname": "buynlarge"},
        {"org_name": "buynlarge", "upstream_registry": "some-upstream-registry"},
        "randomuser",
        403,
    ),
    (
        OrganizationProxyCacheConfig,
        "POST",
        {"orgname": "sellnsmall"},
        {"org_name": "sellnsmall", "upstream_registry": None},
        "devtable",
        400,
    ),
    (
        OrganizationProxyCacheConfig,
        "POST",
        {"orgname": "library"},
        {"org_name": "library", "upstream_registry": "some-upstream-registry"},
        "devtable",
        201,
    ),
    (
        OrganizationProxyCacheConfig,
        "DELETE",
        {"orgname": "buynlarge"},
        None,
        None,
        401,
    ),
    (
        OrganizationProxyCacheConfig,
        "DELETE",
        {"orgname": "buynlarge"},
        None,
        "randomuser",
        403,
    ),
    (
        OrganizationProxyCacheConfig,
        "DELETE",
        {"orgname": "proxyorg"},
        None,
        "devtable",
        201,
    ),
    (
        ProxyCacheConfigValidation,
        "POST",
        {"orgname": "buynlarge"},
        {"org_name": "buynlarge", "upstream_registry": "some-upstream-registry"},
        None,
        401,
    ),
    (
        ProxyCacheConfigValidation,
        "POST",
        {"orgname": "buynlarge"},
        {"org_name": "buynlarge", "upstream_registry": "some-upstream-registry"},
        "randomuser",
        403,
    ),
    (
        ProxyCacheConfigValidation,
        "POST",
        {"orgname": "sellnsmall"},
        {"org_name": "sellnsmall", "upstream_registry": None},
        "devtable",
        400,
    ),
    (
        ProxyCacheConfigValidation,
        "POST",
        {"orgname": "buynlarge"},
        {"org_name": "buynlarge", "upstream_registry": "docker.io"},
        "devtable",
        202,
    ),
    (OrganizationQuotaList, "GET", {"orgname": "buynlarge"}, None, "devtable", 200),
    (OrganizationQuotaList, "GET", {"orgname": "buynlarge"}, None, "randomuser", 403),
    (OrganizationQuotaList, "GET", {"orgname": "buynlarge"}, None, None, 401),
    (OrganizationQuotaList, "POST", {"orgname": "buynlarge"}, {"limit_bytes": 200000}, None, 401),
    (
        OrganizationQuotaList,
        "POST",
        {"orgname": "buynlarge"},
        {"limit_bytes": 200000},
        "devtable",
        400,
    ),  # Quota already exists in test db
    (
        OrganizationQuotaList,
        "POST",
        {"orgname": "buynlarge"},
        {"limit_bytes": 200000},
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaList,
        "POST",
        {"orgname": "library"},
        {"limit_bytes": 200000},
        "devtable",
        201,
    ),
    (OrganizationQuota, "GET", {"orgname": "buynlarge", "quota_id": 1}, None, None, 401),
    (OrganizationQuota, "GET", {"orgname": "buynlarge", "quota_id": 1}, None, "randomuser", 403),
    (OrganizationQuota, "GET", {"orgname": "buynlarge", "quota_id": 1}, None, "devtable", 200),
    (OrganizationQuota, "GET", {"orgname": "buynlarge", "quota_id": 2}, None, "devtable", 404),
    (OrganizationQuota, "PUT", {"orgname": "buynlarge", "quota_id": 1}, {}, None, 401),
    (OrganizationQuota, "PUT", {"orgname": "buynlarge", "quota_id": 1}, {}, "randomuser", 403),
    (OrganizationQuota, "PUT", {"orgname": "buynlarge", "quota_id": 1}, {}, "devtable", 200),
    (OrganizationQuota, "DELETE", {"orgname": "buynlarge", "quota_id": 1}, None, None, 401),
    (OrganizationQuota, "DELETE", {"orgname": "buynlarge", "quota_id": 1}, None, "randomuser", 403),
    (OrganizationQuota, "DELETE", {"orgname": "buynlarge", "quota_id": 1}, None, "devtable", 204),
    (OrganizationQuotaLimitList, "GET", {"orgname": "buynlarge", "quota_id": 1}, None, None, 401),
    (
        OrganizationQuotaLimitList,
        "GET",
        {"orgname": "buynlarge", "quota_id": 1},
        None,
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaLimitList,
        "GET",
        {"orgname": "buynlarge", "quota_id": 1},
        None,
        "devtable",
        200,
    ),
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "warning", "threshold_percent": 50},
        None,
        401,
    ),
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "warning", "threshold_percent": 50},
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "warning", "threshold_percent": 50},
        "devtable",
        400,
    ),  # Exact same configuration already exists
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "undfinedtype", "threshold_percent": 60},
        "devtable",
        400,
    ),
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "warning", "threshold_percent": 60},
        "devtable",
        201,
    ),
    (
        OrganizationQuotaLimitList,
        "POST",
        {"orgname": "buynlarge", "quota_id": 1},
        {"type": "reject", "threshold_percent": 60},
        "devtable",
        201,
    ),
    (
        OrganizationQuotaLimit,
        "GET",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        None,
        401,
    ),
    (
        OrganizationQuotaLimit,
        "GET",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaLimit,
        "GET",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        "devtable",
        200,
    ),
    (
        OrganizationQuotaLimit,
        "PUT",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        {"type": "reject", "threshold_percent": 60},
        None,
        401,
    ),
    (
        OrganizationQuotaLimit,
        "PUT",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        {"type": "reject", "threshold_percent": 60},
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaLimit,
        "PUT",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        {"type": "reject", "threshold_percent": 60},
        "devtable",
        200,
    ),
    (
        OrganizationQuotaLimit,
        "PUT",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        {"type": "undefinedtype", "threshold_percent": 60},
        "devtable",
        400,
    ),
    (
        OrganizationQuotaLimit,
        "DELETE",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        None,
        401,
    ),
    (
        OrganizationQuotaLimit,
        "DELETE",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        "randomuser",
        403,
    ),
    (
        OrganizationQuotaLimit,
        "DELETE",
        {"orgname": "buynlarge", "quota_id": 1, "limit_id": 1},
        None,
        "devtable",
        204,
    ),
    (UserQuotaList, "GET", {}, None, None, 401),
    (UserQuotaList, "GET", {}, None, "freshuser", 200),
    (UserQuotaList, "GET", {}, None, "devtable", 200),
    (UserQuota, "GET", {"quota_id": 2}, None, "freshuser", 404),
    (UserQuota, "GET", {"quota_id": 2}, None, "devtable", 404),
    (UserQuota, "GET", {"quota_id": 2}, None, "randomuser", 200),
    (UserQuotaLimitList, "GET", {"quota_id": 2}, None, "devtable", 404),
    (UserQuotaLimitList, "GET", {"quota_id": 2}, None, "randomuser", 200),
    (UserQuotaLimit, "GET", {"quota_id": 2, "limit_id": 2}, None, "devtable", 404),
    (UserQuotaLimit, "GET", {"quota_id": 2, "limit_id": 2}, None, "randomuser", 200),
    (SuperUserUserQuotaList, "POST", {"namespace": "randomuser"}, {"limit_bytes": 5000}, None, 401),
    (SuperUserUserQuotaList, "POST", {"namespace": "randomuser"}, None, None, 401),
    (
        SuperUserUserQuotaList,
        "POST",
        {"namespace": "randomuser"},
        {"limit_bytes": 5000},
        "freshuser",
        403,
    ),
    (
        SuperUserUserQuotaList,
        "POST",
        {"namespace": "randomuser"},
        {"limit_bytes": 5000},
        "devtable",
        400,
    ),  # Quota for this user already exists
    (
        SuperUserUserQuotaList,
        "POST",
        {"namespace": "freshuser"},
        {"limit_bytes": 5000},
        "devtable",
        201,
    ),
    (SuperUserUserQuotaList, "POST", {"namespace": "randomuser"}, None, "devtable", 400),
    (SuperUserUserQuota, "PUT", {"namespace": "randomuser", "quota_id": 2}, {}, "randomuser", 403),
    (SuperUserUserQuota, "PUT", {"namespace": "randomuser", "quota_id": 2}, {}, "devtable", 200),
    (
        SuperUserUserQuota,
        "DELETE",
        {"namespace": "randomuser", "quota_id": 2},
        None,
        "freshuser",
        403,
    ),
    (
        SuperUserUserQuota,
        "DELETE",
        {"namespace": "randomuser", "quota_id": 2},
        None,
        "devtable",
        204,
    ),
    (
        SuperUserUserQuota,
        "DELETE",
        {"namespace": "randomuser", "quota_id": 1},
        None,
        "devtable",
        404,
    ),
]


@pytest.mark.parametrize("resource,method,params,body,identity,expected", SECURITY_TESTS)
def test_api_security(resource, method, params, body, identity, expected, client):
    with client_with_identity(identity, client) as cl:
        conduct_api_call(cl, resource, method, params, body, expected)


ALLOWED_MISSING_MODULES = {"endpoints.api.suconfig", "endpoints.api.error", "data.userfiles"}


def test_all_apis_tested(app):
    required_tests = set()

    for rule in app.url_map.iter_rules():
        endpoint_method = app.view_functions[rule.endpoint]

        # Verify that we have a view class for this API method,
        # and that we're not testing a v2 endpoint.
        if not "view_class" in dir(endpoint_method) or "v2" in rule.endpoint:
            continue

        view_class = endpoint_method.view_class
        if view_class.__module__ in ALLOWED_MISSING_MODULES:
            continue

        method_names = list(rule.methods.difference(["HEAD", "OPTIONS"]))
        full_name = "%s.%s" % (view_class.__module__, view_class.__name__)
        for method_name in method_names:
            required_tests.add("%s::%s" % (full_name, method_name.upper()))

    assert required_tests

    for test in SECURITY_TESTS:
        view_class = test[0]
        required_tests.discard(
            "%s.%s::%s" % (view_class.__module__, view_class.__name__, test[1].upper())
        )

    assert not required_tests, "API security tests missing for: %s" % required_tests


@pytest.mark.parametrize(
    "is_superuser",
    [
        (True),
        (False),
    ],
)
@pytest.mark.parametrize(
    "allow_nonsuperuser",
    [
        (True),
        (False),
    ],
)
@pytest.mark.parametrize(
    "method, expected",
    [
        ("POST", 400),
        ("DELETE", 200),
    ],
)
def test_team_sync_security(is_superuser, allow_nonsuperuser, method, expected, client):
    def is_superuser_method(_):
        return is_superuser

    with patch("auth.permissions.superusers.is_superuser", is_superuser_method):
        with toggle_feature("NONSUPERUSER_TEAM_SYNCING_SETUP", allow_nonsuperuser):
            with client_with_identity("devtable", client) as cl:
                expect_success = is_superuser or allow_nonsuperuser
                expected_status = expected if expect_success else 403
                conduct_api_call(
                    cl, OrganizationTeamSyncing, method, TEAM_PARAMS, {}, expected_status
                )
