import itertools
import logging
import threading
from collections import namedtuple
from pysqlite2 import dbapi2 as pysq3
from typing import (
    Any,
    AnyStr,
    Callable,
    ClassVar,
    Iterable,
    Iterator,
    List,
    Literal,
    Mapping,
    MutableMapping,
    MutableSet,
    Optional,
    Sequence,
    Text,
    Type,
    TypeVar,
    Union,
    overload,
)

_T = TypeVar("_T")

# Manual Adjustments
SENTINEL = object()

sqlite3 = pysq3
sqlite3 = pysq3

class NullHandler(logging.Handler):
    def emit(self, record: Any) -> None: ...

text_type = str
bytes_type = bytes
buffer_type = memoryview
basestring = str
long = int
izip_longest = itertools.zip_longest

class attrdict(dict):
    def __getattr__(self, attr: Any): ...
    def __setattr__(self, attr: Any, value: Any) -> None: ...
    def __iadd__(self, rhs: Any): ...
    def __add__(self, rhs: Any): ...

OP: Any
DJANGO_MAP: Any
JOIN: Any

def chunked(it: Any, n: Any) -> None: ...

class _callable_context_manager:
    def __call__(self, fn: Any): ...

class Proxy:
    def __init__(self) -> None: ...
    obj: Any = ...
    def initialize(self, obj: Any) -> None: ...
    def attach_callback(self, callback: Any): ...
    def passthrough(method: Any): ...
    __enter__: Any = ...
    __exit__: Any = ...
    def __getattr__(self, attr: Any): ...
    def __setattr__(self, attr: Any, value: Any): ...

class DatabaseProxy(Proxy):
    def connection_context(self): ...
    def atomic(self, *args: Any, **kwargs: Any): ...
    def manual_commit(self): ...
    def transaction(self, *args: Any, **kwargs: Any): ...
    def savepoint(self): ...

class ModelDescriptor: ...

class AliasManager:
    def __init__(self) -> None: ...
    @property
    def mapping(self): ...
    def add(self, source: Any): ...
    def get(self, source: Any, any_depth: bool = ...): ...
    def __getitem__(self, source: Any): ...
    def __setitem__(self, source: Any, alias: Any) -> None: ...
    def push(self) -> None: ...
    def pop(self) -> None: ...

class State:
    def __new__(cls, scope: Any = ..., parentheses: bool = ..., **kwargs: Any): ...
    def __call__(
        self, scope: Optional[Any] = ..., parentheses: Optional[Any] = ..., **kwargs: Any
    ): ...
    def __getattr__(self, attr_name: Any): ...

class Context:
    stack: Any = ...
    alias_manager: Any = ...
    state: Any = ...
    def __init__(self, **settings: Any) -> None: ...
    def as_new(self): ...
    def column_sort_key(self, item: Any): ...
    @property
    def scope(self): ...
    @property
    def parentheses(self): ...
    @property
    def subquery(self): ...
    def __call__(self, **overrides: Any): ...
    scope_normal: Any = ...
    scope_source: Any = ...
    scope_values: Any = ...
    scope_cte: Any = ...
    scope_column: Any = ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    def push_alias(self) -> None: ...
    def sql(self, obj: Any): ...
    def literal(self, keyword: Any): ...
    def value(self, value: Any, converter: Optional[Any] = ..., add_param: bool = ...): ...
    def __sql__(self, ctx: Any): ...
    def parse(self, node: Any): ...
    def query(self): ...

class Node:
    def clone(self): ...
    def __sql__(self, ctx: Context) -> Context: ...
    @staticmethod
    def copy(method: Any): ...
    def coerce(self, _coerce: bool = ...): ...
    def is_alias(self): ...
    def unwrap(self): ...

class ColumnFactory:
    node: Any = ...
    def __init__(self, node: Any) -> None: ...
    def __getattr__(self, attr: Any): ...

class _DynamicColumn:
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...

class _ExplicitColumn:
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...

class Source(Node):
    c: Any = ...
    def __init__(self, alias: Optional[Any] = ...) -> None: ...
    def alias(self, name: Any) -> None: ...
    def select(self, *columns: Any): ...
    def join(self, dest: Any, join_type: Any = ..., on: Optional[Any] = ...): ...
    def left_outer_join(self, dest: Any, on: Optional[Any] = ...): ...
    def cte(
        self,
        name: Any,
        recursive: bool = ...,
        columns: Optional[Any] = ...,
        materialized: Optional[Any] = ...,
    ): ...
    def get_sort_key(self, ctx: Any): ...
    def apply_alias(self, ctx: Any): ...
    def apply_column(self, ctx: Any): ...

class _HashableSource:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def alias(self, name: Any) -> None: ...
    def __hash__(self) -> Any: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

class BaseTable(Source):
    __and__: Any = ...
    __add__: Any = ...
    __sub__: Any = ...
    __or__: Any = ...
    __mul__: Any = ...
    __rand__: Any = ...
    __radd__: Any = ...
    __rsub__: Any = ...
    __ror__: Any = ...
    __rmul__: Any = ...

class _BoundTableContext(_callable_context_manager):
    table: Any = ...
    database: Any = ...
    def __init__(self, table: Any, database: Any) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class Table(_HashableSource, BaseTable):
    __name__: Any = ...
    c: Any = ...
    primary_key: Any = ...
    def __init__(
        self,
        name: Any,
        columns: Optional[Any] = ...,
        primary_key: Optional[Any] = ...,
        schema: Optional[Any] = ...,
        alias: Optional[Any] = ...,
        _model: Optional[Any] = ...,
        _database: Optional[Any] = ...,
    ) -> None: ...
    def clone(self): ...
    def bind(self, database: Optional[Any] = ...): ...
    def bind_ctx(self, database: Optional[Any] = ...): ...
    def select(self, *columns: Any): ...
    def insert(self, insert: Optional[Any] = ..., columns: Optional[Any] = ..., **kwargs: Any): ...
    def replace(self, insert: Optional[Any] = ..., columns: Optional[Any] = ..., **kwargs: Any): ...
    def update(self, update: Optional[Any] = ..., **kwargs: Any): ...
    def delete(self): ...
    def __sql__(self, ctx: Any): ...

class Join(BaseTable):
    lhs: Any = ...
    rhs: Any = ...
    join_type: Any = ...
    def __init__(
        self,
        lhs: Any,
        rhs: Any,
        join_type: Any = ...,
        on: Optional[Any] = ...,
        alias: Optional[Any] = ...,
    ) -> None: ...
    def on(self, predicate: Any): ...
    def __sql__(self, ctx: Any): ...

class ValuesList(_HashableSource, BaseTable):
    def __init__(
        self, values: Any, columns: Optional[Any] = ..., alias: Optional[Any] = ...
    ) -> None: ...
    def columns(self, *names: Any) -> None: ...
    def __sql__(self, ctx: Any): ...

class CTE(_HashableSource, Source):
    def __init__(
        self,
        name: Any,
        query: Any,
        recursive: bool = ...,
        columns: Optional[Any] = ...,
        materialized: Optional[Any] = ...,
    ) -> None: ...
    def select_from(self, *columns: Any): ...
    def union_all(self, rhs: Any): ...
    __add__: Any = ...
    def __sql__(self, ctx: Any): ...

class ColumnBase(Node):
    def alias(self, alias: Any): ...
    def unalias(self): ...
    def cast(self, as_type: Any): ...
    def asc(self, collation: Optional[Any] = ..., nulls: Optional[Any] = ...): ...
    __pos__: Any = ...
    def desc(self, collation: Optional[Any] = ..., nulls: Optional[Any] = ...): ...
    __neg__: Any = ...
    def __invert__(self): ...
    __and__: Any = ...
    __or__: Any = ...
    __add__: Any = ...
    __sub__: Any = ...
    __mul__: Any = ...
    __div__: Any = ...
    __truediv__: Any = ...
    __xor__: Any = ...
    __radd__: Any = ...
    __rsub__: Any = ...
    __rmul__: Any = ...
    __rdiv__: Any = ...
    __rtruediv__: Any = ...
    __rand__: Any = ...
    __ror__: Any = ...
    __rxor__: Any = ...
    def __eq__(self, rhs: Any) -> Any: ...
    def __ne__(self, rhs: Any) -> Any: ...
    __lt__: Any = ...
    __le__: Any = ...
    __gt__: Any = ...
    __ge__: Any = ...
    __lshift__: Any = ...
    __rshift__: Any = ...
    __mod__: Any = ...
    __pow__: Any = ...
    bin_and: Any = ...
    bin_or: Any = ...
    in_: Any = ...
    not_in: Any = ...
    # regexp: Any = ...
    def is_null(self, is_null: bool = ...): ...
    def contains(self, rhs: Any): ...
    def startswith(self, rhs: Any): ...
    def endswith(self, rhs: Any): ...
    def between(self, lo: Any, hi: Any): ...
    def concat(self, rhs: Any): ...
    def regexp(self, rhs: Any): ...
    def iregexp(self, rhs: Any): ...
    def __getitem__(self, item: Any): ...
    def distinct(self): ...
    def collate(self, collation: Any): ...
    def get_sort_key(self, ctx: Any): ...

class Column(ColumnBase):
    source: Any = ...
    name: Any = ...
    def __init__(self, source: Any, name: Any) -> None: ...
    def get_sort_key(self, ctx: Any): ...
    def __hash__(self) -> Any: ...
    def __sql__(self, ctx: Any): ...

class WrappedNode(ColumnBase):
    node: Any = ...
    def __init__(self, node: Any) -> None: ...
    def is_alias(self): ...
    def unwrap(self): ...

class EntityFactory:
    node: Any = ...
    def __init__(self, node: Any) -> None: ...
    def __getattr__(self, attr: Any): ...

class _DynamicEntity:
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...

class Alias(WrappedNode):
    c: Any = ...
    def __init__(self, node: Any, alias: Any) -> None: ...
    def __hash__(self) -> Any: ...
    def alias(self, alias: Optional[Any] = ...): ...
    def unalias(self): ...
    def is_alias(self): ...
    def __sql__(self, ctx: Any): ...

class Negated(WrappedNode):
    def __invert__(self): ...
    def __sql__(self, ctx: Any): ...

class BitwiseMixin:
    def __and__(self, other: Any): ...
    def __or__(self, other: Any): ...
    def __sub__(self, other: Any): ...
    def __invert__(self): ...

class BitwiseNegated(BitwiseMixin, WrappedNode):
    def __invert__(self): ...
    def __sql__(self, ctx: Any): ...

class Value(ColumnBase):
    value: Any = ...
    converter: Any = ...
    multi: Any = ...
    values: Any = ...
    def __init__(self, value: Any, converter: Optional[Any] = ..., unpack: bool = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

def AsIs(value: Any): ...

class Cast(WrappedNode):
    def __init__(self, node: Any, cast: Any) -> None: ...
    def __sql__(self, ctx: Any): ...

class Ordering(WrappedNode):
    direction: Any = ...
    collation: Any = ...
    nulls: Any = ...
    def __init__(
        self, node: Any, direction: Any, collation: Optional[Any] = ..., nulls: Optional[Any] = ...
    ) -> None: ...
    def collate(self, collation: Optional[Any] = ...): ...
    def __sql__(self, ctx: Any): ...

class Expression(ColumnBase):
    lhs: Any = ...
    op: Any = ...
    rhs: Any = ...
    flat: Any = ...
    def __init__(self, lhs: Any, op: Any, rhs: Any, flat: bool = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

class StringExpression(Expression):
    def __add__(self, rhs: Any): ...
    def __radd__(self, lhs: Any): ...

class Entity(ColumnBase):
    def __init__(self, *path: Any) -> None: ...
    def __getattr__(self, attr: Any): ...
    def get_sort_key(self, ctx: Any): ...
    def __hash__(self) -> Any: ...
    def __sql__(self, ctx: Any): ...

class SQL(ColumnBase):
    sql: Any = ...
    params: Any = ...
    def __init__(self, sql: Any, params: Optional[Any] = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

def Check(constraint: Any): ...

class Function(ColumnBase):
    name: Any = ...
    arguments: Any = ...
    def __init__(
        self, name: Any, arguments: Any, coerce: bool = ..., python_value: Optional[Any] = ...
    ) -> None: ...
    def __getattr__(self, attr: Any): ...
    def filter(self, where: Optional[Any] = ...) -> None: ...
    def python_value(self, func: Optional[Any] = ...) -> None: ...
    def over(
        self,
        partition_by: Optional[Any] = ...,
        order_by: Optional[Any] = ...,
        start: Optional[Any] = ...,
        end: Optional[Any] = ...,
        frame_type: Optional[Any] = ...,
        window: Optional[Any] = ...,
        exclude: Optional[Any] = ...,
    ): ...
    def __sql__(self, ctx: Any): ...

fn: Any

class Window(Node):
    CURRENT_ROW: Any = ...
    GROUP: Any = ...
    TIES: Any = ...
    NO_OTHERS: Any = ...
    GROUPS: str = ...
    RANGE: str = ...
    ROWS: str = ...
    partition_by: Any = ...
    order_by: Any = ...
    start: Any = ...
    end: Any = ...
    frame_type: Any = ...
    def __init__(
        self,
        partition_by: Optional[Any] = ...,
        order_by: Optional[Any] = ...,
        start: Optional[Any] = ...,
        end: Optional[Any] = ...,
        frame_type: Optional[Any] = ...,
        extends: Optional[Any] = ...,
        exclude: Optional[Any] = ...,
        alias: Optional[Any] = ...,
        _inline: bool = ...,
    ) -> None: ...
    def alias(self, alias: Optional[Any] = ...): ...
    def as_range(self) -> None: ...
    def as_rows(self) -> None: ...
    def as_groups(self) -> None: ...
    def extends(self, window: Optional[Any] = ...) -> None: ...
    def exclude(self, frame_exclusion: Optional[Any] = ...) -> None: ...
    @staticmethod
    def following(value: Optional[Any] = ...): ...
    @staticmethod
    def preceding(value: Optional[Any] = ...): ...
    def __sql__(self, ctx: Any): ...

class WindowAlias(Node):
    window: Any = ...
    def __init__(self, window: Any) -> None: ...
    def alias(self, window_alias: Any): ...
    def __sql__(self, ctx: Any): ...

class ForUpdate(Node):
    def __init__(self, expr: Any, of: Optional[Any] = ..., nowait: Optional[Any] = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

def Case(predicate: Any, expression_tuples: Any, default: Optional[Any] = ...): ...

class NodeList(ColumnBase):
    nodes: Any = ...
    glue: Any = ...
    parens: Any = ...
    def __init__(self, nodes: Any, glue: str = ..., parens: bool = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

class _Namespace(Node):
    def __init__(self, name: Any) -> None: ...
    def __getattr__(self, attr: Any): ...
    __getitem__: Any = ...

class NamespaceAttribute(ColumnBase):
    def __init__(self, namespace: Any, attribute: Any) -> None: ...
    def __sql__(self, ctx: Any): ...

EXCLUDED: Any

class DQ(ColumnBase):
    query: Any = ...
    def __init__(self, **query: Any) -> None: ...
    def __invert__(self) -> None: ...
    def clone(self): ...

Tuple: Any

class QualifiedNames(WrappedNode):
    def __sql__(self, ctx: Any): ...

class OnConflict(Node):
    def __init__(
        self,
        action: Optional[Any] = ...,
        update: Optional[Any] = ...,
        preserve: Optional[Any] = ...,
        where: Optional[Any] = ...,
        conflict_target: Optional[Any] = ...,
        conflict_where: Optional[Any] = ...,
        conflict_constraint: Optional[Any] = ...,
    ) -> None: ...
    def get_conflict_statement(self, ctx: Any, query: Any): ...
    def get_conflict_update(self, ctx: Any, query: Any): ...
    def preserve(self, *columns: Any) -> None: ...
    def update(self, _data: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def where(self, *expressions: Any) -> None: ...
    def conflict_target(self, *constraints: Any) -> None: ...
    def conflict_where(self, *expressions: Any) -> None: ...
    def conflict_constraint(self, constraint: Any) -> None: ...

class BaseQuery(Node):
    default_row_type: Any = ...
    def __init__(self, _database: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def bind(self, database: Optional[Any] = ...): ...
    def clone(self): ...
    def dicts(self, as_dict: bool = ...): ...
    def tuples(self, as_tuple: bool = ...): ...
    def namedtuples(self, as_namedtuple: bool = ...): ...
    def objects(self, constructor: Optional[Any] = ...): ...
    def __sql__(self, ctx: Context) -> Context: ...
    def sql(self): ...
    def execute(self, database: Any): ...
    def iterator(self, database: Optional[Any] = ...): ...
    def __iter__(self) -> Any: ...
    def __getitem__(self, value: Any): ...
    def __len__(self): ...

class RawQuery(BaseQuery):
    def __init__(
        self, sql: Optional[Any] = ..., params: Optional[Any] = ..., **kwargs: Any
    ) -> None: ...
    def __sql__(self, ctx: Any): ...

class Query(BaseQuery):
    def __init__(
        self,
        where: Optional[Any] = ...,
        order_by: Optional[Any] = ...,
        limit: Optional[Any] = ...,
        offset: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    def with_cte(self, *cte_list: Any) -> None: ...
    def where(self, *expressions: Any) -> None: ...
    def orwhere(self, *expressions: Any) -> None: ...
    def order_by(self, *values: Any) -> None: ...
    def order_by_extend(self, *values: Any) -> None: ...
    def limit(self, value: Optional[Any] = ...) -> None: ...
    def offset(self, value: Optional[Any] = ...) -> None: ...
    def paginate(self, page: Any, paginate_by: int = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

class SelectQuery(Query):
    union_all: Any = ...
    __add__: Any = ...
    union: Any = ...
    __or__: Any = ...
    intersect: Any = ...
    __and__: Any = ...
    except_: Any = ...
    __sub__: Any = ...
    __radd__: Any = ...
    __ror__: Any = ...
    __rand__: Any = ...
    __rsub__: Any = ...
    def select_from(self, *columns: Any): ...

class SelectBase(_HashableSource, Source, SelectQuery):
    def peek(self, database: Any, n: int = ...): ...
    def first(self, database: Any, n: int = ...): ...
    def scalar(self, database: Any, as_tuple: bool = ...): ...
    def count(self, database: Any, clear_limit: bool = ...): ...
    def exists(self, database: Any): ...
    def get(self, database: Any): ...

class CompoundSelectQuery(SelectBase):
    lhs: Any = ...
    op: Any = ...
    rhs: Any = ...
    def __init__(self, lhs: Any, op: Any, rhs: Any) -> None: ...
    def exists(self, database: Any): ...
    def __sql__(self, ctx: Any): ...

class Select(SelectBase):
    def __init__(
        self,
        from_list: Optional[Any] = ...,
        columns: Optional[Any] = ...,
        group_by: Optional[Any] = ...,
        having: Optional[Any] = ...,
        distinct: Optional[Any] = ...,
        windows: Optional[Any] = ...,
        for_update: Optional[Any] = ...,
        for_update_of: Optional[Any] = ...,
        nowait: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    def clone(self): ...
    def columns(self, *columns: Any, **kwargs: Any) -> None: ...
    select: Any = ...
    def select_extend(self, *columns: Any) -> None: ...
    def from_(self, *sources: Any) -> None: ...
    def join(self, dest: Any, join_type: Any = ..., on: Optional[Any] = ...) -> None: ...
    def group_by(self, *columns: Any) -> None: ...
    def group_by_extend(self, *values: Any): ...
    def having(self, *expressions: Any) -> None: ...
    def distinct(self, *columns: Any) -> None: ...
    def window(self, *windows: Any) -> None: ...
    def for_update(
        self, for_update: bool = ..., of: Optional[Any] = ..., nowait: Optional[Any] = ...
    ) -> None: ...
    def __sql_selection__(self, ctx: Any, is_subquery: bool = ...): ...
    def __sql__(self, ctx: Any): ...

class _WriteQuery(Query):
    table: Any = ...
    def __init__(self, table: Any, returning: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def returning(self, *returning: Any) -> None: ...
    def apply_returning(self, ctx: Any): ...
    def execute_returning(self, database: Any): ...
    def handle_result(self, database: Any, cursor: Any): ...
    def __sql__(self, ctx: Any): ...

class Update(_WriteQuery):
    def __init__(self, table: Any, update: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def from_(self, *sources: Any) -> None: ...
    def __sql__(self, ctx: Any): ...

class Insert(_WriteQuery):
    SIMPLE: int = ...
    QUERY: int = ...
    MULTI: int = ...

    class DefaultValuesException(Exception): ...

    def __init__(
        self,
        table: Any,
        insert: Optional[Any] = ...,
        columns: Optional[Any] = ...,
        on_conflict: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    def where(self, *expressions: Any) -> None: ...
    def on_conflict_ignore(self, ignore: bool = ...) -> None: ...
    def on_conflict_replace(self, replace: bool = ...) -> None: ...
    def on_conflict(self, *args: Any, **kwargs: Any) -> None: ...
    def get_default_data(self): ...
    def get_default_columns(self): ...
    def __sql__(self, ctx: Any): ...
    def handle_result(self, database: Any, cursor: Any): ...

class Delete(_WriteQuery):
    def __sql__(self, ctx: Any): ...

class Index(Node):
    def __init__(
        self,
        name: Any,
        table: Any,
        expressions: Any,
        unique: bool = ...,
        safe: bool = ...,
        where: Optional[Any] = ...,
        using: Optional[Any] = ...,
    ) -> None: ...
    def safe(self, _safe: bool = ...) -> None: ...
    def where(self, *expressions: Any) -> None: ...
    def using(self, _using: Optional[Any] = ...) -> None: ...
    def __sql__(self, ctx: Any): ...

class ModelIndex(Index):
    def __init__(
        self,
        model: Any,
        fields: Any,
        unique: bool = ...,
        safe: bool = ...,
        where: Optional[Any] = ...,
        using: Optional[Any] = ...,
        name: Optional[Any] = ...,
    ) -> None: ...

class PeeweeException(Exception):
    def __init__(self, *args: Any) -> None: ...

class ImproperlyConfigured(PeeweeException): ...
class DatabaseError(PeeweeException): ...
class DataError(DatabaseError): ...
class IntegrityError(DatabaseError): ...
class InterfaceError(PeeweeException): ...
class InternalError(DatabaseError): ...
class NotSupportedError(DatabaseError): ...
class OperationalError(DatabaseError): ...
class ProgrammingError(DatabaseError): ...

class ExceptionWrapper:
    exceptions: Any = ...
    def __init__(self, exceptions: Any) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Any, exc_value: Any, traceback: Any) -> None: ...

IndexMetadata = namedtuple("IndexMetadata", ["name", "sql", "columns", "unique", "table"])

ColumnMetadata = namedtuple(
    "ColumnMetadata", ["name", "data_type", "null", "primary_key", "table", "default"]
)

ForeignKeyMetadata = namedtuple(
    "ForeignKeyMetadata", ["column", "dest_table", "dest_column", "table"]
)

ViewMetadata = namedtuple("ViewMetadata", ["name", "sql"])

class _ConnectionState:
    def __init__(self, **kwargs: Any) -> None: ...
    closed: bool = ...
    conn: Any = ...
    ctx: Any = ...
    transactions: Any = ...
    def reset(self) -> None: ...
    def set_connection(self, conn: Any) -> None: ...

class _ConnectionLocal(_ConnectionState, threading.local): ...

class _NoopLock:
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class ConnectionContext(_callable_context_manager):
    db: Any = ...
    def __init__(self, db: Any) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class Database(_callable_context_manager):
    context_class: Any = ...
    field_types: Any = ...
    operations: Any = ...
    param: str = ...
    quote: str = ...
    server_version: Any = ...
    commit_select: bool = ...
    compound_select_parentheses: Any = ...
    for_update: bool = ...
    index_schema_prefix: bool = ...
    limit_max: Any = ...
    nulls_ordering: bool = ...
    returning_clause: bool = ...
    safe_create_index: bool = ...
    safe_drop_index: bool = ...
    sequences: bool = ...
    truncate_table: bool = ...
    autoconnect: Any = ...
    autorollback: Any = ...
    thread_safe: Any = ...
    connect_params: Any = ...
    def __init__(
        self,
        database: Any,
        thread_safe: bool = ...,
        autorollback: bool = ...,
        field_types: Optional[Any] = ...,
        operations: Optional[Any] = ...,
        autocommit: Optional[Any] = ...,
        autoconnect: bool = ...,
        **kwargs: Any,
    ) -> None: ...
    database: Any = ...
    deferred: Any = ...
    def init(self, database: Any, **kwargs: Any) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    def connection_context(self): ...
    def connect(self, reuse_if_open: bool = ...): ...
    def close(self): ...
    def is_closed(self): ...
    def is_connection_usable(self): ...
    def connection(self): ...
    def cursor(self, commit: Optional[Any] = ...): ...
    def execute_sql(self, sql: Any, params: Optional[Any] = ..., commit: Any = ...): ...
    def execute(self, query: Any, commit: Any = ..., **context_options: Any): ...
    def get_context_options(self): ...
    def get_sql_context(self, **context_options: Any): ...
    def conflict_statement(self, on_conflict: Any, query: Any) -> None: ...
    def conflict_update(self, on_conflict: Any, query: Any) -> None: ...
    def last_insert_id(self, cursor: Any, query_type: Optional[Any] = ...): ...
    def rows_affected(self, cursor: Any): ...
    def default_values_insert(self, ctx: Any): ...
    def session_start(self): ...
    def session_commit(self): ...
    def session_rollback(self): ...
    def in_transaction(self): ...
    def push_transaction(self, transaction: Any) -> None: ...
    def pop_transaction(self): ...
    def transaction_depth(self): ...
    def top_transaction(self): ...
    def atomic(self, *args: Any, **kwargs: Any): ...
    def manual_commit(self): ...
    def transaction(self, *args: Any, **kwargs: Any): ...
    def savepoint(self): ...
    def begin(self) -> None: ...
    def commit(self): ...
    def rollback(self): ...
    def batch_commit(self, it: Any, n: Any) -> None: ...
    def table_exists(self, table_name: Any, schema: Optional[Any] = ...): ...
    def get_tables(self, schema: Optional[Any] = ...) -> None: ...
    def get_indexes(self, table: Any, schema: Optional[Any] = ...) -> None: ...
    def get_columns(self, table: Any, schema: Optional[Any] = ...) -> None: ...
    def get_primary_keys(self, table: Any, schema: Optional[Any] = ...) -> None: ...
    def get_foreign_keys(self, table: Any, schema: Optional[Any] = ...) -> None: ...
    def sequence_exists(self, seq: Any) -> None: ...
    def create_tables(self, models: Any, **options: Any) -> None: ...
    def drop_tables(self, models: Any, **kwargs: Any) -> None: ...
    def extract_date(self, date_part: Any, date_field: Any) -> None: ...
    def truncate_date(self, date_part: Any, date_field: Any) -> None: ...
    def to_timestamp(self, date_field: Any) -> None: ...
    def from_timestamp(self, date_field: Any) -> None: ...
    def random(self): ...
    def bind(self, models: Any, bind_refs: bool = ..., bind_backrefs: bool = ...) -> None: ...
    def bind_ctx(self, models: Any, bind_refs: bool = ..., bind_backrefs: bool = ...): ...
    def get_noop_select(self, ctx: Any): ...

class SqliteDatabase(Database):
    field_types: Any = ...
    operations: Any = ...
    index_schema_prefix: bool = ...
    limit_max: int = ...
    server_version: Any = ...
    truncate_table: bool = ...
    nulls_ordering: Any = ...
    def __init__(self, database: Any, *args: Any, **kwargs: Any) -> None: ...
    def init(
        self, database: Any, pragmas: Optional[Any] = ..., timeout: int = ..., **kwargs: Any
    ) -> None: ...
    def pragma(
        self, key: Any, value: Any = ..., permanent: bool = ..., schema: Optional[Any] = ...
    ): ...
    cache_size: Any = ...
    foreign_keys: Any = ...
    journal_mode: Any = ...
    journal_size_limit: Any = ...
    mmap_size: Any = ...
    page_size: Any = ...
    read_uncommitted: Any = ...
    synchronous: Any = ...
    wal_autocheckpoint: Any = ...
    @property
    def timeout(self): ...
    @timeout.setter
    def timeout(self, seconds: Any) -> None: ...
    def register_aggregate(
        self, klass: Any, name: Optional[Any] = ..., num_params: int = ...
    ) -> None: ...
    def aggregate(self, name: Optional[Any] = ..., num_params: int = ...): ...
    def register_collation(self, fn: Any, name: Optional[Any] = ...): ...
    def collation(self, name: Optional[Any] = ...): ...
    def register_function(
        self, fn: Any, name: Optional[Any] = ..., num_params: int = ...
    ) -> None: ...
    def func(self, name: Optional[Any] = ..., num_params: int = ...): ...
    def register_window_function(
        self, klass: Any, name: Optional[Any] = ..., num_params: int = ...
    ) -> None: ...
    def window_function(self, name: Optional[Any] = ..., num_params: int = ...): ...
    def register_table_function(self, klass: Any, name: Optional[Any] = ...) -> None: ...
    def table_function(self, name: Optional[Any] = ...): ...
    def unregister_aggregate(self, name: Any) -> None: ...
    def unregister_collation(self, name: Any) -> None: ...
    def unregister_function(self, name: Any) -> None: ...
    def unregister_window_function(self, name: Any) -> None: ...
    def unregister_table_function(self, name: Any): ...
    def load_extension(self, extension: Any) -> None: ...
    def unload_extension(self, extension: Any) -> None: ...
    def attach(self, filename: Any, name: Any): ...
    def detach(self, name: Any): ...
    def begin(self, lock_type: Optional[Any] = ...) -> None: ...
    def get_tables(self, schema: Optional[Any] = ...): ...
    def get_views(self, schema: Optional[Any] = ...): ...
    def get_indexes(self, table: Any, schema: Optional[Any] = ...): ...
    def get_columns(self, table: Any, schema: Optional[Any] = ...): ...
    def get_primary_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def get_foreign_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def get_binary_type(self): ...
    def conflict_statement(self, on_conflict: Any, query: Any): ...
    def conflict_update(self, oc: Any, query: Any): ...
    def extract_date(self, date_part: Any, date_field: Any): ...
    def truncate_date(self, date_part: Any, date_field: Any): ...
    def to_timestamp(self, date_field: Any): ...
    def from_timestamp(self, date_field: Any): ...

class PostgresqlDatabase(Database):
    field_types: Any = ...
    operations: Any = ...
    param: str = ...
    commit_select: bool = ...
    compound_select_parentheses: Any = ...
    for_update: bool = ...
    nulls_ordering: bool = ...
    returning_clause: bool = ...
    safe_create_index: bool = ...
    sequences: bool = ...
    def init(
        self,
        database: Any,
        register_unicode: bool = ...,
        encoding: Optional[Any] = ...,
        isolation_level: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    def is_connection_usable(self): ...
    def last_insert_id(self, cursor: Any, query_type: Optional[Any] = ...): ...
    def get_tables(self, schema: Optional[Any] = ...): ...
    def get_views(self, schema: Optional[Any] = ...): ...
    def get_indexes(self, table: Any, schema: Optional[Any] = ...): ...
    def get_columns(self, table: Any, schema: Optional[Any] = ...): ...
    def get_primary_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def get_foreign_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def sequence_exists(self, sequence: Any): ...
    def get_binary_type(self): ...
    def conflict_statement(self, on_conflict: Any, query: Any) -> None: ...
    def conflict_update(self, oc: Any, query: Any): ...
    def extract_date(self, date_part: Any, date_field: Any): ...
    def truncate_date(self, date_part: Any, date_field: Any): ...
    def to_timestamp(self, date_field: Any): ...
    def from_timestamp(self, date_field: Any): ...
    def get_noop_select(self, ctx: Any): ...
    def set_time_zone(self, timezone: Any) -> None: ...

class MySQLDatabase(Database):
    field_types: Any = ...
    operations: Any = ...
    param: str = ...
    quote: str = ...
    commit_select: bool = ...
    compound_select_parentheses: Any = ...
    for_update: bool = ...
    limit_max: Any = ...
    safe_create_index: bool = ...
    safe_drop_index: bool = ...
    sql_mode: str = ...
    def init(self, database: Any, **kwargs: Any) -> None: ...
    def default_values_insert(self, ctx: Any): ...
    def get_tables(self, schema: Optional[Any] = ...): ...
    def get_views(self, schema: Optional[Any] = ...): ...
    def get_indexes(self, table: Any, schema: Optional[Any] = ...): ...
    def get_columns(self, table: Any, schema: Optional[Any] = ...): ...
    def get_primary_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def get_foreign_keys(self, table: Any, schema: Optional[Any] = ...): ...
    def get_binary_type(self): ...
    def conflict_statement(self, on_conflict: Any, query: Any): ...
    def conflict_update(self, on_conflict: Any, query: Any): ...
    def extract_date(self, date_part: Any, date_field: Any): ...
    def truncate_date(self, date_part: Any, date_field: Any): ...
    def to_timestamp(self, date_field: Any): ...
    def from_timestamp(self, date_field: Any): ...
    def random(self): ...
    def get_noop_select(self, ctx: Any): ...

class _manual(_callable_context_manager):
    db: Any = ...
    def __init__(self, db: Any) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class _atomic(_callable_context_manager):
    db: Any = ...
    def __init__(self, db: Any, *args: Any, **kwargs: Any) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any): ...

class _transaction(_callable_context_manager):
    db: Any = ...
    def __init__(self, db: Any, *args: Any, **kwargs: Any) -> None: ...
    def commit(self, begin: bool = ...) -> None: ...
    def rollback(self, begin: bool = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class _savepoint(_callable_context_manager):
    db: Any = ...
    sid: Any = ...
    quoted_sid: Any = ...
    def __init__(self, db: Any, sid: Optional[Any] = ...) -> None: ...
    def commit(self, begin: bool = ...) -> None: ...
    def rollback(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class CursorWrapper:
    cursor: Any = ...
    count: int = ...
    index: int = ...
    initialized: bool = ...
    populated: bool = ...
    row_cache: Any = ...
    def __init__(self, cursor: Any) -> None: ...
    def __iter__(self) -> Any: ...
    def __getitem__(self, item: Any): ...
    def __len__(self): ...
    def initialize(self) -> None: ...
    def iterate(self, cache: bool = ...): ...
    def process_row(self, row: Any): ...
    def iterator(self) -> None: ...
    def fill_cache(self, n: int = ...) -> None: ...

class DictCursorWrapper(CursorWrapper):
    initialize: Any = ...
    process_row: Any = ...

class NamedTupleCursorWrapper(CursorWrapper):
    tuple_class: Any = ...
    def initialize(self) -> None: ...
    def process_row(self, row: Any): ...

class ObjectCursorWrapper(DictCursorWrapper):
    constructor: Any = ...
    def __init__(self, cursor: Any, constructor: Any) -> None: ...
    def process_row(self, row: Any): ...

class ResultIterator:
    cursor_wrapper: Any = ...
    index: int = ...
    def __init__(self, cursor_wrapper: Any) -> None: ...
    def __iter__(self) -> Any: ...
    def next(self): ...
    __next__: Any = ...

class FieldAccessor:
    model: Any = ...
    field: Any = ...
    name: Any = ...
    def __init__(self, model: Any, field: Any, name: Any) -> None: ...
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...
    def __set__(self, instance: Any, value: Any) -> None: ...

class ForeignKeyAccessor(FieldAccessor):
    rel_model: Any = ...
    def __init__(self, model: Any, field: Any, name: Any) -> None: ...
    def get_rel_instance(self, instance: Any): ...
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...
    def __set__(self, instance: Any, obj: Any) -> None: ...

class NoQueryForeignKeyAccessor(ForeignKeyAccessor):
    def get_rel_instance(self, instance: Any): ...

class BackrefAccessor:
    field: Any = ...
    model: Any = ...
    rel_model: Any = ...
    def __init__(self, field: Any) -> None: ...
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...

class ObjectIdAccessor:
    field: Any = ...
    def __init__(self, field: Any) -> None: ...
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...
    def __set__(self, instance: Any, value: Any) -> None: ...

class Field(ColumnBase):
    accessor_class: ClassVar[Type[FieldAccessor]]
    auto_increment: ClassVar[bool]
    default_index_type: ClassVar[Optional[str]]
    field_type: ClassVar[str]
    unpack: ClassVar[bool]
    # Instance variables
    model: Type[Model]
    null: bool
    index: bool
    unique: bool
    column_name: str
    default: Any
    primary_key: bool
    constraints: Optional[Iterable[Union[Callable[[str], SQL], SQL]]]
    sequence: Optional[str]
    collation: Optional[str]
    unindexed: bool
    help_text: Optional[str]
    verbose_name: Optional[str]
    index_type: Optional[str]
    def __init__(
        self,
        null: bool = ...,
        index: bool = ...,
        unique: bool = ...,
        column_name: str = ...,
        default: Any = ...,
        primary_key: bool = ...,
        constraints: Optional[Iterable[Union[Callable[[str], SQL], SQL]]] = ...,
        sequence: Optional[str] = ...,
        collation: Optional[str] = ...,
        unindexed: Optional[bool] = ...,
        choices: Optional[Iterable[Tuple[Any, str]]] = ...,
        help_text: Optional[str] = ...,
        verbose_name: Optional[str] = ...,
        index_type: Optional[str] = ...,
        db_column: Optional[str] = ...,  # Deprecated argument, undocumented
        _hidden: bool = ...,
    ): ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def bind(self, model: Type[Model], name: str, set_attribute: bool = ...) -> None: ...
    @property
    def column(self) -> Column: ...
    def adapt(self, value: _T) -> _T: ...
    def db_value(self, value: _T) -> _T: ...
    def python_value(self, value: _T) -> _T: ...
    def to_value(self, value: Any) -> Value: ...
    def get_sort_key(self, ctx: Context) -> Tuple[int, int]: ...
    def __sql__(self, ctx: Context) -> Context: ...
    def get_modifiers(self) -> Any: ...
    def ddl_datatype(self, ctx: Context) -> SQL: ...
    def ddl(self, ctx: Context) -> NodeList: ...

class IntegerField(Field):
    @overload
    def adapt(self, value: Union[str, float, bool]) -> int: ...  # type: ignore
    @overload
    def adapt(self, value: _T) -> _T: ...

class BigIntegerField(IntegerField): ...
class SmallIntegerField(IntegerField): ...

class AutoField(IntegerField):
    def __init__(self, *args: object, primary_key: bool = ..., **kwargs: object): ...

class BigAutoField(AutoField): ...

class IdentityField(AutoField):
    def __init__(self, generate_always: bool = ..., **kwargs: Any) -> None: ...

class PrimaryKeyField(AutoField): ...

class FloatField(Field):
    @overload
    def adapt(self, value: Union[str, float, bool]) -> float: ...  # type: ignore
    @overload
    def adapt(self, value: _T) -> _T: ...

class DoubleField(FloatField): ...
class DecimalField(Field): ...

class _StringField(Field):
    @overload
    def adapt(self, value: AnyStr) -> str: ...
    @overload
    def adapt(self, value: _T) -> _T: ...
    def split(self, sep: Optional[str] = None, maxsplit: int = -1) -> List[str]: ...
    def __add__(self, other: Any) -> StringExpression: ...
    def __radd__(self, other: Any) -> StringExpression: ...

class CharField(_StringField):
    max_length: int
    def __init__(self, max_length: int = ..., *args: object, **kwargs: object): ...
    def get_modifiers(self) -> Optional[List[int]]: ...

class FixedCharField(CharField): ...
class TextField(_StringField): ...

class BlobField(Field):
    def bind(self, model: Any, name: Any, set_attribute: bool = ...): ...
    def db_value(self, value: Any): ...

class BitField(BitwiseMixin, BigIntegerField):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def flag(self, value: Optional[Any] = ...): ...

class BigBitFieldData:
    instance: Any = ...
    name: Any = ...
    def __init__(self, instance: Any, name: Any) -> None: ...
    def set_bit(self, idx: Any) -> None: ...
    def clear_bit(self, idx: Any) -> None: ...
    def toggle_bit(self, idx: Any): ...
    def is_set(self, idx: Any): ...

class BigBitFieldAccessor(FieldAccessor):
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...
    def __set__(self, instance: Any, value: Any) -> None: ...

class BigBitField(BlobField):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def db_value(self, value: Any): ...

class UUIDField(Field):
    def db_value(self, value: Any): ...
    def python_value(self, value: Any): ...

class BinaryUUIDField(BlobField):
    def db_value(self, value: Any): ...
    def python_value(self, value: Any): ...

class _BaseFormattedField(Field):
    formats: Any = ...
    def __init__(self, formats: Optional[Any] = ..., *args: Any, **kwargs: Any) -> None: ...

class DateTimeField(_BaseFormattedField):
    formats: Any = ...
    def adapt(self, value: Any): ...
    def to_timestamp(self): ...
    def truncate(self, part: Any): ...
    year: Any = ...
    month: Any = ...
    day: Any = ...
    hour: Any = ...
    minute: Any = ...
    second: Any = ...

class DateField(_BaseFormattedField):
    formats: Any = ...
    def adapt(self, value: Any): ...
    def to_timestamp(self): ...
    def truncate(self, part: Any): ...
    year: Any = ...
    month: Any = ...
    day: Any = ...

class TimeField(_BaseFormattedField):
    formats: Any = ...
    def adapt(self, value: Any): ...
    hour: Any = ...
    minute: Any = ...
    second: Any = ...

class TimestampField(BigIntegerField):
    valid_resolutions: Any = ...
    resolution: Any = ...
    ticks_to_microsecond: Any = ...
    utc: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def local_to_utc(self, dt: Any): ...
    def utc_to_local(self, dt: Any): ...
    def get_timestamp(self, value: Any): ...
    def db_value(self, value: Any): ...
    def python_value(self, value: Any): ...
    def from_timestamp(self): ...
    year: Any = ...
    month: Any = ...
    day: Any = ...
    hour: Any = ...
    minute: Any = ...
    second: Any = ...

class IPField(BigIntegerField):
    def db_value(self, val: Any): ...
    def python_value(self, val: Any): ...

class BooleanField(Field):
    adapt: Any = ...

class BareField(Field):
    adapt: Any = ...
    def __init__(self, adapt: Optional[Any] = ..., *args: Any, **kwargs: Any) -> None: ...
    def ddl_datatype(self, ctx: Any) -> SQL: ...

class ForeignKeyField(Field):
    rel_model: Any = ...
    rel_field: Any = ...
    declared_backref: Any = ...
    backref: Any = ...
    on_delete: Any = ...
    on_update: Any = ...
    deferrable: Any = ...
    deferred: Any = ...
    object_id_name: Any = ...
    lazy_load: Any = ...
    def __init__(
        self,
        model: Any,
        field: Optional[Any] = ...,
        backref: Optional[Any] = ...,
        on_delete: Optional[Any] = ...,
        on_update: Optional[Any] = ...,
        deferrable: Optional[Any] = ...,
        _deferred: Optional[Any] = ...,
        rel_model: Optional[Any] = ...,
        to_field: Optional[Any] = ...,
        object_id_name: Optional[Any] = ...,
        lazy_load: bool = ...,
        related_name: Optional[Any] = ...,
        *args: Any,
        **kwargs: Any,
    ) -> None: ...
    @property
    def field_type(self): ...
    def get_modifiers(self): ...
    def adapt(self, value: Any): ...
    def db_value(self, value: Any): ...
    def python_value(self, value: Any): ...
    column_name: Any = ...
    safe_name: Any = ...
    def bind(self, model: Any, name: Any, set_attribute: bool = ...) -> None: ...
    def foreign_key_constraint(self): ...
    def __getattr__(self, attr: Any): ...

class DeferredForeignKey(Field):
    field_kwargs: Any = ...
    rel_model_name: Any = ...
    def __init__(self, rel_model_name: Any, **kwargs: Any) -> None: ...
    __hash__: Any = ...
    def __deepcopy__(self, memo: Optional[Any] = ...): ...
    def set_model(self, rel_model: Any) -> None: ...
    @staticmethod
    def resolve(model_cls: Any) -> None: ...

class DeferredThroughModel:
    def __init__(self) -> None: ...
    def set_field(self, model: Any, field: Any, name: Any) -> None: ...
    def set_model(self, through_model: Any) -> None: ...

class MetaField(Field):
    column_name: Any = ...
    default: Any = ...
    model: Any = ...
    name: Any = ...
    primary_key: bool = ...

class ManyToManyFieldAccessor(FieldAccessor):
    model: Any = ...
    rel_model: Any = ...
    through_model: Any = ...
    src_fk: Any = ...
    dest_fk: Any = ...
    def __init__(self, model: Any, field: Any, name: Any) -> None: ...
    def __get__(
        self, instance: Any, instance_type: Optional[Any] = ..., force_query: bool = ...
    ): ...
    def __set__(self, instance: Any, value: Any) -> None: ...

class ManyToManyField(MetaField):
    rel_model: Any = ...
    backref: Any = ...
    def __init__(
        self,
        model: Any,
        backref: Optional[Any] = ...,
        through_model: Optional[Any] = ...,
        on_delete: Optional[Any] = ...,
        on_update: Optional[Any] = ...,
        _is_backref: bool = ...,
    ) -> None: ...
    def bind(self, model: Any, name: Any, set_attribute: bool = ...) -> None: ...
    def get_models(self): ...
    @property
    def through_model(self): ...
    @through_model.setter
    def through_model(self, value: Any) -> None: ...
    def get_through_model(self): ...

class VirtualField(MetaField):
    field_class: Any = ...
    field_instance: Any = ...
    def __init__(self, field_class: Optional[Any] = ..., *args: Any, **kwargs: Any) -> None: ...
    def db_value(self, value: Any): ...
    def python_value(self, value: Any): ...
    model: Any = ...
    column_name: Any = ...
    def bind(self, model: Any, name: Any, set_attribute: bool = ...) -> None: ...

class CompositeKey(MetaField):
    sequence: Any = ...
    field_names: Any = ...
    def __init__(self, *field_names: Any) -> None: ...
    def __get__(self, instance: Any, instance_type: Optional[Any] = ...): ...
    def __set__(self, instance: Any, value: Any) -> None: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...
    def __sql__(self, ctx: Any): ...
    model: Any = ...
    column_name: Any = ...
    def bind(self, model: Any, name: Any, set_attribute: bool = ...) -> None: ...

class _SortedFieldList:
    def __init__(self) -> None: ...
    def __getitem__(self, i: Any): ...
    def __iter__(self) -> Any: ...
    def __contains__(self, item: Any): ...
    def index(self, field: Any): ...
    def insert(self, item: Any) -> None: ...
    def remove(self, item: Any) -> None: ...

class SchemaManager:
    model: Any = ...
    context_options: Any = ...
    def __init__(
        self, model: Any, database: Optional[Any] = ..., **context_options: Any
    ) -> None: ...
    @property
    def database(self): ...
    @database.setter
    def database(self, value: Any) -> None: ...
    def create_table(self, safe: bool = ..., **options: Any) -> None: ...
    def create_table_as(
        self, table_name: Any, query: Any, safe: bool = ..., **meta: Any
    ) -> None: ...
    def drop_table(self, safe: bool = ..., **options: Any) -> None: ...
    def truncate_table(self, restart_identity: bool = ..., cascade: bool = ...) -> None: ...
    def create_indexes(self, safe: bool = ...) -> None: ...
    def drop_indexes(self, safe: bool = ...) -> None: ...
    def create_sequence(self, field: Any) -> None: ...
    def drop_sequence(self, field: Any) -> None: ...
    def create_foreign_key(self, field: Any) -> None: ...
    def create_sequences(self) -> None: ...
    def create_all(self, safe: bool = ..., **table_options: Any) -> None: ...
    def drop_sequences(self) -> None: ...
    def drop_all(self, safe: bool = ..., drop_sequences: bool = ..., **options: Any) -> None: ...

class Metadata:
    model: Any = ...
    database: Any = ...
    fields: Any = ...
    columns: Any = ...
    combined: Any = ...
    sorted_fields: Any = ...
    sorted_field_names: Any = ...
    defaults: Any = ...
    name: Any = ...
    table_function: Any = ...
    legacy_table_names: Any = ...
    table_name: Any = ...
    indexes: Any = ...
    constraints: Any = ...
    primary_key: Any = ...
    composite_key: Any = ...
    only_save_dirty: Any = ...
    depends_on: Any = ...
    table_settings: Any = ...
    without_rowid: Any = ...
    temporary: Any = ...
    refs: Any = ...
    backrefs: Any = ...
    model_refs: Any = ...
    model_backrefs: Any = ...
    manytomany: Any = ...
    options: Any = ...
    def __init__(
        self,
        model: Any,
        database: Optional[Any] = ...,
        table_name: Optional[Any] = ...,
        indexes: Optional[Any] = ...,
        primary_key: Optional[Any] = ...,
        constraints: Optional[Any] = ...,
        schema: Optional[Any] = ...,
        only_save_dirty: bool = ...,
        depends_on: Optional[Any] = ...,
        options: Optional[Any] = ...,
        db_table: Optional[Any] = ...,
        table_function: Optional[Any] = ...,
        table_settings: Optional[Any] = ...,
        without_rowid: bool = ...,
        temporary: bool = ...,
        legacy_table_names: bool = ...,
        **kwargs: Any,
    ) -> None: ...
    def make_table_name(self): ...
    def model_graph(self, refs: bool = ..., backrefs: bool = ..., depth_first: bool = ...): ...
    def add_ref(self, field: Any) -> None: ...
    def remove_ref(self, field: Any) -> None: ...
    def add_manytomany(self, field: Any) -> None: ...
    def remove_manytomany(self, field: Any) -> None: ...
    @property
    def table(self): ...
    @table.setter
    def table(self, value: Any) -> None: ...
    # def table(self) -> None: ...
    @property
    def schema(self): ...
    @schema.setter
    def schema(self, value: Any) -> None: ...
    @property
    def entity(self): ...
    def get_rel_for_model(self, model: Any): ...
    def add_field(self, field_name: Any, field: Any, set_attribute: bool = ...) -> None: ...
    def remove_field(self, field_name: Any) -> None: ...
    auto_increment: Any = ...
    def set_primary_key(self, name: Any, field: Any) -> None: ...
    def get_primary_keys(self): ...
    def get_default_dict(self): ...
    def fields_to_index(self): ...
    def set_database(self, database: Any) -> None: ...
    def set_table_name(self, table_name: Any) -> None: ...

class SubclassAwareMetadata(Metadata):
    models: Any = ...
    def __init__(self, model: Any, *args: Any, **kwargs: Any) -> None: ...
    def map_models(self, fn: Any) -> None: ...

class DoesNotExist(Exception): ...

class ModelBase(type):
    inheritable: Any = ...
    def __new__(cls, name: Any, bases: Any, attrs: Any): ...
    def __iter__(self) -> Any: ...
    def __getitem__(self, key: Any): ...
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def __delitem__(self, key: Any) -> None: ...
    def __contains__(self, key: Any): ...
    def __len__(self): ...
    def __bool__(self): ...
    __nonzero__: Any = ...

class _BoundModelsContext(_callable_context_manager):
    models: Any = ...
    database: Any = ...
    bind_refs: Any = ...
    bind_backrefs: Any = ...
    def __init__(self, models: Any, database: Any, bind_refs: Any, bind_backrefs: Any) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...

class Model(Node, metaclass=ModelBase):
    id: Any
    _meta: ClassVar[Metadata]
    _schema: ClassVar[SchemaManager]
    DoesNotExist: ClassVar[Type[DoesNotExist]]
    __data__: MutableMapping[str, object]
    __rel__: MutableMapping[str, object]
    def __init__(self, *, __no_default__: Union[int, bool] = ..., **kwargs: object): ...
    def __str__(self) -> str: ...
    @classmethod
    def validate_model(cls) -> None: ...
    @classmethod
    def alias(cls, alias: Optional[str] = ...) -> ModelAlias: ...
    @classmethod
    def select(cls, *fields: Field) -> ModelSelect: ...
    @classmethod
    def update(
        cls, __data: Optional[Iterable[Union[str, Field]]] = ..., **update: Any
    ) -> ModelUpdate: ...
    @classmethod
    def insert(
        cls, __data: Optional[Iterable[Union[str, Field]]] = ..., **insert: Any
    ) -> ModelInsert: ...
    @overload
    @classmethod
    def insert_many(cls, rows: Iterable[Mapping[str, object]], fields: None) -> ModelInsert: ...
    @overload
    @classmethod
    def insert_many(cls, rows: Iterable[tuple], fields: Sequence[Field]) -> ModelInsert: ...
    @classmethod
    def insert_from(
        cls, query: SelectQuery, fields: Iterable[Union[Field, Text]]
    ) -> ModelInsert: ...
    @classmethod
    def replace(
        cls, __data: Optional[Iterable[Union[str, Field]]] = ..., **insert: object
    ) -> OnConflict: ...
    @classmethod
    def replace_many(
        cls, rows: Iterable[tuple], fields: Optional[Sequence[Field]] = ...
    ) -> OnConflict: ...
    @classmethod
    def raw(cls, sql: str, *params: object) -> ModelRaw: ...
    @classmethod
    def delete(cls) -> ModelDelete: ...
    @classmethod
    def create(cls: Type[_T], **query) -> _T: ...
    @classmethod
    def bulk_create(
        cls, model_list: Iterable[Type[Model]], batch_size: Optional[int] = ...
    ) -> None: ...
    @classmethod
    def bulk_update(
        cls,
        model_list: Iterable[Type[Model]],
        fields: Iterable[Union[str, Field]],
        batch_size: Optional[int] = ...,
    ) -> int: ...
    @classmethod
    def noop(cls) -> NoopModelSelect: ...
    @classmethod
    def get(cls, *query: object, **filters: object) -> Any: ...
    @classmethod
    def get_or_none(cls, *query: object, **filters: object) -> Optional[Any]: ...
    @classmethod
    def get_by_id(cls, pk: object) -> Any: ...
    @classmethod
    def set_by_id(cls, key, value) -> CursorWrapper: ...
    @classmethod
    def delete_by_id(cls, pk: object) -> CursorWrapper: ...
    @classmethod
    def get_or_create(
        cls, *, defaults: Mapping[str, object] = ..., **kwargs: object
    ) -> Tuple[Any, bool]: ...
    @classmethod
    def filter(cls, *dq_nodes: DQ, **filters: Any) -> SelectQuery: ...
    def get_id(self) -> Any: ...
    def save(
        self, force_insert: bool = ..., only: Optional[Iterable[Union[str, Field]]] = ...
    ) -> Union[Literal[False], int]: ...
    def is_dirty(self) -> bool: ...
    @property
    def dirty_fields(self) -> List[Field]: ...
    def dependencies(
        self, search_nullable: bool = ...
    ) -> Iterator[Tuple[Union[bool, Node], ForeignKeyField]]: ...
    def delete_instance(self: _T, recursive: bool = ..., delete_nullable: bool = ...) -> _T: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __sql__(self, ctx: Any): ...
    @classmethod
    def bind(
        cls,
        database: Database,
        bind_refs: bool = ...,
        bind_backrefs: bool = ...,
        _exclude: Optional[MutableSet[Type[Model]]] = ...,
    ) -> bool: ...
    @classmethod
    def bind_ctx(
        cls, database: Database, bind_refs: bool = ..., bind_backrefs: bool = ...
    ) -> _BoundModelsContext: ...
    @classmethod
    def table_exists(cls) -> bool: ...
    @classmethod
    def create_table(
        cls, safe: bool = ..., *, fail_silently: bool = ..., **options: object
    ) -> None: ...
    @classmethod
    def drop_table(
        cls, safe: bool = ..., drop_sequences: bool = ..., **options: object
    ) -> None: ...
    @classmethod
    def truncate_table(cls, **options: object) -> None: ...
    @classmethod
    def index(cls, *fields: Union[Field, Node, str], **kwargs: object) -> ModelIndex: ...
    @classmethod
    def add_index(cls, *fields: Union[str, SQL, Index], **kwargs: object) -> None: ...

class ModelAlias(Node):
    def __init__(self, model: Any, alias: Optional[Any] = ...) -> None: ...
    def __getattr__(self, attr: Any): ...
    def __setattr__(self, attr: Any, value: Any) -> None: ...
    def get_field_aliases(self): ...
    def select(self, *selection: Any): ...
    def __call__(self, **kwargs: Any): ...
    def __sql__(self, ctx: Any): ...

class FieldAlias(Field):
    source: Any = ...
    model: Any = ...
    field: Any = ...
    def __init__(self, source: Any, field: Any) -> None: ...
    @classmethod
    def create(cls, source: Any, field: Any): ...
    def clone(self): ...
    def adapt(self, value: Any): ...
    def python_value(self, value: Any): ...
    def db_value(self, value: Any): ...
    def __getattr__(self, attr: Any): ...
    def __sql__(self, ctx: Any): ...

class _ModelQueryHelper:
    default_row_type: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def objects(self, constructor: Optional[Any] = ...) -> None: ...

class ModelRaw(_ModelQueryHelper, RawQuery):
    model: Any = ...
    def __init__(self, model: Any, sql: Any, params: Any, **kwargs: Any) -> None: ...
    def get(self): ...

class BaseModelSelect(_ModelQueryHelper):
    def union_all(self, rhs: Any): ...
    __add__: Any = ...
    def union(self, rhs: Any): ...
    __or__: Any = ...
    def intersect(self, rhs: Any): ...
    __and__: Any = ...
    def except_(self, rhs: Any): ...
    __sub__: Any = ...
    def __iter__(self) -> Any: ...
    def prefetch(self, *subqueries: Any): ...
    def get(self, database: Optional[Any] = ...): ...
    def group_by(self, *columns: Any) -> None: ...

class ModelCompoundSelectQuery(BaseModelSelect, CompoundSelectQuery):
    model: Any = ...
    def __init__(self, model: Any, *args: Any, **kwargs: Any) -> None: ...

class ModelSelect(BaseModelSelect, Select):
    model: Any = ...
    def __init__(self, model: Any, fields_or_models: Any, is_default: bool = ...) -> None: ...
    def clone(self): ...
    def select(self, *fields_or_models: Any): ...
    def switch(self, ctx: Optional[Any] = ...): ...
    def join(
        self,
        dest: Any,
        join_type: Any = ...,
        on: Optional[Any] = ...,
        src: Optional[Any] = ...,
        attr: Optional[Any] = ...,
    ) -> None: ...
    def join_from(
        self,
        src: Any,
        dest: Any,
        join_type: Any = ...,
        on: Optional[Any] = ...,
        attr: Optional[Any] = ...,
    ): ...
    def ensure_join(self, lm: Any, rm: Any, on: Optional[Any] = ..., **join_kwargs: Any): ...
    def convert_dict_to_node(self, qdict: Any): ...
    def filter(self, *args: Any, **kwargs: Any): ...
    def create_table(self, name: Any, safe: bool = ..., **meta: Any): ...
    def __sql_selection__(self, ctx: Any, is_subquery: bool = ...): ...

class NoopModelSelect(ModelSelect):
    def __sql__(self, ctx: Any): ...

class _ModelWriteQueryHelper(_ModelQueryHelper):
    model: Any = ...
    def __init__(self, model: Any, *args: Any, **kwargs: Any) -> None: ...
    def returning(self, *returning: Any): ...

class ModelUpdate(_ModelWriteQueryHelper, Update): ...

class ModelInsert(_ModelWriteQueryHelper, Insert):
    default_row_type: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def returning(self, *returning: Any): ...
    def get_default_data(self): ...
    def get_default_columns(self): ...

class ModelDelete(_ModelWriteQueryHelper, Delete): ...

class ManyToManyQuery(ModelSelect):
    def __init__(
        self, instance: Any, accessor: Any, rel: Any, *args: Any, **kwargs: Any
    ) -> None: ...
    def add(self, value: Any, clear_existing: bool = ...) -> None: ...
    def remove(self, value: Any): ...
    def clear(self): ...

class BaseModelCursorWrapper(DictCursorWrapper):
    model: Any = ...
    select: Any = ...
    def __init__(self, cursor: Any, model: Any, columns: Any) -> None: ...
    initialize: Any = ...
    def process_row(self, row: Any) -> None: ...

class ModelDictCursorWrapper(BaseModelCursorWrapper):
    def process_row(self, row: Any): ...

class ModelTupleCursorWrapper(ModelDictCursorWrapper):
    constructor: Any = ...
    def process_row(self, row: Any): ...

class ModelNamedTupleCursorWrapper(ModelTupleCursorWrapper):
    tuple_class: Any = ...
    constructor: Any = ...
    def initialize(self): ...

class ModelObjectCursorWrapper(ModelDictCursorWrapper):
    constructor: Any = ...
    is_model: Any = ...
    def __init__(self, cursor: Any, model: Any, select: Any, constructor: Any) -> None: ...
    def process_row(self, row: Any): ...

class ModelCursorWrapper(BaseModelCursorWrapper):
    from_list: Any = ...
    joins: Any = ...
    def __init__(
        self, cursor: Any, model: Any, select: Any, from_list: Any, joins: Any
    ) -> None: ...
    key_to_constructor: Any = ...
    src_is_dest: Any = ...
    src_to_dest: Any = ...
    column_keys: Any = ...
    def initialize(self) -> None: ...
    def process_row(self, row: Any): ...

class PrefetchQuery:
    def __new__(
        cls,
        query: Any,
        fields: Optional[Any] = ...,
        is_backref: Optional[Any] = ...,
        rel_models: Optional[Any] = ...,
        field_to_name: Optional[Any] = ...,
        model: Optional[Any] = ...,
    ): ...
    def populate_instance(self, instance: Any, id_map: Any) -> None: ...
    def store_instance(self, instance: Any, id_map: Any) -> None: ...

def prefetch(sq: Any, *subqueries: Any): ...
