/**
 * An element that displays a list (grid or table) of repositories.
 */
angular.module('quay').directive('repoListView', function () {
  var directiveDefinitionObject = {
    priority: 0,
    templateUrl: '/static/directives/repo-list-view.html',
    replace: false,
    transclude: true,
    restrict: 'C',
    scope: {
      namespaces: '=namespaces',
      starredRepositories: '=starredRepositories',
      starToggled: '&starToggled',
      repoKind: '@repoKind'
    },
    controller: function($scope, $element, CookieService, StateService, Config) {
      $scope.inReadOnlyMode = StateService.inReadOnlyMode();
      $scope.resources = [];
      $scope.loading = true;
      $scope.optionAllowed = true;
      $scope.quotaManagementEnabled = Config.FEATURE_REPO_MIRROR;
      $scope.quotaManagementEnabled = Config.FEATURE_QUOTA_MANAGEMENT;

      $scope.$watch('namespaces', function(namespaces) {
        if (!namespaces) { return; }

        $scope.loading = false;
        $scope.resources = [];
        namespaces.forEach(function(namespace) {
          if (namespace && namespace.repositories) {
            $scope.resources.push(namespace.repositories);
            if (namespace.repositories.loading) {
              $scope.loading = true;
            }
          }
        });
      }, true);
    }
  };
  return directiveDefinitionObject;
});
