"use strict";
var UNDEFINED_STRING = 'undefined';
var FUNCTION_STRING = 'function';
var Setup = (function () {
    function Setup(object, key) {
        this.object = object;
        this.key = key;
        this.object[key] = {};
        this.spy = spyOn(this.object, key);
    }
    Object.defineProperty(Setup.prototype, "Spy", {
        get: function () {
            return this.spy;
        },
        enumerable: true,
        configurable: true
    });
    /** Setup the return value for the setup of the property */
    Setup.prototype.is = function (value) {
        this.object[this.key] = value;
        if (typeof (value) === FUNCTION_STRING) {
            this.spy = spyOn(this.object, this.key).and.callThrough();
        }
        return this;
    };
    /** deprecated use is() */
    Setup.prototype.returns = function (value) {
        console.warn('returns() is being deprecated, use is()');
        this.is(value);
    };
    return Setup;
}());
exports.Setup = Setup;
