// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to list the user pool clients.
type ListUserPoolClientsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pool clients.
	MaxResults *int64 `min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to list user pool clients.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserPoolClientsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolClientsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUserPoolClientsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server that lists user pool clients.
type ListUserPoolClientsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool clients in the response that lists user pool clients.
	UserPoolClients []UserPoolClientDescription `type:"list"`
}

// String returns the string representation
func (s ListUserPoolClientsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUserPoolClients = "ListUserPoolClients"

// ListUserPoolClientsRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Lists the clients that have been created for the specified user pool.
//
//    // Example sending a request using ListUserPoolClientsRequest.
//    req := client.ListUserPoolClientsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients
func (c *Client) ListUserPoolClientsRequest(input *ListUserPoolClientsInput) ListUserPoolClientsRequest {
	op := &aws.Operation{
		Name:       opListUserPoolClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserPoolClientsInput{}
	}

	req := c.newRequest(op, input, &ListUserPoolClientsOutput{})
	return ListUserPoolClientsRequest{Request: req, Input: input, Copy: c.ListUserPoolClientsRequest}
}

// ListUserPoolClientsRequest is the request type for the
// ListUserPoolClients API operation.
type ListUserPoolClientsRequest struct {
	*aws.Request
	Input *ListUserPoolClientsInput
	Copy  func(*ListUserPoolClientsInput) ListUserPoolClientsRequest
}

// Send marshals and sends the ListUserPoolClients API request.
func (r ListUserPoolClientsRequest) Send(ctx context.Context) (*ListUserPoolClientsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUserPoolClientsResponse{
		ListUserPoolClientsOutput: r.Request.Data.(*ListUserPoolClientsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListUserPoolClientsRequestPaginator returns a paginator for ListUserPoolClients.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListUserPoolClientsRequest(input)
//   p := cognitoidentityprovider.NewListUserPoolClientsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListUserPoolClientsPaginator(req ListUserPoolClientsRequest) ListUserPoolClientsPaginator {
	return ListUserPoolClientsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListUserPoolClientsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListUserPoolClientsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListUserPoolClientsPaginator struct {
	aws.Pager
}

func (p *ListUserPoolClientsPaginator) CurrentPage() *ListUserPoolClientsOutput {
	return p.Pager.CurrentPage().(*ListUserPoolClientsOutput)
}

// ListUserPoolClientsResponse is the response type for the
// ListUserPoolClients API operation.
type ListUserPoolClientsResponse struct {
	*ListUserPoolClientsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUserPoolClients request.
func (r *ListUserPoolClientsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
