// Code generated from specification version 7.0.0: DO NOT EDIT

package esapi

import (
	"context"
	"io"
	"strconv"
	"strings"
	"time"
)

func newIndicesShrinkFunc(t Transport) IndicesShrink {
	return func(index string, target string, o ...func(*IndicesShrinkRequest)) (*Response, error) {
		var r = IndicesShrinkRequest{Index: index, Target: target}
		for _, f := range o {
			f(&r)
		}
		return r.Do(r.ctx, t)
	}
}

// ----- API Definition -------------------------------------------------------

// IndicesShrink allow to shrink an existing index into a new index with fewer primary shards.
//
// See full documentation at http://www.elastic.co/guide/en/elasticsearch/reference/master/indices-shrink-index.html.
//
type IndicesShrink func(index string, target string, o ...func(*IndicesShrinkRequest)) (*Response, error)

// IndicesShrinkRequest configures the Indices Shrink API request.
//
type IndicesShrinkRequest struct {
	Index string

	Body io.Reader

	Target string

	CopySettings        *bool
	MasterTimeout       time.Duration
	Timeout             time.Duration
	WaitForActiveShards string

	Pretty     bool
	Human      bool
	ErrorTrace bool
	FilterPath []string

	ctx context.Context
}

// Do executes the request and returns response or error.
//
func (r IndicesShrinkRequest) Do(ctx context.Context, transport Transport) (*Response, error) {
	var (
		method string
		path   strings.Builder
		params map[string]string
	)

	method = "PUT"

	path.Grow(1 + len(r.Index) + 1 + len("_shrink") + 1 + len(r.Target))
	path.WriteString("/")
	path.WriteString(r.Index)
	path.WriteString("/")
	path.WriteString("_shrink")
	path.WriteString("/")
	path.WriteString(r.Target)

	params = make(map[string]string)

	if r.CopySettings != nil {
		params["copy_settings"] = strconv.FormatBool(*r.CopySettings)
	}

	if r.MasterTimeout != 0 {
		params["master_timeout"] = formatDuration(r.MasterTimeout)
	}

	if r.Timeout != 0 {
		params["timeout"] = formatDuration(r.Timeout)
	}

	if r.WaitForActiveShards != "" {
		params["wait_for_active_shards"] = r.WaitForActiveShards
	}

	if r.Pretty {
		params["pretty"] = "true"
	}

	if r.Human {
		params["human"] = "true"
	}

	if r.ErrorTrace {
		params["error_trace"] = "true"
	}

	if len(r.FilterPath) > 0 {
		params["filter_path"] = strings.Join(r.FilterPath, ",")
	}

	req, _ := newRequest(method, path.String(), r.Body)

	if len(params) > 0 {
		q := req.URL.Query()
		for k, v := range params {
			q.Set(k, v)
		}
		req.URL.RawQuery = q.Encode()
	}

	if r.Body != nil {
		req.Header[headerContentType] = headerContentTypeJSON
	}

	if ctx != nil {
		req = req.WithContext(ctx)
	}

	res, err := transport.Perform(req)
	if err != nil {
		return nil, err
	}

	response := Response{
		StatusCode: res.StatusCode,
		Body:       res.Body,
		Header:     res.Header,
	}

	return &response, nil
}

// WithContext sets the request context.
//
func (f IndicesShrink) WithContext(v context.Context) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.ctx = v
	}
}

// WithBody - The configuration for the target index (`settings` and `aliases`).
//
func (f IndicesShrink) WithBody(v io.Reader) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.Body = v
	}
}

// WithCopySettings - whether or not to copy settings from the source index (defaults to false).
//
func (f IndicesShrink) WithCopySettings(v bool) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.CopySettings = &v
	}
}

// WithMasterTimeout - specify timeout for connection to master.
//
func (f IndicesShrink) WithMasterTimeout(v time.Duration) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.MasterTimeout = v
	}
}

// WithTimeout - explicit operation timeout.
//
func (f IndicesShrink) WithTimeout(v time.Duration) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.Timeout = v
	}
}

// WithWaitForActiveShards - set the number of active shards to wait for on the shrunken index before the operation returns..
//
func (f IndicesShrink) WithWaitForActiveShards(v string) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.WaitForActiveShards = v
	}
}

// WithPretty makes the response body pretty-printed.
//
func (f IndicesShrink) WithPretty() func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.Pretty = true
	}
}

// WithHuman makes statistical values human-readable.
//
func (f IndicesShrink) WithHuman() func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.Human = true
	}
}

// WithErrorTrace includes the stack trace for errors in the response body.
//
func (f IndicesShrink) WithErrorTrace() func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.ErrorTrace = true
	}
}

// WithFilterPath filters the properties of the response body.
//
func (f IndicesShrink) WithFilterPath(v ...string) func(*IndicesShrinkRequest) {
	return func(r *IndicesShrinkRequest) {
		r.FilterPath = v
	}
}
