'use strict';

var _ = require('../');

var type = 'ACTION_TYPE';

describe('isRSA()', function () {
  it('requires a type', function () {
    expect(_.isRSA({ type: type })).to.be['true'];
    expect(_.isRSA({})).to.be['false'];
  });

  it('only accepts plain objects', function () {
    var action = function action() {};
    action.type = type;
    expect(_.isRSA(action)).to.be['false'];
    var action2 = new function C() {
      this.type = type;
    }();
    expect(_.isRSA(action2)).to.be['false'];
  });

  it('handles error actions properly', function () {
    expect(_.isRSA({ type: type, error: true, payload: new Error() })).to.be['true'];
    expect(_.isRSA({ type: type, error: true })).to.be['false'];
    expect(_.isRSA({ type: type, payload: new Error() })).to.be['false'];
  });

  it('returns false if there are invalid keys', function () {
    expect(_.isRSA({ type: type, payload: 'foobar' })).to.be['true'];
    expect(_.isRSA({ type: type, meta: 'foobar' })).to.be['true'];
    expect(_.isRSA({ type: type, extra: 'foobar' })).to.be['false'];
  });
});