Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Metrics = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.isMetrics = isMetrics;
exports.default = createMetrics;

var _eventemitter = require("eventemitter3");

var _eventemitter2 = _interopRequireDefault(_eventemitter);

var _querystring = require("querystring");

var _querystring2 = _interopRequireDefault(_querystring);

var _ExecutionEnvironment = require("fbjs/lib/ExecutionEnvironment");

var _invariant = require("fbjs/lib/invariant");

var _invariant2 = _interopRequireDefault(_invariant);

var _warning = require("fbjs/lib/warning");

var _warning2 = _interopRequireDefault(_warning);

var _ActionTypes = require("./ActionTypes");

var _ActionTypes2 = _interopRequireDefault(_ActionTypes);

var _createService = require("./createService");

var _createService2 = _interopRequireDefault(_createService);

var _extractApis = require("./utils/extractApis");

var _extractApis2 = _interopRequireDefault(_extractApis);

var _isPromise = require("./utils/isPromise");

var _isPromise2 = _interopRequireDefault(_isPromise);

var _useTrackBindingPlugin = require("./useTrackBindingPlugin");

var _useTrackBindingPlugin2 = _interopRequireDefault(_useTrackBindingPlugin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var qs = _ExecutionEnvironment.canUseDOM ? _querystring2.default.decode(window.location.search.substr(1)) : {};
var defaults = {
    pageViewEvent: "pageLoad",
    pageDefaults: function pageDefaults() {
        return {};
    },
    requestTimeout: 15 * 1000
};

var Transaction = function () {
    function Transaction() {
        _classCallCheck(this, Transaction);

        this.pvTransactions = {};
        this.transactionId = 0;
    }

    _createClass(Transaction, [{
        key: "create",
        value: function create() {
            return ++this.transactionId;
        }
    }, {
        key: "current",
        value: function current() {
            return this.transactionId;
        }
    }, {
        key: "get",
        value: function get(tId) {
            return this.pvTransactions[tId];
        }
    }, {
        key: "set",
        value: function set(tId, value) {
            this.pvTransactions[tId] = value;
        }
    }, {
        key: "remove",
        value: function remove(tId) {
            if (tId && this.pvTransactions[tId]) {
                delete this.pvTransactions[tId];
            }
        }
    }, {
        key: "keys",
        value: function keys() {
            return Object.keys(this.pvTransactions);
        }
    }]);

    return Transaction;
}();

var Metrics = exports.Metrics = function (_EventEmitter) {
    _inherits(Metrics, _EventEmitter);

    function Metrics() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Metrics);

        if (!options.vendors) {
            throw new Error("'vendors' option is required.");
        }

        var _this = _possibleConstructorReturn(this, (Metrics.__proto__ || Object.getPrototypeOf(Metrics)).call(this));

        _this.enabled = options.enabled !== false;
        // undocumented option for unit test.
        _this.canUseDOM = options.canUseDOM !== undefined ? !!options.canUseDOM : _ExecutionEnvironment.canUseDOM;
        if (!_this.canUseDOM) {
            _this.enabled = false;
        }
        _this.debug = !!options.debug || qs.metrics_debug === "true";
        _this.customParams = options.customParams || {};
        _this.pageDefaults = options.pageDefaults || defaults.pageDefaults;
        _this.pageViewEvent = options.pageViewEvent || defaults.pageViewEvent;
        _this.requestTimeout = options.requestTimeout || defaults.requestTimeout;
        _this.cancelOnNext = options.cancelOnNext !== undefined ? !!options.cancelOnNext : true;
        _this.vendors = Array.isArray(options.vendors) ? options.vendors : [options.vendors];
        _this.services = _this.vendors.map(function (vendor) {
            return (0, _createService2.default)(vendor);
        });
        _this.apiList = (0, _extractApis2.default)(_this.services.map(function (service) {
            return service.apis;
        }));
        _this.transaction = new Transaction();
        _this.routeState = {};
        _this.apiImpl = _this.apiList.reduce(function (impl, api) {
            impl[api] = function () {
                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                return _this._prepareTrack.apply(_this, [api].concat(args));
            };
            return impl;
        }, {});
        Object.freeze(_this.apiImpl);
        return _this;
    }

    _createClass(Metrics, [{
        key: "listen",
        value: function listen(type, callback) {
            var _this2 = this;

            // if type is not specified, listen for all the apis.
            if (typeof type === "function") {
                callback = type;
                type = null;
            }

            if (type) {
                this.on(type, callback);
            } else {
                this.apiList.forEach(function (api) {
                    _this2.on(api, callback);
                });
            }

            return function () {
                if (type) {
                    _this2.removeListener(type, callback);
                } else {
                    _this2.apiList.forEach(function (api) {
                        _this2.removeListener(api, callback);
                    });
                }
            };
        }
    }, {
        key: "setRouteState",
        value: function setRouteState(state) {
            this._cancelPreviousPromiseIfPending();
            this.routeState = state;
        }

        /* eslint-disable consistent-return */

    }, {
        key: "useTrackBinding",
        value: function useTrackBinding(rootElement, attributePrefix) {
            if (!this.enabled) {
                return;
            }

            // if 'false' is passed as first param, detach listeners
            if (rootElement === false) {
                this._removeTrackBindingListener();
                return;
            }

            (0, _invariant2.default)(typeof this.api.track === "function", "Metrics 'track' method needs to be defined for declarative tracking.");

            if (this._trackBindingListener) {
                this._removeTrackBindingListener();
            }

            this._trackBindingListener = (0, _useTrackBindingPlugin2.default)({
                callback: this._handleClick.bind(this),
                rootElement: rootElement,
                attributePrefix: attributePrefix
            });

            return this._removeTrackBindingListener.bind(this);
        }
    }, {
        key: "destroy",
        value: function destroy() {
            this._removeListeners();
            this._removeTrackBindingListener();
        }
    }, {
        key: "_callServices",

        /**
         * @method _callServices
         * @param type
         * @param promise
         * @returns {Promise.<T>}
         * @private
         */
        value: function _callServices(type, promise) {
            var _this3 = this;

            return promise.then(function (params) {
                params = params || [];
                var results = [];
                var services = _this3.services;
                var requestTimeout = _this3.requestTimeout;

                function isCompleted() {
                    return results.length === services.length;
                }

                function clearTimer(timer) {
                    if (timer) {
                        clearTimeout(timer);
                        timer = null;
                    }
                }

                return new Promise(function (resolve) {
                    function process(result) {
                        if (this.isTimeout) {
                            return;
                        }
                        this.isTimeout = true;
                        clearTimer(this.timer);
                        results.push(result);
                        if (isCompleted()) {
                            resolve(results);
                        }
                    }

                    services.map(function (service) {
                        var apis = service.apis,
                            name = service.name;

                        var apiExists = apis && apis[type];
                        if (apiExists) {
                            (0, _warning2.default)(typeof apis[type] === "function", "'" + type + "'" + (name ? "(" + name + " Service)" : "") + " is not a function");
                        }
                        var requestPromise = apiExists && typeof apis[type] === "function" ? apis[type].apply(apis, _toConsumableArray(params)) : undefined;
                        if (!(0, _isPromise2.default)(requestPromise)) {
                            requestPromise = Promise.resolve(requestPromise);
                        }
                        requestPromise.isTimeout = false;
                        requestPromise.timer = setTimeout(process.bind(requestPromise), requestTimeout, {
                            name: name,
                            params: params,
                            error: new Error("Request time out after " + requestTimeout + " ms."),
                            status: "failure"
                        });
                        return requestPromise.then(function (response) {
                            return {
                                name: name,
                                params: params,
                                response: response,
                                status: "success"
                            };
                        }).catch(function (error) {
                            return {
                                name: name,
                                params: params,
                                error: error,
                                status: "failure"
                            };
                        }).then(process.bind(requestPromise));
                    });
                });
            });
        }
        /**
         * Cancels page view promise if it's still pending while the route has changed.
         *
         * @method _cancelPreviousPromiseIfPending
         * @private
         */

    }, {
        key: "_cancelPreviousPromiseIfPending",
        value: function _cancelPreviousPromiseIfPending() {
            var _this4 = this;

            this.routeState = {};
            this.transaction.keys().forEach(function (tId) {
                var entry = _this4.transaction.get(tId);
                if (entry && entry.cancelOnNext) {
                    entry.shouldCancel = true;
                }
            });
        }

        /**
         * @method _createTransaction
         * @param args
         * @private
         */

    }, {
        key: "_createTransaction",
        value: function _createTransaction(args) {
            var tId = this.transaction.current();
            var cancelOnNext = this.cancelOnNext;
            this.transaction.set(tId, {
                promise: args[0],
                cancelOnNext: cancelOnNext
            });
            args.push(tId);
        }
        /**
         * @method _clearTransaction
         * @param tId
         * @private
         */

    }, {
        key: "_clearTransaction",
        value: function _clearTransaction(tId) {
            this.transaction.remove(tId);
        }
        /**
         * @method _doTrack
         * @param type
         * @param promise
         * @param tId
         * @private
         */

    }, {
        key: "_doTrack",
        value: function _doTrack(type, promise, tId) {
            promise = this._callServices(type, promise);
            var dispatchEvent = function (status, response, error) {
                var eventFacade = {
                    type: type,
                    status: status
                };
                if (response) {
                    eventFacade.response = response;
                } else if (error) {
                    eventFacade.error = error;
                }
                if (tId) {
                    eventFacade.transactionId = tId;
                    this._clearTransaction(tId);
                }
                this.emit(type, eventFacade);
                if (this.debug) {
                    console.log("track result", eventFacade);
                }
            }.bind(this);

            promise.then(function (response) {
                dispatchEvent(response.every(function (item) {
                    return item.status === "success";
                }) ? "success" : "failure", response);
            }).catch(function (error) {
                dispatchEvent("failure", null, error);
            });
        }
        /**
         * Returns the default tracking data provided by a helper object.
         *
         * @method __getDefaultData
         * @return {Object}
         * @private
         */

    }, {
        key: "_getDefaultData",
        value: function _getDefaultData(state) {
            return this.pageDefaults(state);
        }
        /**
         * Returns a merged data between the host passed object and the default tracking data provided by a helper object.
         *
         * @method __mergeWith
         * @return {Object}
         * @private
         */

    }, {
        key: "_mergeWith",
        value: function _mergeWith(data, state) {
            return Object.assign({}, this._getDefaultData(state), this.customParams, data);
        }
        /**
         * Checks if this promise should be cancelled by rejecting it before it's sent to the facade.
         *
         * @method __addCancelHook
         * @param {Promise} promise
         * @returns {Promise}
         * @private
         */

    }, {
        key: "_addCancelHook",
        value: function _addCancelHook(promise) {
            var _this5 = this;

            var tId = this.transaction.create();
            return promise.then(function (data) {
                return _this5.transaction.get(tId).shouldCancel ? Promise.reject(new Error("Page view cancelled")) : data;
            });
        }
        /**
         * Modify the data to include 'eventName' before it's sent to the facade.
         *
         * @method __addEventNameToPromise
         * @param {String} eventName
         * @param {Promise} promise
         * @param {boolean} shouldMerge
         * @returns {Promise}
         * @private
         */

    }, {
        key: "_addEventNameToPromise",
        value: function _addEventNameToPromise(eventName, promise, shouldMerge) {
            return promise.then(function (state, data) {
                data = [shouldMerge ? this._mergeWith(data, state) : data];
                data.unshift(eventName);
                return data;
            }.bind(this, this.routeState));
        }
        /**
         * Run checks to the arguments passed to 'pageView' and 'track', set default page view eventName if it's not provided.
         * Also merges the default data with the passed pageView data, and optionally for track data if a flag is set.
         *
         * @method __inspectArguments
         * @param {String} type
         * @param args
         * @returns {Array}
         * @private
         */

    }, {
        key: "_inspectArguments",
        value: function _inspectArguments(type) {
            for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
            }

            var shouldMerge = true;
            if (type !== _ActionTypes2.default.PAGE_VIEW) {
                // don't merge `pageDefaults` with track params unless it's explicitly requested by the third argument.
                shouldMerge = false;
                if (type === _ActionTypes2.default.TRACK) {
                    (0, _invariant2.default)(typeof args[0] === "string", "Metrics 'track' method requires 'eventName' string as the first argument and object or promise as the second argument.");
                }
                // this might be confusing but for now, use the last argument as a flag for merge when it's boolean.
                if (args.length >= 3 && typeof args[args.length - 1] === "boolean") {
                    shouldMerge = args[args.length - 1];
                }
            }

            // set default page view event name when missing.

            var _args = args,
                _args2 = _slicedToArray(_args, 2),
                eventName = _args2[0],
                params = _args2[1];

            if (!params && typeof eventName !== "string") {
                params = eventName;
                eventName = type === _ActionTypes2.default.PAGE_VIEW ? this.pageViewEvent : null;
            }

            // make sure `params` is a promise.
            if (!(0, _isPromise2.default)(params)) {
                params = Promise.resolve(params);
            }

            // add cancel hook so that it can be cancelled(rejected) if the promise is still pending when the route changes.
            if (type === _ActionTypes2.default.PAGE_VIEW) {
                params = this._addCancelHook(params);
            }

            // PAGE_VIEW or TRACK should always have `eventName`.
            if (eventName) {
                params = this._addEventNameToPromise(eventName, params, shouldMerge);
            }
            args = [type, params];

            if (type === _ActionTypes2.default.PAGE_VIEW) {
                this._createTransaction(args);
            }

            return args;
        }
        /**
         * @method _prepareTrack
         * @param type
         * @param args
         * @private
         */

    }, {
        key: "_prepareTrack",
        value: function _prepareTrack(type) {
            for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
                args[_key3 - 1] = arguments[_key3];
            }

            if (!this.enabled) {
                return;
            }
            args = this._inspectArguments.apply(this, [type].concat(_toConsumableArray(args)));
            this._doTrack.apply(this, _toConsumableArray(args));
        }
        /**
         * A click handler to perform custom link tracking, any element with 'metrics-*' attribute will be tracked.
         *
         * @method _handleClick
         * @param {Object} params
         * @private
         */

    }, {
        key: "_handleClick",
        value: function _handleClick() {
            var _api;

            (_api = this.api).track.apply(_api, arguments);
        }
    }, {
        key: "_removeListeners",
        value: function _removeListeners() {
            this.removeAllListeners();
        }
    }, {
        key: "_removeTrackBindingListener",
        value: function _removeTrackBindingListener() {
            if (this._trackBindingListener) {
                this._trackBindingListener.remove();
                this._trackBindingListener = null;
            }
        }
    }, {
        key: "api",
        get: function get() {
            return this.apiImpl;
        }
    }]);

    return Metrics;
}(_eventemitter2.default);

function isMetrics(value) {
    return value && typeof value.listen === "function" && typeof value.setRouteState === "function" && typeof value.useTrackBinding === "function" && typeof value.destroy === "function" && _typeof(value.api) === "object";
}

function createMetrics(options) {
    var metrics = new Metrics(options);
    return {
        listen: metrics.listen.bind(metrics),
        setRouteState: metrics.setRouteState.bind(metrics),
        useTrackBinding: metrics.useTrackBinding.bind(metrics),
        destroy: metrics.destroy.bind(metrics),
        get enabled() {
            return metrics.enabled;
        },
        get api() {
            return metrics.api;
        }
    };
}