import invariant from 'invariant';
import plain from './structure/plain';


var createFormValueSelector = function createFormValueSelector(_ref) {
  var getIn = _ref.getIn;
  return function (form, getFormState) {
    invariant(form, 'Form value must be specified');
    var nonNullGetFormState = getFormState || function (state) {
      return getIn(state, 'form');
    };
    return function (state) {
      for (var _len = arguments.length, fields = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        fields[_key - 1] = arguments[_key];
      }

      invariant(fields.length, 'No fields specified');
      return fields.length === 1 ? // only selecting one field, so return its value
      getIn(nonNullGetFormState(state), form + '.values.' + fields[0]) : // selecting many fields, so return an object of field values
      fields.reduce(function (accumulator, field) {
        var value = getIn(nonNullGetFormState(state), form + '.values.' + field);
        return value === undefined ? accumulator : plain.setIn(accumulator, field, value);
      }, {});
    };
  };
};

export default createFormValueSelector;