// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// If true, the schedule is enabled. If false, the scheduled action does not
	// trigger. For more information about state of the scheduled action, see ScheduledAction.
	Enable *bool `type:"boolean"`

	// The end time in UTC of the scheduled action. After this time, the scheduled
	// action does not trigger. For more information about this parameter, see ScheduledAction.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the target action. For more information about
	// this parameter, see ScheduledAction.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// The schedule in at( ) or cron( ) format. For more information about this
	// parameter, see ScheduledAction.
	//
	// Schedule is a required field
	Schedule *string `type:"string" required:"true"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action. The name must be unique within an account.
	// For more information about this parameter, see ScheduledAction.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `type:"string" required:"true"`

	// The start time in UTC of the scheduled action. Before this time, the scheduled
	// action does not trigger. For more information about this parameter, see ScheduledAction.
	StartTime *time.Time `type:"timestamp"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	// For more information about this parameter, see ScheduledAction.
	//
	// TargetAction is a required field
	TargetAction *ScheduledActionType `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateScheduledActionInput"}

	if s.IamRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRole"))
	}

	if s.Schedule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schedule"))
	}

	if s.ScheduledActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduledActionName"))
	}

	if s.TargetAction == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAction"))
	}
	if s.TargetAction != nil {
		if err := s.TargetAction.Validate(); err != nil {
			invalidParams.AddNested("TargetAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which
// API operations can be scheduled, see ScheduledActionType.
type CreateScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string `type:"string"`

	// List of times when the scheduled action will run.
	NextInvocations []time.Time `locationNameList:"ScheduledActionTime" type:"list"`

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour.
	//
	// Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
	//
	// Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week
	// Year)". For example, "cron(0, 10, *, *, MON, *)". For more information, see
	// Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `type:"string"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `type:"timestamp"`

	// The state of the scheduled action. For example, DISABLED.
	State ScheduledActionState `type:"string" enum:"true"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	//
	// "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s CreateScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateScheduledAction = "CreateScheduledAction"

// CreateScheduledActionRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates a scheduled action. A scheduled action contains a schedule and an
// Amazon Redshift API action. For example, you can create a schedule of when
// to run the ResizeCluster API operation.
//
//    // Example sending a request using CreateScheduledActionRequest.
//    req := client.CreateScheduledActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction
func (c *Client) CreateScheduledActionRequest(input *CreateScheduledActionInput) CreateScheduledActionRequest {
	op := &aws.Operation{
		Name:       opCreateScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScheduledActionInput{}
	}

	req := c.newRequest(op, input, &CreateScheduledActionOutput{})
	return CreateScheduledActionRequest{Request: req, Input: input, Copy: c.CreateScheduledActionRequest}
}

// CreateScheduledActionRequest is the request type for the
// CreateScheduledAction API operation.
type CreateScheduledActionRequest struct {
	*aws.Request
	Input *CreateScheduledActionInput
	Copy  func(*CreateScheduledActionInput) CreateScheduledActionRequest
}

// Send marshals and sends the CreateScheduledAction API request.
func (r CreateScheduledActionRequest) Send(ctx context.Context) (*CreateScheduledActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateScheduledActionResponse{
		CreateScheduledActionOutput: r.Request.Data.(*CreateScheduledActionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateScheduledActionResponse is the response type for the
// CreateScheduledAction API operation.
type CreateScheduledActionResponse struct {
	*CreateScheduledActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateScheduledAction request.
func (r *CreateScheduledActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
