package centrifuge

import (
	"testing"
	"time"

	"github.com/stretchr/testify/require"
)

func TestWithHistory(t *testing.T) {
	opt := WithHistory(10, time.Second)
	opts := &PublishOptions{}
	opt(opts)
	require.Equal(t, 10, opts.HistorySize)
	require.Equal(t, time.Second, opts.HistoryTTL)
}

func TestWithResubscribe(t *testing.T) {
	opt := WithResubscribe(true)
	opts := &UnsubscribeOptions{}
	opt(opts)
	require.Equal(t, true, opts.Resubscribe)
}

func TestWithReconnect(t *testing.T) {
	opt := WithReconnect(true)
	opts := &DisconnectOptions{}
	opt(opts)
	require.Equal(t, true, opts.Reconnect)
}

func TestWithLimit(t *testing.T) {
	opt := WithLimit(NoLimit)
	opts := &HistoryOptions{}
	opt(opts)
	require.Equal(t, NoLimit, opts.Limit)
}
