function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

var DropdownItem = function DropdownItem(_ref) {
  var className = _ref.className,
      value = _ref.value,
      isDropdownOpen = _ref.isDropdownOpen,
      itemText = _ref.itemText,
      onClick = _ref.onClick,
      onKeyPress = _ref.onKeyPress,
      href = _ref.href,
      selected = _ref.selected,
      other = _objectWithoutProperties(_ref, ["className", "value", "isDropdownOpen", "itemText", "onClick", "onKeyPress", "href", "selected"]);

  var dropdownItemClasses = classNames(_defineProperty({
    'bx--dropdown-item': true
  }, className, className));

  var handleClick = function handleClick() {
    var info = {
      value: value,
      itemText: itemText
    };
    onClick(info);
  };

  var handleKeypress = function handleKeypress() {
    var info = {
      value: value,
      itemText: itemText
    };
    onKeyPress(info);
  };

  return React.createElement("li", _extends({}, other, {
    value: value,
    className: dropdownItemClasses,
    onClick: handleClick,
    onKeyPress: handleKeypress,
    tabIndex: -1,
    "aria-selected": selected,
    role: "option"
  }), React.createElement("a", {
    tabIndex: isDropdownOpen ? 0 : -1,
    href: href,
    onClick:
    /* istanbul ignore next */
    function onClick(evt) {
      return evt.preventDefault();
    },
    className: "bx--dropdown-link"
  }, itemText));
};

DropdownItem.propTypes = {
  value: PropTypes.string.isRequired,
  itemText: PropTypes.string.isRequired,
  className: PropTypes.string,
  onClick: PropTypes.func,
  onKeyPress: PropTypes.func,
  href: PropTypes.string,
  selected: PropTypes.bool
};
DropdownItem.defaultProps = {
  onClick:
  /* istanbul ignore next */
  function onClick() {},
  onKeyPress:
  /* istanbul ignore next */
  function onKeyPress() {},
  href: '',
  selected: false
};
export default DropdownItem;