'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Breadcrumb = require('../Breadcrumb');

var _Breadcrumb2 = _interopRequireDefault(_Breadcrumb);

var _BreadcrumbItem = require('../BreadcrumbItem');

var _BreadcrumbItem2 = _interopRequireDefault(_BreadcrumbItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Breadcrumb', function () {
  describe('Renders as expected', function () {
    var breadcrumb = (0, _enzyme.mount)(_react2.default.createElement(
      _Breadcrumb2.default,
      { className: 'parent-class' },
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { className: 'some-class', href: 'www.google.com' },
        'Breadcrumb 1'
      )
    ));

    var breadcrumbItem = breadcrumb.find(_BreadcrumbItem2.default);

    it('renders a breadcrumb', function () {
      expect(breadcrumb.length).toEqual(1);
    });

    it('should use the appropriate breadcrumb class', function () {
      expect(breadcrumb.children().hasClass('bx--breadcrumb')).toEqual(true);
    });

    it('should add extra classes that are passed via className', function () {
      expect(breadcrumb.hasClass('parent-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(breadcrumb.find(_BreadcrumbItem2.default).length).toEqual(1);
    });

    it('should render children content as expected', function () {
      expect(breadcrumbItem.text()).toEqual('Breadcrumb 1');
    });
  });
});