'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _ComposedModal = require('../ComposedModal');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('<ModalHeader />', function () {
  describe('Renders as expected', function () {
    var titleWrapper = (0, _enzyme.shallow)(_react2.default.createElement(_ComposedModal.ModalHeader, { title: 'Something' }));
    var labelWrapper = (0, _enzyme.shallow)(_react2.default.createElement(_ComposedModal.ModalHeader, { label: 'Something' }));

    it('does not render title if no title', function () {
      expect(labelWrapper.find('.bx--modal-header__heading').exists()).toBe(false);
    });

    it('does not render label if no label', function () {
      expect(titleWrapper.find('.bx--modal-header__label').exists()).toBe(false);
    });

    it('renders title if title text', function () {
      expect(titleWrapper.find('.bx--modal-header__heading').exists()).toBe(true);
    });

    it('renders label if label text', function () {
      expect(labelWrapper.find('.bx--modal-header__label').exists()).toBe(true);
    });
  });
});

describe('<ModalBody />', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _ComposedModal.ModalBody,
      { className: 'extra-class' },
      _react2.default.createElement(
        'p',
        null,
        'Test'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('p').length).toBe(1);
    });

    it('renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--modal-content')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});

describe('<ModalFooter />', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _ComposedModal.ModalFooter,
      { className: 'extra-class' },
      _react2.default.createElement(
        'p',
        null,
        'Test'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('p').length).toBe(1);
    });

    it('renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--modal-footer')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });

  describe('Should render buttons only if appropriate prop passed in in', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _ComposedModal.ModalFooter,
      { className: 'extra-class' },
      _react2.default.createElement(
        'p',
        null,
        'Test'
      )
    ));

    var primaryWrapper = (0, _enzyme.shallow)(_react2.default.createElement(_ComposedModal.ModalFooter, { primaryButtonText: 'test' }));
    var secondaryWrapper = (0, _enzyme.shallow)(_react2.default.createElement(_ComposedModal.ModalFooter, { secondaryButtonText: 'test' }));

    it('does not render primary button if no primary text', function () {
      expect(wrapper.find('.bx--btn--primary').exists()).toBe(false);
    });

    it('does not render secondary button if no secondary text', function () {
      expect(wrapper.find('.bx--btn--secondary').exists()).toBe(false);
    });

    it('renders primary button if primary text', function () {
      var buttonComponent = primaryWrapper.find('Button');
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('primary');
    });

    it('renders primary button if secondary text', function () {
      var buttonComponent = secondaryWrapper.find('Button');
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('secondary');
    });
  });
});