"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Icon = _interopRequireDefault(require("../Icon"));

var _TableCell = _interopRequireDefault(require("./TableCell"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

var TableExpandRow = function TableExpandRow(_ref) {
  var ariaLabel = _ref.ariaLabel,
      rowClassName = _ref.className,
      children = _ref.children,
      isExpanded = _ref.isExpanded,
      onExpand = _ref.onExpand,
      rest = _objectWithoutProperties(_ref, ["ariaLabel", "className", "children", "isExpanded", "onExpand"]);

  var className = (0, _classnames.default)({
    'bx--parent-row-v2': true,
    'bx--expandable-row-v2': isExpanded
  }, rowClassName);
  var previousValue = isExpanded ? 'collapsed' : undefined;
  return _react.default.createElement("tr", _extends({}, rest, {
    className: className,
    "data-parent-row": true
  }), _react.default.createElement(_TableCell.default, {
    className: "bx--table-expand-v2",
    "data-previous-value": previousValue
  }, _react.default.createElement("button", {
    className: "bx--table-expand-v2__button",
    onClick: onExpand,
    "aria-label": ariaLabel
  }, _react.default.createElement(_Icon.default, {
    className: "bx--table-expand-v2__svg",
    name: "chevron--right"
  }))), children);
};

TableExpandRow.propTypes = {
  /**
   * Specify the string read by a voice reader when the expand trigger is
   * focused
   */
  ariaLabel: _propTypes.default.string.isRequired,
  className: _propTypes.default.string,
  children: _propTypes.default.node,

  /**
   * Specify whether this row is expanded or not. This helps coordinate data
   * attributes so that `TableExpandRow` and `TableExapndedRow` work together
   */
  isExpanded: _propTypes.default.bool.isRequired,

  /**
   * Hook for when a listener initiates a request to expand the given row
   */
  onExpand: _propTypes.default.func.isRequired
};
var _default = TableExpandRow;
exports.default = _default;