'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Icon', function () {
  describe('Renders as expected', function () {
    var props = {
      className: 'extra-class',
      name: 'search--glyph',
      width: '20',
      height: '20',
      description: 'close the thing',
      style: {
        transition: '2s'
      }
    };

    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Icon2.default, props));

    it('Renders `description` as expected', function () {
      expect(wrapper.props().description).toEqual('close the thing');
    });

    it('should have a default role prop', function () {
      expect(wrapper.props().role).toEqual('img');
    });

    it('should have expected viewBox on <svg>', function () {
      expect(wrapper.find('svg').props().viewBox).not.toEqual('');
    });

    it('should add extra classes that are passed via className', function () {
      expect(wrapper.props().className).toEqual('extra-class');
    });

    it('should recieve width props', function () {
      expect(wrapper.props().width).toEqual('20');
    });

    it('should recieve height props', function () {
      expect(wrapper.props().height).toEqual('20');
    });

    it('should recieve style props', function () {
      expect(wrapper.props().style).toEqual({ transition: '2s' });
    });
  });

  describe('findIcon', function () {
    it('should return a defined object', function () {
      var test = (0, _Icon.findIcon)('search');
      expect(test).toBeDefined();
    });

    it('returns a single JSON object', function () {
      var test = [(0, _Icon.findIcon)('search')];
      expect(test.length).toEqual(1);
    });

    it('returns false when given wrong name param', function () {
      var test = (0, _Icon.findIcon)('wrong-name');
      expect(test).toBe(false);
    });

    it('throws if multiple icons are found from one name param', function () {
      var json = [{ name: 'bob' }, { name: 'bob' }];

      expect(function () {
        (0, _Icon.findIcon)('bob', json);
      }).toThrow();
    });
  });

  describe('getSvgData', function () {
    it('returns false when given an undefined icon name', function () {
      var badData = (0, _Icon.getSvgData)('wrongIconName');

      expect(badData).toBe(false);
    });
  });

  describe('svgShapes', function () {
    it('returns with SVG XML when given a valid icon name', function () {
      var data = (0, _Icon.getSvgData)('icon--search');
      var content = (0, _Icon.svgShapes)(data);
      expect(content.length).toBeGreaterThan(0);
    });

    it('returns empty when given an icon with no valid svgProp', function () {
      var svgData = {
        invalidProp: [{ invalidAttribute: 43 }]
      };
      var content = (0, _Icon.svgShapes)(svgData);
      expect(content.length).toBeGreaterThan(0);
      expect(content).toEqual(['']);
    });
  });

  describe('isPrefixed', function () {
    it('returns true when given a name with icon-- prefix', function () {
      var prefixed = (0, _Icon.isPrefixed)('icon--search--glyph');
      expect(prefixed).toBe(true);
    });

    it('returns false when given a name without icon-- prefix', function () {
      var prefixed = (0, _Icon.isPrefixed)('search--glyph');
      expect(prefixed).toBe(false);
    });
  });

  describe('JSON file', function () {
    it('should be defined', function () {
      expect(typeof _Icon.icons === 'undefined' ? 'undefined' : _typeof(_Icon.icons)).toBeDefined();
    });

    it('should have length > 0', function () {
      expect(_Icon.icons.length).toBeGreaterThan(0);
    });
  });
});