'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummary', function () {
  describe('Renders as expected', function () {
    var orderSummary = (0, _enzyme.shallow)(_react2.default.createElement(
      _OrderSummary.OrderSummary,
      { className: 'some-class' },
      _react2.default.createElement(_OrderSummary.OrderSummaryHeader, null)
    ));

    it('renders Order Summary', function () {
      expect(orderSummary.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummary.hasClass('bx--order-summary')).toEqual(true);
      expect(orderSummary.hasClass('some-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(orderSummary.find(_OrderSummary.OrderSummaryHeader).length).toEqual(1);
    });
  });
});