'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummaryCategory', function () {
  describe('Renders as expected', function () {
    var orderSummaryCategory = (0, _enzyme.shallow)(_react2.default.createElement(
      _OrderSummary.OrderSummaryCategory,
      { className: 'some-class', categoryText: 'Category 1' },
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null)
    ));

    it('renders Order Summary Category', function () {
      expect(orderSummaryCategory.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummaryCategory.hasClass('bx--order-category')).toEqual(true);
      expect(orderSummaryCategory.hasClass('some-class')).toEqual(true);
    });

    it('should render with the correct title', function () {
      expect(orderSummaryCategory.find('.bx--order-category-title').text()).toEqual('Category 1');
    });

    it('should render children as expected', function () {
      expect(orderSummaryCategory.find(_OrderSummary.OrderSummaryListItem).length).toEqual(3);
    });
  });
});