'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _RadioButtonGroup = require('../RadioButtonGroup');

var _RadioButtonGroup2 = _interopRequireDefault(_RadioButtonGroup);

var _RadioButton = require('../RadioButton');

var _RadioButton2 = _interopRequireDefault(_RadioButton);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('RadioButtonGroup', function () {
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _RadioButtonGroup2.default,
      { defaultSelected: 'female', name: 'gender' },
      _react2.default.createElement(_RadioButton2.default, { labelText: 'Male', value: 'male' }),
      _react2.default.createElement(_RadioButton2.default, { labelText: 'Female', value: 'female' })
    ));

    describe('wrapping div', function () {
      var div = wrapper.first('div');

      it('renders a div', function () {
        expect(div.length).toEqual(1);
      });

      it('sets classes that are passed via className prop', function () {
        wrapper.setProps({ className: 'extra-class' });
        expect(div.hasClass('extra-class'));
      });

      it('sets disabled attribute if disabled prop is set', function () {
        wrapper.setProps({ disabled: true });
        expect(wrapper.first().props().disabled).toEqual(true);
      });
    });

    describe('children', function () {
      var radioButton = function radioButton() {
        return wrapper.find(_RadioButton2.default);
      };

      it('renders expected number of children', function () {
        expect(radioButton().length).toEqual(2);
      });

      it('should set checked property based on defaultSelected prop', function () {
        expect(radioButton().last().props().checked).toEqual(true);
      });

      it('should set checked property based on valueSelected prop', function () {
        wrapper.setProps({ valueSelected: 'male' });
        expect(radioButton().first().props().checked).toEqual(true);
        wrapper.setProps({ valueSelected: 'female' });
        expect(radioButton().last().props().checked).toEqual(true);
      });

      it('should set expected props on children', function () {
        var firstChild = radioButton().first();
        expect(firstChild.props().name).toEqual('gender');
        expect(firstChild.props().value).toEqual('male');
      });
    });
  });

  describe('onChange event', function () {
    var onChange = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _RadioButtonGroup2.default,
      { onChange: onChange, name: 'gender' },
      _react2.default.createElement(_RadioButton2.default, { labelText: 'Male', value: 'male' }),
      _react2.default.createElement(_RadioButton2.default, { labelText: 'Female', value: 'female' })
    ));

    var firstRadio = wrapper.find(_RadioButton2.default).first();
    var args = ['male', 'gender', { test: 'test event' }];

    it('first child should not have checked set initially', function () {
      expect(firstRadio.props().checked).toEqual(false);
    });

    it('invoking onChange sets checked on correct child', function () {
      var _firstRadio$props;

      (_firstRadio$props = firstRadio.props()).onChange.apply(_firstRadio$props, args);
      wrapper.update();
      expect(wrapper.find(_RadioButton2.default).first().props().checked).toEqual(true);
    });

    it('should invoke onChange with correct arguments', function () {
      var _expect;

      (_expect = expect(onChange)).toBeCalledWith.apply(_expect, args);
    });

    it('calling onChange with same args should not call onChange prop', function () {
      var _firstRadio$props2;

      onChange.mockClear();
      (_firstRadio$props2 = firstRadio.props()).onChange.apply(_firstRadio$props2, args);
      expect(onChange).not.toHaveBeenCalled();
    });
  });
});