'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Slider = require('../Slider');

var _Slider2 = _interopRequireDefault(_Slider);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mock = (0, _addonActions.action)('onChange');

(0, _react3.storiesOf)('Slider', module).addWithInfo('default', '\n      Sliders provide a visual indication of adjustable content, where the user can move the handle along a horizontal track to increase or decrease the value.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(_Slider2.default, {
      id: 'slider',
      value: 50,
      min: 0,
      max: 100,
      step: 1,
      labelText: 'Slider Label',
      onChange: (0, _addonActions.action)('onChange')
    })
  );
}).addWithInfo('without TextInput', '\n      This example shows the Slider without it\'s accompanying TextInput. This is an exception and the majority of the time the default state should be used.\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(_Slider2.default, {
      id: 'slider',
      value: 50,
      min: 0,
      max: 100,
      step: 1,
      labelText: 'Slider Label',
      hideTextInput: true,
      onChange: mock
    })
  );
}).addWithInfo('disabled', '\n      This example shows the disabled state of the Slider\n    ', function () {
  return _react2.default.createElement(
    'div',
    { style: { marginTop: '2rem' } },
    _react2.default.createElement(_Slider2.default, {
      id: 'slider',
      value: 50,
      min: 0,
      max: 100,
      step: 1,
      labelText: 'Slider Label',
      onChange: mock,
      disabled: true
    })
  );
});