'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TextInput = require('../TextInput');

var _TextInput2 = _interopRequireDefault(_TextInput);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('TextInput', function () {
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_TextInput2.default, { id: 'test', className: 'extra-class', labelText: 'testlabel' }));

    var textInput = function textInput() {
      return wrapper.find('input');
    };

    describe('input', function () {
      it('renders as expected', function () {
        expect(textInput().length).toBe(1);
      });

      it('has the expected classes', function () {
        expect(textInput().hasClass('bx--text-input')).toEqual(true);
      });

      it('should add extra classes that are passed via className', function () {
        expect(textInput().hasClass('extra-class')).toEqual(true);
      });

      it('should set type as expected', function () {
        expect(textInput().props().type).toEqual('text');
        wrapper.setProps({ type: 'email' });
        expect(textInput().props().type).toEqual('email');
      });

      it('should set value as expected', function () {
        expect(textInput().props().defaultValue).toEqual(undefined);
        wrapper.setProps({ defaultValue: 'test' });
        expect(textInput().props().defaultValue).toEqual('test');
      });

      it('should set disabled as expected', function () {
        expect(textInput().props().disabled).toEqual(false);
        wrapper.setProps({ disabled: true });
        expect(textInput().props().disabled).toEqual(true);
      });

      it('should set placeholder as expected', function () {
        expect(textInput().props().placeholder).not.toBeDefined();
        wrapper.setProps({ placeholder: 'Enter text' });
        expect(textInput().props().placeholder).toEqual('Enter text');
      });
    });

    describe('label', function () {
      wrapper.setProps({ labelText: 'Email Input' });
      var renderedLabel = wrapper.find('label');

      it('renders a label', function () {
        expect(renderedLabel.length).toBe(1);
      });

      it('has the expected classes', function () {
        expect(renderedLabel.hasClass('bx--label')).toEqual(true);
      });

      it('should set label as expected', function () {
        expect(renderedLabel.text()).toEqual('Email Input');
      });
    });
  });

  describe('events', function () {
    describe('disabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();

      var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_TextInput2.default, {
        id: 'test',
        labelText: 'testlabel',
        onClick: onClick,
        onChange: onChange,
        disabled: true
      }));

      var input = wrapper.find('input');

      it('should not invoke onClick', function () {
        input.simulate('click');
        expect(onClick).not.toBeCalled();
      });

      it('should not invoke onChange', function () {
        input.simulate('change');
        expect(onChange).not.toBeCalled();
      });
    });

    describe('enabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();

      var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_TextInput2.default, {
        labelText: 'testlabel',
        id: 'test',
        onClick: onClick,
        onChange: onChange
      }));

      var input = wrapper.find('input');
      var eventObject = {
        target: {
          defaultValue: 'test'
        }
      };

      it('should invoke onClick when input is clicked', function () {
        input.simulate('click');
        expect(onClick).toBeCalled();
      });

      it('should invoke onChange when input value is changed', function () {
        input.simulate('change', eventObject);
        expect(onChange).toBeCalledWith(eventObject);
      });
    });
  });
});