/*******************************************************************************
 * Licensed Materials - Property of IBM
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import React from 'react'
import PropTypes from 'prop-types'
import classNames from 'classnames'
import { Tab, Tabs } from 'carbon-components-react'
import '../scss/editor-header.scss'
import msgs from '../../../../nls/platform.properties'

class EditorHeader extends React.Component {

  static propTypes = {
    children: PropTypes.node,
    handleTabChange: PropTypes.func,
    locale: PropTypes.string,
    otherYAMLTabs: PropTypes.array,
    type: PropTypes.string.isRequired,
  }

  constructor (props) {
    super(props)
  }

  render() {
    const { children, otherYAMLTabs=[], locale } = this.props
    const editorToolbarTitle = msgs.get('editor.toolbar', locale)
    const hasTabs = otherYAMLTabs.length>0
    const classnames = classNames({
      'creation-view-yaml-header': true,
      'hasTabs': hasTabs
    })
    return (
      <div className={classnames} >
        <div className='creation-view-yaml-header-toolbar' role='region' aria-label={editorToolbarTitle} id={editorToolbarTitle}>
          {children}
        </div>
        {hasTabs && <div className='creation-view-yaml-header-tabs'>
          {this.renderEditorTabs(otherYAMLTabs)}
        </div>}
      </div>
    )
  }

  renderEditorTabs = (otherYAMLTabs) => {
    const { type='unknown', handleTabChange } = this.props
    return (
      <Tabs selected={0} aria-label={'Select template'}>
        <Tab label={type} key='main' id='main' onClick={handleTabChange.bind(this, 0)} />
        {otherYAMLTabs.map(({id}, inx) => {
          return <Tab label={id} key={id} id={id} onClick={handleTabChange.bind(this, inx+1)} />
        })}
      </Tabs>
    )
  }

}

export default EditorHeader
