"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const tree_view_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/TreeView/tree-view"));
const TreeViewSearch_1 = require("./TreeViewSearch");
const Divider_1 = require("../Divider");
exports.TreeViewList = (_a) => {
    var { isNested = false, onSearch, searchProps, children } = _a, props = tslib_1.__rest(_a, ["isNested", "onSearch", "searchProps", "children"]);
    const list = react_1.default.createElement("ul", { role: isNested ? 'group' : 'tree' }, children);
    return isNested ? (list) : (react_1.default.createElement("div", Object.assign({ className: react_styles_1.css(tree_view_1.default.treeView) }, props),
        onSearch && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(TreeViewSearch_1.TreeViewSearch, Object.assign({ onChange: onSearch }, searchProps)),
            react_1.default.createElement(Divider_1.Divider, null))),
        list));
};
exports.TreeViewList.displayName = 'TreeViewList';
//# sourceMappingURL=TreeViewList.js.map