"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _Loading = _interopRequireDefault(require("../Loading"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var InlineLoading =
/*#__PURE__*/
function (_React$Component) {
  _inherits(InlineLoading, _React$Component);

  function InlineLoading() {
    _classCallCheck(this, InlineLoading);

    return _possibleConstructorReturn(this, _getPrototypeOf(InlineLoading).apply(this, arguments));
  }

  _createClass(InlineLoading, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          success = _this$props.success,
          description = _this$props.description,
          onSuccess = _this$props.onSuccess,
          successDelay = _this$props.successDelay,
          other = _objectWithoutProperties(_this$props, ["className", "success", "description", "onSuccess", "successDelay"]);

      var loadingClasses = (0, _classnames.default)("".concat(prefix, "--inline-loading"), className);

      var getLoading = function getLoading() {
        if (success) {
          setTimeout(function () {
            if (onSuccess) {
              onSuccess();
            }
          }, successDelay);
          return _react.default.createElement("svg", {
            className: "".concat(prefix, "--inline-loading__checkmark-container ").concat(prefix, "--inline-loading__svg"),
            xmlns: "http://www.w3.org/2000/svg",
            viewBox: "0 0 10 10"
          }, _react.default.createElement("polyline", {
            className: "".concat(prefix, "--inline-loading__checkmark"),
            points: "0.74 3.4 3.67 6.34 9.24 0.74"
          }));
        }

        return _react.default.createElement(_Loading.default, {
          small: true,
          withOverlay: false
        });
      };

      var loadingText = _react.default.createElement("p", {
        className: "".concat(prefix, "--inline-loading__text")
      }, description);

      return _react.default.createElement("div", _extends({
        className: loadingClasses
      }, other), _react.default.createElement("div", {
        className: "".concat(prefix, "--inline-loading__animation")
      }, getLoading()), description && loadingText);
    }
  }]);

  return InlineLoading;
}(_react.default.Component);

exports.default = InlineLoading;

_defineProperty(InlineLoading, "propTypes", {
  /**
   * Specify a custom className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the load was successful
   */
  success: _propTypes.default.bool,

  /**
   * Specify the description for the inline loading text
   */
  description: _propTypes.default.string,

  /**
   * Provide an optional handler to be inovked when <InlineLoading> is
   * successful
   */
  onSuccess: _propTypes.default.func,

  /**
   * Provide a delay for the `setTimeout` for success
   */
  successDelay: _propTypes.default.number
});

_defineProperty(InlineLoading, "defaultProps", {
  success: false,
  successDelay: 1500
});