import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Menu/menu';
import { css } from '@patternfly/react-styles';
import ExternalLinkAltIcon from "@patternfly/react-icons/dist/esm/icons/external-link-alt-icon";
import AngleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-right-icon";
import CheckIcon from "@patternfly/react-icons/dist/esm/icons/check-icon";
import { MenuContext, MenuItemContext } from './MenuContext';
import { MenuItemAction } from './MenuItemAction';
const MenuItemBase = (_a) => {
    var { children, className, itemId = null, to, isActive = null, isFavorited = null, flyoutMenu, description = null, onClick = () => { }, component, isDisabled = false, isExternalLink = false, isSelected = null, icon, actions, onShowFlyout, innerRef } = _a, props = __rest(_a, ["children", "className", "itemId", "to", "isActive", "isFavorited", "flyoutMenu", "description", "onClick", "component", "isDisabled", "isExternalLink", "isSelected", "icon", "actions", "onShowFlyout", "innerRef"]);
    const Component = component || to ? 'a' : 'button';
    const [flyoutVisible, setFlyoutVisible] = React.useState(false);
    const showFlyout = (displayFlyout) => {
        setFlyoutVisible(displayFlyout);
        onShowFlyout && displayFlyout && onShowFlyout();
    };
    const onItemSelect = (event, onSelect) => {
        // Trigger callback for Menu onSelect
        onSelect && onSelect(event, itemId);
        // Trigger callback for item onClick
        onClick && onClick(event);
    };
    const renderItem = (onSelect, activeItemId, selected) => {
        const additionalProps = Component === 'a'
            ? {
                href: to,
                'aria-disabled': isDisabled ? true : null,
                tabIndex: isDisabled ? -1 : null
            }
            : {};
        const getAriaCurrent = () => {
            if (isActive !== null) {
                if (isActive) {
                    return 'page';
                }
                else {
                    return null;
                }
            }
            else if (itemId !== null && activeItemId !== null) {
                return itemId === activeItemId;
            }
            return null;
        };
        const getIsSelected = () => {
            if (isSelected !== null) {
                return isSelected;
            }
            else if (selected !== null && itemId !== null) {
                return (Array.isArray(selected) && selected.includes(itemId)) || itemId === selected;
            }
            return false;
        };
        return (React.createElement(React.Fragment, null,
            React.createElement(Component, Object.assign({ onClick: (event) => onItemSelect(event, onSelect), className: css(styles.menuItem, getIsSelected() && styles.modifiers.selected, className), "aria-current": getAriaCurrent() }, (isDisabled && { disabled: true }), additionalProps),
                React.createElement("div", { className: css(styles.menuItemMain) },
                    icon && React.createElement("span", { className: css(styles.menuItemIcon) }, icon),
                    React.createElement("span", { className: css(styles.menuItemText) }, children),
                    isExternalLink && (React.createElement("span", { className: css(styles.menuItemExternalIcon) },
                        React.createElement(ExternalLinkAltIcon, { "aria-hidden": true }))),
                    flyoutMenu && (React.createElement("span", { className: css(styles.menuItemToggleIcon) },
                        React.createElement(AngleRightIcon, { "aria-hidden": true }))),
                    getIsSelected() && (React.createElement("span", { className: css(styles.menuItemSelectIcon) },
                        React.createElement(CheckIcon, { "aria-hidden": true })))),
                description && (React.createElement("div", { className: css(styles.menuItemDescription) },
                    React.createElement("span", null, description)))),
            flyoutVisible && flyoutMenu));
    };
    return (React.createElement("li", Object.assign({ className: css(styles.menuListItem, isDisabled && styles.modifiers.disabled, className), onMouseOver: flyoutMenu !== undefined ? () => showFlyout(true) : undefined, onMouseLeave: flyoutMenu !== undefined ? () => showFlyout(false) : undefined, ref: innerRef }, props),
        React.createElement(MenuContext.Consumer, null, ({ onSelect, onActionClick, activeItemId, selected }) => (React.createElement(React.Fragment, null,
            renderItem(onSelect, activeItemId, selected),
            React.createElement(MenuItemContext.Provider, { value: { itemId, isDisabled } },
                actions,
                isFavorited !== null && (React.createElement(MenuItemAction, { icon: "favorites", isFavorited: isFavorited, "aria-label": isFavorited ? 'starred' : 'not starred', onClick: event => onActionClick(event, itemId), actionId: "fav" }))))))));
};
export const MenuItem = React.forwardRef((props, ref) => (React.createElement(MenuItemBase, Object.assign({}, props, { innerRef: ref }))));
MenuItem.displayName = 'MenuItem';
//# sourceMappingURL=MenuItem.js.map