"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onCopy = exports.TooltipWrapper = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
function TooltipWrapper(props) {
    return props.showTooltip ? (react_1.default.createElement(react_core_1.Tooltip, { content: props.tooltip, position: react_core_1.TooltipPosition.top }, props.children)) : (props.children);
}
exports.TooltipWrapper = TooltipWrapper;
exports.onCopy = function (event, text) {
    var clipboard = event.currentTarget.parentElement;
    /* istanbul ignore else */
    if (clipboard) {
        var el = document.createElement('textarea');
        el.value = text;
        clipboard.appendChild(el);
        el.select();
        document.execCommand('copy');
        clipboard.removeChild(el);
    }
};
//# sourceMappingURL=utils.js.map