import * as React from 'react';
import { NumberOrCallback, StringOrNumberOrCallback } from 'victory-core';
import { ChartThemeDefinition } from '../ChartTheme';
/**
 * See https://github.com/FormidableLabs/victory/blob/master/packages/victory-core/src/index.d.ts
 * and https://github.com/FormidableLabs/victory/blob/master/packages/victory-legend/src/index.d.ts
 */
export interface ChartLegendTooltipContentProps {
    /**
     * The activePoints prop specifies the active data
     *
     * **This prop should not be set manually.**
     */
    activePoints?: any[];
    /**
     * The center prop determines the position of the center of the tooltip flyout. This prop should be given as an object
     * that describes the desired x and y svg coordinates of the center of the tooltip. This prop is useful for
     * positioning the flyout of a tooltip independent from the pointer. When ChartTooltip is used with
     * ChartVoronoiContainer, the center prop is what enables the mouseFollowTooltips option. When this prop is set,
     * non-zero pointerLength values will no longer be respected.
     */
    center?: {
        x: number;
        y: number;
    };
    /**
     * Victory components can pass a datum prop to their label component. This can be used to calculate functional styles,
     * and determine child text
     */
    datum?: {};
    /**
     * The dx prop defines a horizontal shift from the x coordinate.
     */
    dx?: NumberOrCallback;
    /**
     * The dy prop defines a horizontal shift from the y coordinate.
     */
    dy?: NumberOrCallback;
    /**
     * The flyoutHeight prop defines the height of the tooltip flyout. This prop may be given as a positive number or a function
     * of datum. If this prop is not set, height will be determined based on an approximate text size calculated from the
     * text and style props provided to ChartTooltip.
     */
    flyoutHeight?: NumberOrCallback;
    /**
     * The flyoutWidth prop defines the width of the tooltip flyout. This prop may be given as a positive number or a
     * function of datum. If this prop is not set, flyoutWidth will be determined based on an approximate text size
     * calculated from the text and style props provided to VictoryTooltip.
     */
    flyoutWidth?: NumberOrCallback;
    /**
     * Specifies the height the svg viewBox of the chart container. This value should be given as a
     * number of pixels.
     *
     * Because Victory renders responsive containers, the width and height props do not determine the width and
     * height of the chart in number of pixels, but instead define an aspect ratio for the chart. The exact number of
     * pixels will depend on the size of the container the chart is rendered into.
     */
    height?: number;
    /**
     * The labelComponent prop takes a component instance which will be used
     * to render each legend label. The new element created from the passed
     * labelComponent will be supplied with the following properties: x, y,
     * style, and text. Any of these props may be overridden by passing in
     * props to the supplied component, or modified or ignored within the
     * custom component itself. If labelComponent is omitted, a new
     * ChartLabel will be created with the props described above.
     */
    labelComponent?: React.ReactElement<any>;
    /**
     * The legend component to render with chart.
     *
     * Note: Use legendData so the legend width can be calculated and positioned properly.
     * Default legend properties may be applied
     */
    legendComponent?: React.ReactElement<any>;
    /**
     * Specify data via the data prop. ChartLegend expects data as an array of objects with name (required), symbol, and
     * labels properties. The childName is used to sync the data series associated with the given chart child name.
     *
     * The data prop must be given as an array.
     *
     * @example legendData={[{ name: `GBps capacity - 45%` }, { name: 'Unused' }]}
     * @example legendData={[{ childName: `cats`, name: `Total cats` }, { childName: `dogs`, name: 'Total dogs' }]}
     */
    legendData?: {
        childName?: string;
        name?: string;
        labels?: {
            fill?: string;
        };
        symbol?: {
            fill?: string;
            type?: string;
        };
    }[];
    /**
     * The text prop defines the text ChartTooltip will render. The text prop may be given as a string, number, or
     * function of datum. When ChartLabel is used as the labelComponent, strings may include newline characters, which
     * ChartLabel will split in to separate <tspan/> elements.
     */
    text?: StringOrNumberOrCallback | string[] | number[];
    /**
     * The theme prop takes a style object with nested data, labels, and parent objects.
     * You can create this object yourself, or you can use a theme provided by
     * When using ChartLegend as a solo component, implement the theme directly on
     * ChartLegend. If you are wrapping ChartLegend in ChartChart or
     * ChartGroup, please call the theme on the outermost wrapper component instead.
     */
    theme?: ChartThemeDefinition;
    /**
     * Specifies the theme color. Valid values are 'blue', 'green', 'multi', etc.
     *
     * Note: Not compatible with theme prop
     *
     * @example themeColor={ChartThemeColor.blue}
     */
    themeColor?: string;
    /**
     * Specifies the theme variant. Valid values are 'dark' or 'light'
     *
     * Note: Not compatible with theme prop
     *
     * @example themeVariant={ChartThemeVariant.light}
     */
    themeVariant?: string;
    /**
     * The title prop specifies a title to render with the legend.
     * This prop should be given as a string, or an array of strings for multi-line titles.
     *
     * Valid types are string, string[], or Function
     *
     * Example: title={(datum) => datum.x}
     */
    title?: string | string[] | Function;
    /**
     * The titleComponent prop takes a component instance which will be used to render
     * a title for the component. The new element created from the passed
     * labelComponent will be supplied with the following properties: x, y, index, data,
     * datum, verticalAnchor, textAnchor, style, text, and events. Any of these props
     * may be overridden by passing in props to the supplied component, or modified
     * or ignored within the custom component itself. If labelComponent is omitted,
     * a new ChartLabel will be created with the props described above.
     */
    titleComponent?: React.ReactElement<any>;
    /**
     * Specifies the width of the svg viewBox of the chart container. This value should be given as a
     * number of pixels.
     *
     * Because Victory renders responsive containers, the width and height props do not determine the width and
     * height of the chart in number of pixels, but instead define an aspect ratio for the chart. The exact number of
     * pixels will depend on the size of the container the chart is rendered into.
     */
    width?: number;
}
export declare const ChartLegendTooltipContent: React.FunctionComponent<ChartLegendTooltipContentProps>;
//# sourceMappingURL=ChartLegendTooltipContent.d.ts.map