"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var NativeTypes = require("../NativeTypes");
var getDataFromDataTransfer_1 = require("./getDataFromDataTransfer");
exports.nativeTypesConfig = (_a = {},
    _a[NativeTypes.FILE] = {
        exposeProperties: {
            files: function (dataTransfer) {
                return Array.prototype.slice.call(dataTransfer.files);
            },
            items: function (dataTransfer) { return dataTransfer.items; },
        },
        matchesTypes: ['Files'],
    },
    _a[NativeTypes.URL] = {
        exposeProperties: {
            urls: function (dataTransfer, matchesTypes) {
                return getDataFromDataTransfer_1.getDataFromDataTransfer(dataTransfer, matchesTypes, '').split('\n');
            },
        },
        matchesTypes: ['Url', 'text/uri-list'],
    },
    _a[NativeTypes.TEXT] = {
        exposeProperties: {
            text: function (dataTransfer, matchesTypes) {
                return getDataFromDataTransfer_1.getDataFromDataTransfer(dataTransfer, matchesTypes, '');
            },
        },
        matchesTypes: ['Text', 'text/plain'],
    },
    _a);
