'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = validateAdapter;

var _EnzymeAdapter = require('./EnzymeAdapter');

var _EnzymeAdapter2 = _interopRequireDefault(_EnzymeAdapter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function validateAdapter(adapter) {
  if (!adapter) {
    throw new Error('\n      Enzyme Internal Error: Enzyme expects an adapter to be configured, but found none.\n      To configure an adapter, you should call `Enzyme.configure({ adapter: new Adapter() })`\n      before using any of Enzyme\'s top level APIs, where `Adapter` is the adapter\n      corresponding to the library currently being tested. For example:\n\n      import Adapter from \'enzyme-adapter-react-15\';\n\n      To find out more about this, see https://airbnb.io/enzyme/docs/installation/index.html\n    ');
  }
  if (typeof adapter === 'function') {
    if (Object.getPrototypeOf(adapter) === _EnzymeAdapter2['default']) {
      throw new Error('\n        Enzyme Internal Error: Enzyme expects an adapter instance to be configured -\n        you provided an adapter *constructor*.\n        To configure an adapter, you should call `Enzyme.configure({ adapter: new Adapter() })`\n        before using any of Enzyme\'s top level APIs, where `Adapter` is the adapter\n        corresponding to the library currently being tested. For example:\n\n        import Adapter from \'enzyme-adapter-react-15\';\n\n        To find out more about this, see https://airbnb.io/enzyme/docs/installation/index.html\n      ');
    }
    throw new Error('\n      Enzyme Internal Error: Enzyme expects an adapter to be configured -\n      an enzyme adapter must be an object instance; you provided a function.\n      To configure an adapter, you should call `Enzyme.configure({ adapter: new Adapter() })`\n      before using any of Enzyme\'s top level APIs, where `Adapter` is the adapter\n      corresponding to the library currently being tested. For example:\n\n      import Adapter from \'enzyme-adapter-react-15\';\n\n      To find out more about this, see https://airbnb.io/enzyme/docs/installation/index.html\n    ');
  }
  if (!(adapter instanceof _EnzymeAdapter2['default'])) {
    throw new Error('Enzyme Internal Error: configured enzyme adapter did not inherit from the EnzymeAdapter base class');
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=validateAdapter.js.map