"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _SelectItemGroup = _interopRequireDefault(require("../SelectItemGroup"));

var _Select2 = _interopRequireDefault(require("../Select/Select.Skeleton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var props = {
  select: function select() {
    return {
      className: 'some-class',
      light: (0, _addonKnobs.boolean)('Light variant (light in <Select>)', false),
      inline: (0, _addonKnobs.boolean)('Put control in-line with label (inline in <Select>)', false),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <Select>)', false),
      hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel in <Select>)', false),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid in <Select>)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText in <Select>)', 'A valid value is required'),
      helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  group: function group() {
    return {
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <SelectItemGroup>)', false)
    };
  }
};
(0, _react2.storiesOf)('Select', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  var groupProps = props.group();
  return _react.default.createElement(_Select.default, _extends({}, props.select(), {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), _react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), _react.default.createElement(_SelectItemGroup.default, _extends({
    label: "Category 1"
  }, groupProps), _react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), _react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), _react.default.createElement(_SelectItemGroup.default, _extends({
    label: "Category 2"
  }, groupProps), _react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), _react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  })));
}, {
  info: {
    text: "\n            Select displays a list below its title when selected. They are used primarily in forms,\n            where a user chooses one option from a list. Once the user selects an item, the dropdown will\n            disappear and the field will reflect the user's choice. Create Select Item components for each\n            option in the list. The example below shows an enabled Select component with three items.\n          "
  }
}).add('skeleton', function () {
  return _react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, _react.default.createElement(_Select2.default, null));
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});