import * as React from 'react';
import { ChartContainer } from '../ChartContainer';
import { ChartLabel } from '../ChartLabel';
import { ChartBulletStyles, ChartCommonStyles } from '../ChartTheme';
import { getBulletTheme, getBulletLabelX, getBulletLabelY, getPaddingForSide } from '../ChartUtils';
export const ChartBulletTitle = ({ ariaDesc, ariaTitle, capHeight = 1.1, horizontal = true, legendPosition = 'bottom', padding, standalone = true, subTitle, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel, null), titlePosition, 
// destructure last
theme = getBulletTheme(themeColor, themeVariant), height = horizontal ? theme.chart.height : theme.chart.width, width = horizontal ? theme.chart.width : theme.chart.height }) => {
    const chartSize = {
        height: horizontal ? theme.chart.height : height,
        width: horizontal ? width : theme.chart.height
    };
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.chart.padding),
        left: getPaddingForSide('left', padding, theme.chart.padding),
        right: getPaddingForSide('right', padding, theme.chart.padding),
        top: getPaddingForSide('top', padding, theme.chart.padding)
    };
    // Returns title
    const getTitle = () => {
        const showBoth = title && subTitle;
        let labelPosition = horizontal ? 'left' : 'bottom';
        if (titlePosition && titlePosition.includes('left') && horizontal) {
            labelPosition = titlePosition;
        }
        // The x and y calculations below are used to adjust the position of the title, based on padding and scale.
        // This ensures that when padding is adjusted, the title moves along with the chart's position.
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (showBoth && { capHeight })), { style: [ChartBulletStyles.label.title, ChartBulletStyles.label.subTitle], text: showBoth ? [title, subTitle] : title, textAnchor: labelPosition === 'top-left' ? 'start' : horizontal ? 'end' : 'middle', verticalAnchor: labelPosition === 'top-left' ? 'end' : 'middle', 
            // Adjust for padding
            x: horizontal
                ? getBulletLabelX({
                    chartWidth: chartSize.width,
                    dx: labelPosition === 'top-left'
                        ? defaultPadding.left
                        : defaultPadding.left - ChartCommonStyles.label.margin * 1.75,
                    labelPosition: 'left',
                    legendPosition,
                    svgWidth: width
                })
                : defaultPadding.left * 0.5 +
                    (defaultPadding.right * 0.5 - (defaultPadding.right - 50)) +
                    ChartBulletStyles.qualitativeRangeWidth / 2, y: getBulletLabelY({
                chartHeight: chartSize.height,
                // Adjust for padding
                dy: labelPosition === 'top-left'
                    ? defaultPadding.top * 0.5 +
                        (defaultPadding.bottom * 0.5 - defaultPadding.bottom) +
                        58 -
                        ChartCommonStyles.legend.margin +
                        (showBoth ? 0 : 1)
                    : horizontal
                        ? defaultPadding.top * 0.5 + (defaultPadding.bottom * 0.5 - defaultPadding.bottom)
                        : ChartCommonStyles.legend.margin * 2 - defaultPadding.bottom,
                labelPosition
            }) }), titleComponent.props));
    };
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, getTitle())) : (React.createElement(React.Fragment, null, getTitle()));
};
ChartBulletTitle.displayName = 'ChartBulletTitle';
//# sourceMappingURL=ChartBulletTitle.js.map