"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmInlineStatus = exports.StatusType = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var StatusType;
(function (StatusType) {
    StatusType["healthy"] = "healthy";
    StatusType["danger"] = "danger";
    StatusType["warning"] = "warning";
    StatusType["progress"] = "progress";
    StatusType["unknown"] = "unknown";
})(StatusType = exports.StatusType || (exports.StatusType = {}));
function AcmInlineStatus(props) {
    return (react_1.default.createElement("div", { className: "inline-status-" + props.type },
        react_1.default.createElement(StatusIcon, { type: props.type }),
        react_1.default.createElement("span", { style: { marginLeft: '.4rem' } }, props.status)));
}
exports.AcmInlineStatus = AcmInlineStatus;
function StatusIcon(props) {
    switch (props.type) {
        case StatusType.healthy:
            return react_1.default.createElement(react_icons_1.CheckCircleIcon, { color: "var(--pf-global--success-color--100)" });
        case StatusType.danger:
            return react_1.default.createElement(react_icons_1.ExclamationCircleIcon, { color: "var(--pf-global--danger-color--100)" });
        case StatusType.warning:
            return react_1.default.createElement(react_icons_1.ExclamationTriangleIcon, { color: "var(--pf-global--warning-color--100)" });
        case StatusType.progress:
            return react_1.default.createElement(react_core_1.Spinner, { size: "md", style: { verticalAlign: 'middle' } });
        case 'unknown':
        default:
            return react_1.default.createElement(react_icons_1.MinusCircleIcon, { color: "var(--pf-global--disabled-color--100)" });
    }
}
//# sourceMappingURL=AcmInlineStatus.js.map