import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/DualListSelector/dual-list-selector';
import { DualListSelectorTreeItem } from './DualListSelectorTreeItem';
export const DualListSelectorTree = (_a) => {
    var { data, hasBadges = false, isNested = false, defaultAllExpanded = false, onOptionCheck } = _a, props = __rest(_a, ["data", "hasBadges", "isNested", "defaultAllExpanded", "onOptionCheck"]);
    const tree = data.map(item => (React.createElement(DualListSelectorTreeItem, Object.assign({ key: item.id, text: item.text, id: item.id, defaultExpanded: item.defaultExpanded !== undefined ? item.defaultExpanded : defaultAllExpanded, onOptionCheck: onOptionCheck, isChecked: item.isChecked, checkProps: item.checkProps, hasBadge: item.hasBadge !== undefined ? item.hasBadge : hasBadges, badgeProps: item.badgeProps, itemData: item }, (item.children && {
        children: (React.createElement(DualListSelectorTree, { isNested: true, data: item.children, hasBadges: hasBadges, defaultAllExpanded: defaultAllExpanded, onOptionCheck: onOptionCheck }))
    })))));
    return isNested ? (React.createElement("ul", Object.assign({ className: css(styles.dualListSelectorList), role: "group" }, props), tree)) : (React.createElement(React.Fragment, null, tree));
};
DualListSelectorTree.displayName = 'DualListSelectorTree';
//# sourceMappingURL=DualListSelectorTree.js.map