// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package redis // import "google.golang.org/genproto/googleapis/cloud/redis/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
	// Redis instance is importing data (availability may be affected).
	Instance_IMPORTING Instance_State = 8
	// Redis instance is failing over (availability may be affected).
	Instance_FAILING_OVER Instance_State = 10
)

var Instance_State_name = map[int32]string{
	0:  "STATE_UNSPECIFIED",
	1:  "CREATING",
	2:  "READY",
	3:  "UPDATING",
	4:  "DELETING",
	5:  "REPAIRING",
	6:  "MAINTENANCE",
	8:  "IMPORTING",
	10: "FAILING_OVER",
}
var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
	"IMPORTING":         8,
	"FAILING_OVER":      10,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}
var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}
func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{0, 1}
}

type FailoverInstanceRequest_DataProtectionMode int32

const (
	FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED FailoverInstanceRequest_DataProtectionMode = 0
	// Instance failover will be protected with data loss control. More
	// specifically, the failover will only be performed if the current
	// replication offset diff between master and replica is under a certain
	// threshold.
	FailoverInstanceRequest_LIMITED_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 1
	// Instance failover will be performed without data loss control.
	FailoverInstanceRequest_FORCE_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 2
)

var FailoverInstanceRequest_DataProtectionMode_name = map[int32]string{
	0: "DATA_PROTECTION_MODE_UNSPECIFIED",
	1: "LIMITED_DATA_LOSS",
	2: "FORCE_DATA_LOSS",
}
var FailoverInstanceRequest_DataProtectionMode_value = map[string]int32{
	"DATA_PROTECTION_MODE_UNSPECIFIED": 0,
	"LIMITED_DATA_LOSS":                1,
	"FORCE_DATA_LOSS":                  2,
}

func (x FailoverInstanceRequest_DataProtectionMode) String() string {
	return proto.EnumName(FailoverInstanceRequest_DataProtectionMode_name, int32(x))
}
func (FailoverInstanceRequest_DataProtectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{7, 0}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id] and
	// [alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. If [alternative_location_id] is also provided, it must be
	// different from [location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used. Updating the
	// version will perform an upgrade/downgrade to the new version. Currently,
	// the supported values are:
	//
	//  *   `REDIS_4_0` for Redis 4.0 compatibility
	//  *   `REDIS_3_2` for Redis 3.2 compatibility (default)
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in an authorized network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed Redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. For Basic
	// Tier instances, this will always be the same as the [location_id]
	// provided by the user at creation time. For Standard Tier instances,
	// this can be either [location_id] or [alternative_location_id] and can
	// change after a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1beta1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//
	//  Redis 3.2 and above:
	//
	//  *   maxmemory-policy
	//  *   notify-keyspace-events
	//
	//  Redis 4.0 and above:
	//
	//  *   activedefrag
	//  *   lfu-log-factor
	//  *   lfu-decay-time
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1beta1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GiB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork    string   `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{0}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (dst *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(dst, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

// Request for
// [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudRedis.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{1}
}
func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(dst, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for
// [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the "name" field set to a value of
	// the form projects/{project_id}/locations/{location_id}/instances/- and the
	// "status" field set to ERROR and "status_message" field set to "location not
	// available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{2}
}
func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(dst, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.redis.v1beta1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{3}
}
func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(dst, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for
// [CreateInstance][google.cloud.redis.v1beta1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{4}
}
func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(dst, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for
// [UpdateInstance][google.cloud.redis.v1beta1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][google.cloud.redis.v1beta1.Instance]:
	//
	//  *   `displayName`
	//  *   `labels`
	//  *   `memorySizeGb`
	//  *   `redisConfig`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{5}
}
func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(dst, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for
// [DeleteInstance][google.cloud.redis.v1beta1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{6}
}
func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(dst, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for
// [Failover][google.cloud.redis.v1beta1.CloudRedis.FailoverInstance].
type FailoverInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Available data protection modes that the user can choose. If it's
	// unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
	DataProtectionMode   FailoverInstanceRequest_DataProtectionMode `protobuf:"varint,2,opt,name=data_protection_mode,json=dataProtectionMode,proto3,enum=google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode" json:"data_protection_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *FailoverInstanceRequest) Reset()         { *m = FailoverInstanceRequest{} }
func (m *FailoverInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*FailoverInstanceRequest) ProtoMessage()    {}
func (*FailoverInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{7}
}
func (m *FailoverInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailoverInstanceRequest.Unmarshal(m, b)
}
func (m *FailoverInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailoverInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *FailoverInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailoverInstanceRequest.Merge(dst, src)
}
func (m *FailoverInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_FailoverInstanceRequest.Size(m)
}
func (m *FailoverInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FailoverInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FailoverInstanceRequest proto.InternalMessageInfo

func (m *FailoverInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FailoverInstanceRequest) GetDataProtectionMode() FailoverInstanceRequest_DataProtectionMode {
	if m != nil {
		return m.DataProtectionMode
	}
	return FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{8}
}
func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (dst *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(dst, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_ec9ebde39ed154fe, []int{9}
}
func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (dst *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(dst, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1beta1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1beta1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1beta1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1beta1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1beta1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1beta1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1beta1.DeleteInstanceRequest")
	proto.RegisterType((*FailoverInstanceRequest)(nil), "google.cloud.redis.v1beta1.FailoverInstanceRequest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.ZoneMetadata")
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode", FailoverInstanceRequest_DataProtectionMode_name, FailoverInstanceRequest_DataProtectionMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc *grpc.ClientConn
}

func NewCloudRedisClient(cc *grpc.ClientConn) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(context.Context, *FailoverInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_FailoverInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).FailoverInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).FailoverInstance(ctx, req.(*FailoverInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1beta1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "FailoverInstance",
			Handler:    _CloudRedis_FailoverInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1beta1/cloud_redis.proto",
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1beta1/cloud_redis.proto", fileDescriptor_cloud_redis_ec9ebde39ed154fe)
}

var fileDescriptor_cloud_redis_ec9ebde39ed154fe = []byte{
	// 1417 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x6f, 0x6f, 0xdb, 0x44,
	0x18, 0xc7, 0x6d, 0x53, 0x9a, 0x27, 0x6d, 0xea, 0xde, 0x5a, 0x66, 0x02, 0x63, 0xc1, 0x1b, 0xa8,
	0x14, 0x70, 0x58, 0x86, 0xa6, 0xd1, 0x6a, 0x5b, 0xdd, 0xc4, 0xed, 0x2c, 0x35, 0x7f, 0xe4, 0x64,
	0x93, 0x18, 0x2f, 0xac, 0x6b, 0x7c, 0xcd, 0xbc, 0x3a, 0x3e, 0x63, 0x3b, 0x61, 0x2d, 0x9a, 0x90,
	0xf8, 0x02, 0x48, 0x03, 0xf1, 0x12, 0x5e, 0x21, 0xf1, 0x0a, 0xc1, 0x67, 0xe1, 0x2b, 0xf0, 0x8a,
	0x77, 0x7c, 0x03, 0x74, 0x67, 0xbb, 0x75, 0xd2, 0x34, 0xcb, 0xfa, 0xee, 0xee, 0xf7, 0xfc, 0x9e,
	0xbb, 0x9f, 0x9f, 0xe7, 0xee, 0x67, 0x1b, 0x3e, 0xe9, 0x52, 0xda, 0x75, 0x48, 0xa9, 0xe3, 0xd0,
	0xbe, 0x55, 0xf2, 0x89, 0x65, 0x07, 0xa5, 0xc1, 0xad, 0x03, 0x12, 0xe2, 0x5b, 0x11, 0x66, 0x72,
	0x4c, 0xf1, 0x7c, 0x1a, 0x52, 0x54, 0x88, 0xd8, 0x0a, 0x8f, 0x28, 0x51, 0x24, 0x66, 0x17, 0xde,
	0x8d, 0x57, 0xc2, 0x9e, 0x5d, 0xc2, 0xae, 0x4b, 0x43, 0x1c, 0xda, 0xd4, 0x8d, 0x33, 0x0b, 0x6f,
	0xa7, 0xa2, 0x3e, 0x09, 0x68, 0xdf, 0xef, 0x90, 0x38, 0x74, 0x23, 0x0e, 0x39, 0xd4, 0xed, 0xfa,
	0x7d, 0xd7, 0xb5, 0xdd, 0x6e, 0x89, 0x7a, 0xc4, 0x1f, 0xca, 0x2f, 0xc6, 0x24, 0x3e, 0x3b, 0xe8,
	0x1f, 0x96, 0x0e, 0x6d, 0xe2, 0x58, 0x66, 0x0f, 0x07, 0x47, 0x31, 0xe3, 0xfa, 0x28, 0x23, 0xb4,
	0x7b, 0x24, 0x08, 0x71, 0xcf, 0x8b, 0x08, 0xf2, 0x7f, 0x0b, 0xb0, 0xa0, 0xbb, 0x41, 0x88, 0xdd,
	0x0e, 0x41, 0x08, 0xe6, 0x5c, 0xdc, 0x23, 0x92, 0x50, 0x14, 0xd6, 0xb3, 0x06, 0x1f, 0xa3, 0xf7,
	0x61, 0xd1, 0xb2, 0x03, 0xcf, 0xc1, 0xc7, 0x26, 0x8f, 0xcd, 0xf0, 0x58, 0x2e, 0xc6, 0xea, 0x8c,
	0xf2, 0x10, 0xe6, 0x1d, 0x7c, 0x40, 0x9c, 0x40, 0x9a, 0x2d, 0xce, 0xae, 0xe7, 0xca, 0x9f, 0x29,
	0x17, 0x57, 0x44, 0x49, 0x36, 0x53, 0xf6, 0x79, 0x8a, 0xe6, 0x86, 0xfe, 0xb1, 0x11, 0xe7, 0xa3,
	0xeb, 0x90, 0x73, 0x68, 0x87, 0x3f, 0xa3, 0x69, 0x5b, 0xd2, 0x1c, 0xdf, 0x0b, 0x12, 0x48, 0xb7,
	0xd0, 0x1d, 0xb8, 0x8a, 0x9d, 0x90, 0xf8, 0x2e, 0x0e, 0xed, 0x01, 0x31, 0xd3, 0xe4, 0x0c, 0x27,
	0xaf, 0xa5, 0xc2, 0xfb, 0x67, 0x79, 0x37, 0x60, 0x89, 0xcb, 0x30, 0x07, 0xc4, 0x0f, 0x6c, 0xea,
	0x4a, 0x6f, 0x72, 0xf6, 0x22, 0x07, 0x1f, 0x47, 0x18, 0xda, 0x80, 0x15, 0x9f, 0x04, 0xc4, 0x1f,
	0x10, 0xcb, 0xb4, 0x3d, 0xd3, 0xc7, 0x6e, 0x97, 0x48, 0x59, 0x4e, 0x5c, 0x4e, 0x02, 0xba, 0x67,
	0x30, 0x98, 0x95, 0xea, 0x29, 0x0d, 0x42, 0x09, 0xa2, 0x52, 0xb1, 0x31, 0xc3, 0x3c, 0xea, 0x87,
	0x52, 0xae, 0x28, 0xac, 0x67, 0x0c, 0x3e, 0x46, 0x0a, 0x5c, 0xe9, 0xf4, 0x7d, 0x9f, 0xb8, 0xe1,
	0x90, 0xd8, 0x45, 0x9e, 0xb6, 0x12, 0x87, 0x52, 0x42, 0xb7, 0x20, 0xd7, 0xf1, 0x09, 0x0e, 0x89,
	0xc9, 0x3a, 0x25, 0x2d, 0x15, 0x85, 0xf5, 0x5c, 0xb9, 0x90, 0x14, 0x34, 0x69, 0xa3, 0xd2, 0x4e,
	0xda, 0x68, 0x40, 0x44, 0x67, 0x00, 0xda, 0x86, 0x4c, 0x10, 0xe2, 0x90, 0x48, 0xf9, 0xa2, 0xb0,
	0x9e, 0x2f, 0x6f, 0x4c, 0xd5, 0x87, 0x16, 0xcb, 0x30, 0xa2, 0x44, 0xf4, 0x01, 0xe4, 0xd9, 0xa0,
	0x1f, 0x98, 0x3d, 0x12, 0x04, 0xb8, 0x4b, 0xa4, 0x65, 0xae, 0x74, 0x29, 0x42, 0x6b, 0x11, 0x88,
	0xbe, 0x4a, 0xca, 0xd9, 0xa1, 0xee, 0xa1, 0xdd, 0x0d, 0x24, 0x91, 0x37, 0xfe, 0xce, 0x54, 0x1b,
	0x1a, 0x0c, 0xae, 0x44, 0x89, 0x51, 0xfb, 0xa3, 0x36, 0xc4, 0x10, 0xba, 0x07, 0x73, 0xa1, 0x4d,
	0x7c, 0x69, 0x85, 0x3f, 0xc4, 0x47, 0x53, 0xad, 0xd9, 0xb6, 0x89, 0x6f, 0xf0, 0x34, 0x74, 0x13,
	0xf2, 0x3d, 0xd2, 0xa3, 0xfe, 0xb1, 0x19, 0xd8, 0x27, 0xc4, 0xec, 0x1e, 0x48, 0x88, 0xf7, 0x63,
	0x31, 0x42, 0x5b, 0xf6, 0x09, 0xd9, 0x3b, 0x40, 0x9f, 0x02, 0xc2, 0xfd, 0xf0, 0x29, 0xf5, 0xed,
	0x13, 0x62, 0x99, 0x2e, 0x09, 0xbf, 0xa1, 0xfe, 0x91, 0xb4, 0x1a, 0xb5, 0xe5, 0x2c, 0x52, 0x8f,
	0x02, 0x85, 0x2f, 0x20, 0x97, 0x3a, 0xaf, 0x48, 0x84, 0xd9, 0x23, 0x72, 0x1c, 0xdf, 0x13, 0x36,
	0x44, 0xab, 0x90, 0x19, 0x60, 0xa7, 0x9f, 0xdc, 0x8f, 0x68, 0xb2, 0x39, 0x73, 0x57, 0x28, 0x3c,
	0x80, 0x95, 0x73, 0x4f, 0xfc, 0x3a, 0x0b, 0xc8, 0x3f, 0x09, 0x90, 0xe1, 0x4d, 0x42, 0x6b, 0xb0,
	0xd2, 0x6a, 0xab, 0x6d, 0xcd, 0x7c, 0x54, 0x6f, 0x35, 0xb5, 0x8a, 0xbe, 0xab, 0x6b, 0x55, 0xf1,
	0x0d, 0xb4, 0x08, 0x0b, 0x15, 0x43, 0x53, 0xdb, 0x7a, 0x7d, 0x4f, 0x14, 0x50, 0x16, 0x32, 0x86,
	0xa6, 0x56, 0xbf, 0x14, 0x67, 0x58, 0xe0, 0x51, 0xb3, 0x1a, 0x05, 0x66, 0xd9, 0xac, 0xaa, 0xed,
	0x6b, 0x7c, 0x36, 0x87, 0x96, 0x20, 0x6b, 0x68, 0x4d, 0x55, 0x37, 0xd8, 0x34, 0x83, 0x96, 0x21,
	0x57, 0x53, 0xf5, 0x7a, 0x5b, 0xab, 0xab, 0xf5, 0x8a, 0x26, 0xce, 0xb3, 0xb8, 0x5e, 0x6b, 0x36,
	0x0c, 0x4e, 0x5f, 0x40, 0x22, 0x2c, 0xee, 0xaa, 0xfa, 0xbe, 0x5e, 0xdf, 0x33, 0x1b, 0x8f, 0x35,
	0x43, 0x04, 0xf9, 0x2e, 0xcc, 0xb1, 0xaa, 0xa3, 0x55, 0x10, 0xdb, 0xba, 0x66, 0x8c, 0x68, 0xca,
	0x42, 0x66, 0x47, 0x6d, 0xe9, 0x15, 0x51, 0x60, 0x4b, 0xb7, 0xda, 0x6a, 0xbd, 0xaa, 0x1a, 0x55,
	0xf3, 0xa1, 0x2a, 0xce, 0xca, 0xcf, 0x60, 0x75, 0xdf, 0x0e, 0xc2, 0xa4, 0x79, 0x81, 0x41, 0xbe,
	0xee, 0x93, 0x20, 0x44, 0x6f, 0xc1, 0xbc, 0x87, 0xd9, 0x7d, 0x88, 0xeb, 0x12, 0xcf, 0xd0, 0x3b,
	0x90, 0xf5, 0x70, 0x97, 0xf0, 0x7e, 0xf2, 0xf2, 0x64, 0x8c, 0x05, 0x06, 0xb0, 0x56, 0xa2, 0x6b,
	0x00, 0x3c, 0x18, 0xd2, 0x23, 0xe2, 0x4a, 0xb3, 0x3c, 0x91, 0xd3, 0xdb, 0x0c, 0x90, 0x7f, 0x13,
	0x60, 0x6d, 0x64, 0xb3, 0xc0, 0xa3, 0x6e, 0x40, 0xd0, 0x0e, 0x64, 0xed, 0x04, 0x94, 0x04, 0x7e,
	0x7e, 0x6f, 0x4e, 0x73, 0xd6, 0x8c, 0xb3, 0x34, 0xf4, 0x21, 0x2c, 0xbb, 0xe4, 0x79, 0x68, 0xa6,
	0x14, 0x44, 0xed, 0x5b, 0x62, 0x70, 0x33, 0x51, 0x81, 0x8a, 0x90, 0xeb, 0xbb, 0x3e, 0xc1, 0x9d,
	0xa7, 0xf8, 0xc0, 0x21, 0xdc, 0x26, 0xb3, 0x46, 0x1a, 0x92, 0xd7, 0x01, 0xed, 0x91, 0x53, 0x95,
	0x49, 0x45, 0xc6, 0x18, 0xb2, 0xfc, 0x52, 0x80, 0xb5, 0x0a, 0xbf, 0xf3, 0xa3, 0xec, 0x8b, 0xea,
	0x77, 0x1d, 0x72, 0x89, 0x64, 0xe6, 0x3d, 0x91, 0x42, 0x48, 0x20, 0xdd, 0x42, 0xdb, 0xb0, 0x90,
	0xcc, 0x78, 0x05, 0xa7, 0xad, 0xc4, 0x69, 0x96, 0xfc, 0xb3, 0x00, 0x6b, 0x8f, 0x3c, 0x6b, 0x8c,
	0xa8, 0x2d, 0xc8, 0xf5, 0x79, 0x80, 0xbf, 0x96, 0xb8, 0xb2, 0x71, 0x86, 0xb6, 0xcb, 0xde, 0x5c,
	0x35, 0x1c, 0x1c, 0x19, 0x10, 0xd1, 0xd9, 0x78, 0x48, 0xd8, 0xcc, 0xa5, 0x84, 0x7d, 0x0c, 0x6b,
	0x55, 0xe2, 0x90, 0xf3, 0xba, 0xc6, 0x95, 0xf6, 0x87, 0x19, 0xb8, 0xba, 0x8b, 0x6d, 0x87, 0x0e,
	0x88, 0x3f, 0x05, 0x1f, 0x3d, 0x87, 0x55, 0x0b, 0x87, 0xd8, 0x64, 0x4f, 0x41, 0x3a, 0xdc, 0xdb,
	0x7b, 0xd4, 0x8a, 0xa4, 0xe6, 0xcb, 0xbb, 0x93, 0xa4, 0x5e, 0xb0, 0x8d, 0x52, 0xc5, 0x21, 0x6e,
	0x9e, 0x2e, 0x57, 0xa3, 0x16, 0x31, 0x90, 0x75, 0x0e, 0x93, 0x0f, 0x01, 0x9d, 0x67, 0xa2, 0x9b,
	0x50, 0xac, 0xaa, 0x6d, 0xd5, 0x6c, 0x1a, 0x8d, 0xb6, 0x56, 0x69, 0xeb, 0x8d, 0xba, 0x59, 0x6b,
	0x54, 0x47, 0xed, 0x62, 0x0d, 0x56, 0xf6, 0xf5, 0x9a, 0xde, 0xd6, 0xaa, 0x26, 0x67, 0xef, 0x37,
	0x5a, 0x2d, 0x51, 0x40, 0x57, 0x60, 0x79, 0xb7, 0x61, 0x54, 0xb4, 0x14, 0x38, 0x23, 0xff, 0x2b,
	0x80, 0x98, 0xbc, 0x9d, 0x6a, 0x24, 0xc4, 0x4c, 0x0a, 0xb2, 0x61, 0x19, 0x0f, 0xb0, 0xed, 0xb0,
	0x83, 0x6b, 0x9e, 0x50, 0xf7, 0xf4, 0xfe, 0x6c, 0x4f, 0x7a, 0xe2, 0xd1, 0x65, 0x14, 0x35, 0x59,
	0xe3, 0x09, 0x5b, 0x22, 0x7a, 0x13, 0xe4, 0xf1, 0x10, 0x58, 0x38, 0x82, 0x2b, 0x63, 0x68, 0x63,
	0xec, 0xf3, 0x7e, 0xda, 0x3e, 0x73, 0xe5, 0xf5, 0x49, 0x4a, 0xd8, 0x42, 0x89, 0x8a, 0xb4, 0xd1,
	0xe6, 0x61, 0x31, 0x1d, 0x2a, 0xbf, 0x5c, 0x00, 0xa8, 0xb0, 0x7c, 0xee, 0xdf, 0xe8, 0x4f, 0x01,
	0x96, 0x86, 0xac, 0x04, 0x4d, 0xfc, 0xd0, 0x19, 0x67, 0x71, 0x85, 0x5b, 0xaf, 0x91, 0x11, 0xf9,
	0x94, 0xbc, 0xf9, 0xfd, 0xdf, 0xff, 0xfc, 0x38, 0xf3, 0x39, 0x2a, 0x9f, 0x7e, 0x82, 0x7e, 0x1b,
	0xdd, 0xeb, 0x7b, 0x9e, 0x4f, 0x9f, 0x91, 0x4e, 0x18, 0x94, 0x36, 0x4a, 0xc9, 0xb7, 0x45, 0x50,
	0xda, 0x78, 0x51, 0x3a, 0xf3, 0xa7, 0x5f, 0x05, 0xc8, 0xa5, 0x6c, 0x05, 0x29, 0x93, 0xb6, 0x3f,
	0xef, 0x3f, 0x85, 0xa9, 0x6e, 0xdb, 0x38, 0x85, 0xec, 0x7a, 0x5c, 0xa0, 0xef, 0x4c, 0x5e, 0x69,
	0xe3, 0x05, 0xfa, 0x5d, 0x80, 0xfc, 0xb0, 0x9b, 0xa1, 0x89, 0x35, 0x1a, 0xeb, 0x7c, 0x85, 0x6b,
	0x49, 0x4a, 0xea, 0x73, 0x59, 0x69, 0x24, 0x9f, 0xcb, 0x72, 0x95, 0x0b, 0xbc, 0x2f, 0x5f, 0xa2,
	0x84, 0x9b, 0xa7, 0x56, 0x82, 0xfe, 0x12, 0x20, 0x3f, 0xec, 0x71, 0x93, 0xa5, 0x8e, 0xf5, 0xc3,
	0x57, 0x49, 0xad, 0x71, 0xa9, 0x7b, 0xe5, 0xad, 0x33, 0xa9, 0x89, 0x00, 0x65, 0xda, 0xa2, 0xa6,
	0x34, 0xff, 0x21, 0x80, 0x38, 0x6a, 0x35, 0xe8, 0xf6, 0x25, 0x8c, 0xe9, 0x55, 0xba, 0x77, 0xb9,
	0xee, 0x6d, 0x79, 0xeb, 0xf5, 0xcf, 0xc0, 0xe6, 0x61, 0xbc, 0xe5, 0xa6, 0xb0, 0x81, 0x7e, 0x11,
	0x20, 0x3f, 0x6c, 0xd8, 0x93, 0x8b, 0x3c, 0xd6, 0xdc, 0x5f, 0x25, 0x36, 0x3e, 0xb0, 0x1b, 0x97,
	0x38, 0xb0, 0x3b, 0xdf, 0xc1, 0x7b, 0x1d, 0xda, 0x9b, 0x20, 0x69, 0xa7, 0x70, 0xe6, 0x19, 0x2d,
	0xe2, 0x0f, 0xec, 0x0e, 0xd9, 0x21, 0x91, 0x55, 0xd3, 0xa6, 0xf0, 0xe4, 0x41, 0x9c, 0xd9, 0xa5,
	0x0e, 0x76, 0xbb, 0x0a, 0xf5, 0xbb, 0xa5, 0x2e, 0x71, 0xf9, 0x7b, 0xb0, 0x14, 0x85, 0xb0, 0x67,
	0x07, 0xe3, 0x7e, 0x3d, 0xb7, 0xf8, 0xec, 0x60, 0x9e, 0x73, 0x6f, 0xff, 0x1f, 0x00, 0x00, 0xff,
	0xff, 0xfd, 0x6d, 0xa4, 0x8f, 0xa5, 0x0e, 0x00, 0x00,
}
