// Code generated by protoc-gen-go. DO NOT EDIT.
// source: logical/plugin/pb/backend.proto

/*
Package pb is a generated protocol buffer package.

It is generated from these files:
	logical/plugin/pb/backend.proto

It has these top-level messages:
	Empty
	Header
	ProtoError
	Paths
	Request
	Alias
	Auth
	LeaseOptions
	Secret
	Response
	ResponseWrapInfo
	RequestWrapInfo
	HandleRequestArgs
	HandleRequestReply
	SpecialPathsReply
	HandleExistenceCheckArgs
	HandleExistenceCheckReply
	SetupArgs
	SetupReply
	TypeReply
	InvalidateKeyArgs
	StorageEntry
	StorageListArgs
	StorageListReply
	StorageGetArgs
	StorageGetReply
	StoragePutArgs
	StoragePutReply
	StorageDeleteArgs
	StorageDeleteReply
	TTLReply
	SudoPrivilegeArgs
	SudoPrivilegeReply
	TaintedReply
	CachingDisabledReply
	ReplicationStateReply
	ResponseWrapDataArgs
	ResponseWrapDataReply
	MlockEnabledReply
	LocalMountReply
	Connection
*/
package pb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Empty struct {
}

func (m *Empty) Reset()                    { *m = Empty{} }
func (m *Empty) String() string            { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()               {}
func (*Empty) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type Header struct {
	Header []string `sentinel:"" protobuf:"bytes,1,rep,name=header" json:"header,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Header) GetHeader() []string {
	if m != nil {
		return m.Header
	}
	return nil
}

type ProtoError struct {
	// Error type can be one of:
	// ErrTypeUnknown uint32 = iota
	// ErrTypeUserError
	// ErrTypeInternalError
	// ErrTypeCodedError
	// ErrTypeStatusBadRequest
	// ErrTypeUnsupportedOperation
	// ErrTypeUnsupportedPath
	// ErrTypeInvalidRequest
	// ErrTypePermissionDenied
	// ErrTypeMultiAuthzPending
	ErrType uint32 `sentinel:"" protobuf:"varint,1,opt,name=err_type,json=errType" json:"err_type,omitempty"`
	ErrMsg  string `sentinel:"" protobuf:"bytes,2,opt,name=err_msg,json=errMsg" json:"err_msg,omitempty"`
	ErrCode int64  `sentinel:"" protobuf:"varint,3,opt,name=err_code,json=errCode" json:"err_code,omitempty"`
}

func (m *ProtoError) Reset()                    { *m = ProtoError{} }
func (m *ProtoError) String() string            { return proto.CompactTextString(m) }
func (*ProtoError) ProtoMessage()               {}
func (*ProtoError) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ProtoError) GetErrType() uint32 {
	if m != nil {
		return m.ErrType
	}
	return 0
}

func (m *ProtoError) GetErrMsg() string {
	if m != nil {
		return m.ErrMsg
	}
	return ""
}

func (m *ProtoError) GetErrCode() int64 {
	if m != nil {
		return m.ErrCode
	}
	return 0
}

// Paths is the structure of special paths that is used for SpecialPaths.
type Paths struct {
	// Root are the paths that require a root token to access
	Root []string `sentinel:"" protobuf:"bytes,1,rep,name=root" json:"root,omitempty"`
	// Unauthenticated are the paths that can be accessed without any auth.
	Unauthenticated []string `sentinel:"" protobuf:"bytes,2,rep,name=unauthenticated" json:"unauthenticated,omitempty"`
	// LocalStorage are paths (prefixes) that are local to this instance; this
	// indicates that these paths should not be replicated
	LocalStorage []string `sentinel:"" protobuf:"bytes,3,rep,name=local_storage,json=localStorage" json:"local_storage,omitempty"`
	// SealWrapStorage are storage paths that, when using a capable seal,
	// should be seal wrapped with extra encryption. It is exact matching
	// unless it ends with '/' in which case it will be treated as a prefix.
	SealWrapStorage []string `sentinel:"" protobuf:"bytes,4,rep,name=seal_wrap_storage,json=sealWrapStorage" json:"seal_wrap_storage,omitempty"`
}

func (m *Paths) Reset()                    { *m = Paths{} }
func (m *Paths) String() string            { return proto.CompactTextString(m) }
func (*Paths) ProtoMessage()               {}
func (*Paths) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Paths) GetRoot() []string {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *Paths) GetUnauthenticated() []string {
	if m != nil {
		return m.Unauthenticated
	}
	return nil
}

func (m *Paths) GetLocalStorage() []string {
	if m != nil {
		return m.LocalStorage
	}
	return nil
}

func (m *Paths) GetSealWrapStorage() []string {
	if m != nil {
		return m.SealWrapStorage
	}
	return nil
}

type Request struct {
	// ID is the uuid associated with each request
	ID string `sentinel:"" protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// If set, the name given to the replication secondary where this request
	// originated
	ReplicationCluster string `sentinel:"" protobuf:"bytes,2,opt,name=ReplicationCluster" json:"ReplicationCluster,omitempty"`
	// Operation is the requested operation type
	Operation string `sentinel:"" protobuf:"bytes,3,opt,name=operation" json:"operation,omitempty"`
	// Path is the part of the request path not consumed by the
	// routing. As an example, if the original request path is "prod/aws/foo"
	// and the AWS logical backend is mounted at "prod/aws/", then the
	// final path is "foo" since the mount prefix is trimmed.
	Path string `sentinel:"" protobuf:"bytes,4,opt,name=path" json:"path,omitempty"`
	// Request data is a JSON object that must have keys with string type.
	Data string `sentinel:"" protobuf:"bytes,5,opt,name=data" json:"data,omitempty"`
	// Secret will be non-nil only for Revoke and Renew operations
	// to represent the secret that was returned prior.
	Secret *Secret `sentinel:"" protobuf:"bytes,6,opt,name=secret" json:"secret,omitempty"`
	// Auth will be non-nil only for Renew operations
	// to represent the auth that was returned prior.
	Auth *Auth `sentinel:"" protobuf:"bytes,7,opt,name=auth" json:"auth,omitempty"`
	// Headers will contain the http headers from the request. This value will
	// be used in the audit broker to ensure we are auditing only the allowed
	// headers.
	Headers map[string]*Header `sentinel:"" protobuf:"bytes,8,rep,name=headers" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ClientToken is provided to the core so that the identity
	// can be verified and ACLs applied. This value is passed
	// through to the logical backends but after being salted and
	// hashed.
	ClientToken string `sentinel:"" protobuf:"bytes,9,opt,name=client_token,json=clientToken" json:"client_token,omitempty"`
	// ClientTokenAccessor is provided to the core so that the it can get
	// logged as part of request audit logging.
	ClientTokenAccessor string `sentinel:"" protobuf:"bytes,10,opt,name=client_token_accessor,json=clientTokenAccessor" json:"client_token_accessor,omitempty"`
	// DisplayName is provided to the logical backend to help associate
	// dynamic secrets with the source entity. This is not a sensitive
	// name, but is useful for operators.
	DisplayName string `sentinel:"" protobuf:"bytes,11,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// MountPoint is provided so that a logical backend can generate
	// paths relative to itself. The `Path` is effectively the client
	// request path with the MountPoint trimmed off.
	MountPoint string `sentinel:"" protobuf:"bytes,12,opt,name=mount_point,json=mountPoint" json:"mount_point,omitempty"`
	// MountType is provided so that a logical backend can make decisions
	// based on the specific mount type (e.g., if a mount type has different
	// aliases, generating different defaults depending on the alias)
	MountType string `sentinel:"" protobuf:"bytes,13,opt,name=mount_type,json=mountType" json:"mount_type,omitempty"`
	// MountAccessor is provided so that identities returned by the authentication
	// backends can be tied to the mount it belongs to.
	MountAccessor string `sentinel:"" protobuf:"bytes,14,opt,name=mount_accessor,json=mountAccessor" json:"mount_accessor,omitempty"`
	// WrapInfo contains requested response wrapping parameters
	WrapInfo *RequestWrapInfo `sentinel:"" protobuf:"bytes,15,opt,name=wrap_info,json=wrapInfo" json:"wrap_info,omitempty"`
	// ClientTokenRemainingUses represents the allowed number of uses left on the
	// token supplied
	ClientTokenRemainingUses int64 `sentinel:"" protobuf:"varint,16,opt,name=client_token_remaining_uses,json=clientTokenRemainingUses" json:"client_token_remaining_uses,omitempty"`
	// EntityID is the identity of the caller extracted out of the token used
	// to make this request
	EntityID string `sentinel:"" protobuf:"bytes,17,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// PolicyOverride indicates that the requestor wishes to override
	// soft-mandatory Sentinel policies
	PolicyOverride bool `sentinel:"" protobuf:"varint,18,opt,name=policy_override,json=policyOverride" json:"policy_override,omitempty"`
	// Whether the request is unauthenticated, as in, had no client token
	// attached. Useful in some situations where the client token is not made
	// accessible.
	Unauthenticated bool `sentinel:"" protobuf:"varint,19,opt,name=unauthenticated" json:"unauthenticated,omitempty"`
	// Connection will be non-nil only for credential providers to
	// inspect the connection information and potentially use it for
	// authentication/protection.
	Connection *Connection `sentinel:"" protobuf:"bytes,20,opt,name=connection" json:"connection,omitempty"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Request) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Request) GetReplicationCluster() string {
	if m != nil {
		return m.ReplicationCluster
	}
	return ""
}

func (m *Request) GetOperation() string {
	if m != nil {
		return m.Operation
	}
	return ""
}

func (m *Request) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Request) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

func (m *Request) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *Request) GetAuth() *Auth {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *Request) GetHeaders() map[string]*Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *Request) GetClientToken() string {
	if m != nil {
		return m.ClientToken
	}
	return ""
}

func (m *Request) GetClientTokenAccessor() string {
	if m != nil {
		return m.ClientTokenAccessor
	}
	return ""
}

func (m *Request) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Request) GetMountPoint() string {
	if m != nil {
		return m.MountPoint
	}
	return ""
}

func (m *Request) GetMountType() string {
	if m != nil {
		return m.MountType
	}
	return ""
}

func (m *Request) GetMountAccessor() string {
	if m != nil {
		return m.MountAccessor
	}
	return ""
}

func (m *Request) GetWrapInfo() *RequestWrapInfo {
	if m != nil {
		return m.WrapInfo
	}
	return nil
}

func (m *Request) GetClientTokenRemainingUses() int64 {
	if m != nil {
		return m.ClientTokenRemainingUses
	}
	return 0
}

func (m *Request) GetEntityID() string {
	if m != nil {
		return m.EntityID
	}
	return ""
}

func (m *Request) GetPolicyOverride() bool {
	if m != nil {
		return m.PolicyOverride
	}
	return false
}

func (m *Request) GetUnauthenticated() bool {
	if m != nil {
		return m.Unauthenticated
	}
	return false
}

func (m *Request) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

type Alias struct {
	// MountType is the backend mount's type to which this identity belongs
	MountType string `sentinel:"" protobuf:"bytes,1,opt,name=mount_type,json=mountType" json:"mount_type,omitempty"`
	// MountAccessor is the identifier of the mount entry to which this
	// identity belongs
	MountAccessor string `sentinel:"" protobuf:"bytes,2,opt,name=mount_accessor,json=mountAccessor" json:"mount_accessor,omitempty"`
	// Name is the identifier of this identity in its authentication source
	Name string `sentinel:"" protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
}

func (m *Alias) Reset()                    { *m = Alias{} }
func (m *Alias) String() string            { return proto.CompactTextString(m) }
func (*Alias) ProtoMessage()               {}
func (*Alias) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Alias) GetMountType() string {
	if m != nil {
		return m.MountType
	}
	return ""
}

func (m *Alias) GetMountAccessor() string {
	if m != nil {
		return m.MountAccessor
	}
	return ""
}

func (m *Alias) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type Auth struct {
	LeaseOptions *LeaseOptions `sentinel:"" protobuf:"bytes,1,opt,name=lease_options,json=leaseOptions" json:"lease_options,omitempty"`
	// InternalData is a JSON object that is stored with the auth struct.
	// This will be sent back during a Renew/Revoke for storing internal data
	// used for those operations.
	InternalData string `sentinel:"" protobuf:"bytes,2,opt,name=internal_data,json=internalData" json:"internal_data,omitempty"`
	// DisplayName is a non-security sensitive identifier that is
	// applicable to this Auth. It is used for logging and prefixing
	// of dynamic secrets. For example, DisplayName may be "armon" for
	// the github credential backend. If the client token is used to
	// generate a SQL credential, the user may be "github-armon-uuid".
	// This is to help identify the source without using audit tables.
	DisplayName string `sentinel:"" protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Policies is the list of policies that the authenticated user
	// is associated with.
	Policies []string `sentinel:"" protobuf:"bytes,4,rep,name=policies" json:"policies,omitempty"`
	// Metadata is used to attach arbitrary string-type metadata to
	// an authenticated user. This metadata will be outputted into the
	// audit log.
	Metadata map[string]string `sentinel:"" protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ClientToken is the token that is generated for the authentication.
	// This will be filled in by Vault core when an auth structure is
	// returned. Setting this manually will have no effect.
	ClientToken string `sentinel:"" protobuf:"bytes,6,opt,name=client_token,json=clientToken" json:"client_token,omitempty"`
	// Accessor is the identifier for the ClientToken. This can be used
	// to perform management functionalities (especially revocation) when
	// ClientToken in the audit logs are obfuscated. Accessor can be used
	// to revoke a ClientToken and to lookup the capabilities of the ClientToken,
	// both without actually knowing the ClientToken.
	Accessor string `sentinel:"" protobuf:"bytes,7,opt,name=accessor" json:"accessor,omitempty"`
	// Period indicates that the token generated using this Auth object
	// should never expire. The token should be renewed within the duration
	// specified by this period.
	Period int64 `sentinel:"" protobuf:"varint,8,opt,name=period" json:"period,omitempty"`
	// Number of allowed uses of the issued token
	NumUses int64 `sentinel:"" protobuf:"varint,9,opt,name=num_uses,json=numUses" json:"num_uses,omitempty"`
	// EntityID is the identifier of the entity in identity store to which the
	// identity of the authenticating client belongs to.
	EntityID string `sentinel:"" protobuf:"bytes,10,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Alias is the information about the authenticated client returned by
	// the auth backend
	Alias *Alias `sentinel:"" protobuf:"bytes,11,opt,name=alias" json:"alias,omitempty"`
	// GroupAliases are the informational mappings of external groups which an
	// authenticated user belongs to. This is used to check if there are
	// mappings groups for the group aliases in identity store. For all the
	// matching groups, the entity ID of the user will be added.
	GroupAliases []*Alias `sentinel:"" protobuf:"bytes,12,rep,name=group_aliases,json=groupAliases" json:"group_aliases,omitempty"`
}

func (m *Auth) Reset()                    { *m = Auth{} }
func (m *Auth) String() string            { return proto.CompactTextString(m) }
func (*Auth) ProtoMessage()               {}
func (*Auth) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Auth) GetLeaseOptions() *LeaseOptions {
	if m != nil {
		return m.LeaseOptions
	}
	return nil
}

func (m *Auth) GetInternalData() string {
	if m != nil {
		return m.InternalData
	}
	return ""
}

func (m *Auth) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Auth) GetPolicies() []string {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *Auth) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Auth) GetClientToken() string {
	if m != nil {
		return m.ClientToken
	}
	return ""
}

func (m *Auth) GetAccessor() string {
	if m != nil {
		return m.Accessor
	}
	return ""
}

func (m *Auth) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *Auth) GetNumUses() int64 {
	if m != nil {
		return m.NumUses
	}
	return 0
}

func (m *Auth) GetEntityID() string {
	if m != nil {
		return m.EntityID
	}
	return ""
}

func (m *Auth) GetAlias() *Alias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Auth) GetGroupAliases() []*Alias {
	if m != nil {
		return m.GroupAliases
	}
	return nil
}

type LeaseOptions struct {
	TTL       int64                      `sentinel:"" protobuf:"varint,1,opt,name=TTL" json:"TTL,omitempty"`
	Renewable bool                       `sentinel:"" protobuf:"varint,2,opt,name=renewable" json:"renewable,omitempty"`
	Increment int64                      `sentinel:"" protobuf:"varint,3,opt,name=increment" json:"increment,omitempty"`
	IssueTime *google_protobuf.Timestamp `sentinel:"" protobuf:"bytes,4,opt,name=issue_time,json=issueTime" json:"issue_time,omitempty"`
}

func (m *LeaseOptions) Reset()                    { *m = LeaseOptions{} }
func (m *LeaseOptions) String() string            { return proto.CompactTextString(m) }
func (*LeaseOptions) ProtoMessage()               {}
func (*LeaseOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *LeaseOptions) GetTTL() int64 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *LeaseOptions) GetRenewable() bool {
	if m != nil {
		return m.Renewable
	}
	return false
}

func (m *LeaseOptions) GetIncrement() int64 {
	if m != nil {
		return m.Increment
	}
	return 0
}

func (m *LeaseOptions) GetIssueTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.IssueTime
	}
	return nil
}

type Secret struct {
	LeaseOptions *LeaseOptions `sentinel:"" protobuf:"bytes,1,opt,name=lease_options,json=leaseOptions" json:"lease_options,omitempty"`
	// InternalData is a JSON object that is stored with the secret.
	// This will be sent back during a Renew/Revoke for storing internal data
	// used for those operations.
	InternalData string `sentinel:"" protobuf:"bytes,2,opt,name=internal_data,json=internalData" json:"internal_data,omitempty"`
	// LeaseID is the ID returned to the user to manage this secret.
	// This is generated by Vault core. Any set value will be ignored.
	// For requests, this will always be blank.
	LeaseID string `sentinel:"" protobuf:"bytes,3,opt,name=lease_id,json=leaseId" json:"lease_id,omitempty"`
}

func (m *Secret) Reset()                    { *m = Secret{} }
func (m *Secret) String() string            { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()               {}
func (*Secret) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Secret) GetLeaseOptions() *LeaseOptions {
	if m != nil {
		return m.LeaseOptions
	}
	return nil
}

func (m *Secret) GetInternalData() string {
	if m != nil {
		return m.InternalData
	}
	return ""
}

func (m *Secret) GetLeaseID() string {
	if m != nil {
		return m.LeaseID
	}
	return ""
}

type Response struct {
	// Secret, if not nil, denotes that this response represents a secret.
	Secret *Secret `sentinel:"" protobuf:"bytes,1,opt,name=secret" json:"secret,omitempty"`
	// Auth, if not nil, contains the authentication information for
	// this response. This is only checked and means something for
	// credential backends.
	Auth *Auth `sentinel:"" protobuf:"bytes,2,opt,name=auth" json:"auth,omitempty"`
	// Response data is a JSON object that must have string keys. For
	// secrets, this data is sent down to the user as-is. To store internal
	// data that you don't want the user to see, store it in
	// Secret.InternalData.
	Data string `sentinel:"" protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	// Redirect is an HTTP URL to redirect to for further authentication.
	// This is only valid for credential backends. This will be blanked
	// for any logical backend and ignored.
	Redirect string `sentinel:"" protobuf:"bytes,4,opt,name=redirect" json:"redirect,omitempty"`
	// Warnings allow operations or backends to return warnings in response
	// to user actions without failing the action outright.
	Warnings []string `sentinel:"" protobuf:"bytes,5,rep,name=warnings" json:"warnings,omitempty"`
	// Information for wrapping the response in a cubbyhole
	WrapInfo *ResponseWrapInfo `sentinel:"" protobuf:"bytes,6,opt,name=wrap_info,json=wrapInfo" json:"wrap_info,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Response) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

func (m *Response) GetAuth() *Auth {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *Response) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

func (m *Response) GetRedirect() string {
	if m != nil {
		return m.Redirect
	}
	return ""
}

func (m *Response) GetWarnings() []string {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *Response) GetWrapInfo() *ResponseWrapInfo {
	if m != nil {
		return m.WrapInfo
	}
	return nil
}

type ResponseWrapInfo struct {
	// Setting to non-zero specifies that the response should be wrapped.
	// Specifies the desired TTL of the wrapping token.
	TTL int64 `sentinel:"" protobuf:"varint,1,opt,name=TTL" json:"TTL,omitempty"`
	// The token containing the wrapped response
	Token string `sentinel:"" protobuf:"bytes,2,opt,name=token" json:"token,omitempty"`
	// The token accessor for the wrapped response token
	Accessor string `sentinel:"" protobuf:"bytes,3,opt,name=accessor" json:"accessor,omitempty"`
	// The creation time. This can be used with the TTL to figure out an
	// expected expiration.
	CreationTime *google_protobuf.Timestamp `sentinel:"" protobuf:"bytes,4,opt,name=creation_time,json=creationTime" json:"creation_time,omitempty"`
	// If the contained response is the output of a token creation call, the
	// created token's accessor will be accessible here
	WrappedAccessor string `sentinel:"" protobuf:"bytes,5,opt,name=wrapped_accessor,json=wrappedAccessor" json:"wrapped_accessor,omitempty"`
	// WrappedEntityID is the entity identifier of the caller who initiated the
	// wrapping request
	WrappedEntityID string `sentinel:"" protobuf:"bytes,6,opt,name=wrapped_entity_id,json=wrappedEntityID" json:"wrapped_entity_id,omitempty"`
	// The format to use. This doesn't get returned, it's only internal.
	Format string `sentinel:"" protobuf:"bytes,7,opt,name=format" json:"format,omitempty"`
	// CreationPath is the original request path that was used to create
	// the wrapped response.
	CreationPath string `sentinel:"" protobuf:"bytes,8,opt,name=creation_path,json=creationPath" json:"creation_path,omitempty"`
	// Controls seal wrapping behavior downstream for specific use cases
	SealWrap bool `sentinel:"" protobuf:"varint,9,opt,name=seal_wrap,json=sealWrap" json:"seal_wrap,omitempty"`
}

func (m *ResponseWrapInfo) Reset()                    { *m = ResponseWrapInfo{} }
func (m *ResponseWrapInfo) String() string            { return proto.CompactTextString(m) }
func (*ResponseWrapInfo) ProtoMessage()               {}
func (*ResponseWrapInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ResponseWrapInfo) GetTTL() int64 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *ResponseWrapInfo) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *ResponseWrapInfo) GetAccessor() string {
	if m != nil {
		return m.Accessor
	}
	return ""
}

func (m *ResponseWrapInfo) GetCreationTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *ResponseWrapInfo) GetWrappedAccessor() string {
	if m != nil {
		return m.WrappedAccessor
	}
	return ""
}

func (m *ResponseWrapInfo) GetWrappedEntityID() string {
	if m != nil {
		return m.WrappedEntityID
	}
	return ""
}

func (m *ResponseWrapInfo) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *ResponseWrapInfo) GetCreationPath() string {
	if m != nil {
		return m.CreationPath
	}
	return ""
}

func (m *ResponseWrapInfo) GetSealWrap() bool {
	if m != nil {
		return m.SealWrap
	}
	return false
}

type RequestWrapInfo struct {
	// Setting to non-zero specifies that the response should be wrapped.
	// Specifies the desired TTL of the wrapping token.
	TTL int64 `sentinel:"" protobuf:"varint,1,opt,name=TTL" json:"TTL,omitempty"`
	// The format to use for the wrapped response; if not specified it's a bare
	// token
	Format string `sentinel:"" protobuf:"bytes,2,opt,name=format" json:"format,omitempty"`
	// A flag to conforming backends that data for a given request should be
	// seal wrapped
	SealWrap bool `sentinel:"" protobuf:"varint,3,opt,name=seal_wrap,json=sealWrap" json:"seal_wrap,omitempty"`
}

func (m *RequestWrapInfo) Reset()                    { *m = RequestWrapInfo{} }
func (m *RequestWrapInfo) String() string            { return proto.CompactTextString(m) }
func (*RequestWrapInfo) ProtoMessage()               {}
func (*RequestWrapInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *RequestWrapInfo) GetTTL() int64 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *RequestWrapInfo) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *RequestWrapInfo) GetSealWrap() bool {
	if m != nil {
		return m.SealWrap
	}
	return false
}

// HandleRequestArgs is the args for HandleRequest method.
type HandleRequestArgs struct {
	StorageID uint32   `sentinel:"" protobuf:"varint,1,opt,name=storage_id,json=storageId" json:"storage_id,omitempty"`
	Request   *Request `sentinel:"" protobuf:"bytes,2,opt,name=request" json:"request,omitempty"`
}

func (m *HandleRequestArgs) Reset()                    { *m = HandleRequestArgs{} }
func (m *HandleRequestArgs) String() string            { return proto.CompactTextString(m) }
func (*HandleRequestArgs) ProtoMessage()               {}
func (*HandleRequestArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *HandleRequestArgs) GetStorageID() uint32 {
	if m != nil {
		return m.StorageID
	}
	return 0
}

func (m *HandleRequestArgs) GetRequest() *Request {
	if m != nil {
		return m.Request
	}
	return nil
}

// HandleRequestReply is the reply for HandleRequest method.
type HandleRequestReply struct {
	Response *Response   `sentinel:"" protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Err      *ProtoError `sentinel:"" protobuf:"bytes,2,opt,name=err" json:"err,omitempty"`
}

func (m *HandleRequestReply) Reset()                    { *m = HandleRequestReply{} }
func (m *HandleRequestReply) String() string            { return proto.CompactTextString(m) }
func (*HandleRequestReply) ProtoMessage()               {}
func (*HandleRequestReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *HandleRequestReply) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *HandleRequestReply) GetErr() *ProtoError {
	if m != nil {
		return m.Err
	}
	return nil
}

// SpecialPathsReply is the reply for SpecialPaths method.
type SpecialPathsReply struct {
	Paths *Paths `sentinel:"" protobuf:"bytes,1,opt,name=paths" json:"paths,omitempty"`
}

func (m *SpecialPathsReply) Reset()                    { *m = SpecialPathsReply{} }
func (m *SpecialPathsReply) String() string            { return proto.CompactTextString(m) }
func (*SpecialPathsReply) ProtoMessage()               {}
func (*SpecialPathsReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *SpecialPathsReply) GetPaths() *Paths {
	if m != nil {
		return m.Paths
	}
	return nil
}

// HandleExistenceCheckArgs is the args for HandleExistenceCheck method.
type HandleExistenceCheckArgs struct {
	StorageID uint32   `sentinel:"" protobuf:"varint,1,opt,name=storage_id,json=storageId" json:"storage_id,omitempty"`
	Request   *Request `sentinel:"" protobuf:"bytes,2,opt,name=request" json:"request,omitempty"`
}

func (m *HandleExistenceCheckArgs) Reset()                    { *m = HandleExistenceCheckArgs{} }
func (m *HandleExistenceCheckArgs) String() string            { return proto.CompactTextString(m) }
func (*HandleExistenceCheckArgs) ProtoMessage()               {}
func (*HandleExistenceCheckArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *HandleExistenceCheckArgs) GetStorageID() uint32 {
	if m != nil {
		return m.StorageID
	}
	return 0
}

func (m *HandleExistenceCheckArgs) GetRequest() *Request {
	if m != nil {
		return m.Request
	}
	return nil
}

// HandleExistenceCheckReply is the reply for HandleExistenceCheck method.
type HandleExistenceCheckReply struct {
	CheckFound bool        `sentinel:"" protobuf:"varint,1,opt,name=check_found,json=checkFound" json:"check_found,omitempty"`
	Exists     bool        `sentinel:"" protobuf:"varint,2,opt,name=exists" json:"exists,omitempty"`
	Err        *ProtoError `sentinel:"" protobuf:"bytes,3,opt,name=err" json:"err,omitempty"`
}

func (m *HandleExistenceCheckReply) Reset()                    { *m = HandleExistenceCheckReply{} }
func (m *HandleExistenceCheckReply) String() string            { return proto.CompactTextString(m) }
func (*HandleExistenceCheckReply) ProtoMessage()               {}
func (*HandleExistenceCheckReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *HandleExistenceCheckReply) GetCheckFound() bool {
	if m != nil {
		return m.CheckFound
	}
	return false
}

func (m *HandleExistenceCheckReply) GetExists() bool {
	if m != nil {
		return m.Exists
	}
	return false
}

func (m *HandleExistenceCheckReply) GetErr() *ProtoError {
	if m != nil {
		return m.Err
	}
	return nil
}

// SetupArgs is the args for Setup method.
type SetupArgs struct {
	BrokerID uint32            `sentinel:"" protobuf:"varint,1,opt,name=broker_id,json=brokerId" json:"broker_id,omitempty"`
	Config   map[string]string `sentinel:"" protobuf:"bytes,2,rep,name=Config" json:"Config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SetupArgs) Reset()                    { *m = SetupArgs{} }
func (m *SetupArgs) String() string            { return proto.CompactTextString(m) }
func (*SetupArgs) ProtoMessage()               {}
func (*SetupArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *SetupArgs) GetBrokerID() uint32 {
	if m != nil {
		return m.BrokerID
	}
	return 0
}

func (m *SetupArgs) GetConfig() map[string]string {
	if m != nil {
		return m.Config
	}
	return nil
}

// SetupReply is the reply for Setup method.
type SetupReply struct {
	Err string `sentinel:"" protobuf:"bytes,1,opt,name=err" json:"err,omitempty"`
}

func (m *SetupReply) Reset()                    { *m = SetupReply{} }
func (m *SetupReply) String() string            { return proto.CompactTextString(m) }
func (*SetupReply) ProtoMessage()               {}
func (*SetupReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *SetupReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

// TypeReply is the reply for the Type method.
type TypeReply struct {
	Type uint32 `sentinel:"" protobuf:"varint,1,opt,name=type" json:"type,omitempty"`
}

func (m *TypeReply) Reset()                    { *m = TypeReply{} }
func (m *TypeReply) String() string            { return proto.CompactTextString(m) }
func (*TypeReply) ProtoMessage()               {}
func (*TypeReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *TypeReply) GetType() uint32 {
	if m != nil {
		return m.Type
	}
	return 0
}

type InvalidateKeyArgs struct {
	Key string `sentinel:"" protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
}

func (m *InvalidateKeyArgs) Reset()                    { *m = InvalidateKeyArgs{} }
func (m *InvalidateKeyArgs) String() string            { return proto.CompactTextString(m) }
func (*InvalidateKeyArgs) ProtoMessage()               {}
func (*InvalidateKeyArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *InvalidateKeyArgs) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type StorageEntry struct {
	Key      string `sentinel:"" protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value    []byte `sentinel:"" protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	SealWrap bool   `sentinel:"" protobuf:"varint,3,opt,name=seal_wrap,json=sealWrap" json:"seal_wrap,omitempty"`
}

func (m *StorageEntry) Reset()                    { *m = StorageEntry{} }
func (m *StorageEntry) String() string            { return proto.CompactTextString(m) }
func (*StorageEntry) ProtoMessage()               {}
func (*StorageEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *StorageEntry) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *StorageEntry) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *StorageEntry) GetSealWrap() bool {
	if m != nil {
		return m.SealWrap
	}
	return false
}

type StorageListArgs struct {
	Prefix string `sentinel:"" protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
}

func (m *StorageListArgs) Reset()                    { *m = StorageListArgs{} }
func (m *StorageListArgs) String() string            { return proto.CompactTextString(m) }
func (*StorageListArgs) ProtoMessage()               {}
func (*StorageListArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *StorageListArgs) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

type StorageListReply struct {
	Keys []string `sentinel:"" protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	Err  string   `sentinel:"" protobuf:"bytes,2,opt,name=err" json:"err,omitempty"`
}

func (m *StorageListReply) Reset()                    { *m = StorageListReply{} }
func (m *StorageListReply) String() string            { return proto.CompactTextString(m) }
func (*StorageListReply) ProtoMessage()               {}
func (*StorageListReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *StorageListReply) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *StorageListReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

type StorageGetArgs struct {
	Key string `sentinel:"" protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
}

func (m *StorageGetArgs) Reset()                    { *m = StorageGetArgs{} }
func (m *StorageGetArgs) String() string            { return proto.CompactTextString(m) }
func (*StorageGetArgs) ProtoMessage()               {}
func (*StorageGetArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *StorageGetArgs) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type StorageGetReply struct {
	Entry *StorageEntry `sentinel:"" protobuf:"bytes,1,opt,name=entry" json:"entry,omitempty"`
	Err   string        `sentinel:"" protobuf:"bytes,2,opt,name=err" json:"err,omitempty"`
}

func (m *StorageGetReply) Reset()                    { *m = StorageGetReply{} }
func (m *StorageGetReply) String() string            { return proto.CompactTextString(m) }
func (*StorageGetReply) ProtoMessage()               {}
func (*StorageGetReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *StorageGetReply) GetEntry() *StorageEntry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (m *StorageGetReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

type StoragePutArgs struct {
	Entry *StorageEntry `sentinel:"" protobuf:"bytes,1,opt,name=entry" json:"entry,omitempty"`
}

func (m *StoragePutArgs) Reset()                    { *m = StoragePutArgs{} }
func (m *StoragePutArgs) String() string            { return proto.CompactTextString(m) }
func (*StoragePutArgs) ProtoMessage()               {}
func (*StoragePutArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *StoragePutArgs) GetEntry() *StorageEntry {
	if m != nil {
		return m.Entry
	}
	return nil
}

type StoragePutReply struct {
	Err string `sentinel:"" protobuf:"bytes,1,opt,name=err" json:"err,omitempty"`
}

func (m *StoragePutReply) Reset()                    { *m = StoragePutReply{} }
func (m *StoragePutReply) String() string            { return proto.CompactTextString(m) }
func (*StoragePutReply) ProtoMessage()               {}
func (*StoragePutReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *StoragePutReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

type StorageDeleteArgs struct {
	Key string `sentinel:"" protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
}

func (m *StorageDeleteArgs) Reset()                    { *m = StorageDeleteArgs{} }
func (m *StorageDeleteArgs) String() string            { return proto.CompactTextString(m) }
func (*StorageDeleteArgs) ProtoMessage()               {}
func (*StorageDeleteArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *StorageDeleteArgs) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type StorageDeleteReply struct {
	Err string `sentinel:"" protobuf:"bytes,1,opt,name=err" json:"err,omitempty"`
}

func (m *StorageDeleteReply) Reset()                    { *m = StorageDeleteReply{} }
func (m *StorageDeleteReply) String() string            { return proto.CompactTextString(m) }
func (*StorageDeleteReply) ProtoMessage()               {}
func (*StorageDeleteReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *StorageDeleteReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

type TTLReply struct {
	TTL int64 `sentinel:"" protobuf:"varint,1,opt,name=TTL" json:"TTL,omitempty"`
}

func (m *TTLReply) Reset()                    { *m = TTLReply{} }
func (m *TTLReply) String() string            { return proto.CompactTextString(m) }
func (*TTLReply) ProtoMessage()               {}
func (*TTLReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *TTLReply) GetTTL() int64 {
	if m != nil {
		return m.TTL
	}
	return 0
}

type SudoPrivilegeArgs struct {
	Path  string `sentinel:"" protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Token string `sentinel:"" protobuf:"bytes,2,opt,name=token" json:"token,omitempty"`
}

func (m *SudoPrivilegeArgs) Reset()                    { *m = SudoPrivilegeArgs{} }
func (m *SudoPrivilegeArgs) String() string            { return proto.CompactTextString(m) }
func (*SudoPrivilegeArgs) ProtoMessage()               {}
func (*SudoPrivilegeArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *SudoPrivilegeArgs) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *SudoPrivilegeArgs) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

type SudoPrivilegeReply struct {
	Sudo bool `sentinel:"" protobuf:"varint,1,opt,name=sudo" json:"sudo,omitempty"`
}

func (m *SudoPrivilegeReply) Reset()                    { *m = SudoPrivilegeReply{} }
func (m *SudoPrivilegeReply) String() string            { return proto.CompactTextString(m) }
func (*SudoPrivilegeReply) ProtoMessage()               {}
func (*SudoPrivilegeReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *SudoPrivilegeReply) GetSudo() bool {
	if m != nil {
		return m.Sudo
	}
	return false
}

type TaintedReply struct {
	Tainted bool `sentinel:"" protobuf:"varint,1,opt,name=tainted" json:"tainted,omitempty"`
}

func (m *TaintedReply) Reset()                    { *m = TaintedReply{} }
func (m *TaintedReply) String() string            { return proto.CompactTextString(m) }
func (*TaintedReply) ProtoMessage()               {}
func (*TaintedReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *TaintedReply) GetTainted() bool {
	if m != nil {
		return m.Tainted
	}
	return false
}

type CachingDisabledReply struct {
	Disabled bool `sentinel:"" protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *CachingDisabledReply) Reset()                    { *m = CachingDisabledReply{} }
func (m *CachingDisabledReply) String() string            { return proto.CompactTextString(m) }
func (*CachingDisabledReply) ProtoMessage()               {}
func (*CachingDisabledReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *CachingDisabledReply) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

type ReplicationStateReply struct {
	State int32 `sentinel:"" protobuf:"varint,1,opt,name=state" json:"state,omitempty"`
}

func (m *ReplicationStateReply) Reset()                    { *m = ReplicationStateReply{} }
func (m *ReplicationStateReply) String() string            { return proto.CompactTextString(m) }
func (*ReplicationStateReply) ProtoMessage()               {}
func (*ReplicationStateReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ReplicationStateReply) GetState() int32 {
	if m != nil {
		return m.State
	}
	return 0
}

type ResponseWrapDataArgs struct {
	Data string `sentinel:"" protobuf:"bytes,1,opt,name=data" json:"data,omitempty"`
	TTL  int64  `sentinel:"" protobuf:"varint,2,opt,name=TTL" json:"TTL,omitempty"`
	JWT  bool   `sentinel:"" protobuf:"varint,3,opt,name=JWT" json:"JWT,omitempty"`
}

func (m *ResponseWrapDataArgs) Reset()                    { *m = ResponseWrapDataArgs{} }
func (m *ResponseWrapDataArgs) String() string            { return proto.CompactTextString(m) }
func (*ResponseWrapDataArgs) ProtoMessage()               {}
func (*ResponseWrapDataArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ResponseWrapDataArgs) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

func (m *ResponseWrapDataArgs) GetTTL() int64 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *ResponseWrapDataArgs) GetJWT() bool {
	if m != nil {
		return m.JWT
	}
	return false
}

type ResponseWrapDataReply struct {
	WrapInfo *ResponseWrapInfo `sentinel:"" protobuf:"bytes,1,opt,name=wrap_info,json=wrapInfo" json:"wrap_info,omitempty"`
	Err      string            `sentinel:"" protobuf:"bytes,2,opt,name=err" json:"err,omitempty"`
}

func (m *ResponseWrapDataReply) Reset()                    { *m = ResponseWrapDataReply{} }
func (m *ResponseWrapDataReply) String() string            { return proto.CompactTextString(m) }
func (*ResponseWrapDataReply) ProtoMessage()               {}
func (*ResponseWrapDataReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ResponseWrapDataReply) GetWrapInfo() *ResponseWrapInfo {
	if m != nil {
		return m.WrapInfo
	}
	return nil
}

func (m *ResponseWrapDataReply) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

type MlockEnabledReply struct {
	Enabled bool `sentinel:"" protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *MlockEnabledReply) Reset()                    { *m = MlockEnabledReply{} }
func (m *MlockEnabledReply) String() string            { return proto.CompactTextString(m) }
func (*MlockEnabledReply) ProtoMessage()               {}
func (*MlockEnabledReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *MlockEnabledReply) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

type LocalMountReply struct {
	Local bool `sentinel:"" protobuf:"varint,1,opt,name=local" json:"local,omitempty"`
}

func (m *LocalMountReply) Reset()                    { *m = LocalMountReply{} }
func (m *LocalMountReply) String() string            { return proto.CompactTextString(m) }
func (*LocalMountReply) ProtoMessage()               {}
func (*LocalMountReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *LocalMountReply) GetLocal() bool {
	if m != nil {
		return m.Local
	}
	return false
}

type Connection struct {
	// RemoteAddr is the network address that sent the request.
	RemoteAddr string `sentinel:"" protobuf:"bytes,1,opt,name=remote_addr,json=remoteAddr" json:"remote_addr,omitempty"`
}

func (m *Connection) Reset()                    { *m = Connection{} }
func (m *Connection) String() string            { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()               {}
func (*Connection) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *Connection) GetRemoteAddr() string {
	if m != nil {
		return m.RemoteAddr
	}
	return ""
}

func init() {
	proto.RegisterType((*Empty)(nil), "pb.Empty")
	proto.RegisterType((*Header)(nil), "pb.Header")
	proto.RegisterType((*ProtoError)(nil), "pb.ProtoError")
	proto.RegisterType((*Paths)(nil), "pb.Paths")
	proto.RegisterType((*Request)(nil), "pb.Request")
	proto.RegisterType((*Alias)(nil), "pb.Alias")
	proto.RegisterType((*Auth)(nil), "pb.Auth")
	proto.RegisterType((*LeaseOptions)(nil), "pb.LeaseOptions")
	proto.RegisterType((*Secret)(nil), "pb.Secret")
	proto.RegisterType((*Response)(nil), "pb.Response")
	proto.RegisterType((*ResponseWrapInfo)(nil), "pb.ResponseWrapInfo")
	proto.RegisterType((*RequestWrapInfo)(nil), "pb.RequestWrapInfo")
	proto.RegisterType((*HandleRequestArgs)(nil), "pb.HandleRequestArgs")
	proto.RegisterType((*HandleRequestReply)(nil), "pb.HandleRequestReply")
	proto.RegisterType((*SpecialPathsReply)(nil), "pb.SpecialPathsReply")
	proto.RegisterType((*HandleExistenceCheckArgs)(nil), "pb.HandleExistenceCheckArgs")
	proto.RegisterType((*HandleExistenceCheckReply)(nil), "pb.HandleExistenceCheckReply")
	proto.RegisterType((*SetupArgs)(nil), "pb.SetupArgs")
	proto.RegisterType((*SetupReply)(nil), "pb.SetupReply")
	proto.RegisterType((*TypeReply)(nil), "pb.TypeReply")
	proto.RegisterType((*InvalidateKeyArgs)(nil), "pb.InvalidateKeyArgs")
	proto.RegisterType((*StorageEntry)(nil), "pb.StorageEntry")
	proto.RegisterType((*StorageListArgs)(nil), "pb.StorageListArgs")
	proto.RegisterType((*StorageListReply)(nil), "pb.StorageListReply")
	proto.RegisterType((*StorageGetArgs)(nil), "pb.StorageGetArgs")
	proto.RegisterType((*StorageGetReply)(nil), "pb.StorageGetReply")
	proto.RegisterType((*StoragePutArgs)(nil), "pb.StoragePutArgs")
	proto.RegisterType((*StoragePutReply)(nil), "pb.StoragePutReply")
	proto.RegisterType((*StorageDeleteArgs)(nil), "pb.StorageDeleteArgs")
	proto.RegisterType((*StorageDeleteReply)(nil), "pb.StorageDeleteReply")
	proto.RegisterType((*TTLReply)(nil), "pb.TTLReply")
	proto.RegisterType((*SudoPrivilegeArgs)(nil), "pb.SudoPrivilegeArgs")
	proto.RegisterType((*SudoPrivilegeReply)(nil), "pb.SudoPrivilegeReply")
	proto.RegisterType((*TaintedReply)(nil), "pb.TaintedReply")
	proto.RegisterType((*CachingDisabledReply)(nil), "pb.CachingDisabledReply")
	proto.RegisterType((*ReplicationStateReply)(nil), "pb.ReplicationStateReply")
	proto.RegisterType((*ResponseWrapDataArgs)(nil), "pb.ResponseWrapDataArgs")
	proto.RegisterType((*ResponseWrapDataReply)(nil), "pb.ResponseWrapDataReply")
	proto.RegisterType((*MlockEnabledReply)(nil), "pb.MlockEnabledReply")
	proto.RegisterType((*LocalMountReply)(nil), "pb.LocalMountReply")
	proto.RegisterType((*Connection)(nil), "pb.Connection")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Backend service

type BackendClient interface {
	// HandleRequest is used to handle a request and generate a response.
	// The plugins must check the operation type and handle appropriately.
	HandleRequest(ctx context.Context, in *HandleRequestArgs, opts ...grpc.CallOption) (*HandleRequestReply, error)
	// SpecialPaths is a list of paths that are special in some way.
	// See PathType for the types of special paths. The key is the type
	// of the special path, and the value is a list of paths for this type.
	// This is not a regular expression but is an exact match. If the path
	// ends in '*' then it is a prefix-based match. The '*' can only appear
	// at the end.
	SpecialPaths(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SpecialPathsReply, error)
	// HandleExistenceCheck is used to handle a request and generate a response
	// indicating whether the given path exists or not; this is used to
	// understand whether the request must have a Create or Update capability
	// ACL applied. The first bool indicates whether an existence check
	// function was found for the backend; the second indicates whether, if an
	// existence check function was found, the item exists or not.
	HandleExistenceCheck(ctx context.Context, in *HandleExistenceCheckArgs, opts ...grpc.CallOption) (*HandleExistenceCheckReply, error)
	// Cleanup is invoked during an unmount of a backend to allow it to
	// handle any cleanup like connection closing or releasing of file handles.
	// Cleanup is called right before Vault closes the plugin process.
	Cleanup(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	// InvalidateKey may be invoked when an object is modified that belongs
	// to the backend. The backend can use this to clear any caches or reset
	// internal state as needed.
	InvalidateKey(ctx context.Context, in *InvalidateKeyArgs, opts ...grpc.CallOption) (*Empty, error)
	// Setup is used to set up the backend based on the provided backend
	// configuration. The plugin's setup implementation should use the provided
	// broker_id to create a connection back to Vault for use with the Storage
	// and SystemView clients.
	Setup(ctx context.Context, in *SetupArgs, opts ...grpc.CallOption) (*SetupReply, error)
	// Type returns the BackendType for the particular backend
	Type(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TypeReply, error)
}

type backendClient struct {
	cc *grpc.ClientConn
}

func NewBackendClient(cc *grpc.ClientConn) BackendClient {
	return &backendClient{cc}
}

func (c *backendClient) HandleRequest(ctx context.Context, in *HandleRequestArgs, opts ...grpc.CallOption) (*HandleRequestReply, error) {
	out := new(HandleRequestReply)
	err := grpc.Invoke(ctx, "/pb.Backend/HandleRequest", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) SpecialPaths(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SpecialPathsReply, error) {
	out := new(SpecialPathsReply)
	err := grpc.Invoke(ctx, "/pb.Backend/SpecialPaths", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) HandleExistenceCheck(ctx context.Context, in *HandleExistenceCheckArgs, opts ...grpc.CallOption) (*HandleExistenceCheckReply, error) {
	out := new(HandleExistenceCheckReply)
	err := grpc.Invoke(ctx, "/pb.Backend/HandleExistenceCheck", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Cleanup(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := grpc.Invoke(ctx, "/pb.Backend/Cleanup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) InvalidateKey(ctx context.Context, in *InvalidateKeyArgs, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := grpc.Invoke(ctx, "/pb.Backend/InvalidateKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Setup(ctx context.Context, in *SetupArgs, opts ...grpc.CallOption) (*SetupReply, error) {
	out := new(SetupReply)
	err := grpc.Invoke(ctx, "/pb.Backend/Setup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Type(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TypeReply, error) {
	out := new(TypeReply)
	err := grpc.Invoke(ctx, "/pb.Backend/Type", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Backend service

type BackendServer interface {
	// HandleRequest is used to handle a request and generate a response.
	// The plugins must check the operation type and handle appropriately.
	HandleRequest(context.Context, *HandleRequestArgs) (*HandleRequestReply, error)
	// SpecialPaths is a list of paths that are special in some way.
	// See PathType for the types of special paths. The key is the type
	// of the special path, and the value is a list of paths for this type.
	// This is not a regular expression but is an exact match. If the path
	// ends in '*' then it is a prefix-based match. The '*' can only appear
	// at the end.
	SpecialPaths(context.Context, *Empty) (*SpecialPathsReply, error)
	// HandleExistenceCheck is used to handle a request and generate a response
	// indicating whether the given path exists or not; this is used to
	// understand whether the request must have a Create or Update capability
	// ACL applied. The first bool indicates whether an existence check
	// function was found for the backend; the second indicates whether, if an
	// existence check function was found, the item exists or not.
	HandleExistenceCheck(context.Context, *HandleExistenceCheckArgs) (*HandleExistenceCheckReply, error)
	// Cleanup is invoked during an unmount of a backend to allow it to
	// handle any cleanup like connection closing or releasing of file handles.
	// Cleanup is called right before Vault closes the plugin process.
	Cleanup(context.Context, *Empty) (*Empty, error)
	// InvalidateKey may be invoked when an object is modified that belongs
	// to the backend. The backend can use this to clear any caches or reset
	// internal state as needed.
	InvalidateKey(context.Context, *InvalidateKeyArgs) (*Empty, error)
	// Setup is used to set up the backend based on the provided backend
	// configuration. The plugin's setup implementation should use the provided
	// broker_id to create a connection back to Vault for use with the Storage
	// and SystemView clients.
	Setup(context.Context, *SetupArgs) (*SetupReply, error)
	// Type returns the BackendType for the particular backend
	Type(context.Context, *Empty) (*TypeReply, error)
}

func RegisterBackendServer(s *grpc.Server, srv BackendServer) {
	s.RegisterService(&_Backend_serviceDesc, srv)
}

func _Backend_HandleRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleRequestArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).HandleRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/HandleRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).HandleRequest(ctx, req.(*HandleRequestArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_SpecialPaths_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).SpecialPaths(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/SpecialPaths",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).SpecialPaths(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_HandleExistenceCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleExistenceCheckArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).HandleExistenceCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/HandleExistenceCheck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).HandleExistenceCheck(ctx, req.(*HandleExistenceCheckArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Cleanup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Cleanup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/Cleanup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Cleanup(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_InvalidateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InvalidateKeyArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).InvalidateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/InvalidateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).InvalidateKey(ctx, req.(*InvalidateKeyArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Setup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetupArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Setup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/Setup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Setup(ctx, req.(*SetupArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Type_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Type(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Backend/Type",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Type(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _Backend_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Backend",
	HandlerType: (*BackendServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleRequest",
			Handler:    _Backend_HandleRequest_Handler,
		},
		{
			MethodName: "SpecialPaths",
			Handler:    _Backend_SpecialPaths_Handler,
		},
		{
			MethodName: "HandleExistenceCheck",
			Handler:    _Backend_HandleExistenceCheck_Handler,
		},
		{
			MethodName: "Cleanup",
			Handler:    _Backend_Cleanup_Handler,
		},
		{
			MethodName: "InvalidateKey",
			Handler:    _Backend_InvalidateKey_Handler,
		},
		{
			MethodName: "Setup",
			Handler:    _Backend_Setup_Handler,
		},
		{
			MethodName: "Type",
			Handler:    _Backend_Type_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "logical/plugin/pb/backend.proto",
}

// Client API for Storage service

type StorageClient interface {
	List(ctx context.Context, in *StorageListArgs, opts ...grpc.CallOption) (*StorageListReply, error)
	Get(ctx context.Context, in *StorageGetArgs, opts ...grpc.CallOption) (*StorageGetReply, error)
	Put(ctx context.Context, in *StoragePutArgs, opts ...grpc.CallOption) (*StoragePutReply, error)
	Delete(ctx context.Context, in *StorageDeleteArgs, opts ...grpc.CallOption) (*StorageDeleteReply, error)
}

type storageClient struct {
	cc *grpc.ClientConn
}

func NewStorageClient(cc *grpc.ClientConn) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) List(ctx context.Context, in *StorageListArgs, opts ...grpc.CallOption) (*StorageListReply, error) {
	out := new(StorageListReply)
	err := grpc.Invoke(ctx, "/pb.Storage/List", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Get(ctx context.Context, in *StorageGetArgs, opts ...grpc.CallOption) (*StorageGetReply, error) {
	out := new(StorageGetReply)
	err := grpc.Invoke(ctx, "/pb.Storage/Get", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Put(ctx context.Context, in *StoragePutArgs, opts ...grpc.CallOption) (*StoragePutReply, error) {
	out := new(StoragePutReply)
	err := grpc.Invoke(ctx, "/pb.Storage/Put", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Delete(ctx context.Context, in *StorageDeleteArgs, opts ...grpc.CallOption) (*StorageDeleteReply, error) {
	out := new(StorageDeleteReply)
	err := grpc.Invoke(ctx, "/pb.Storage/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Storage service

type StorageServer interface {
	List(context.Context, *StorageListArgs) (*StorageListReply, error)
	Get(context.Context, *StorageGetArgs) (*StorageGetReply, error)
	Put(context.Context, *StoragePutArgs) (*StoragePutReply, error)
	Delete(context.Context, *StorageDeleteArgs) (*StorageDeleteReply, error)
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

func _Storage_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageListArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Storage/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).List(ctx, req.(*StorageListArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageGetArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Storage/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Get(ctx, req.(*StorageGetArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Put_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoragePutArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Put(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Storage/Put",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Put(ctx, req.(*StoragePutArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageDeleteArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Storage/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Delete(ctx, req.(*StorageDeleteArgs))
	}
	return interceptor(ctx, in, info, handler)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _Storage_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Storage_Get_Handler,
		},
		{
			MethodName: "Put",
			Handler:    _Storage_Put_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Storage_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "logical/plugin/pb/backend.proto",
}

// Client API for SystemView service

type SystemViewClient interface {
	// DefaultLeaseTTL returns the default lease TTL set in Vault configuration
	DefaultLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error)
	// MaxLeaseTTL returns the max lease TTL set in Vault configuration; backend
	// authors should take care not to issue credentials that last longer than
	// this value, as Vault will revoke them
	MaxLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error)
	// SudoPrivilege returns true if given path has sudo privileges
	// for the given client token
	SudoPrivilege(ctx context.Context, in *SudoPrivilegeArgs, opts ...grpc.CallOption) (*SudoPrivilegeReply, error)
	// Tainted, returns true if the mount is tainted. A mount is tainted if it is in the
	// process of being unmounted. This should only be used in special
	// circumstances; a primary use-case is as a guard in revocation functions.
	// If revocation of a backend's leases fails it can keep the unmounting
	// process from being successful. If the reason for this failure is not
	// relevant when the mount is tainted (for instance, saving a CRL to disk
	// when the stored CRL will be removed during the unmounting process
	// anyways), we can ignore the errors to allow unmounting to complete.
	Tainted(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TaintedReply, error)
	// CachingDisabled returns true if caching is disabled. If true, no caches
	// should be used, despite known slowdowns.
	CachingDisabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CachingDisabledReply, error)
	// ReplicationState indicates the state of cluster replication
	ReplicationState(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ReplicationStateReply, error)
	// ResponseWrapData wraps the given data in a cubbyhole and returns the
	// token used to unwrap.
	ResponseWrapData(ctx context.Context, in *ResponseWrapDataArgs, opts ...grpc.CallOption) (*ResponseWrapDataReply, error)
	// MlockEnabled returns the configuration setting for enabling mlock on
	// plugins.
	MlockEnabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*MlockEnabledReply, error)
	// LocalMount, when run from a system view attached to a request, indicates
	// whether the request is affecting a local mount or not
	LocalMount(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*LocalMountReply, error)
}

type systemViewClient struct {
	cc *grpc.ClientConn
}

func NewSystemViewClient(cc *grpc.ClientConn) SystemViewClient {
	return &systemViewClient{cc}
}

func (c *systemViewClient) DefaultLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error) {
	out := new(TTLReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/DefaultLeaseTTL", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) MaxLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error) {
	out := new(TTLReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/MaxLeaseTTL", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) SudoPrivilege(ctx context.Context, in *SudoPrivilegeArgs, opts ...grpc.CallOption) (*SudoPrivilegeReply, error) {
	out := new(SudoPrivilegeReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/SudoPrivilege", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) Tainted(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TaintedReply, error) {
	out := new(TaintedReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/Tainted", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) CachingDisabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CachingDisabledReply, error) {
	out := new(CachingDisabledReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/CachingDisabled", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) ReplicationState(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ReplicationStateReply, error) {
	out := new(ReplicationStateReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/ReplicationState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) ResponseWrapData(ctx context.Context, in *ResponseWrapDataArgs, opts ...grpc.CallOption) (*ResponseWrapDataReply, error) {
	out := new(ResponseWrapDataReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/ResponseWrapData", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) MlockEnabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*MlockEnabledReply, error) {
	out := new(MlockEnabledReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/MlockEnabled", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) LocalMount(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*LocalMountReply, error) {
	out := new(LocalMountReply)
	err := grpc.Invoke(ctx, "/pb.SystemView/LocalMount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for SystemView service

type SystemViewServer interface {
	// DefaultLeaseTTL returns the default lease TTL set in Vault configuration
	DefaultLeaseTTL(context.Context, *Empty) (*TTLReply, error)
	// MaxLeaseTTL returns the max lease TTL set in Vault configuration; backend
	// authors should take care not to issue credentials that last longer than
	// this value, as Vault will revoke them
	MaxLeaseTTL(context.Context, *Empty) (*TTLReply, error)
	// SudoPrivilege returns true if given path has sudo privileges
	// for the given client token
	SudoPrivilege(context.Context, *SudoPrivilegeArgs) (*SudoPrivilegeReply, error)
	// Tainted, returns true if the mount is tainted. A mount is tainted if it is in the
	// process of being unmounted. This should only be used in special
	// circumstances; a primary use-case is as a guard in revocation functions.
	// If revocation of a backend's leases fails it can keep the unmounting
	// process from being successful. If the reason for this failure is not
	// relevant when the mount is tainted (for instance, saving a CRL to disk
	// when the stored CRL will be removed during the unmounting process
	// anyways), we can ignore the errors to allow unmounting to complete.
	Tainted(context.Context, *Empty) (*TaintedReply, error)
	// CachingDisabled returns true if caching is disabled. If true, no caches
	// should be used, despite known slowdowns.
	CachingDisabled(context.Context, *Empty) (*CachingDisabledReply, error)
	// ReplicationState indicates the state of cluster replication
	ReplicationState(context.Context, *Empty) (*ReplicationStateReply, error)
	// ResponseWrapData wraps the given data in a cubbyhole and returns the
	// token used to unwrap.
	ResponseWrapData(context.Context, *ResponseWrapDataArgs) (*ResponseWrapDataReply, error)
	// MlockEnabled returns the configuration setting for enabling mlock on
	// plugins.
	MlockEnabled(context.Context, *Empty) (*MlockEnabledReply, error)
	// LocalMount, when run from a system view attached to a request, indicates
	// whether the request is affecting a local mount or not
	LocalMount(context.Context, *Empty) (*LocalMountReply, error)
}

func RegisterSystemViewServer(s *grpc.Server, srv SystemViewServer) {
	s.RegisterService(&_SystemView_serviceDesc, srv)
}

func _SystemView_DefaultLeaseTTL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).DefaultLeaseTTL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/DefaultLeaseTTL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).DefaultLeaseTTL(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_MaxLeaseTTL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).MaxLeaseTTL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/MaxLeaseTTL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).MaxLeaseTTL(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_SudoPrivilege_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SudoPrivilegeArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).SudoPrivilege(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/SudoPrivilege",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).SudoPrivilege(ctx, req.(*SudoPrivilegeArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_Tainted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).Tainted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/Tainted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).Tainted(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_CachingDisabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).CachingDisabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/CachingDisabled",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).CachingDisabled(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_ReplicationState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).ReplicationState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/ReplicationState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).ReplicationState(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_ResponseWrapData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResponseWrapDataArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).ResponseWrapData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/ResponseWrapData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).ResponseWrapData(ctx, req.(*ResponseWrapDataArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_MlockEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).MlockEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/MlockEnabled",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).MlockEnabled(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_LocalMount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).LocalMount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.SystemView/LocalMount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).LocalMount(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _SystemView_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.SystemView",
	HandlerType: (*SystemViewServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DefaultLeaseTTL",
			Handler:    _SystemView_DefaultLeaseTTL_Handler,
		},
		{
			MethodName: "MaxLeaseTTL",
			Handler:    _SystemView_MaxLeaseTTL_Handler,
		},
		{
			MethodName: "SudoPrivilege",
			Handler:    _SystemView_SudoPrivilege_Handler,
		},
		{
			MethodName: "Tainted",
			Handler:    _SystemView_Tainted_Handler,
		},
		{
			MethodName: "CachingDisabled",
			Handler:    _SystemView_CachingDisabled_Handler,
		},
		{
			MethodName: "ReplicationState",
			Handler:    _SystemView_ReplicationState_Handler,
		},
		{
			MethodName: "ResponseWrapData",
			Handler:    _SystemView_ResponseWrapData_Handler,
		},
		{
			MethodName: "MlockEnabled",
			Handler:    _SystemView_MlockEnabled_Handler,
		},
		{
			MethodName: "LocalMount",
			Handler:    _SystemView_LocalMount_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "logical/plugin/pb/backend.proto",
}

func init() { proto.RegisterFile("logical/plugin/pb/backend.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2085 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x5b, 0x73, 0xdb, 0xc6,
	0xf5, 0x1f, 0x92, 0x22, 0x09, 0x1e, 0x92, 0xba, 0xac, 0x65, 0xff, 0x21, 0xda, 0xf9, 0x8b, 0x45,
	0xc6, 0x0a, 0xe3, 0xa9, 0x29, 0x9b, 0xbd, 0x39, 0xed, 0x24, 0x1d, 0x55, 0x56, 0x1c, 0x35, 0x52,
	0xa2, 0x81, 0xd4, 0xa6, 0x9d, 0x76, 0x86, 0x59, 0x01, 0x47, 0x14, 0x46, 0x20, 0x80, 0x2e, 0x16,
	0x92, 0xf9, 0xd4, 0x6f, 0x91, 0x7e, 0x9c, 0xbe, 0x76, 0xa6, 0xcf, 0xfd, 0x04, 0x7d, 0xef, 0x43,
	0x3f, 0x41, 0x67, 0x2f, 0x00, 0x17, 0x24, 0x55, 0xbb, 0x33, 0xed, 0xdb, 0x9e, 0xcb, 0xee, 0xb9,
	0xe0, 0x9c, 0xdf, 0xd9, 0x05, 0xec, 0x86, 0xf1, 0x24, 0xf0, 0x68, 0xb8, 0x9f, 0x84, 0xd9, 0x24,
	0x88, 0xf6, 0x93, 0xcb, 0xfd, 0x4b, 0xea, 0xdd, 0x60, 0xe4, 0x0f, 0x13, 0x16, 0xf3, 0x98, 0x54,
	0x93, 0xcb, 0xde, 0xee, 0x24, 0x8e, 0x27, 0x21, 0xee, 0x4b, 0xce, 0x65, 0x76, 0xb5, 0xcf, 0x83,
	0x29, 0xa6, 0x9c, 0x4e, 0x13, 0xa5, 0xe4, 0x34, 0xa1, 0x7e, 0x34, 0x4d, 0xf8, 0xcc, 0xe9, 0x43,
	0xe3, 0x0b, 0xa4, 0x3e, 0x32, 0xf2, 0x08, 0x1a, 0xd7, 0x72, 0x65, 0x57, 0xfa, 0xb5, 0x41, 0xcb,
	0xd5, 0x94, 0xf3, 0x3b, 0x80, 0x33, 0xb1, 0xe7, 0x88, 0xb1, 0x98, 0x91, 0x1d, 0xb0, 0x90, 0xb1,
	0x31, 0x9f, 0x25, 0x68, 0x57, 0xfa, 0x95, 0x41, 0xd7, 0x6d, 0x22, 0x63, 0x17, 0xb3, 0x04, 0xc9,
	0xff, 0x81, 0x58, 0x8e, 0xa7, 0xe9, 0xc4, 0xae, 0xf6, 0x2b, 0xe2, 0x04, 0x64, 0xec, 0x34, 0x9d,
	0xe4, 0x7b, 0xbc, 0xd8, 0x47, 0xbb, 0xd6, 0xaf, 0x0c, 0x6a, 0x72, 0xcf, 0x61, 0xec, 0xa3, 0xf3,
	0x5d, 0x05, 0xea, 0x67, 0x94, 0x5f, 0xa7, 0x84, 0xc0, 0x1a, 0x8b, 0x63, 0xae, 0x8d, 0xcb, 0x35,
	0x19, 0xc0, 0x46, 0x16, 0xd1, 0x8c, 0x5f, 0x63, 0xc4, 0x03, 0x8f, 0x72, 0xf4, 0xed, 0xaa, 0x14,
	0x2f, 0xb2, 0xc9, 0x87, 0xd0, 0x0d, 0x63, 0x8f, 0x86, 0xe3, 0x94, 0xc7, 0x8c, 0x4e, 0x84, 0x1d,
	0xa1, 0xd7, 0x91, 0xcc, 0x73, 0xc5, 0x23, 0xcf, 0x60, 0x2b, 0x45, 0x1a, 0x8e, 0xef, 0x18, 0x4d,
	0x0a, 0xc5, 0x35, 0x75, 0xa0, 0x10, 0x7c, 0xc3, 0x68, 0xa2, 0x75, 0x9d, 0x3f, 0x37, 0xa0, 0xe9,
	0xe2, 0x1f, 0x32, 0x4c, 0x39, 0x59, 0x87, 0x6a, 0xe0, 0xcb, 0x68, 0x5b, 0x6e, 0x35, 0xf0, 0xc9,
	0x10, 0x88, 0x8b, 0x49, 0x28, 0x4c, 0x07, 0x71, 0x74, 0x18, 0x66, 0x29, 0x47, 0xa6, 0x63, 0x5e,
	0x21, 0x21, 0x4f, 0xa0, 0x15, 0x27, 0xc8, 0x24, 0x4f, 0x26, 0xa0, 0xe5, 0xce, 0x19, 0x22, 0xf0,
	0x84, 0xf2, 0x6b, 0x7b, 0x4d, 0x0a, 0xe4, 0x5a, 0xf0, 0x7c, 0xca, 0xa9, 0x5d, 0x57, 0x3c, 0xb1,
	0x26, 0x0e, 0x34, 0x52, 0xf4, 0x18, 0x72, 0xbb, 0xd1, 0xaf, 0x0c, 0xda, 0x23, 0x18, 0x26, 0x97,
	0xc3, 0x73, 0xc9, 0x71, 0xb5, 0x84, 0x3c, 0x81, 0x35, 0x91, 0x17, 0xbb, 0x29, 0x35, 0x2c, 0xa1,
	0x71, 0x90, 0xf1, 0x6b, 0x57, 0x72, 0xc9, 0x08, 0x9a, 0xea, 0x9b, 0xa6, 0xb6, 0xd5, 0xaf, 0x0d,
	0xda, 0x23, 0x5b, 0x28, 0xe8, 0x28, 0x87, 0xaa, 0x0c, 0xd2, 0xa3, 0x88, 0xb3, 0x99, 0x9b, 0x2b,
	0x92, 0xef, 0x41, 0xc7, 0x0b, 0x03, 0x8c, 0xf8, 0x98, 0xc7, 0x37, 0x18, 0xd9, 0x2d, 0xe9, 0x51,
	0x5b, 0xf1, 0x2e, 0x04, 0x8b, 0x8c, 0xe0, 0xa1, 0xa9, 0x32, 0xa6, 0x9e, 0x87, 0x69, 0x1a, 0x33,
	0x1b, 0xa4, 0xee, 0x03, 0x43, 0xf7, 0x40, 0x8b, 0xc4, 0xb1, 0x7e, 0x90, 0x26, 0x21, 0x9d, 0x8d,
	0x23, 0x3a, 0x45, 0xbb, 0xad, 0x8e, 0xd5, 0xbc, 0xaf, 0xe8, 0x14, 0xc9, 0x2e, 0xb4, 0xa7, 0x71,
	0x16, 0xf1, 0x71, 0x12, 0x07, 0x11, 0xb7, 0x3b, 0x52, 0x03, 0x24, 0xeb, 0x4c, 0x70, 0xc8, 0x07,
	0xa0, 0x28, 0x55, 0x8c, 0x5d, 0x95, 0x57, 0xc9, 0x91, 0xe5, 0xf8, 0x14, 0xd6, 0x95, 0xb8, 0xf0,
	0x67, 0x5d, 0xaa, 0x74, 0x25, 0xb7, 0xf0, 0xe4, 0x05, 0xb4, 0x64, 0x3d, 0x04, 0xd1, 0x55, 0x6c,
	0x6f, 0xc8, 0xbc, 0x3d, 0x30, 0xd2, 0x22, 0x6a, 0xe2, 0x38, 0xba, 0x8a, 0x5d, 0xeb, 0x4e, 0xaf,
	0xc8, 0xa7, 0xf0, 0xb8, 0x14, 0x2f, 0xc3, 0x29, 0x0d, 0xa2, 0x20, 0x9a, 0x8c, 0xb3, 0x14, 0x53,
	0x7b, 0x53, 0x56, 0xb8, 0x6d, 0x44, 0xed, 0xe6, 0x0a, 0xbf, 0x4a, 0x31, 0x25, 0x8f, 0xa1, 0x25,
	0xea, 0x96, 0xcf, 0xc6, 0x81, 0x6f, 0x6f, 0x49, 0x97, 0x2c, 0xc5, 0x38, 0xf6, 0xc9, 0x47, 0xb0,
	0x91, 0xc4, 0x61, 0xe0, 0xcd, 0xc6, 0xf1, 0x2d, 0x32, 0x16, 0xf8, 0x68, 0x93, 0x7e, 0x65, 0x60,
	0xb9, 0xeb, 0x8a, 0xfd, 0xb5, 0xe6, 0xae, 0x6a, 0x8d, 0x07, 0x52, 0x71, 0xa9, 0x35, 0x86, 0x00,
	0x5e, 0x1c, 0x45, 0xe8, 0xc9, 0xf2, 0xdb, 0x96, 0x11, 0xae, 0x8b, 0x08, 0x0f, 0x0b, 0xae, 0x6b,
	0x68, 0xf4, 0x3e, 0x87, 0x8e, 0x59, 0x0a, 0x64, 0x13, 0x6a, 0x37, 0x38, 0xd3, 0xe5, 0x2f, 0x96,
	0xa4, 0x0f, 0xf5, 0x5b, 0x1a, 0x66, 0x28, 0x4b, 0x5e, 0x17, 0xa2, 0xda, 0xe2, 0x2a, 0xc1, 0x4f,
	0xab, 0xaf, 0x2a, 0x0e, 0x85, 0xfa, 0x41, 0x18, 0xd0, 0x74, 0xe1, 0x3b, 0x55, 0xde, 0xfd, 0x9d,
	0xaa, 0xab, 0xbe, 0x13, 0x81, 0x35, 0x59, 0x29, 0xaa, 0x7f, 0xe4, 0xda, 0xf9, 0x67, 0x0d, 0xd6,
	0x44, 0x7d, 0x93, 0x1f, 0x41, 0x37, 0x44, 0x9a, 0xe2, 0x38, 0x4e, 0x44, 0x0c, 0xa9, 0xb4, 0xd2,
	0x1e, 0x6d, 0x0a, 0xcf, 0x4e, 0x84, 0xe0, 0x6b, 0xc5, 0x77, 0x3b, 0xa1, 0x41, 0x09, 0xd4, 0x08,
	0x22, 0x8e, 0x2c, 0xa2, 0xe1, 0x58, 0xf6, 0x9b, 0xb2, 0xdc, 0xc9, 0x99, 0xaf, 0x45, 0xdf, 0x2d,
	0x96, 0x6a, 0x6d, 0xb9, 0x54, 0x7b, 0x60, 0xc9, 0xcf, 0x13, 0x60, 0xaa, 0xf1, 0xa4, 0xa0, 0xc9,
	0x08, 0xac, 0x29, 0x72, 0xaa, 0xdb, 0x59, 0x74, 0xdd, 0xa3, 0xbc, 0x2d, 0x87, 0xa7, 0x5a, 0xa0,
	0x7a, 0xae, 0xd0, 0x5b, 0x6a, 0xba, 0xc6, 0x72, 0xd3, 0xf5, 0xc0, 0x2a, 0xf2, 0xd5, 0x54, 0x45,
	0x94, 0xd3, 0x02, 0xc9, 0x13, 0x64, 0x41, 0xec, 0xdb, 0x96, 0xac, 0x45, 0x4d, 0x09, 0x1c, 0x8e,
	0xb2, 0xa9, 0xaa, 0xd2, 0x96, 0xc2, 0xe1, 0x28, 0x9b, 0x2e, 0x17, 0x25, 0x2c, 0x14, 0xe5, 0x2e,
	0xd4, 0xa9, 0xf8, 0x92, 0xb2, 0x4b, 0xdb, 0xa3, 0x96, 0xf4, 0x5f, 0x30, 0x5c, 0xc5, 0x27, 0x43,
	0xe8, 0x4e, 0x58, 0x9c, 0x25, 0x63, 0x49, 0x62, 0x6a, 0x77, 0x64, 0xa0, 0x86, 0x62, 0x47, 0xca,
	0x0f, 0x94, 0xb8, 0xf7, 0x33, 0xe8, 0x96, 0x42, 0x5f, 0x51, 0x63, 0xdb, 0x66, 0x8d, 0xb5, 0xcc,
	0xba, 0xfa, 0x53, 0x05, 0x3a, 0xe6, 0x37, 0x15, 0x9b, 0x2f, 0x2e, 0x4e, 0xe4, 0xe6, 0x9a, 0x2b,
	0x96, 0x02, 0x70, 0x19, 0x46, 0x78, 0x47, 0x2f, 0x43, 0x75, 0x80, 0xe5, 0xce, 0x19, 0x42, 0x1a,
	0x44, 0x1e, 0xc3, 0x29, 0x46, 0x5c, 0xcf, 0xa3, 0x39, 0x83, 0x7c, 0x02, 0x10, 0xa4, 0x69, 0x86,
	0x63, 0x31, 0x32, 0x25, 0x28, 0xb7, 0x47, 0xbd, 0xa1, 0x9a, 0xa7, 0xc3, 0x7c, 0x9e, 0x0e, 0x2f,
	0xf2, 0x79, 0xea, 0xb6, 0xa4, 0xb6, 0xa0, 0x9d, 0x3f, 0x42, 0x43, 0xe1, 0xf1, 0xff, 0xb4, 0x1e,
	0x77, 0xc0, 0x52, 0x67, 0x07, 0xbe, 0xae, 0xc5, 0xa6, 0xa4, 0x8f, 0x7d, 0xe7, 0xaf, 0x15, 0xb0,
	0x5c, 0x4c, 0x93, 0x38, 0x4a, 0xd1, 0x98, 0x17, 0x95, 0x77, 0xce, 0x8b, 0xea, 0xca, 0x79, 0x91,
	0x4f, 0xa1, 0x9a, 0x31, 0x85, 0x7a, 0x60, 0x31, 0xf4, 0x03, 0x86, 0x1e, 0xd7, 0x13, 0xab, 0xa0,
	0x85, 0xec, 0x8e, 0x32, 0x01, 0x74, 0xa9, 0x2c, 0xf5, 0x96, 0x5b, 0xd0, 0xe4, 0xa5, 0x09, 0xb3,
	0x6a, 0x80, 0x6d, 0x2b, 0x98, 0x55, 0xee, 0x2e, 0xe3, 0xac, 0xf3, 0x97, 0x2a, 0x6c, 0x2e, 0x8a,
	0x57, 0x7c, 0xec, 0x6d, 0xa8, 0xab, 0x2e, 0xd1, 0x95, 0xc2, 0x97, 0xfa, 0xa3, 0xb6, 0xd0, 0x1f,
	0x3f, 0x87, 0xae, 0xc7, 0x50, 0x4e, 0xdf, 0xf7, 0xfd, 0xca, 0x9d, 0x7c, 0x83, 0x60, 0x91, 0x8f,
	0x61, 0x53, 0x78, 0x99, 0xa0, 0x3f, 0x07, 0x2d, 0x35, 0xaa, 0x37, 0x34, 0xbf, 0x80, 0xad, 0x67,
	0xb0, 0x95, 0xab, 0xce, 0x1b, 0xac, 0x51, 0xd2, 0x3d, 0xca, 0xfb, 0xec, 0x11, 0x34, 0xae, 0x62,
	0x36, 0xa5, 0x5c, 0x77, 0xb4, 0xa6, 0x44, 0x59, 0x14, 0xfe, 0xca, 0xab, 0x82, 0xa5, 0xca, 0x22,
	0x67, 0x8a, 0x0b, 0x94, 0xe8, 0xe0, 0xe2, 0x72, 0x23, 0xbb, 0xdb, 0x72, 0xad, 0xfc, 0x52, 0xe3,
	0xfc, 0x06, 0x36, 0x16, 0xe6, 0xd9, 0x8a, 0x44, 0xce, 0xcd, 0x57, 0x4b, 0xe6, 0x4b, 0x27, 0xd7,
	0x16, 0x4e, 0xfe, 0x2d, 0x6c, 0x7d, 0x41, 0x23, 0x3f, 0x44, 0x7d, 0xfe, 0x01, 0x9b, 0x48, 0xc4,
	0xd7, 0xd7, 0xab, 0xb1, 0xbe, 0x38, 0x75, 0xdd, 0x96, 0xe6, 0x1c, 0xfb, 0xe4, 0x29, 0x34, 0x99,
	0xd2, 0xd6, 0x85, 0xd7, 0x36, 0x06, 0xae, 0x9b, 0xcb, 0x9c, 0x6f, 0x81, 0x94, 0x8e, 0x16, 0x37,
	0xab, 0x19, 0x19, 0x88, 0x02, 0x54, 0x45, 0xa1, 0x0b, 0xbb, 0x63, 0xd6, 0x91, 0x5b, 0x48, 0x49,
	0x1f, 0x6a, 0xc8, 0x98, 0x36, 0x21, 0x27, 0xde, 0xfc, 0x1e, 0xeb, 0x0a, 0x91, 0xf3, 0x43, 0xd8,
	0x3a, 0x4f, 0xd0, 0x0b, 0x68, 0x28, 0xef, 0xa0, 0xca, 0xc0, 0x2e, 0xd4, 0x45, 0x92, 0xf3, 0x9e,
	0x95, 0x20, 0xa6, 0xc4, 0x8a, 0xef, 0x7c, 0x0b, 0xb6, 0xf2, 0xeb, 0xe8, 0x6d, 0x90, 0x72, 0x8c,
	0x3c, 0x3c, 0xbc, 0x46, 0xef, 0xe6, 0xbf, 0x18, 0xf9, 0x2d, 0xec, 0xac, 0xb2, 0x90, 0xfb, 0xd7,
	0xf6, 0x04, 0x35, 0xbe, 0x8a, 0xb3, 0x48, 0xd9, 0xb0, 0x5c, 0x90, 0xac, 0xcf, 0x05, 0x47, 0x7c,
	0x47, 0x14, 0xfb, 0x52, 0x0d, 0x7d, 0x9a, 0xca, 0xf3, 0x51, 0xbb, 0x3f, 0x1f, 0xdf, 0x55, 0xa0,
	0x75, 0x8e, 0x3c, 0x4b, 0x64, 0x2c, 0x8f, 0xa1, 0x75, 0xc9, 0xe2, 0x1b, 0x64, 0xf3, 0x50, 0x2c,
	0xc5, 0x38, 0xf6, 0xc9, 0x4b, 0x68, 0x1c, 0xc6, 0xd1, 0x55, 0x30, 0x91, 0x37, 0xf2, 0xf6, 0x68,
	0x47, 0xa1, 0x8b, 0xde, 0x3b, 0x54, 0x32, 0x35, 0xd7, 0xb4, 0x62, 0xef, 0x13, 0x68, 0x1b, 0xec,
	0xff, 0x08, 0xf3, 0xff, 0x1f, 0x40, 0x9e, 0xad, 0x32, 0xb0, 0xa9, 0x02, 0xd1, 0x3b, 0x85, 0xe3,
	0xbb, 0xd0, 0x12, 0x77, 0x09, 0x25, 0x26, 0xb0, 0x66, 0x3c, 0x4f, 0xe4, 0xda, 0x79, 0x0a, 0x5b,
	0xc7, 0xd1, 0x2d, 0x0d, 0x03, 0x9f, 0x72, 0xfc, 0x12, 0x67, 0x32, 0xc0, 0x25, 0x0f, 0x9c, 0x73,
	0xe8, 0xe8, 0x07, 0xc0, 0x7b, 0xf9, 0xd8, 0xd1, 0x3e, 0xfe, 0xfb, 0x16, 0xf9, 0x18, 0x36, 0xf4,
	0xa1, 0x27, 0x81, 0x6e, 0x10, 0x31, 0xa1, 0x19, 0x5e, 0x05, 0x6f, 0xf5, 0xd1, 0x9a, 0x72, 0x5e,
	0xc1, 0xa6, 0xa1, 0x5a, 0x84, 0x73, 0x83, 0xb3, 0x34, 0x7f, 0x18, 0x89, 0x75, 0x9e, 0x81, 0xea,
	0x3c, 0x03, 0x0e, 0xac, 0xeb, 0x9d, 0x6f, 0x90, 0xdf, 0x13, 0xdd, 0x97, 0x85, 0x23, 0x6f, 0x50,
	0x1f, 0xbe, 0x07, 0x75, 0x14, 0x91, 0x9a, 0x03, 0xca, 0xcc, 0x80, 0xab, 0xc4, 0x2b, 0x0c, 0xbe,
	0x2a, 0x0c, 0x9e, 0x65, 0xca, 0xe0, 0x7b, 0x9e, 0xe5, 0x7c, 0x58, 0xb8, 0x71, 0x96, 0xf1, 0xfb,
	0xbe, 0xe8, 0x53, 0xd8, 0xd2, 0x4a, 0xaf, 0x31, 0x44, 0x8e, 0xf7, 0x84, 0xb4, 0x07, 0xa4, 0xa4,
	0x76, 0xdf, 0x71, 0x4f, 0xc0, 0xba, 0xb8, 0x38, 0x29, 0xa4, 0x65, 0xe4, 0x73, 0x3e, 0x85, 0xad,
	0xf3, 0xcc, 0x8f, 0xcf, 0x58, 0x70, 0x1b, 0x84, 0x38, 0x51, 0xc6, 0xf2, 0x77, 0x59, 0xc5, 0x78,
	0x97, 0xad, 0x9c, 0x35, 0xce, 0x00, 0x48, 0x69, 0x7b, 0xf1, 0xdd, 0xd2, 0xcc, 0x8f, 0x75, 0x83,
	0xca, 0xb5, 0x33, 0x80, 0xce, 0x05, 0x15, 0xd3, 0xdc, 0x57, 0x3a, 0x36, 0x34, 0xb9, 0xa2, 0xb5,
	0x5a, 0x4e, 0x3a, 0x23, 0xd8, 0x3e, 0xa4, 0xde, 0x75, 0x10, 0x4d, 0x5e, 0x07, 0xa9, 0xb8, 0xb6,
	0xe8, 0x1d, 0x3d, 0xb0, 0x7c, 0xcd, 0xd0, 0x5b, 0x0a, 0xda, 0x79, 0x0e, 0x0f, 0x8d, 0xd7, 0xe7,
	0x39, 0xa7, 0x79, 0x3e, 0xb6, 0xa1, 0x9e, 0x0a, 0x4a, 0xee, 0xa8, 0xbb, 0x8a, 0x70, 0xbe, 0x82,
	0x6d, 0x73, 0xbc, 0x8a, 0xcb, 0x45, 0x1e, 0xb8, 0x1c, 0xfb, 0x15, 0x63, 0xec, 0xeb, 0x9c, 0x55,
	0xe7, 0xd3, 0x62, 0x13, 0x6a, 0xbf, 0xfc, 0xe6, 0x42, 0x17, 0xbb, 0x58, 0x3a, 0xbf, 0x17, 0xe6,
	0xcb, 0xe7, 0x29, 0xf3, 0xa5, 0xd9, 0x5f, 0x79, 0x9f, 0xd9, 0xbf, 0xa2, 0xde, 0x9e, 0xc3, 0xd6,
	0x69, 0x18, 0x7b, 0x37, 0x47, 0x91, 0x91, 0x0d, 0x1b, 0x9a, 0x18, 0x99, 0xc9, 0xc8, 0x49, 0xe7,
	0x23, 0xd8, 0x38, 0x11, 0x6f, 0xff, 0x53, 0xf1, 0x88, 0x28, 0xb2, 0x20, 0x7f, 0x07, 0x68, 0x55,
	0x45, 0x38, 0xcf, 0x01, 0xe6, 0x0f, 0x21, 0x01, 0xae, 0x0c, 0xa7, 0x31, 0xc7, 0x31, 0xf5, 0xfd,
	0xbc, 0x82, 0x40, 0xb1, 0x0e, 0x7c, 0x9f, 0x8d, 0xfe, 0x51, 0x85, 0xe6, 0x2f, 0xd4, 0xff, 0x16,
	0xf2, 0x19, 0x74, 0x4b, 0x03, 0x8a, 0x3c, 0x94, 0x2f, 0xa1, 0xc5, 0x71, 0xd8, 0x7b, 0xb4, 0xc4,
	0x56, 0x0e, 0xbd, 0x80, 0x8e, 0x39, 0x7e, 0x88, 0x1c, 0x35, 0xf2, 0xb7, 0x4c, 0x4f, 0x9e, 0xb4,
	0x3c, 0x9b, 0xce, 0x61, 0x7b, 0xd5, 0x60, 0x20, 0x4f, 0xe6, 0x16, 0x96, 0x87, 0x52, 0xef, 0x83,
	0xfb, 0xa4, 0xf9, 0x40, 0x69, 0x1e, 0x86, 0x48, 0xa3, 0x2c, 0x31, 0x3d, 0x98, 0x2f, 0xc9, 0x4b,
	0xe8, 0x96, 0xc0, 0x53, 0xc5, 0xb9, 0x84, 0xa7, 0xe6, 0x96, 0x3d, 0xa8, 0x4b, 0xc0, 0x26, 0xdd,
	0xd2, 0x5c, 0xe8, 0xad, 0x17, 0xa4, 0xb2, 0xdd, 0x87, 0x35, 0xf9, 0x08, 0x34, 0x0c, 0xcb, 0x1d,
	0x05, 0x9a, 0x8f, 0xfe, 0x56, 0x81, 0x66, 0xfe, 0x03, 0xe7, 0x25, 0xac, 0x09, 0x5c, 0x24, 0x0f,
	0x0c, 0x68, 0xc9, 0x31, 0xb5, 0xb7, 0xbd, 0xc0, 0x54, 0x06, 0x86, 0x50, 0x7b, 0x83, 0x9c, 0x10,
	0x43, 0xa8, 0x01, 0xb2, 0xf7, 0xa0, 0xcc, 0x2b, 0xf4, 0xcf, 0xb2, 0xb2, 0xbe, 0xc6, 0xb7, 0x92,
	0x7e, 0x81, 0x5c, 0x3f, 0x81, 0x86, 0x42, 0x1e, 0x95, 0x94, 0x25, 0xcc, 0x52, 0x1f, 0x7f, 0x19,
	0xa3, 0x46, 0x7f, 0xaf, 0x01, 0x9c, 0xcf, 0x52, 0x8e, 0xd3, 0x5f, 0x07, 0x78, 0x47, 0x9e, 0xc1,
	0xc6, 0x6b, 0xbc, 0xa2, 0x59, 0xc8, 0xe5, 0xfb, 0x40, 0x74, 0x98, 0x91, 0x13, 0x79, 0xc5, 0x29,
	0x00, 0x6c, 0x0f, 0xda, 0xa7, 0xf4, 0xed, 0xbb, 0xf5, 0x3e, 0x83, 0x6e, 0x09, 0x97, 0xb4, 0x8b,
	0x8b, 0x48, 0xa7, 0x5d, 0x5c, 0x46, 0xb0, 0x3d, 0x68, 0x6a, 0xb4, 0x32, 0x6d, 0x48, 0x5c, 0x2f,
	0xa1, 0xd8, 0x8f, 0x61, 0x63, 0x01, 0xab, 0x4c, 0x7d, 0xf9, 0x93, 0x69, 0x25, 0x96, 0xbd, 0x12,
	0xf7, 0xfb, 0x32, 0x5e, 0x99, 0x1b, 0x77, 0x14, 0x46, 0xac, 0x02, 0xb4, 0x37, 0xe5, 0x97, 0x81,
	0x7c, 0x17, 0xd9, 0x8b, 0x90, 0x92, 0x03, 0x5a, 0x7e, 0xd0, 0x2a, 0x68, 0x7a, 0x01, 0x1d, 0x13,
	0x55, 0x96, 0x5a, 0x70, 0x19, 0x72, 0xbe, 0x0f, 0x30, 0x07, 0x16, 0x53, 0x5f, 0x96, 0xc7, 0x02,
	0xe6, 0x5c, 0x36, 0xe4, 0x5b, 0xe2, 0x07, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xe5, 0x31, 0x02,
	0x9d, 0xb6, 0x15, 0x00, 0x00,
}
