// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetDeviceMethodsInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceMethodsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceMethodsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDeviceMethodsInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDeviceMethodsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetDeviceMethodsOutput struct {
	_ struct{} `type:"structure"`

	// List of available device APIs.
	DeviceMethods []DeviceMethod `locationName:"deviceMethods" type:"list"`
}

// String returns the string representation
func (s GetDeviceMethodsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDeviceMethodsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceMethods != nil {
		v := s.DeviceMethods

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "deviceMethods", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetDeviceMethods = "GetDeviceMethods"

// GetDeviceMethodsRequest returns a request value for making API operation for
// AWS IoT 1-Click Devices Service.
//
// Given a device ID, returns the invokable methods associated with the device.
//
//    // Example sending a request using GetDeviceMethodsRequest.
//    req := client.GetDeviceMethodsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods
func (c *Client) GetDeviceMethodsRequest(input *GetDeviceMethodsInput) GetDeviceMethodsRequest {
	op := &aws.Operation{
		Name:       opGetDeviceMethods,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{deviceId}/methods",
	}

	if input == nil {
		input = &GetDeviceMethodsInput{}
	}

	req := c.newRequest(op, input, &GetDeviceMethodsOutput{})
	return GetDeviceMethodsRequest{Request: req, Input: input, Copy: c.GetDeviceMethodsRequest}
}

// GetDeviceMethodsRequest is the request type for the
// GetDeviceMethods API operation.
type GetDeviceMethodsRequest struct {
	*aws.Request
	Input *GetDeviceMethodsInput
	Copy  func(*GetDeviceMethodsInput) GetDeviceMethodsRequest
}

// Send marshals and sends the GetDeviceMethods API request.
func (r GetDeviceMethodsRequest) Send(ctx context.Context) (*GetDeviceMethodsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDeviceMethodsResponse{
		GetDeviceMethodsOutput: r.Request.Data.(*GetDeviceMethodsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDeviceMethodsResponse is the response type for the
// GetDeviceMethods API operation.
type GetDeviceMethodsResponse struct {
	*GetDeviceMethodsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDeviceMethods request.
func (r *GetDeviceMethodsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
