// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of application components.
	ApplicationComponentList []ApplicationComponent `type:"list"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListComponents = "ListComponents"

// ListComponentsRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Lists the auto-grouped, standalone, and custom components of the application.
//
//    // Example sending a request using ListComponentsRequest.
//    req := client.ListComponentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListComponents
func (c *Client) ListComponentsRequest(input *ListComponentsInput) ListComponentsRequest {
	op := &aws.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	req := c.newRequest(op, input, &ListComponentsOutput{})
	return ListComponentsRequest{Request: req, Input: input, Copy: c.ListComponentsRequest}
}

// ListComponentsRequest is the request type for the
// ListComponents API operation.
type ListComponentsRequest struct {
	*aws.Request
	Input *ListComponentsInput
	Copy  func(*ListComponentsInput) ListComponentsRequest
}

// Send marshals and sends the ListComponents API request.
func (r ListComponentsRequest) Send(ctx context.Context) (*ListComponentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListComponentsResponse{
		ListComponentsOutput: r.Request.Data.(*ListComponentsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListComponentsRequestPaginator returns a paginator for ListComponents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListComponentsRequest(input)
//   p := applicationinsights.NewListComponentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListComponentsPaginator(req ListComponentsRequest) ListComponentsPaginator {
	return ListComponentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListComponentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListComponentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListComponentsPaginator struct {
	aws.Pager
}

func (p *ListComponentsPaginator) CurrentPage() *ListComponentsOutput {
	return p.Pager.CurrentPage().(*ListComponentsOutput)
}

// ListComponentsResponse is the response type for the
// ListComponents API operation.
type ListComponentsResponse struct {
	*ListComponentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListComponents request.
func (r *ListComponentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
