// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object representing a container instance or task attachment.
type Attachment struct {
	_ struct{} `type:"structure"`

	// Details of the attachment. For elastic network interfaces, this includes
	// the network interface ID, the MAC address, the subnet ID, and the private
	// IPv4 address.
	Details []KeyValuePair `locationName:"details" type:"list"`

	// The unique identifier for the attachment.
	Id *string `locationName:"id" type:"string"`

	// The status of the attachment. Valid values are PRECREATED, CREATED, ATTACHING,
	// ATTACHED, DETACHING, DETACHED, and DELETED.
	Status *string `locationName:"status" type:"string"`

	// The type of the attachment, such as ElasticNetworkInterface.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// An object representing a change in state for a task attachment.
type AttachmentStateChange struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the attachment.
	//
	// AttachmentArn is a required field
	AttachmentArn *string `locationName:"attachmentArn" type:"string" required:"true"`

	// The status of the attachment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachmentStateChange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentStateChange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachmentStateChange"}

	if s.AttachmentArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttachmentArn"))
	}

	if s.Status == nil {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An attribute is a name-value pair associated with an Amazon ECS object. Attributes
// enable you to extend the Amazon ECS data model by adding custom metadata
// to your resources. For more information, see Attributes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes)
// in the Amazon Elastic Container Service Developer Guide.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute. Up to 128 letters (uppercase and lowercase), numbers,
	// hyphens, underscores, and periods are allowed.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ID of the target. You can specify the short form ID for a resource or
	// the full Amazon Resource Name (ARN).
	TargetId *string `locationName:"targetId" type:"string"`

	// The type of the target with which to attach the attribute. This parameter
	// is required if you use the short form ID for a resource instead of the full
	// ARN.
	TargetType TargetType `locationName:"targetType" type:"string" enum:"true"`

	// The value of the attribute. Up to 128 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, periods, at signs (@), forward slashes, colons,
	// and spaces are allowed.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Attribute"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details of the Auto Scaling group for the capacity provider.
type AutoScalingGroupProvider struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the Auto Scaling group.
	//
	// AutoScalingGroupArn is a required field
	AutoScalingGroupArn *string `locationName:"autoScalingGroupArn" type:"string" required:"true"`

	// The managed scaling settings for the Auto Scaling group capacity provider.
	ManagedScaling *ManagedScaling `locationName:"managedScaling" type:"structure"`

	// The managed termination protection setting to use for the Auto Scaling group
	// capacity provider. This determines whether the Auto Scaling group has managed
	// termination protection.
	//
	// When managed termination protection is enabled, Amazon ECS prevents the Amazon
	// EC2 instances in an Auto Scaling group that contain tasks from being terminated
	// during a scale-in action. The Auto Scaling group and each instance in the
	// Auto Scaling group must have instance protection from scale-in actions enabled
	// as well. For more information, see Instance Protection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
	// in the AWS Auto Scaling User Guide.
	//
	// When managed termination protection is disabled, your Amazon EC2 instances
	// are not protected from termination when the Auto Scaling group scales in.
	ManagedTerminationProtection ManagedTerminationProtection `locationName:"managedTerminationProtection" type:"string" enum:"true"`
}

// String returns the string representation
func (s AutoScalingGroupProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingGroupProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingGroupProvider"}

	if s.AutoScalingGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupArn"))
	}
	if s.ManagedScaling != nil {
		if err := s.ManagedScaling.Validate(); err != nil {
			invalidParams.AddNested("ManagedScaling", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing the networking details for a task or service.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether the task's elastic network interface receives a public IP address.
	// The default value is DISABLED.
	AssignPublicIp AssignPublicIp `locationName:"assignPublicIp" type:"string" enum:"true"`

	// The security groups associated with the task or service. If you do not specify
	// a security group, the default security group for the VPC is used. There is
	// a limit of 5 security groups that can be specified per AwsVpcConfiguration.
	//
	// All specified security groups must be from the same VPC.
	SecurityGroups []string `locationName:"securityGroups" type:"list"`

	// The subnets associated with the task or service. There is a limit of 16 subnets
	// that can be specified per AwsVpcConfiguration.
	//
	// All specified subnets must be from the same VPC.
	//
	// Subnets is a required field
	Subnets []string `locationName:"subnets" type:"list" required:"true"`
}

// String returns the string representation
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsVpcConfiguration"}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details of a capacity provider.
type CapacityProvider struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling group settings for the capacity provider.
	AutoScalingGroupProvider *AutoScalingGroupProvider `locationName:"autoScalingGroupProvider" type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the capacity provider.
	CapacityProviderArn *string `locationName:"capacityProviderArn" type:"string"`

	// The name of the capacity provider.
	Name *string `locationName:"name" type:"string"`

	// The current status of the capacity provider. Only capacity providers in an
	// ACTIVE state can be used in a cluster.
	Status CapacityProviderStatus `locationName:"status" type:"string" enum:"true"`

	// The metadata that you apply to the capacity provider to help you categorize
	// and organize it. Each tag consists of a key and an optional value, both of
	// which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CapacityProvider) String() string {
	return awsutil.Prettify(s)
}

// The details of a capacity provider strategy.
type CapacityProviderStrategyItem struct {
	_ struct{} `type:"structure"`

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined.
	Base *int64 `locationName:"base" type:"integer"`

	// The short name or full Amazon Resource Name (ARN) of the capacity provider.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" type:"string" required:"true"`

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider.
	//
	// For example, if you have a strategy that contains two capacity providers
	// and both have a weight of 1, then when the base is satisfied, the tasks will
	// be split evenly across the two capacity providers. Using that same logic,
	// if you specify a weight of 1 for capacityProviderA and a weight of 4 for
	// capacityProviderB, then for every one task that is run using capacityProviderA,
	// four tasks would use capacityProviderB.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation
func (s CapacityProviderStrategyItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityProviderStrategyItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CapacityProviderStrategyItem"}

	if s.CapacityProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("CapacityProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A regional grouping of one or more container instances on which you can run
// task requests. Each account receives a default cluster the first time you
// use the Amazon ECS service, but you may also create other clusters. Clusters
// may contain more than one instance type simultaneously.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The number of services that are running on the cluster in an ACTIVE state.
	// You can view these services with ListServices.
	ActiveServicesCount *int64 `locationName:"activeServicesCount" type:"integer"`

	// The resources attached to a cluster. When using a capacity provider with
	// a cluster, the Auto Scaling plan that is created will be returned as a cluster
	// attachment.
	Attachments []Attachment `locationName:"attachments" type:"list"`

	// The status of the capacity providers associated with the cluster. The following
	// are the states that will be returned:
	//
	// UPDATE_IN_PROGRESS
	//
	// The available capacity providers for the cluster are updating. This occurs
	// when the Auto Scaling plan is provisioning or deprovisioning.
	//
	// UPDATE_COMPLETE
	//
	// The capacity providers have successfully updated.
	//
	// UPDATE_FAILED
	//
	// The capacity provider updates failed.
	AttachmentsStatus *string `locationName:"attachmentsStatus" type:"string"`

	// The capacity providers associated with the cluster.
	CapacityProviders []string `locationName:"capacityProviders" type:"list"`

	// The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains
	// the arn:aws:ecs namespace, followed by the Region of the cluster, the AWS
	// account ID of the cluster owner, the cluster namespace, and then the cluster
	// name. For example, arn:aws:ecs:region:012345678910:cluster/test.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// A user-generated string that you use to identify your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The default capacity provider strategy for the cluster. When services or
	// tasks are run in the cluster with no launch type or capacity provider strategy
	// specified, the default capacity provider strategy is used.
	DefaultCapacityProviderStrategy []CapacityProviderStrategyItem `locationName:"defaultCapacityProviderStrategy" type:"list"`

	// The number of tasks in the cluster that are in the PENDING state.
	PendingTasksCount *int64 `locationName:"pendingTasksCount" type:"integer"`

	// The number of container instances registered into the cluster. This includes
	// container instances in both ACTIVE and DRAINING status.
	RegisteredContainerInstancesCount *int64 `locationName:"registeredContainerInstancesCount" type:"integer"`

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount *int64 `locationName:"runningTasksCount" type:"integer"`

	// The settings for the cluster. This parameter indicates whether CloudWatch
	// Container Insights is enabled or disabled for a cluster.
	Settings []ClusterSetting `locationName:"settings" type:"list"`

	// Additional information about your clusters that are separated by launch type,
	// including:
	//
	//    * runningEC2TasksCount
	//
	//    * RunningFargateTasksCount
	//
	//    * pendingEC2TasksCount
	//
	//    * pendingFargateTasksCount
	//
	//    * activeEC2ServiceCount
	//
	//    * activeFargateServiceCount
	//
	//    * drainingEC2ServiceCount
	//
	//    * drainingFargateServiceCount
	Statistics []KeyValuePair `locationName:"statistics" type:"list"`

	// The status of the cluster. The valid values are ACTIVE or INACTIVE. ACTIVE
	// indicates that you can register container instances with the cluster and
	// the associated instances can accept tasks.
	Status *string `locationName:"status" type:"string"`

	// The metadata that you apply to the cluster to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// The settings to use when creating a cluster. This parameter is used to enable
// CloudWatch Container Insights for a cluster.
type ClusterSetting struct {
	_ struct{} `type:"structure"`

	// The name of the cluster setting. The only supported value is containerInsights.
	Name ClusterSettingName `locationName:"name" type:"string" enum:"true"`

	// The value to set for the cluster setting. The supported values are enabled
	// and disabled. If enabled is specified, CloudWatch Container Insights will
	// be enabled for the cluster, otherwise it will be disabled unless the containerInsights
	// account setting is enabled. If a cluster value is specified, it will override
	// the containerInsights value set with PutAccountSetting or PutAccountSettingDefault.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ClusterSetting) String() string {
	return awsutil.Prettify(s)
}

// A Docker container that is part of a task.
type Container struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container.
	ContainerArn *string `locationName:"containerArn" type:"string"`

	// The number of CPU units set for the container. The value will be 0 if no
	// value was specified in the container definition when the task definition
	// was registered.
	Cpu *string `locationName:"cpu" type:"string"`

	// The exit code returned from the container.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The IDs of each GPU assigned to the container.
	GpuIds []string `locationName:"gpuIds" type:"list"`

	// The health status of the container. If health checks are not configured for
	// this container in its task definition, then it reports the health status
	// as UNKNOWN.
	HealthStatus HealthStatus `locationName:"healthStatus" type:"string" enum:"true"`

	// The image used for the container.
	Image *string `locationName:"image" type:"string"`

	// The container image manifest digest.
	//
	// The imageDigest is only returned if the container is using an image hosted
	// in Amazon ECR, otherwise it is omitted.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The last known status of the container.
	LastStatus *string `locationName:"lastStatus" type:"string"`

	// The hard limit (in MiB) of memory set for the container.
	Memory *string `locationName:"memory" type:"string"`

	// The soft limit (in MiB) of memory set for the container.
	MemoryReservation *string `locationName:"memoryReservation" type:"string"`

	// The name of the container.
	Name *string `locationName:"name" type:"string"`

	// The network bindings associated with the container.
	NetworkBindings []NetworkBinding `locationName:"networkBindings" type:"list"`

	// The network interfaces associated with the container.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the Docker container.
	RuntimeId *string `locationName:"runtimeId" type:"string"`

	// The ARN of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// Container definitions are used in task definitions to describe the different
// containers that are launched as part of a task.
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd). If there are multiple
	// arguments, each argument should be a separated string in the array.
	Command []string `locationName:"command" type:"list"`

	// The number of cpu units reserved for the container. This parameter maps to
	// CpuShares in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This field is optional for tasks using the Fargate launch type, and the only
	// requirement is that the total amount of CPU reserved for all containers within
	// a task be lower than the task-level cpu value.
	//
	// You can determine the number of CPU units that are available per EC2 instance
	// type by multiplying the vCPUs listed for that instance type on the Amazon
	// EC2 Instances (http://aws.amazon.com/ec2/instance-types/) detail page by
	// 1,024.
	//
	// For example, if you run a single-container task on a single-core instance
	// type with 512 CPU units specified for that container, and that is the only
	// task running on the container instance, that container could use the full
	// 1,024 CPU unit share at any given time. However, if you launched another
	// copy of the same task on that container instance, each task would be guaranteed
	// a minimum of 512 CPU units when needed, and each container could float to
	// higher CPU usage if the other container was not using it, but if both tasks
	// were 100% active all of the time, they would be limited to 512 CPU units.
	//
	// Linux containers share unallocated CPU units with other containers on the
	// container instance with the same ratio as their allocated amount. For example,
	// if you run a single-container task on a single-core instance type with 512
	// CPU units specified for that container, and that is the only task running
	// on the container instance, that container could use the full 1,024 CPU unit
	// share at any given time. However, if you launched another copy of the same
	// task on that container instance, each task would be guaranteed a minimum
	// of 512 CPU units when needed, and each container could float to higher CPU
	// usage if the other container was not using it, but if both tasks were 100%
	// active all of the time, they would be limited to 512 CPU units.
	//
	// On Linux container instances, the Docker daemon on the container instance
	// uses the CPU value to calculate the relative CPU share ratios for running
	// containers. For more information, see CPU share constraint (https://docs.docker.com/engine/reference/run/#cpu-share-constraint)
	// in the Docker documentation. The minimum valid CPU share value that the Linux
	// kernel allows is 2. However, the CPU parameter is not required, and you can
	// use CPU values below 2 in your container definitions. For CPU values below
	// 2 (including null), the behavior varies based on your Amazon ECS container
	// agent version:
	//
	//    * Agent versions less than or equal to 1.1.0: Null and zero CPU values
	//    are passed to Docker as 0, which Docker then converts to 1,024 CPU shares.
	//    CPU values of 1 are passed to Docker as 1, which the Linux kernel converts
	//    to two CPU shares.
	//
	//    * Agent versions greater than or equal to 1.2.0: Null, zero, and CPU values
	//    of 1 are passed to Docker as 2.
	//
	// On Windows container instances, the CPU limit is enforced as an absolute
	// limit, or a quota. Windows containers only have access to the specified amount
	// of CPU that is described in the task definition.
	Cpu *int64 `locationName:"cpu" type:"integer"`

	// The dependencies defined for container startup and shutdown. A container
	// can contain multiple dependencies. When a dependency is defined for container
	// startup, for container shutdown it is reversed.
	//
	// For tasks using the EC2 launch type, the container instances require at least
	// version 1.26.0 of the container agent to enable container dependencies. However,
	// we recommend using the latest container agent version. For information about
	// checking your agent version and updating to the latest version, see Updating
	// the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you are using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For tasks using the Fargate launch type, the task or service requires platform
	// version 1.3.0 or later.
	DependsOn []ContainerDependency `locationName:"dependsOn" type:"list"`

	// When this parameter is true, networking is disabled within the container.
	// This parameter maps to NetworkDisabled in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/).
	//
	// This parameter is not supported for Windows containers.
	DisableNetworking *bool `locationName:"disableNetworking" type:"boolean"`

	// A list of DNS search domains that are presented to the container. This parameter
	// maps to DnsSearch in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --dns-search option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers.
	DnsSearchDomains []string `locationName:"dnsSearchDomains" type:"list"`

	// A list of DNS servers that are presented to the container. This parameter
	// maps to Dns in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --dns option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers.
	DnsServers []string `locationName:"dnsServers" type:"list"`

	// A key/value map of labels to add to the container. This parameter maps to
	// Labels in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --label option to docker run (https://docs.docker.com/engine/reference/run/).
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	DockerLabels map[string]string `locationName:"dockerLabels" type:"map"`

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems. This field is not valid for containers in tasks using the
	// Fargate launch type.
	//
	// This parameter maps to SecurityOpt in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --security-opt option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// The Amazon ECS container agent running on a container instance must register
	// with the ECS_SELINUX_CAPABLE=true or ECS_APPARMOR_CAPABLE=true environment
	// variables before containers placed on that instance can use these security
	// options. For more information, see Amazon ECS Container Agent Configuration
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// This parameter is not supported for Windows containers.
	DockerSecurityOptions []string `locationName:"dockerSecurityOptions" type:"list"`

	//
	// Early versions of the Amazon ECS container agent do not properly handle entryPoint
	// parameters. If you have problems using entryPoint, update your container
	// agent or enter your commands and arguments as command array items instead.
	//
	// The entry point that is passed to the container. This parameter maps to Entrypoint
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --entrypoint option to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#entrypoint
	// (https://docs.docker.com/engine/reference/builder/#entrypoint).
	EntryPoint []string `locationName:"entryPoint" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We do not recommend using plaintext environment variables for sensitive information,
	// such as credential data.
	Environment []KeyValuePair `locationName:"environment" type:"list"`

	// If the essential parameter of a container is marked as true, and that container
	// fails or stops for any reason, all other containers that are part of the
	// task are stopped. If the essential parameter of a container is marked as
	// false, then its failure does not affect the rest of the containers in a task.
	// If this parameter is omitted, a container is assumed to be essential.
	//
	// All tasks must have at least one essential container. If you have an application
	// that is composed of multiple containers, you should group containers that
	// are used for a common purpose into components, and separate the different
	// components into multiple task definitions. For more information, see Application
	// Architecture (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Essential *bool `locationName:"essential" type:"boolean"`

	// A list of hostnames and IP address mappings to append to the /etc/hosts file
	// on the container. This parameter maps to ExtraHosts in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --add-host option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers or tasks that use
	// the awsvpc network mode.
	ExtraHosts []HostEntry `locationName:"extraHosts" type:"list"`

	// The FireLens configuration for the container. This is used to specify and
	// configure a log router for container logs. For more information, see Custom
	// Log Routing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
	// in the Amazon Elastic Container Service Developer Guide.
	FirelensConfiguration *FirelensConfiguration `locationName:"firelensConfiguration" type:"structure"`

	// The health check command and associated configuration parameters for the
	// container. This parameter maps to HealthCheck in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the HEALTHCHECK parameter of docker run (https://docs.docker.com/engine/reference/run/).
	HealthCheck *HealthCheck `locationName:"healthCheck" type:"structure"`

	// The hostname to use for your container. This parameter maps to Hostname in
	// the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --hostname option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// The hostname parameter is not supported if you are using the awsvpc network
	// mode.
	Hostname *string `locationName:"hostname" type:"string"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. Images in the Docker Hub registry are available by default.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest . Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the IMAGE parameter of docker run (https://docs.docker.com/engine/reference/run/).
	//
	//    * When a new task starts, the Amazon ECS container agent pulls the latest
	//    version of the specified image and tag for the container to use. However,
	//    subsequent updates to a repository image are not propagated to already
	//    running tasks.
	//
	//    * Images in Amazon ECR repositories can be specified by either using the
	//    full registry/repository:tag or registry/repository@digest. For example,
	//    012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest
	//    or 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE.
	//
	//    * Images in official repositories on Docker Hub use a single name (for
	//    example, ubuntu or mongo).
	//
	//    * Images in other repositories on Docker Hub are qualified with an organization
	//    name (for example, amazon/amazon-ecs-agent).
	//
	//    * Images in other online repositories are qualified further by a domain
	//    name (for example, quay.io/assemblyline/ubuntu).
	Image *string `locationName:"image" type:"string"`

	// When this parameter is true, this allows you to deploy containerized applications
	// that require stdin or a tty to be allocated. This parameter maps to OpenStdin
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --interactive option to docker run (https://docs.docker.com/engine/reference/run/).
	Interactive *bool `locationName:"interactive" type:"boolean"`

	// The links parameter allows containers to communicate with each other without
	// the need for port mappings. This parameter is only supported if the network
	// mode of a task definition is bridge. The name:internalName construct is analogous
	// to name:alias in Docker links. Up to 255 letters (uppercase and lowercase),
	// numbers, and hyphens are allowed. For more information about linking Docker
	// containers, go to Legacy container links (https://docs.docker.com/network/links/)
	// in the Docker documentation. This parameter maps to Links in the Create a
	// container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --link option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers.
	//
	// Containers that are collocated on a single container instance may be able
	// to communicate with each other without requiring links or host port mappings.
	// Network isolation is achieved on the container instance using security groups
	// and VPC settings.
	Links []string `locationName:"links" type:"list"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information see KernelCapabilities.
	//
	// This parameter is not supported for Windows containers.
	LinuxParameters *LinuxParameters `locationName:"linuxParameters" type:"structure"`

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --log-driver option to docker run (https://docs.docker.com/engine/reference/run/).
	// By default, containers use the same logging driver that the Docker daemon
	// uses. However the container may use a different logging driver than the Docker
	// daemon by specifying a log driver with this parameter in the container definition.
	// To use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server
	// for remote logging options). For more information on the options for different
	// supported log drivers, see Configure logging drivers (https://docs.docker.com/engine/admin/logging/overview/)
	// in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to
	// the Docker daemon (shown in the LogConfiguration data type). Additional log
	// drivers may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the ECS_AVAILABLE_LOGGING_DRIVERS
	// environment variable before containers placed on that instance can use these
	// log configuration options. For more information, see Amazon ECS Container
	// Agent Configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure"`

	// The amount (in MiB) of memory to present to the container. If your container
	// attempts to exceed the memory specified here, the container is killed. The
	// total amount of memory reserved for all containers within a task must be
	// lower than the task memory value, if one is specified. This parameter maps
	// to Memory in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If using the Fargate launch type, this parameter is optional.
	//
	// If using the EC2 launch type, you must specify either a task-level memory
	// value or a container-level memory value. If you specify both a container-level
	// memory and memoryReservation value, memory must be greater than memoryReservation.
	// If you specify memoryReservation, then that value is subtracted from the
	// available memory resources for the container instance on which the container
	// is placed. Otherwise, the value of memory is used.
	//
	// The Docker daemon reserves a minimum of 4 MiB of memory for a container,
	// so you should not specify fewer than 4 MiB of memory for your containers.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container. When system
	// memory is under heavy contention, Docker attempts to keep the container memory
	// to this soft limit. However, your container can consume more memory when
	// it needs to, up to either the hard limit specified with the memory parameter
	// (if applicable), or all of the available memory on the container instance,
	// whichever comes first. This parameter maps to MemoryReservation in the Create
	// a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --memory-reservation option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If a task-level memory value is not specified, you must specify a non-zero
	// integer for one or both of memory or memoryReservation in a container definition.
	// If you specify both, memory must be greater than memoryReservation. If you
	// specify memoryReservation, then that value is subtracted from the available
	// memory resources for the container instance on which the container is placed.
	// Otherwise, the value of memory is used.
	//
	// For example, if your container normally uses 128 MiB of memory, but occasionally
	// bursts to 256 MiB of memory for short periods of time, you can set a memoryReservation
	// of 128 MiB, and a memory hard limit of 300 MiB. This configuration would
	// allow the container to only reserve 128 MiB of memory from the remaining
	// resources on the container instance, but also allow the container to consume
	// more memory resources when needed.
	//
	// The Docker daemon reserves a minimum of 4 MiB of memory for a container,
	// so you should not specify fewer than 4 MiB of memory for your containers.
	MemoryReservation *int64 `locationName:"memoryReservation" type:"integer"`

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers cannot mount directories on a different drive, and mount
	// point cannot be across drives.
	MountPoints []MountPoint `locationName:"mountPoints" type:"list"`

	// The name of a container. If you are linking multiple containers together
	// in a task definition, the name of one container can be entered in the links
	// of another container to connect the containers. Up to 255 letters (uppercase
	// and lowercase), numbers, and hyphens are allowed. This parameter maps to
	// name in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --name option to docker run (https://docs.docker.com/engine/reference/run/).
	Name *string `locationName:"name" type:"string"`

	// The list of port mappings for the container. Port mappings allow containers
	// to access ports on the host container instance to send or receive traffic.
	//
	// For task definitions that use the awsvpc network mode, you should only specify
	// the containerPort. The hostPort can be left blank or it must be the same
	// value as the containerPort.
	//
	// Port mappings on Windows use the NetNAT gateway address rather than localhost.
	// There is no loopback for port mappings on Windows, so you cannot access a
	// container's mapped port from the host itself.
	//
	// This parameter maps to PortBindings in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --publish option to docker run (https://docs.docker.com/engine/reference/run/).
	// If the network mode of a task definition is set to none, then you can't specify
	// port mappings. If the network mode of a task definition is set to host, then
	// host ports must either be undefined or they must match the container port
	// in the port mapping.
	//
	// After a task reaches the RUNNING status, manual and automatic host and container
	// port assignments are visible in the Network Bindings section of a container
	// description for a selected task in the Amazon ECS console. The assignments
	// are also visible in the networkBindings section DescribeTasks responses.
	PortMappings []PortMapping `locationName:"portMappings" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers or tasks using the
	// Fargate launch type.
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, a TTY is allocated. This parameter maps to Tty
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --tty option to docker run (https://docs.docker.com/engine/reference/run/).
	PseudoTerminal *bool `locationName:"pseudoTerminal" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section
	// of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/) and
	// the --read-only option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// This parameter is not supported for Windows containers.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials `locationName:"repositoryCredentials" type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The secrets to pass to the container. For more information, see Specifying
	// Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Secrets []Secret `locationName:"secrets" type:"list"`

	// Time duration (in seconds) to wait before giving up on resolving dependencies
	// for a container. For example, you specify two containers in a task definition
	// with containerA having a dependency on containerB reaching a COMPLETE, SUCCESS,
	// or HEALTHY status. If a startTimeout value is specified for containerB and
	// it does not reach the desired status within that time then containerA will
	// give up and not start. This results in the task transitioning to a STOPPED
	// state.
	//
	// For tasks using the EC2 launch type, the container instances require at least
	// version 1.26.0 of the container agent to enable a container start timeout
	// value. However, we recommend using the latest container agent version. For
	// information about checking your agent version and updating to the latest
	// version, see Updating the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you are using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For tasks using the Fargate launch type, the task or service requires platform
	// version 1.3.0 or later.
	StartTimeout *int64 `locationName:"startTimeout" type:"integer"`

	// Time duration (in seconds) to wait before the container is forcefully killed
	// if it doesn't exit normally on its own.
	//
	// For tasks using the Fargate launch type, the max stopTimeout value is 2 minutes
	// and the task or service requires platform version 1.3.0 or later.
	//
	// For tasks using the EC2 launch type, the stop timeout value for the container
	// takes precedence over the ECS_CONTAINER_STOP_TIMEOUT container agent configuration
	// parameter, if used. Container instances require at least version 1.26.0 of
	// the container agent to enable a container stop timeout value. However, we
	// recommend using the latest container agent version. For information about
	// checking your agent version and updating to the latest version, see Updating
	// the Amazon ECS Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
	// in the Amazon Elastic Container Service Developer Guide. If you are using
	// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
	// of the ecs-init package. If your container instances are launched from version
	// 20190301 or later, then they contain the required versions of the container
	// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
	// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	StopTimeout *int64 `locationName:"stopTimeout" type:"integer"`

	// A list of namespaced kernel parameters to set in the container. This parameter
	// maps to Sysctls in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --sysctl option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// It is not recommended that you specify network-related systemControls parameters
	// for multiple containers in a single task that also uses either the awsvpc
	// or host network modes. For tasks that use the awsvpc network mode, the container
	// that is started last determines which systemControls parameters take effect.
	// For tasks that use the host network mode, it changes the container instance's
	// namespaced kernel parameters as well as the containers.
	SystemControls []SystemControl `locationName:"systemControls" type:"list"`

	// A list of ulimits to set in the container. This parameter maps to Ulimits
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/).
	// Valid naming values are displayed in the Ulimit data type. This parameter
	// requires version 1.18 of the Docker Remote API or greater on your container
	// instance. To check the Docker Remote API version on your container instance,
	// log in to your container instance and run the following command: sudo docker
	// version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	Ulimits []Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container. This parameter maps to User in
	// the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// You can use the following formats. If specifying a UID or GID, you must specify
	// it as a positive integer.
	//
	//    * user
	//
	//    * user:group
	//
	//    * uid
	//
	//    * uid:gid
	//
	//    * user:gid
	//
	//    * uid:group
	//
	// This parameter is not supported for Windows containers.
	User *string `locationName:"user" type:"string"`

	// Data volumes to mount from another container. This parameter maps to VolumesFrom
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --volumes-from option to docker run (https://docs.docker.com/engine/reference/run/).
	VolumesFrom []VolumeFrom `locationName:"volumesFrom" type:"list"`

	// The working directory in which to run commands inside the container. This
	// parameter maps to WorkingDir in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --workdir option to docker run (https://docs.docker.com/engine/reference/run/).
	WorkingDirectory *string `locationName:"workingDirectory" type:"string"`
}

// String returns the string representation
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.DependsOn != nil {
		for i, v := range s.DependsOn {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DependsOn", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ExtraHosts != nil {
		for i, v := range s.ExtraHosts {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtraHosts", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.FirelensConfiguration != nil {
		if err := s.FirelensConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FirelensConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(aws.ErrInvalidParams))
		}
	}
	if s.LinuxParameters != nil {
		if err := s.LinuxParameters.Validate(); err != nil {
			invalidParams.AddNested("LinuxParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.RepositoryCredentials != nil {
		if err := s.RepositoryCredentials.Validate(); err != nil {
			invalidParams.AddNested("RepositoryCredentials", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Secrets != nil {
		for i, v := range s.Secrets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Secrets", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The dependencies defined for container startup and shutdown. A container
// can contain multiple dependencies. When a dependency is defined for container
// startup, for container shutdown it is reversed.
//
// Your Amazon ECS container instances require at least version 1.26.0 of the
// container agent to enable container dependencies. However, we recommend using
// the latest container agent version. For information about checking your agent
// version and updating to the latest version, see Updating the Amazon ECS Container
// Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html)
// in the Amazon Elastic Container Service Developer Guide. If you are using
// an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1
// of the ecs-init package. If your container instances are launched from version
// 20190301 or later, then they contain the required versions of the container
// agent and ecs-init. For more information, see Amazon ECS-optimized Linux
// AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// If you are using tasks that use the Fargate launch type, container dependency
// parameters are not supported.
type ContainerDependency struct {
	_ struct{} `type:"structure"`

	// The dependency condition of the container. The following are the available
	// conditions and their behavior:
	//
	//    * START - This condition emulates the behavior of links and volumes today.
	//    It validates that a dependent container is started before permitting other
	//    containers to start.
	//
	//    * COMPLETE - This condition validates that a dependent container runs
	//    to completion (exits) before permitting other containers to start. This
	//    can be useful for nonessential containers that run a script and then exit.
	//
	//    * SUCCESS - This condition is the same as COMPLETE, but it also requires
	//    that the container exits with a zero status.
	//
	//    * HEALTHY - This condition validates that the dependent container passes
	//    its Docker health check before permitting other containers to start. This
	//    requires that the dependent container has health checks configured. This
	//    condition is confirmed only at task startup.
	//
	// Condition is a required field
	Condition ContainerCondition `locationName:"condition" type:"string" required:"true" enum:"true"`

	// The name of a container.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`
}

// String returns the string representation
func (s ContainerDependency) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDependency) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerDependency"}
	if len(s.Condition) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Condition"))
	}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An EC2 instance that is running the Amazon ECS agent and has been registered
// with a cluster.
type ContainerInstance struct {
	_ struct{} `type:"structure"`

	// This parameter returns true if the agent is connected to Amazon ECS. Registered
	// instances with an agent that may be unhealthy or stopped return false. Only
	// instances connected to an agent can accept placement requests.
	AgentConnected *bool `locationName:"agentConnected" type:"boolean"`

	// The status of the most recent agent update. If an update has never been requested,
	// this value is NULL.
	AgentUpdateStatus AgentUpdateStatus `locationName:"agentUpdateStatus" type:"string" enum:"true"`

	// The resources attached to a container instance, such as elastic network interfaces.
	Attachments []Attachment `locationName:"attachments" type:"list"`

	// The attributes set for the container instance, either by the Amazon ECS container
	// agent at instance registration or manually with the PutAttributes operation.
	Attributes []Attribute `locationName:"attributes" type:"list"`

	// The capacity provider associated with the container instance.
	CapacityProviderName *string `locationName:"capacityProviderName" type:"string"`

	// The Amazon Resource Name (ARN) of the container instance. The ARN contains
	// the arn:aws:ecs namespace, followed by the Region of the container instance,
	// the AWS account ID of the container instance owner, the container-instance
	// namespace, and then the container instance ID. For example, arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The EC2 instance ID of the container instance.
	Ec2InstanceId *string `locationName:"ec2InstanceId" type:"string"`

	// The number of tasks on the container instance that are in the PENDING status.
	PendingTasksCount *int64 `locationName:"pendingTasksCount" type:"integer"`

	// The Unix timestamp for when the container instance was registered.
	RegisteredAt *time.Time `locationName:"registeredAt" type:"timestamp"`

	// For CPU and memory resource types, this parameter describes the amount of
	// each resource that was available on the container instance when the container
	// agent registered it with Amazon ECS. This value represents the total amount
	// of CPU and memory that can be allocated on this container instance to tasks.
	// For port resource types, this parameter describes the ports that were reserved
	// by the Amazon ECS container agent when it registered the container instance
	// with Amazon ECS.
	RegisteredResources []Resource `locationName:"registeredResources" type:"list"`

	// For CPU and memory resource types, this parameter describes the remaining
	// CPU and memory that has not already been allocated to tasks and is therefore
	// available for new tasks. For port resource types, this parameter describes
	// the ports that were reserved by the Amazon ECS container agent (at instance
	// registration time) and any task containers that have reserved port mappings
	// on the host (with the host or bridge network mode). Any port that is not
	// specified here is available for new tasks.
	RemainingResources []Resource `locationName:"remainingResources" type:"list"`

	// The number of tasks on the container instance that are in the RUNNING status.
	RunningTasksCount *int64 `locationName:"runningTasksCount" type:"integer"`

	// The status of the container instance. The valid values are REGISTERING, REGISTRATION_FAILED,
	// ACTIVE, INACTIVE, DEREGISTERING, or DRAINING.
	//
	// If your account has opted in to the awsvpcTrunking account setting, then
	// any newly registered container instance will transition to a REGISTERING
	// status while the trunk elastic network interface is provisioned for the instance.
	// If the registration fails, the instance will transition to a REGISTRATION_FAILED
	// status. You can describe the container instance and see the reason for failure
	// in the statusReason parameter. Once the container instance is terminated,
	// the instance transitions to a DEREGISTERING status while the trunk elastic
	// network interface is deprovisioned. The instance then transitions to an INACTIVE
	// status.
	//
	// The ACTIVE status indicates that the container instance can accept tasks.
	// The DRAINING indicates that new tasks are not placed on the container instance
	// and any service tasks running on the container instance are removed if possible.
	// For more information, see Container Instance Draining (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Status *string `locationName:"status" type:"string"`

	// The reason that the container instance reached its current status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The metadata that you apply to the container instance to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`

	// The version counter for the container instance. Every time a container instance
	// experiences a change that triggers a CloudWatch event, the version counter
	// is incremented. If you are replicating your Amazon ECS container instance
	// state with CloudWatch Events, you can compare the version of a container
	// instance reported by the Amazon ECS APIs with the version reported in CloudWatch
	// Events for the container instance (inside the detail object) to verify that
	// the version in your event stream is current.
	Version *int64 `locationName:"version" type:"long"`

	// The version information for the Amazon ECS container agent and Docker daemon
	// running on the container instance.
	VersionInfo *VersionInfo `locationName:"versionInfo" type:"structure"`
}

// String returns the string representation
func (s ContainerInstance) String() string {
	return awsutil.Prettify(s)
}

// The overrides that should be sent to a container. An empty container override
// can be passed in. An example of an empty container override would be {"containerOverrides":
// [ ] }. If a non-empty container override is specified, the name parameter
// must be included.
type ContainerOverride struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the task definition. You must also specify a container
	// name.
	Command []string `locationName:"command" type:"list"`

	// The number of cpu units reserved for the container, instead of the default
	// value from the task definition. You must also specify a container name.
	Cpu *int64 `locationName:"cpu" type:"integer"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the task definition.
	// You must also specify a container name.
	Environment []KeyValuePair `locationName:"environment" type:"list"`

	// The hard limit (in MiB) of memory to present to the container, instead of
	// the default value from the task definition. If your container attempts to
	// exceed the memory specified here, the container is killed. You must also
	// specify a container name.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container, instead of
	// the default value from the task definition. You must also specify a container
	// name.
	MemoryReservation *int64 `locationName:"memoryReservation" type:"integer"`

	// The name of the container that receives the override. This parameter is required
	// if any override is specified.
	Name *string `locationName:"name" type:"string"`

	// The type and amount of a resource to assign to a container, instead of the
	// default value from the task definition. The only supported resource is a
	// GPU.
	ResourceRequirements []ResourceRequirement `locationName:"resourceRequirements" type:"list"`
}

// String returns the string representation
func (s ContainerOverride) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerOverride) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerOverride"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing a change in state for a container.
type ContainerStateChange struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The exit code for the container, if the state change is a result of the container
	// exiting.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The container image SHA 256 digest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// Any network bindings associated with the container.
	NetworkBindings []NetworkBinding `locationName:"networkBindings" type:"list"`

	// The reason for the state change.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the Docker container.
	RuntimeId *string `locationName:"runtimeId" type:"string"`

	// The status of the container.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s ContainerStateChange) String() string {
	return awsutil.Prettify(s)
}

// The details of an Amazon ECS service deployment. This is used only when a
// service uses the ECS deployment controller type.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy that the deployment is using.
	CapacityProviderStrategy []CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Unix timestamp for when the service deployment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The most recent desired count of tasks that was specified for the service
	// to deploy or maintain.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// The ID of the deployment.
	Id *string `locationName:"id" type:"string"`

	// The launch type the tasks in the service are using. For more information,
	// see Amazon ECS Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType LaunchType `locationName:"launchType" type:"string" enum:"true"`

	// The VPC subnet and security group configuration for tasks that receive their
	// own elastic network interface by using the awsvpc networking mode.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the deployment that are in the PENDING status.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The platform version on which your tasks in the service are running. A platform
	// version is only specified for tasks using the Fargate launch type. If one
	// is not specified, the LATEST platform version is used by default. For more
	// information, see AWS Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The number of tasks in the deployment that are in the RUNNING status.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// The status of the deployment. The following describes each state:
	//
	// PRIMARY
	//
	// The most recent deployment of a service.
	//
	// ACTIVE
	//
	// A service deployment that still has running tasks, but are in the process
	// of being replaced with a new PRIMARY deployment.
	//
	// INACTIVE
	//
	// A deployment that has been completely replaced.
	Status *string `locationName:"status" type:"string"`

	// The most recent task definition that was specified for the tasks in the service
	// to use.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// The Unix timestamp for when the service deployment was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// Optional deployment parameters that control how many tasks run during a deployment
// and the ordering of stopping and starting tasks.
type DeploymentConfiguration struct {
	_ struct{} `type:"structure"`

	// If a service is using the rolling update (ECS) deployment type, the maximum
	// percent parameter represents an upper limit on the number of tasks in a service
	// that are allowed in the RUNNING or PENDING state during a deployment, as
	// a percentage of the desired number of tasks (rounded down to the nearest
	// integer), and while any container instances are in the DRAINING state if
	// the service contains tasks using the EC2 launch type. This parameter enables
	// you to define the deployment batch size. For example, if your service has
	// a desired number of four tasks and a maximum percent value of 200%, the scheduler
	// may start four new tasks before stopping the four older tasks (provided that
	// the cluster resources required to do this are available). The default value
	// for maximum percent is 200%.
	//
	// If a service is using the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the maximum percent value is
	// set to the default value and is used to define the upper limit on the number
	// of the tasks in the service that remain in the RUNNING state while the container
	// instances are in the DRAINING state. If the tasks in the service use the
	// Fargate launch type, the maximum percent value is not used, although it is
	// returned when describing your service.
	MaximumPercent *int64 `locationName:"maximumPercent" type:"integer"`

	// If a service is using the rolling update (ECS) deployment type, the minimum
	// healthy percent represents a lower limit on the number of tasks in a service
	// that must remain in the RUNNING state during a deployment, as a percentage
	// of the desired number of tasks (rounded up to the nearest integer), and while
	// any container instances are in the DRAINING state if the service contains
	// tasks using the EC2 launch type. This parameter enables you to deploy without
	// using additional cluster capacity. For example, if your service has a desired
	// number of four tasks and a minimum healthy percent of 50%, the scheduler
	// may stop two existing tasks to free up cluster capacity before starting two
	// new tasks. Tasks for services that do not use a load balancer are considered
	// healthy if they are in the RUNNING state; tasks for services that do use
	// a load balancer are considered healthy if they are in the RUNNING state and
	// they are reported as healthy by the load balancer. The default value for
	// minimum healthy percent is 100%.
	//
	// If a service is using the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the minimum healthy percent
	// value is set to the default value and is used to define the lower limit on
	// the number of the tasks in the service that remain in the RUNNING state while
	// the container instances are in the DRAINING state. If the tasks in the service
	// use the Fargate launch type, the minimum healthy percent value is not used,
	// although it is returned when describing your service.
	MinimumHealthyPercent *int64 `locationName:"minimumHealthyPercent" type:"integer"`
}

// String returns the string representation
func (s DeploymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The deployment controller to use for the service. For more information, see
// Amazon ECS Deployment Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
// in the Amazon Elastic Container Service Developer Guide.
type DeploymentController struct {
	_ struct{} `type:"structure"`

	// The deployment controller type to use.
	//
	// There are three deployment controller types available:
	//
	// ECS
	//
	// The rolling update (ECS) deployment type involves replacing the current running
	// version of the container with the latest version. The number of containers
	// Amazon ECS adds or removes from the service during a rolling update is controlled
	// by adjusting the minimum and maximum number of healthy tasks allowed during
	// a service deployment, as specified in the DeploymentConfiguration.
	//
	// CODE_DEPLOY
	//
	// The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment
	// model powered by AWS CodeDeploy, which allows you to verify a new deployment
	// of a service before sending production traffic to it.
	//
	// EXTERNAL
	//
	// The external (EXTERNAL) deployment type enables you to use any third-party
	// deployment controller for full control over the deployment process for an
	// Amazon ECS service.
	//
	// Type is a required field
	Type DeploymentControllerType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DeploymentController) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentController) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentController"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing a container instance host device.
type Device struct {
	_ struct{} `type:"structure"`

	// The path inside the container at which to expose the host device.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// The path for the device on the host container instance.
	//
	// HostPath is a required field
	HostPath *string `locationName:"hostPath" type:"string" required:"true"`

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []DeviceCgroupPermission `locationName:"permissions" type:"list"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Device) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Device"}

	if s.HostPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This parameter is specified when you are using Docker volumes. Docker volumes
// are only supported when you are using the EC2 launch type. Windows containers
// only support the use of the local driver. To use bind mounts, specify a host
// instead.
type DockerVolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// If this value is true, the Docker volume is created if it does not already
	// exist.
	//
	// This field is only used if the scope is shared.
	Autoprovision *bool `locationName:"autoprovision" type:"boolean"`

	// The Docker volume driver to use. The driver value must match the driver name
	// provided by Docker because it is used for task placement. If the driver was
	// installed using the Docker plugin CLI, use docker plugin ls to retrieve the
	// driver name from your container instance. If the driver was installed using
	// another method, use Docker plugin discovery to retrieve the driver name.
	// For more information, see Docker plugin discovery (https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery).
	// This parameter maps to Driver in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxdriver option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	Driver *string `locationName:"driver" type:"string"`

	// A map of Docker driver-specific options passed through. This parameter maps
	// to DriverOpts in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxopt option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	DriverOpts map[string]string `locationName:"driverOpts" type:"map"`

	// Custom metadata to add to your Docker volume. This parameter maps to Labels
	// in the Create a volume (https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the xxlabel option to docker volume create (https://docs.docker.com/engine/reference/commandline/volume_create/).
	Labels map[string]string `locationName:"labels" type:"map"`

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are automatically provisioned when the task starts
	// and destroyed when the task stops. Docker volumes that are scoped as shared
	// persist after the task stops.
	Scope Scope `locationName:"scope" type:"string" enum:"true"`
}

// String returns the string representation
func (s DockerVolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// A failed resource.
type Failure struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the failed resource.
	Arn *string `locationName:"arn" type:"string"`

	// The details of the failure.
	Detail *string `locationName:"detail" type:"string"`

	// The reason for the failure.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s Failure) String() string {
	return awsutil.Prettify(s)
}

// The FireLens configuration for the container. This is used to specify and
// configure a log router for container logs. For more information, see Custom
// Log Routing (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
// in the Amazon Elastic Container Service Developer Guide.
type FirelensConfiguration struct {
	_ struct{} `type:"structure"`

	// The options to use when configuring the log router. This field is optional
	// and can be used to specify a custom configuration file or to add additional
	// metadata, such as the task, task definition, cluster, and container instance
	// details to the log event. If specified, the syntax to use is "options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}.
	// For more information, see Creating a Task Definition that Uses a FireLens
	// Configuration (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef)
	// in the Amazon Elastic Container Service Developer Guide.
	Options map[string]string `locationName:"options" type:"map"`

	// The log router to use. The valid values are fluentd or fluentbit.
	//
	// Type is a required field
	Type FirelensConfigurationType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FirelensConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirelensConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FirelensConfiguration"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing a container health check. Health check parameters
// that are specified in a container definition override any Docker health checks
// that exist in the container image (such as those specified in a parent image
// or from the image's Dockerfile).
//
// The following are notes about container health check support:
//
//    * Container health checks require version 1.17.0 or greater of the Amazon
//    ECS container agent. For more information, see Updating the Amazon ECS
//    Container Agent (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html).
//
//    * Container health checks are supported for Fargate tasks if you are using
//    platform version 1.1.0 or greater. For more information, see AWS Fargate
//    Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
//
//    * Container health checks are not supported for tasks that are part of
//    a service that is configured to use a Classic Load Balancer.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A string array representing the command that the container runs to determine
	// if it is healthy. The string array must start with CMD to execute the command
	// arguments directly, or CMD-SHELL to run the command with the container's
	// default shell. For example:
	//
	// [ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]
	//
	// An exit code of 0 indicates success, and non-zero exit code indicates failure.
	// For more information, see HealthCheck in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/).
	//
	// Command is a required field
	Command []string `locationName:"command" type:"list" required:"true"`

	// The time period in seconds between each health check execution. You may specify
	// between 5 and 300 seconds. The default value is 30 seconds.
	Interval *int64 `locationName:"interval" type:"integer"`

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. You may specify between 1 and 10 retries. The default
	// value is 3.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The optional grace period within which to provide containers time to bootstrap
	// before failed health checks count towards the maximum number of retries.
	// You may specify between 0 and 300 seconds. The startPeriod is disabled by
	// default.
	//
	// If a health check succeeds within the startPeriod, then the container is
	// considered healthy and any subsequent failures count toward the maximum number
	// of retries.
	StartPeriod *int64 `locationName:"startPeriod" type:"integer"`

	// The time period in seconds to wait for a health check to succeed before it
	// is considered a failure. You may specify between 2 and 60 seconds. The default
	// value is 5.
	Timeout *int64 `locationName:"timeout" type:"integer"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheck) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheck"}

	if s.Command == nil {
		invalidParams.Add(aws.NewErrParamRequired("Command"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Hostnames and IP address entries that are added to the /etc/hosts file of
// a container via the extraHosts parameter of its ContainerDefinition.
type HostEntry struct {
	_ struct{} `type:"structure"`

	// The hostname to use in the /etc/hosts entry.
	//
	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`

	// The IP address to use in the /etc/hosts entry.
	//
	// IpAddress is a required field
	IpAddress *string `locationName:"ipAddress" type:"string" required:"true"`
}

// String returns the string representation
func (s HostEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HostEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HostEntry"}

	if s.Hostname == nil {
		invalidParams.Add(aws.NewErrParamRequired("Hostname"))
	}

	if s.IpAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("IpAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on a container instance bind mount host volume.
type HostVolumeProperties struct {
	_ struct{} `type:"structure"`

	// When the host parameter is used, specify a sourcePath to declare the path
	// on the host container instance that is presented to the container. If this
	// parameter is empty, then the Docker daemon has assigned a host path for you.
	// If the host parameter contains a sourcePath file location, then the data
	// volume persists at the specified location on the host container instance
	// until you delete it manually. If the sourcePath value does not exist on the
	// host container instance, the Docker daemon creates it. If the location does
	// exist, the contents of the source path folder are exported.
	//
	// If you are using the Fargate launch type, the sourcePath parameter is not
	// supported.
	SourcePath *string `locationName:"sourcePath" type:"string"`
}

// String returns the string representation
func (s HostVolumeProperties) String() string {
	return awsutil.Prettify(s)
}

// Details on a Elastic Inference accelerator. For more information, see Working
// with Amazon Elastic Inference on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-eia.html)
// in the Amazon Elastic Container Service Developer Guide.
type InferenceAccelerator struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name. The deviceName must also be
	// referenced in a container definition as a ResourceRequirement.
	//
	// DeviceName is a required field
	DeviceName *string `locationName:"deviceName" type:"string" required:"true"`

	// The Elastic Inference accelerator type to use.
	//
	// DeviceType is a required field
	DeviceType *string `locationName:"deviceType" type:"string" required:"true"`
}

// String returns the string representation
func (s InferenceAccelerator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceAccelerator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InferenceAccelerator"}

	if s.DeviceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceName"))
	}

	if s.DeviceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on an Elastic Inference accelerator task override. This parameter
// is used to override the Elastic Inference accelerator specified in the task
// definition. For more information, see Working with Amazon Elastic Inference
// on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-eia.html)
// in the Amazon Elastic Container Service Developer Guide.
type InferenceAcceleratorOverride struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name to override for the task. This
	// parameter must match a deviceName specified in the task definition.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The Elastic Inference accelerator type to use.
	DeviceType *string `locationName:"deviceType" type:"string"`
}

// String returns the string representation
func (s InferenceAcceleratorOverride) String() string {
	return awsutil.Prettify(s)
}

// The Linux capabilities for the container that are added to or dropped from
// the default configuration provided by Docker. For more information on the
// default capabilities and the non-default available capabilities, see Runtime
// privilege and Linux capabilities (https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities)
// in the Docker run reference. For more detailed information on these Linux
// capabilities, see the capabilities(7) (http://man7.org/linux/man-pages/man7/capabilities.7.html)
// Linux manual page.
type KernelCapabilities struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that have been added to the default
	// configuration provided by Docker. This parameter maps to CapAdd in the Create
	// a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cap-add option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you are using tasks that use the Fargate launch type, the add parameter
	// is not supported.
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Add []string `locationName:"add" type:"list"`

	// The Linux capabilities for the container that have been removed from the
	// default configuration provided by Docker. This parameter maps to CapDrop
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --cap-drop option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// Valid values: "ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
	// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK"
	// | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE"
	// | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW"
	// | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT"
	// | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" |
	// "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
	// "WAKE_ALARM"
	Drop []string `locationName:"drop" type:"list"`
}

// String returns the string representation
func (s KernelCapabilities) String() string {
	return awsutil.Prettify(s)
}

// A key-value pair object.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// Linux-specific options that are applied to the container, such as Linux KernelCapabilities.
type LinuxParameters struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to or dropped from
	// the default configuration provided by Docker.
	//
	// If you are using tasks that use the Fargate launch type, capabilities is
	// supported but the add parameter is not supported.
	Capabilities *KernelCapabilities `locationName:"capabilities" type:"structure"`

	// Any host devices to expose to the container. This parameter maps to Devices
	// in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
	// and the --device option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you are using tasks that use the Fargate launch type, the devices parameter
	// is not supported.
	Devices []Device `locationName:"devices" type:"list"`

	// Run an init process inside the container that forwards signals and reaps
	// processes. This parameter maps to the --init option to docker run (https://docs.docker.com/engine/reference/run/).
	// This parameter requires version 1.25 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	InitProcessEnabled *bool `locationName:"initProcessEnabled" type:"boolean"`

	// The total amount of swap memory (in MiB) a container can use. This parameter
	// will be translated to the --memory-swap option to docker run (https://docs.docker.com/engine/reference/run/)
	// where the value would be the sum of the container memory plus the maxSwap
	// value.
	//
	// If a maxSwap value of 0 is specified, the container will not use swap. Accepted
	// values are 0 or any positive integer. If the maxSwap parameter is omitted,
	// the container will use the swap configuration for the container instance
	// it is running on. A maxSwap value must be set for the swappiness parameter
	// to be used.
	//
	// If you are using tasks that use the Fargate launch type, the maxSwap parameter
	// is not supported.
	MaxSwap *int64 `locationName:"maxSwap" type:"integer"`

	// The value for the size (in MiB) of the /dev/shm volume. This parameter maps
	// to the --shm-size option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you are using tasks that use the Fargate launch type, the sharedMemorySize
	// parameter is not supported.
	SharedMemorySize *int64 `locationName:"sharedMemorySize" type:"integer"`

	// This allows you to tune a container's memory swappiness behavior. A swappiness
	// value of 0 will cause swapping to not happen unless absolutely necessary.
	// A swappiness value of 100 will cause pages to be swapped very aggressively.
	// Accepted values are whole numbers between 0 and 100. If the swappiness parameter
	// is not specified, a default value of 60 is used. If a value is not specified
	// for maxSwap then this parameter is ignored. This parameter maps to the --memory-swappiness
	// option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you are using tasks that use the Fargate launch type, the swappiness parameter
	// is not supported.
	Swappiness *int64 `locationName:"swappiness" type:"integer"`

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	// This parameter maps to the --tmpfs option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you are using tasks that use the Fargate launch type, the tmpfs parameter
	// is not supported.
	Tmpfs []Tmpfs `locationName:"tmpfs" type:"list"`
}

// String returns the string representation
func (s LinuxParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LinuxParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LinuxParameters"}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tmpfs != nil {
		for i, v := range s.Tmpfs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tmpfs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on the load balancer or load balancers to use with a service or task
// set.
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The name of the container (as it appears in a container definition) to associate
	// with the load balancer.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The port on the container to associate with the load balancer. This port
	// must correspond to a containerPort in the task definition the tasks in the
	// service are using. For tasks that use the EC2 launch type, the container
	// instance they are launched on must allow ingress traffic on the hostPort
	// of the port mapping.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The name of the load balancer to associate with the Amazon ECS service or
	// task set.
	//
	// A load balancer name is only specified when using a Classic Load Balancer.
	// If you are using an Application Load Balancer or a Network Load Balancer
	// this should be omitted.
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string"`

	// The full Amazon Resource Name (ARN) of the Elastic Load Balancing target
	// group or groups associated with a service or task set.
	//
	// A target group ARN is only specified when using an Application Load Balancer
	// or Network Load Balancer. If you are using a Classic Load Balancer this should
	// be omitted.
	//
	// For services using the ECS deployment controller, you can specify one or
	// multiple target groups. For more information, see Registering Multiple Target
	// Groups with a Service (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// For services using the CODE_DEPLOY deployment controller, you are required
	// to define two target groups for the load balancer. For more information,
	// see Blue/Green Deployment with CodeDeploy (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If your service's task definition uses the awsvpc network mode (which is
	// required for the Fargate launch type), you must choose ip as the target type,
	// not instance, when creating your target groups because tasks that use the
	// awsvpc network mode are associated with an elastic network interface, not
	// an Amazon EC2 instance.
	TargetGroupArn *string `locationName:"targetGroupArn" type:"string"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// Log configuration options to send to a custom log driver for the container.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The log driver to use for the container. The valid values listed for this
	// parameter are log drivers that the Amazon ECS container agent can communicate
	// with by default.
	//
	// For tasks using the Fargate launch type, the supported log drivers are awslogs
	// and splunk.
	//
	// For tasks using the EC2 launch type, the supported log drivers are awslogs,
	// fluentd, gelf, json-file, journald, logentries, syslog, and splunk.
	//
	// For more information about using the awslogs log driver, see Using the awslogs
	// Log Driver (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// If you have a custom driver that is not listed above that you would like
	// to work with the Amazon ECS container agent, you can fork the Amazon ECS
	// container agent project that is available on GitHub (https://github.com/aws/amazon-ecs-agent)
	// and customize it to work with that driver. We encourage you to submit pull
	// requests for changes that you would like to have included. However, Amazon
	// Web Services does not currently support running modified copies of this software.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater
	// on your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// LogDriver is a required field
	LogDriver LogDriver `locationName:"logDriver" type:"string" required:"true" enum:"true"`

	// The configuration options to send to the log driver. This parameter requires
	// version 1.19 of the Docker Remote API or greater on your container instance.
	// To check the Docker Remote API version on your container instance, log in
	// to your container instance and run the following command: sudo docker version
	// --format '{{.Server.APIVersion}}'
	Options map[string]string `locationName:"options" type:"map"`

	// The secrets to pass to the log configuration. For more information, see Specifying
	// Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
	// in the Amazon Elastic Container Service Developer Guide.
	SecretOptions []Secret `locationName:"secretOptions" type:"list"`
}

// String returns the string representation
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogConfiguration"}
	if len(s.LogDriver) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LogDriver"))
	}
	if s.SecretOptions != nil {
		for i, v := range s.SecretOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecretOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The managed scaling settings for the Auto Scaling group capacity provider.
//
// When managed scaling is enabled, Amazon ECS manages the scale-in and scale-out
// actions of the Auto Scaling group. Amazon ECS manages a target tracking scaling
// policy using an Amazon ECS-managed CloudWatch metric with the specified targetCapacity
// value as the target value for the metric. For more information, see Using
// Managed Scaling (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling)
// in the Amazon Elastic Container Service Developer Guide.
//
// If managed scaling is disabled, the user must manage the scaling of the Auto
// Scaling group.
type ManagedScaling struct {
	_ struct{} `type:"structure"`

	// The maximum number of container instances that Amazon ECS will scale in or
	// scale out at one time. If this parameter is omitted, the default value of
	// 10000 is used.
	MaximumScalingStepSize *int64 `locationName:"maximumScalingStepSize" min:"1" type:"integer"`

	// The minimum number of container instances that Amazon ECS will scale in or
	// scale out at one time. If this parameter is omitted, the default value of
	// 1 is used.
	MinimumScalingStepSize *int64 `locationName:"minimumScalingStepSize" min:"1" type:"integer"`

	// Whether or not to enable managed scaling for the capacity provider.
	Status ManagedScalingStatus `locationName:"status" type:"string" enum:"true"`

	// The target capacity value for the capacity provider. The specified value
	// must be greater than 0 and less than or equal to 100. A value of 100 will
	// result in the Amazon EC2 instances in your Auto Scaling group being completely
	// utilized.
	TargetCapacity *int64 `locationName:"targetCapacity" min:"1" type:"integer"`
}

// String returns the string representation
func (s ManagedScaling) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedScaling) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ManagedScaling"}
	if s.MaximumScalingStepSize != nil && *s.MaximumScalingStepSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaximumScalingStepSize", 1))
	}
	if s.MinimumScalingStepSize != nil && *s.MinimumScalingStepSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinimumScalingStepSize", 1))
	}
	if s.TargetCapacity != nil && *s.TargetCapacity < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TargetCapacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on a volume mount point that is used in a container definition.
type MountPoint struct {
	_ struct{} `type:"structure"`

	// The path on the container to mount the host volume at.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// If this value is true, the container has read-only access to the volume.
	// If this value is false, then the container can write to the volume. The default
	// value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of the volume to mount. Must be a volume name referenced in the
	// name parameter of task definition volume.
	SourceVolume *string `locationName:"sourceVolume" type:"string"`
}

// String returns the string representation
func (s MountPoint) String() string {
	return awsutil.Prettify(s)
}

// Details on the network bindings between a container and its host container
// instance. After a task reaches the RUNNING status, manual and automatic host
// and container port assignments are visible in the networkBindings section
// of DescribeTasks API responses.
type NetworkBinding struct {
	_ struct{} `type:"structure"`

	// The IP address that the container is bound to on the container instance.
	BindIP *string `locationName:"bindIP" type:"string"`

	// The port number on the container that is used with the network binding.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port number on the host that is used with the network binding.
	HostPort *int64 `locationName:"hostPort" type:"integer"`

	// The protocol used for the network binding.
	Protocol TransportProtocol `locationName:"protocol" type:"string" enum:"true"`
}

// String returns the string representation
func (s NetworkBinding) String() string {
	return awsutil.Prettify(s)
}

// An object representing the network configuration for a task or service.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// The VPC subnets and security groups associated with a task.
	//
	// All specified subnets and security groups must be from the same VPC.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing the elastic network interface for tasks that use the
// awsvpc network mode.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The attachment ID for the network interface.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The private IPv6 address for the network interface.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string `locationName:"privateIpv4Address" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// An object representing a constraint on task placement. For more information,
// see Task Placement Constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// If you are using the Fargate launch type, task placement constraints are
// not supported.
type PlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance. For more
	// information, see Cluster Query Language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. Use distinctInstance to ensure that each task in
	// a particular group is running on a different container instance. Use memberOf
	// to restrict the selection to a group of valid candidates.
	Type PlacementConstraintType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s PlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// The task placement strategy for a task or service. For more information,
// see Task Placement Strategies (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html)
// in the Amazon Elastic Container Service Developer Guide.
type PlacementStrategy struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect),
	// or any platform or custom attribute that is applied to a container instance,
	// such as attribute:ecs.availability-zone. For the binpack placement strategy,
	// valid values are cpu and memory. For the random placement strategy, this
	// field is not used.
	Field *string `locationName:"field" type:"string"`

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least
	// amount of remaining memory (but still enough to run the task).
	Type PlacementStrategyType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s PlacementStrategy) String() string {
	return awsutil.Prettify(s)
}

// The devices that are available on the container instance. The only supported
// device type is a GPU.
type PlatformDevice struct {
	_ struct{} `type:"structure"`

	// The ID for the GPU(s) on the container instance. The available GPU IDs can
	// also be obtained on the container instance in the /var/lib/ecs/gpu/nvidia_gpu_info.json
	// file.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The type of device that is available on the container instance. The only
	// supported value is GPU.
	//
	// Type is a required field
	Type PlatformDeviceType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PlatformDevice) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlatformDevice) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PlatformDevice"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Port mappings allow containers to access ports on the host container instance
// to send or receive traffic. Port mappings are specified as part of the container
// definition.
//
// If you are using containers in a task with the awsvpc or host network mode,
// exposed ports should be specified using containerPort. The hostPort can be
// left blank or it must be the same value as the containerPort.
//
// After a task reaches the RUNNING status, manual and automatic host and container
// port assignments are visible in the networkBindings section of DescribeTasks
// API responses.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port number on the container that is bound to the user-specified or automatically
	// assigned host port.
	//
	// If you are using containers in a task with the awsvpc or host network mode,
	// exposed ports should be specified using containerPort.
	//
	// If you are using containers in a task with the bridge network mode and you
	// specify a container port and not a host port, your container automatically
	// receives a host port in the ephemeral port range. For more information, see
	// hostPort. Port mappings that are automatically assigned in this way do not
	// count toward the 100 reserved ports limit of a container instance.
	//
	// You cannot expose the same container port for multiple protocols. An error
	// will be returned if this is attempted.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port number on the container instance to reserve for your container.
	//
	// If you are using containers in a task with the awsvpc or host network mode,
	// the hostPort can either be left blank or set to the same value as the containerPort.
	//
	// If you are using containers in a task with the bridge network mode, you can
	// specify a non-reserved host port for your container port mapping, or you
	// can omit the hostPort (or set it to 0) while specifying a containerPort and
	// your container automatically receives a port in the ephemeral port range
	// for your container instance operating system and Docker version.
	//
	// The default ephemeral port range for Docker version 1.6.0 and later is listed
	// on the instance under /proc/sys/net/ipv4/ip_local_port_range. If this kernel
	// parameter is unavailable, the default ephemeral port range from 49153 through
	// 65535 is used. Do not attempt to specify a host port in the ephemeral port
	// range as these are reserved for automatic assignment. In general, ports below
	// 32768 are outside of the ephemeral port range.
	//
	// The default ephemeral port range from 49153 through 65535 is always used
	// for Docker versions before 1.6.0.
	//
	// The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376,
	// and the Amazon ECS container agent ports 51678-51680. Any host port that
	// was previously specified in a running task is also reserved while the task
	// is running (after a task stops, the host port is released). The current reserved
	// ports are displayed in the remainingResources of DescribeContainerInstances
	// output. A container instance can have up to 100 reserved ports at a time,
	// including the default reserved ports. Automatically assigned ports don't
	// count toward the 100 reserved ports limit.
	HostPort *int64 `locationName:"hostPort" type:"integer"`

	// The protocol used for the port mapping. Valid values are tcp and udp. The
	// default is tcp.
	Protocol TransportProtocol `locationName:"protocol" type:"string" enum:"true"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// The configuration details for the App Mesh proxy.
//
// For tasks using the EC2 launch type, the container instances require at least
// version 1.26.0 of the container agent and at least version 1.26.0-1 of the
// ecs-init package to enable a proxy configuration. If your container instances
// are launched from the Amazon ECS-optimized AMI version 20190301 or later,
// then they contain the required versions of the container agent and ecs-init.
// For more information, see Amazon ECS-optimized Linux AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// For tasks using the Fargate launch type, the task or service requires platform
// version 1.3.0 or later.
type ProxyConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the container that will serve as the App Mesh proxy.
	//
	// ContainerName is a required field
	ContainerName *string `locationName:"containerName" type:"string" required:"true"`

	// The set of network configuration parameters to provide the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	//
	//    * IgnoredUID - (Required) The user ID (UID) of the proxy container as
	//    defined by the user parameter in a container definition. This is used
	//    to ensure the proxy ignores its own traffic. If IgnoredGID is specified,
	//    this field can be empty.
	//
	//    * IgnoredGID - (Required) The group ID (GID) of the proxy container as
	//    defined by the user parameter in a container definition. This is used
	//    to ensure the proxy ignores its own traffic. If IgnoredUID is specified,
	//    this field can be empty.
	//
	//    * AppPorts - (Required) The list of ports that the application uses. Network
	//    traffic to these ports is forwarded to the ProxyIngressPort and ProxyEgressPort.
	//
	//    * ProxyIngressPort - (Required) Specifies the port that incoming traffic
	//    to the AppPorts is directed to.
	//
	//    * ProxyEgressPort - (Required) Specifies the port that outgoing traffic
	//    from the AppPorts is directed to.
	//
	//    * EgressIgnoredPorts - (Required) The egress traffic going to the specified
	//    ports is ignored and not redirected to the ProxyEgressPort. It can be
	//    an empty list.
	//
	//    * EgressIgnoredIPs - (Required) The egress traffic going to the specified
	//    IP addresses is ignored and not redirected to the ProxyEgressPort. It
	//    can be an empty list.
	Properties []KeyValuePair `locationName:"properties" type:"list"`

	// The proxy type. The only supported value is APPMESH.
	Type ProxyConfigurationType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ProxyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProxyConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProxyConfiguration"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The repository credentials for private registry authentication.
type RepositoryCredentials struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret containing the private repository
	// credentials.
	//
	// When you are using the Amazon ECS API, AWS CLI, or AWS SDK, if the secret
	// exists in the same Region as the task that you are launching then you can
	// use either the full ARN or the name of the secret. When you are using the
	// AWS Management Console, you must specify the full ARN of the secret.
	//
	// CredentialsParameter is a required field
	CredentialsParameter *string `locationName:"credentialsParameter" type:"string" required:"true"`
}

// String returns the string representation
func (s RepositoryCredentials) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryCredentials) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RepositoryCredentials"}

	if s.CredentialsParameter == nil {
		invalidParams.Add(aws.NewErrParamRequired("CredentialsParameter"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the resources available for a container instance.
type Resource struct {
	_ struct{} `type:"structure"`

	// When the doubleValue type is set, the value of the resource must be a double
	// precision floating-point type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// When the integerValue type is set, the value of the resource must be an integer.
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// When the longValue type is set, the value of the resource must be an extended
	// precision floating-point type.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// The name of the resource, such as CPU, MEMORY, PORTS, PORTS_UDP, or a user-defined
	// resource.
	Name *string `locationName:"name" type:"string"`

	// When the stringSetValue type is set, the value of the resource must be a
	// string type.
	StringSetValue []string `locationName:"stringSetValue" type:"list"`

	// The type of the resource, such as INTEGER, DOUBLE, LONG, or STRINGSET.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// The type and amount of a resource to assign to a container. The supported
// resource types are GPUs and Elastic Inference accelerators. For more information,
// see Working with GPUs on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html)
// or Working with Amazon Elastic Inference on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-eia.html)
// in the Amazon Elastic Container Service Developer Guide
type ResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. The supported values are GPU
	// or InferenceAccelerator.
	//
	// Type is a required field
	Type ResourceType `locationName:"type" type:"string" required:"true" enum:"true"`

	// The value for the specified resource type.
	//
	// If the GPU type is used, the value is the number of physical GPUs the Amazon
	// ECS container agent will reserve for the container. The number of GPUs reserved
	// for all containers in a task should not exceed the number of available GPUs
	// on the container instance the task is launched on.
	//
	// If the InferenceAccelerator type is used, the value should match the deviceName
	// for an InferenceAccelerator specified in a task definition.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRequirement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceRequirement"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A floating-point percentage of the desired number of tasks to place and keep
// running in the task set.
type Scale struct {
	_ struct{} `type:"structure"`

	// The unit of measure for the scale value.
	Unit ScaleUnit `locationName:"unit" type:"string" enum:"true"`

	// The value, specified as a percent total of a service's desiredCount, to scale
	// the task set. Accepted values are numbers between 0 and 100.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation
func (s Scale) String() string {
	return awsutil.Prettify(s)
}

// An object representing the secret to expose to your container. Secrets can
// be exposed to a container in the following ways:
//
//    * To inject sensitive data into your containers as environment variables,
//    use the secrets container definition parameter.
//
//    * To reference sensitive information in the log configuration of a container,
//    use the secretOptions container definition parameter.
//
// For more information, see Specifying Sensitive Data (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
// in the Amazon Elastic Container Service Developer Guide.
type Secret struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The secret to expose to the container. The supported values are either the
	// full ARN of the AWS Secrets Manager secret or the full ARN of the parameter
	// in the AWS Systems Manager Parameter Store.
	//
	// If the AWS Systems Manager Parameter Store parameter exists in the same Region
	// as the task you are launching, then you can use either the full ARN or name
	// of the parameter. If the parameter exists in a different Region, then the
	// full ARN must be specified.
	//
	// ValueFrom is a required field
	ValueFrom *string `locationName:"valueFrom" type:"string" required:"true"`
}

// String returns the string representation
func (s Secret) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Secret) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Secret"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.ValueFrom == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValueFrom"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on a service within a cluster
type Service struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy associated with the service.
	CapacityProviderStrategy []CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Amazon Resource Name (ARN) of the cluster that hosts the service.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The Unix timestamp for when the service was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The principal that created the service.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// Optional deployment parameters that control how many tasks run during the
	// deployment and the ordering of stopping and starting tasks.
	DeploymentConfiguration *DeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// The deployment controller type the service is using. When using the DescribeServices
	// API, this field is omitted if the service is using the ECS deployment controller
	// type.
	DeploymentController *DeploymentController `locationName:"deploymentController" type:"structure"`

	// The current state of deployments for the service.
	Deployments []Deployment `locationName:"deployments" type:"list"`

	// The desired number of instantiations of the task definition to keep running
	// on the service. This value is specified when the service is created with
	// CreateService, and it can be modified with UpdateService.
	DesiredCount *int64 `locationName:"desiredCount" type:"integer"`

	// Specifies whether to enable Amazon ECS managed tags for the tasks in the
	// service. For more information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `locationName:"enableECSManagedTags" type:"boolean"`

	// The event stream for your service. A maximum of 100 of the latest events
	// are displayed.
	Events []ServiceEvent `locationName:"events" type:"list"`

	// The period of time, in seconds, that the Amazon ECS service scheduler ignores
	// unhealthy Elastic Load Balancing target health checks after a task has first
	// started.
	HealthCheckGracePeriodSeconds *int64 `locationName:"healthCheckGracePeriodSeconds" type:"integer"`

	// The launch type on which your service is running. If no value is specified,
	// it will default to EC2. Valid values include EC2 and FARGATE. For more information,
	// see Amazon ECS Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType LaunchType `locationName:"launchType" type:"string" enum:"true"`

	// A list of Elastic Load Balancing load balancer objects, containing the load
	// balancer name, the container name (as it appears in a container definition),
	// and the container port to access from the load balancer.
	LoadBalancers []LoadBalancer `locationName:"loadBalancers" type:"list"`

	// The VPC subnet and security group configuration for tasks that receive their
	// own elastic network interface by using the awsvpc networking mode.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the cluster that are in the PENDING state.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The placement constraints for the tasks in the service.
	PlacementConstraints []PlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The placement strategy that determines how tasks for the service are placed.
	PlacementStrategy []PlacementStrategy `locationName:"placementStrategy" type:"list"`

	// The platform version on which to run your service. A platform version is
	// only specified for tasks using the Fargate launch type. If one is not specified,
	// the LATEST platform version is used by default. For more information, see
	// AWS Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// Specifies whether to propagate the tags from the task definition or the service
	// to the task. If no value is specified, the tags are not propagated.
	PropagateTags PropagateTags `locationName:"propagateTags" type:"string" enum:"true"`

	// The ARN of the IAM role associated with the service that allows the Amazon
	// ECS container agent to register container instances with an Elastic Load
	// Balancing load balancer.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// The scheduling strategy to use for the service. For more information, see
	// Services (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
	//
	// There are two service scheduler strategies available:
	//
	//    * REPLICA-The replica scheduling strategy places and maintains the desired
	//    number of tasks across your cluster. By default, the service scheduler
	//    spreads tasks across Availability Zones. You can use task placement strategies
	//    and constraints to customize task placement decisions.
	//
	//    * DAEMON-The daemon scheduling strategy deploys exactly one task on each
	//    container instance in your cluster. When you are using this strategy,
	//    do not specify a desired number of tasks or any task placement strategies.
	//    Fargate tasks do not support the DAEMON scheduling strategy.
	SchedulingStrategy SchedulingStrategy `locationName:"schedulingStrategy" type:"string" enum:"true"`

	// The ARN that identifies the service. The ARN contains the arn:aws:ecs namespace,
	// followed by the Region of the service, the AWS account ID of the service
	// owner, the service namespace, and then the service name. For example, arn:aws:ecs:region:012345678910:service/my-service.
	ServiceArn *string `locationName:"serviceArn" type:"string"`

	// The name of your service. Up to 255 letters (uppercase and lowercase), numbers,
	// and hyphens are allowed. Service names must be unique within a cluster, but
	// you can have similarly named services in multiple clusters within a Region
	// or across multiple Regions.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The details of the service discovery registries to assign to this service.
	// For more information, see Service Discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	ServiceRegistries []ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The status of the service. The valid values are ACTIVE, DRAINING, or INACTIVE.
	Status *string `locationName:"status" type:"string"`

	// The metadata that you apply to the service to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`

	// The task definition to use for tasks in the service. This value is specified
	// when the service is created with CreateService, and it can be modified with
	// UpdateService.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or
	// an EXTERNAL deployment. An Amazon ECS task set includes details such as the
	// desired number of tasks, how many tasks are running, and whether the task
	// set serves production traffic.
	TaskSets []TaskSet `locationName:"taskSets" type:"list"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// Details on an event associated with a service.
type ServiceEvent struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for when the event was triggered.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID string of the event.
	Id *string `locationName:"id" type:"string"`

	// The event message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceEvent) String() string {
	return awsutil.Prettify(s)
}

// Details of the service registry.
type ServiceRegistry struct {
	_ struct{} `type:"structure"`

	// The container name value, already specified in the task definition, to be
	// used for your service discovery service. If the task definition that your
	// service task specifies uses the bridge or host network mode, you must specify
	// a containerName and containerPort combination from the task definition. If
	// the task definition that your service task specifies uses the awsvpc network
	// mode and a type SRV DNS record is used, you must specify either a containerName
	// and containerPort combination or a port value, but not both.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The port value, already specified in the task definition, to be used for
	// your service discovery service. If the task definition your service task
	// specifies uses the bridge or host network mode, you must specify a containerName
	// and containerPort combination from the task definition. If the task definition
	// your service task specifies uses the awsvpc network mode and a type SRV DNS
	// record is used, you must specify either a containerName and containerPort
	// combination or a port value, but not both.
	ContainerPort *int64 `locationName:"containerPort" type:"integer"`

	// The port value used if your service discovery service specified an SRV record.
	// This field may be used if both the awsvpc network mode and SRV records are
	// used.
	Port *int64 `locationName:"port" type:"integer"`

	// The Amazon Resource Name (ARN) of the service registry. The currently supported
	// service registry is AWS Cloud Map. For more information, see CreateService
	// (https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
	RegistryArn *string `locationName:"registryArn" type:"string"`
}

// String returns the string representation
func (s ServiceRegistry) String() string {
	return awsutil.Prettify(s)
}

// The current account setting for a resource.
type Setting struct {
	_ struct{} `type:"structure"`

	// The Amazon ECS resource name.
	Name SettingName `locationName:"name" type:"string" enum:"true"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If this field is omitted, the authenticated user is assumed.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// Whether the account setting is enabled or disabled for the specified resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Setting) String() string {
	return awsutil.Prettify(s)
}

// A list of namespaced kernel parameters to set in the container. This parameter
// maps to Sysctls in the Create a container (https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.35/)
// and the --sysctl option to docker run (https://docs.docker.com/engine/reference/run/).
//
// It is not recommended that you specify network-related systemControls parameters
// for multiple containers in a single task that also uses either the awsvpc
// or host network mode for the following reasons:
//
//    * For tasks that use the awsvpc network mode, if you set systemControls
//    for any container, it applies to all containers in the task. If you set
//    different systemControls for multiple containers in a single task, the
//    container that is started last determines which systemControls take effect.
//
//    * For tasks that use the host network mode, the systemControls parameter
//    applies to the container instance's kernel parameter as well as that of
//    all containers of any tasks running on that container instance.
type SystemControl struct {
	_ struct{} `type:"structure"`

	// The namespaced kernel parameter for which to set a value.
	Namespace *string `locationName:"namespace" type:"string"`

	// The value for the namespaced kernel parameter specified in namespace.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s SystemControl) String() string {
	return awsutil.Prettify(s)
}

// The metadata that you apply to a resource to help you categorize and organize
// them. Each tag consists of a key and an optional value, both of which you
// define.
//
// The following basic restrictions apply to tags:
//
//    * Maximum number of tags per resource - 50
//
//    * For each resource, each tag key must be unique, and each tag key can
//    have only one value.
//
//    * Maximum key length - 128 Unicode characters in UTF-8
//
//    * Maximum value length - 256 Unicode characters in UTF-8
//
//    * If your tagging schema is used across multiple services and resources,
//    remember that other services may have restrictions on allowed characters.
//    Generally allowed characters are: letters, numbers, and spaces representable
//    in UTF-8, and the following characters: + - = . _ : / @.
//
//    * Tag keys and values are case-sensitive.
//
//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
//    as a prefix for either keys or values as it is reserved for AWS use. You
//    cannot edit or delete tag keys or values with this prefix. Tags with this
//    prefix do not count against your tags per resource limit.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details on a task in a cluster.
type Task struct {
	_ struct{} `type:"structure"`

	// The Elastic Network Adapter associated with the task if the task uses the
	// awsvpc network mode.
	Attachments []Attachment `locationName:"attachments" type:"list"`

	// The attributes of the task
	Attributes []Attribute `locationName:"attributes" type:"list"`

	// The availability zone of the task.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The capacity provider associated with the task.
	CapacityProviderName *string `locationName:"capacityProviderName" type:"string"`

	// The ARN of the cluster that hosts the task.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The connectivity status of a task.
	Connectivity Connectivity `locationName:"connectivity" type:"string" enum:"true"`

	// The Unix timestamp for when the task last went into CONNECTED status.
	ConnectivityAt *time.Time `locationName:"connectivityAt" type:"timestamp"`

	// The ARN of the container instances that host the task.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The containers associated with the task.
	Containers []Container `locationName:"containers" type:"list"`

	// The number of CPU units used by the task as expressed in a task definition.
	// It can be expressed as an integer using CPU units, for example 1024. It can
	// also be expressed as a string using vCPUs, for example 1 vCPU or 1 vcpu.
	// String values are converted to an integer indicating the CPU units when the
	// task definition is registered.
	//
	// If you are using the EC2 launch type, this field is optional. Supported values
	// are between 128 CPU units (0.125 vCPUs) and 10240 CPU units (10 vCPUs).
	//
	// If you are using the Fargate launch type, this field is required and you
	// must use one of the following values, which determines your range of supported
	// values for the memory parameter:
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The Unix timestamp for when the task was created (the task entered the PENDING
	// state).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The desired status of the task. For more information, see Task Lifecycle
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
	DesiredStatus *string `locationName:"desiredStatus" type:"string"`

	// The Unix timestamp for when the task execution stopped.
	ExecutionStoppedAt *time.Time `locationName:"executionStoppedAt" type:"timestamp"`

	// The name of the task group associated with the task.
	Group *string `locationName:"group" type:"string"`

	// The health status for the task, which is determined by the health of the
	// essential containers in the task. If all essential containers in the task
	// are reporting as HEALTHY, then the task status also reports as HEALTHY. If
	// any essential containers in the task are reporting as UNHEALTHY or UNKNOWN,
	// then the task status also reports as UNHEALTHY or UNKNOWN, accordingly.
	//
	// The Amazon ECS container agent does not monitor or report on Docker health
	// checks that are embedded in a container image (such as those specified in
	// a parent image or from the image's Dockerfile) and not specified in the container
	// definition. Health check parameters that are specified in a container definition
	// override any Docker health checks that exist in the container image.
	HealthStatus HealthStatus `locationName:"healthStatus" type:"string" enum:"true"`

	// The Elastic Inference accelerator associated with the task.
	InferenceAccelerators []InferenceAccelerator `locationName:"inferenceAccelerators" type:"list"`

	// The last known status of the task. For more information, see Task Lifecycle
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
	LastStatus *string `locationName:"lastStatus" type:"string"`

	// The launch type on which your task is running. For more information, see
	// Amazon ECS Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType LaunchType `locationName:"launchType" type:"string" enum:"true"`

	// The amount of memory (in MiB) used by the task as expressed in a task definition.
	// It can be expressed as an integer using MiB, for example 1024. It can also
	// be expressed as a string using GB, for example 1GB or 1 GB. String values
	// are converted to an integer indicating the MiB when the task definition is
	// registered.
	//
	// If you are using the EC2 launch type, this field is optional.
	//
	// If you are using the Fargate launch type, this field is required and you
	// must use one of the following values, which determines your range of supported
	// values for the cpu parameter:
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// One or more container overrides.
	Overrides *TaskOverride `locationName:"overrides" type:"structure"`

	// The platform version on which your task is running. A platform version is
	// only specified for tasks using the Fargate launch type. If one is not specified,
	// the LATEST platform version is used by default. For more information, see
	// AWS Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The Unix timestamp for when the container image pull began.
	PullStartedAt *time.Time `locationName:"pullStartedAt" type:"timestamp"`

	// The Unix timestamp for when the container image pull completed.
	PullStoppedAt *time.Time `locationName:"pullStoppedAt" type:"timestamp"`

	// The Unix timestamp for when the task started (the task transitioned from
	// the PENDING state to the RUNNING state).
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// The tag specified when a task is started. If the task is started by an Amazon
	// ECS service, then the startedBy parameter contains the deployment ID of the
	// service that starts it.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The stop code indicating why a task was stopped. The stoppedReason may contain
	// additional details.
	StopCode TaskStopCode `locationName:"stopCode" type:"string" enum:"true"`

	// The Unix timestamp for when the task was stopped (the task transitioned from
	// the RUNNING state to the STOPPED state).
	StoppedAt *time.Time `locationName:"stoppedAt" type:"timestamp"`

	// The reason that the task was stopped.
	StoppedReason *string `locationName:"stoppedReason" type:"string"`

	// The Unix timestamp for when the task stops (transitions from the RUNNING
	// state to STOPPED).
	StoppingAt *time.Time `locationName:"stoppingAt" type:"timestamp"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// The ARN of the task definition that creates the task.
	TaskDefinitionArn *string `locationName:"taskDefinitionArn" type:"string"`

	// The version counter for the task. Every time a task experiences a change
	// that triggers a CloudWatch event, the version counter is incremented. If
	// you are replicating your Amazon ECS task state with CloudWatch Events, you
	// can compare the version of a task reported by the Amazon ECS API actions
	// with the version reported in CloudWatch Events for the task (inside the detail
	// object) to verify that the version in your event stream is current.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// The details of a task definition which describes the container and volume
// definitions of an Amazon Elastic Container Service task. You can specify
// which Docker images to use, the required resources, and other configurations
// related to launching the task definition through an Amazon ECS service or
// task.
type TaskDefinition struct {
	_ struct{} `type:"structure"`

	// The launch type to use with your task. For more information, see Amazon ECS
	// Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Compatibilities []Compatibility `locationName:"compatibilities" type:"list"`

	// A list of container definitions in JSON format that describe the different
	// containers that make up your task. For more information about container definition
	// parameters and defaults, see Amazon ECS Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ContainerDefinitions []ContainerDefinition `locationName:"containerDefinitions" type:"list"`

	// The number of cpu units used by the task. If you are using the EC2 launch
	// type, this field is optional and any value can be used. If you are using
	// the Fargate launch type, this field is required and you must use one of the
	// following values, which determines your range of valid values for the memory
	// parameter:
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The Amazon Resource Name (ARN) of the task execution role that containers
	// in this task can assume. All containers in this task are granted the permissions
	// that are specified in this role.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The name of a family that this task definition is registered to. A family
	// groups multiple versions of a task definition. Amazon ECS gives the first
	// task definition that you registered to a family a revision number of 1. Amazon
	// ECS gives sequential revision numbers to each task definition that you add.
	Family *string `locationName:"family" type:"string"`

	// The Elastic Inference accelerator associated with the task.
	InferenceAccelerators []InferenceAccelerator `locationName:"inferenceAccelerators" type:"list"`

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host, task, or none. If host is specified, then all containers
	// within the tasks that specified the host IPC mode on the same container instance
	// share the same IPC resources with the host Amazon EC2 instance. If task is
	// specified, all containers within the specified task share the same IPC resources.
	// If none is specified, then IPC resources within the containers of a task
	// are private and not shared with other containers in a task or on the container
	// instance. If no value is specified, then the IPC resource namespace sharing
	// depends on the Docker daemon setting on the container instance. For more
	// information, see IPC settings (https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
	// in the Docker run reference.
	//
	// If the host IPC mode is used, be aware that there is a heightened risk of
	// undesired IPC namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// If you are setting namespaced kernel parameters using systemControls for
	// the containers in the task, the following will apply to your IPC resource
	// namespace. For more information, see System Controls (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	//    * For tasks that use the host IPC mode, IPC namespace related systemControls
	//    are not supported.
	//
	//    * For tasks that use the task IPC mode, IPC namespace related systemControls
	//    will apply to all containers within a task.
	//
	// This parameter is not supported for Windows containers or tasks using the
	// Fargate launch type.
	IpcMode IpcMode `locationName:"ipcMode" type:"string" enum:"true"`

	// The amount (in MiB) of memory used by the task.
	//
	// If using the EC2 launch type, this field is optional and any value can be
	// used. If a task-level memory value is specified then the container-level
	// memory value is optional.
	//
	// If using the Fargate launch type, this field is required and you must use
	// one of the following values, which determines your range of valid values
	// for the cpu parameter:
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// The Docker networking mode to use for the containers in the task. The valid
	// values are none, bridge, awsvpc, and host. The default Docker network mode
	// is bridge. If you are using the Fargate launch type, the awsvpc network mode
	// is required. If you are using the EC2 launch type, any network mode can be
	// used. If the network mode is set to none, you cannot specify port mappings
	// in your container definitions, and the tasks containers do not have external
	// connectivity. The host and awsvpc network modes offer the highest networking
	// performance for containers because they use the EC2 network stack instead
	// of the virtualized network stack provided by the bridge mode.
	//
	// With the host and awsvpc network modes, exposed container ports are mapped
	// directly to the corresponding host port (for the host network mode) or the
	// attached elastic network interface port (for the awsvpc network mode), so
	// you cannot take advantage of dynamic host port mappings.
	//
	// If the network mode is awsvpc, the task is allocated an elastic network interface,
	// and you must specify a NetworkConfiguration value when you create a service
	// or run a task with the task definition. For more information, see Task Networking
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with
	// the ecs-init package, or AWS Fargate infrastructure support the awsvpc network
	// mode.
	//
	// If the network mode is host, you cannot run multiple instantiations of the
	// same task on a single container instance when port mappings are used.
	//
	// Docker for Windows uses different network modes than Docker for Linux. When
	// you register a task definition with Windows containers, you must not specify
	// a network mode. If you use the console to register a task definition with
	// Windows containers, you must choose the <default> network mode object.
	//
	// For more information, see Network settings (https://docs.docker.com/engine/reference/run/#network-settings)
	// in the Docker run reference.
	NetworkMode NetworkMode `locationName:"networkMode" type:"string" enum:"true"`

	// The process namespace to use for the containers in the task. The valid values
	// are host or task. If host is specified, then all containers within the tasks
	// that specified the host PID mode on the same container instance share the
	// same process namespace with the host Amazon EC2 instance. If task is specified,
	// all containers within the specified task share the same process namespace.
	// If no value is specified, the default is a private namespace. For more information,
	// see PID settings (https://docs.docker.com/engine/reference/run/#pid-settings---pid)
	// in the Docker run reference.
	//
	// If the host PID mode is used, be aware that there is a heightened risk of
	// undesired process namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// This parameter is not supported for Windows containers or tasks using the
	// Fargate launch type.
	PidMode PidMode `locationName:"pidMode" type:"string" enum:"true"`

	// An array of placement constraint objects to use for tasks. This field is
	// not valid if you are using the Fargate launch type for your task.
	PlacementConstraints []TaskDefinitionPlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The configuration details for the App Mesh proxy.
	//
	// Your Amazon ECS container instances require at least version 1.26.0 of the
	// container agent and at least version 1.26.0-1 of the ecs-init package to
	// enable a proxy configuration. If your container instances are launched from
	// the Amazon ECS-optimized AMI version 20190301 or later, then they contain
	// the required versions of the container agent and ecs-init. For more information,
	// see Amazon ECS-optimized Linux AMI (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ProxyConfiguration *ProxyConfiguration `locationName:"proxyConfiguration" type:"structure"`

	// The container instance attributes required by your task. This field is not
	// valid if you are using the Fargate launch type for your task.
	RequiresAttributes []Attribute `locationName:"requiresAttributes" type:"list"`

	// The launch type the task requires. If no value is specified, it will default
	// to EC2. Valid values include EC2 and FARGATE.
	RequiresCompatibilities []Compatibility `locationName:"requiresCompatibilities" type:"list"`

	// The revision of the task in a particular family. The revision is a version
	// number of a task definition in a family. When you register a task definition
	// for the first time, the revision is 1. Each time that you register a new
	// revision of a task definition in the same family, the revision value always
	// increases by one, even if you have deregistered previous revisions in this
	// family.
	Revision *int64 `locationName:"revision" type:"integer"`

	// The status of the task definition.
	Status TaskDefinitionStatus `locationName:"status" type:"string" enum:"true"`

	// The full Amazon Resource Name (ARN) of the task definition.
	TaskDefinitionArn *string `locationName:"taskDefinitionArn" type:"string"`

	// The short name or full Amazon Resource Name (ARN) of the AWS Identity and
	// Access Management (IAM) role that grants containers in the task permission
	// to call AWS APIs on your behalf. For more information, see Amazon ECS Task
	// Role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_IAM_role.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// IAM roles for tasks on Windows require that the -EnableTaskIAMRole option
	// is set when you launch the Amazon ECS-optimized Windows AMI. Your containers
	// must also run some configuration code in order to take advantage of the feature.
	// For more information, see Windows IAM Roles for Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// The list of volume definitions for the task.
	//
	// If your tasks are using the Fargate launch type, the host and sourcePath
	// parameters are not supported.
	//
	// For more information about volume definition parameters and defaults, see
	// Amazon ECS Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definitions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Volumes []Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s TaskDefinition) String() string {
	return awsutil.Prettify(s)
}

// An object representing a constraint on task placement in the task definition.
// For more information, see Task Placement Constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// If you are using the Fargate launch type, task placement constraints are
// not supported.
type TaskDefinitionPlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. For more
	// information, see Cluster Query Language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. The MemberOf constraint restricts selection to be
	// from a group of valid candidates.
	Type TaskDefinitionPlacementConstraintType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s TaskDefinitionPlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// The overrides associated with a task.
type TaskOverride struct {
	_ struct{} `type:"structure"`

	// One or more container overrides sent to a task.
	ContainerOverrides []ContainerOverride `locationName:"containerOverrides" type:"list"`

	// The cpu override for the task.
	Cpu *string `locationName:"cpu" type:"string"`

	// The Amazon Resource Name (ARN) of the task execution role that the Amazon
	// ECS container agent and the Docker daemon can assume.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// The Elastic Inference accelerator override for the task.
	InferenceAcceleratorOverrides []InferenceAcceleratorOverride `locationName:"inferenceAcceleratorOverrides" type:"list"`

	// The memory override for the task.
	Memory *string `locationName:"memory" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that containers in this task
	// can assume. All containers in this task are granted the permissions that
	// are specified in this role.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`
}

// String returns the string representation
func (s TaskOverride) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskOverride) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TaskOverride"}
	if s.ContainerOverrides != nil {
		for i, v := range s.ContainerOverrides {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContainerOverrides", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or
// an EXTERNAL deployment. An Amazon ECS task set includes details such as the
// desired number of tasks, how many tasks are running, and whether the task
// set serves production traffic.
type TaskSet struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy associated with the task set.
	CapacityProviderStrategy []CapacityProviderStrategyItem `locationName:"capacityProviderStrategy" type:"list"`

	// The Amazon Resource Name (ARN) of the cluster that the service that hosts
	// the task set exists in.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The computed desired count for the task set. This is calculated by multiplying
	// the service's desiredCount by the task set's scale percentage. The result
	// is always rounded up. For example, if the computed desired count is 1.2,
	// it rounds up to 2 tasks.
	ComputedDesiredCount *int64 `locationName:"computedDesiredCount" type:"integer"`

	// The Unix timestamp for when the task set was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The external ID associated with the task set.
	//
	// If a task set is created by an AWS CodeDeploy deployment, the externalId
	// parameter contains the AWS CodeDeploy deployment ID.
	//
	// If a task set is created for an external deployment and is associated with
	// a service discovery registry, the externalId parameter contains the ECS_TASK_SET_EXTERNAL_ID
	// AWS Cloud Map attribute.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The ID of the task set.
	Id *string `locationName:"id" type:"string"`

	// The launch type the tasks in the task set are using. For more information,
	// see Amazon ECS Launch Types (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType LaunchType `locationName:"launchType" type:"string" enum:"true"`

	// Details on a load balancer that is used with a task set.
	LoadBalancers []LoadBalancer `locationName:"loadBalancers" type:"list"`

	// The network configuration for the task set.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The number of tasks in the task set that are in the PENDING status during
	// a deployment. A task in the PENDING state is preparing to enter the RUNNING
	// state. A task set enters the PENDING status when it launches for the first
	// time or when it is restarted after being in the STOPPED state.
	PendingCount *int64 `locationName:"pendingCount" type:"integer"`

	// The platform version on which the tasks in the task set are running. A platform
	// version is only specified for tasks using the Fargate launch type. If one
	// is not specified, the LATEST platform version is used by default. For more
	// information, see AWS Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The number of tasks in the task set that are in the RUNNING status during
	// a deployment. A task in the RUNNING state is running and ready for use.
	RunningCount *int64 `locationName:"runningCount" type:"integer"`

	// A floating-point percentage of the desired number of tasks to place and keep
	// running in the task set.
	Scale *Scale `locationName:"scale" type:"structure"`

	// The Amazon Resource Name (ARN) of the service the task set exists in.
	ServiceArn *string `locationName:"serviceArn" type:"string"`

	// The details of the service discovery registries to assign to this task set.
	// For more information, see Service Discovery (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
	ServiceRegistries []ServiceRegistry `locationName:"serviceRegistries" type:"list"`

	// The stability status, which indicates whether the task set has reached a
	// steady state. If the following conditions are met, the task set will be in
	// STEADY_STATE:
	//
	//    * The task runningCount is equal to the computedDesiredCount.
	//
	//    * The pendingCount is 0.
	//
	//    * There are no tasks running on container instances in the DRAINING status.
	//
	//    * All tasks are reporting a healthy status from the load balancers, service
	//    discovery, and container health checks.
	//
	// If any of those conditions are not met, the stability status returns STABILIZING.
	StabilityStatus StabilityStatus `locationName:"stabilityStatus" type:"string" enum:"true"`

	// The Unix timestamp for when the task set stability status was retrieved.
	StabilityStatusAt *time.Time `locationName:"stabilityStatusAt" type:"timestamp"`

	// The tag specified when a task set is started. If the task set is created
	// by an AWS CodeDeploy deployment, the startedBy parameter is CODE_DEPLOY.
	// For a task set created for an external deployment, the startedBy field isn't
	// used.
	StartedBy *string `locationName:"startedBy" type:"string"`

	// The status of the task set. The following describes each state:
	//
	// PRIMARY
	//
	// The task set is serving production traffic.
	//
	// ACTIVE
	//
	// The task set is not serving production traffic.
	//
	// DRAINING
	//
	// The tasks in the task set are being stopped and their corresponding targets
	// are being deregistered from their target group.
	Status *string `locationName:"status" type:"string"`

	// The task definition the task set is using.
	TaskDefinition *string `locationName:"taskDefinition" type:"string"`

	// The Amazon Resource Name (ARN) of the task set.
	TaskSetArn *string `locationName:"taskSetArn" type:"string"`

	// The Unix timestamp for when the task set was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation
func (s TaskSet) String() string {
	return awsutil.Prettify(s)
}

// The container path, mount options, and size of the tmpfs mount.
type Tmpfs struct {
	_ struct{} `type:"structure"`

	// The absolute file path where the tmpfs volume is to be mounted.
	//
	// ContainerPath is a required field
	ContainerPath *string `locationName:"containerPath" type:"string" required:"true"`

	// The list of tmpfs volume mount options.
	//
	// Valid values: "defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev"
	// | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" |
	// "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind"
	// | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared"
	// | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime"
	// | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"
	MountOptions []string `locationName:"mountOptions" type:"list"`

	// The size (in MiB) of the tmpfs volume.
	//
	// Size is a required field
	Size *int64 `locationName:"size" type:"integer" required:"true"`
}

// String returns the string representation
func (s Tmpfs) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tmpfs) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tmpfs"}

	if s.ContainerPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerPath"))
	}

	if s.Size == nil {
		invalidParams.Add(aws.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The ulimit settings to pass to the container.
type Ulimit struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	//
	// HardLimit is a required field
	HardLimit *int64 `locationName:"hardLimit" type:"integer" required:"true"`

	// The type of the ulimit.
	//
	// Name is a required field
	Name UlimitName `locationName:"name" type:"string" required:"true" enum:"true"`

	// The soft limit for the ulimit type.
	//
	// SoftLimit is a required field
	SoftLimit *int64 `locationName:"softLimit" type:"integer" required:"true"`
}

// String returns the string representation
func (s Ulimit) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ulimit) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ulimit"}

	if s.HardLimit == nil {
		invalidParams.Add(aws.NewErrParamRequired("HardLimit"))
	}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SoftLimit == nil {
		invalidParams.Add(aws.NewErrParamRequired("SoftLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Docker and Amazon ECS container agent version information about a container
// instance.
type VersionInfo struct {
	_ struct{} `type:"structure"`

	// The Git commit hash for the Amazon ECS container agent build on the amazon-ecs-agent
	// (https://github.com/aws/amazon-ecs-agent/commits/master) GitHub repository.
	AgentHash *string `locationName:"agentHash" type:"string"`

	// The version number of the Amazon ECS container agent.
	AgentVersion *string `locationName:"agentVersion" type:"string"`

	// The Docker version running on the container instance.
	DockerVersion *string `locationName:"dockerVersion" type:"string"`
}

// String returns the string representation
func (s VersionInfo) String() string {
	return awsutil.Prettify(s)
}

// A data volume used in a task definition. For tasks that use a Docker volume,
// specify a DockerVolumeConfiguration. For tasks that use a bind mount host
// volume, specify a host and optional sourcePath. For more information, see
// Using Data Volumes in Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
type Volume struct {
	_ struct{} `type:"structure"`

	// This parameter is specified when you are using Docker volumes. Docker volumes
	// are only supported when you are using the EC2 launch type. Windows containers
	// only support the use of the local driver. To use bind mounts, specify a host
	// instead.
	DockerVolumeConfiguration *DockerVolumeConfiguration `locationName:"dockerVolumeConfiguration" type:"structure"`

	// This parameter is specified when you are using bind mount host volumes. Bind
	// mount host volumes are supported when you are using either the EC2 or Fargate
	// launch types. The contents of the host parameter determine whether your bind
	// mount host volume persists on the host container instance and where it is
	// stored. If the host parameter is empty, then the Docker daemon assigns a
	// host path for your data volume. However, the data is not guaranteed to persist
	// after the containers associated with it stop running.
	//
	// Windows containers can mount whole directories on the same drive as $env:ProgramData.
	// Windows containers cannot mount directories on a different drive, and mount
	// point cannot be across drives. For example, you can mount C:\my\path:C:\my\path
	// and D:\:D:\, but not D:\my\path:C:\my\path or D:\:C:\my\path.
	Host *HostVolumeProperties `locationName:"host" type:"structure"`

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// and hyphens are allowed. This name is referenced in the sourceVolume parameter
	// of container definition mountPoints.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// Details on a data volume from another container in the same task definition.
type VolumeFrom struct {
	_ struct{} `type:"structure"`

	// If this value is true, the container has read-only access to the volume.
	// If this value is false, then the container can write to the volume. The default
	// value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of another container within the same task definition from which
	// to mount volumes.
	SourceContainer *string `locationName:"sourceContainer" type:"string"`
}

// String returns the string representation
func (s VolumeFrom) String() string {
	return awsutil.Prettify(s)
}
