package openstack

import (
	"testing"

	"github.com/hashicorp/terraform/helper/resource"
)

func TestAccSFSV2ShareNetwork_importBasic(t *testing.T) {
	resourceName := "openstack_sharedfilesystem_sharenetwork_v2.sharenetwork_1"

	resource.Test(t, resource.TestCase{
		PreCheck:     func() { testAccPreCheckSFS(t) },
		Providers:    testAccProviders,
		CheckDestroy: testAccCheckSFSV2ShareNetworkDestroy,
		Steps: []resource.TestStep{
			{
				Config: testAccSFSV2ShareNetworkConfig_basic,
			},

			{
				ResourceName:      resourceName,
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}
