// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/actions/sdk/v2/interactionmodel/global_intent_event.proto

package interactionmodel

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Defines a global intent handler. Global intent events are scoped to the
// entire Actions project and may be overridden by intent handlers in a scene.
// Intent names must be unique within an Actions project.
//
// Global intents can be matched anytime during a session, allowing users to
// access common flows like  "get help" or "go back home." They can also be
// used to deep link users into specific flows when they invoke an Action.
//
// Note, the intent name is specified in the name of the file.
type GlobalIntentEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Destination scene which the conversation should jump to. The state of the
	// current scene is destroyed on the transition.
	TransitionToScene string `protobuf:"bytes,1,opt,name=transition_to_scene,json=transitionToScene,proto3" json:"transition_to_scene,omitempty"`
	// Optional. Event handler which is triggered when the intent is matched. Should execute
	// before transitioning to the destination scene. Useful to generate Prompts
	// in response to events.
	Handler *EventHandler `protobuf:"bytes,2,opt,name=handler,proto3" json:"handler,omitempty"`
}

func (x *GlobalIntentEvent) Reset() {
	*x = GlobalIntentEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalIntentEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalIntentEvent) ProtoMessage() {}

func (x *GlobalIntentEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalIntentEvent.ProtoReflect.Descriptor instead.
func (*GlobalIntentEvent) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescGZIP(), []int{0}
}

func (x *GlobalIntentEvent) GetTransitionToScene() string {
	if x != nil {
		return x.TransitionToScene
	}
	return ""
}

func (x *GlobalIntentEvent) GetHandler() *EventHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

var File_google_actions_sdk_v2_interactionmodel_global_intent_event_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76,
	0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x01, 0x0a, 0x11, 0x47, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a,
	0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x5f, 0x73,
	0x63, 0x65, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x53, 0x63, 0x65,
	0x6e, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x42, 0x9e, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x16, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_goTypes = []interface{}{
	(*GlobalIntentEvent)(nil), // 0: google.actions.sdk.v2.interactionmodel.GlobalIntentEvent
	(*EventHandler)(nil),      // 1: google.actions.sdk.v2.interactionmodel.EventHandler
}
var file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.interactionmodel.GlobalIntentEvent.handler:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_global_intent_event_proto != nil {
		return
	}
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlobalIntentEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_global_intent_event_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_global_intent_event_proto_depIdxs = nil
}
