// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "open-cluster-management.io/api/client/cluster/clientset/versioned/scheme"
	v1alpha1 "open-cluster-management.io/api/cluster/v1alpha1"
)

// AddOnPlacementScoresGetter has a method to return a AddOnPlacementScoreInterface.
// A group's client should implement this interface.
type AddOnPlacementScoresGetter interface {
	AddOnPlacementScores(namespace string) AddOnPlacementScoreInterface
}

// AddOnPlacementScoreInterface has methods to work with AddOnPlacementScore resources.
type AddOnPlacementScoreInterface interface {
	Create(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.CreateOptions) (*v1alpha1.AddOnPlacementScore, error)
	Update(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.UpdateOptions) (*v1alpha1.AddOnPlacementScore, error)
	UpdateStatus(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.UpdateOptions) (*v1alpha1.AddOnPlacementScore, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.AddOnPlacementScore, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AddOnPlacementScoreList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AddOnPlacementScore, err error)
	AddOnPlacementScoreExpansion
}

// addOnPlacementScores implements AddOnPlacementScoreInterface
type addOnPlacementScores struct {
	client rest.Interface
	ns     string
}

// newAddOnPlacementScores returns a AddOnPlacementScores
func newAddOnPlacementScores(c *ClusterV1alpha1Client, namespace string) *addOnPlacementScores {
	return &addOnPlacementScores{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the addOnPlacementScore, and returns the corresponding addOnPlacementScore object, and an error if there is any.
func (c *addOnPlacementScores) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AddOnPlacementScore, err error) {
	result = &v1alpha1.AddOnPlacementScore{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addonplacementscores").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AddOnPlacementScores that match those selectors.
func (c *addOnPlacementScores) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AddOnPlacementScoreList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AddOnPlacementScoreList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addonplacementscores").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested addOnPlacementScores.
func (c *addOnPlacementScores) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("addonplacementscores").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a addOnPlacementScore and creates it.  Returns the server's representation of the addOnPlacementScore, and an error, if there is any.
func (c *addOnPlacementScores) Create(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.CreateOptions) (result *v1alpha1.AddOnPlacementScore, err error) {
	result = &v1alpha1.AddOnPlacementScore{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("addonplacementscores").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(addOnPlacementScore).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a addOnPlacementScore and updates it. Returns the server's representation of the addOnPlacementScore, and an error, if there is any.
func (c *addOnPlacementScores) Update(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.UpdateOptions) (result *v1alpha1.AddOnPlacementScore, err error) {
	result = &v1alpha1.AddOnPlacementScore{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("addonplacementscores").
		Name(addOnPlacementScore.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(addOnPlacementScore).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *addOnPlacementScores) UpdateStatus(ctx context.Context, addOnPlacementScore *v1alpha1.AddOnPlacementScore, opts v1.UpdateOptions) (result *v1alpha1.AddOnPlacementScore, err error) {
	result = &v1alpha1.AddOnPlacementScore{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("addonplacementscores").
		Name(addOnPlacementScore.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(addOnPlacementScore).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the addOnPlacementScore and deletes it. Returns an error if one occurs.
func (c *addOnPlacementScores) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addonplacementscores").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *addOnPlacementScores) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addonplacementscores").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched addOnPlacementScore.
func (c *addOnPlacementScores) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AddOnPlacementScore, err error) {
	result = &v1alpha1.AddOnPlacementScore{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("addonplacementscores").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
