import { EdgeServerInfo } from './reportingOperationTypes';
import { Logger } from 'apollo-server-types';
export declare const reportServerInfoGql = "\n  mutation ReportServerInfo($info: EdgeServerInfo!, $executableSchema: String) {\n    me {\n      __typename\n      ... on ServiceMutation {\n        reportServerInfo(info: $info, executableSchema: $executableSchema) {\n          inSeconds\n          withExecutableSchema\n        }\n      }\n    }\n  }\n";
export declare function reportingLoop(schemaReporter: SchemaReporter, logger: Logger, sendNextWithExecutableSchema: boolean, fallbackReportingDelayInMs: number): void;
interface ReportServerInfoReturnVal {
    inSeconds: number;
    withExecutableSchema: boolean;
}
export declare class SchemaReporter {
    private readonly serverInfo;
    private readonly executableSchemaDocument;
    private readonly url;
    private isStopped;
    private readonly headers;
    constructor(serverInfo: EdgeServerInfo, schemaSdl: string, apiKey: string, schemaReportingEndpoint: string | undefined);
    stopped(): Boolean;
    stop(): void;
    reportServerInfo(withExecutableSchema: boolean): Promise<ReportServerInfoReturnVal>;
    private graphManagerQuery;
}
export {};
//# sourceMappingURL=schemaReporter.d.ts.map